/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.stream.stat;

import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.analyzer.expr.ConstructorProxy;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.control.stream.ValueGetter;

public abstract class AbstractStat
implements Constructor {
    public String toString() {
        return this.name();
    }

    @Override
    public Object analyze(Statement s, Constructor.Position pos) throws ScriptException {
        ValueGetter expr;
        Object stub;
        int last = s.length() - 2;
        if (s.get(0) instanceof ConstructorProxy) {
            stub = pos.getOperand(s, last == 1 ? 1 : 0);
            expr = last == 1 ? new ValueGetter.ExprGetter(pos.getOperand(s, 0)) : ValueGetter.CURRENT;
        } else {
            stub = pos.getOperand(s, 0);
            expr = last == 1 ? new ValueGetter.ExprGetter(pos.getOperand(s, 1)) : ValueGetter.CURRENT;
        }
        return this.createEvalutor(stub, expr);
    }

    private Object createEvalutor(final Object stub, final ValueGetter expr) {
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object c = Util.eval(ctx, stub);
                if (c == null) {
                    return null;
                }
                if (c instanceof Map) {
                    return AbstractStat.this.visitMap(ctx, (Map)c, expr);
                }
                if (c instanceof Iterable) {
                    return AbstractStat.this.visitCollection(ctx, (Iterable)c, expr);
                }
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString("%1$s \u7684\u5b9e\u9645\u7c7b\u578b\u662f\uff1a%2$s", "AbstractStat_1", "isc-iscb-util", new Object[0]), stub, c.getClass().getName()));
            }
        };
    }

    protected abstract Object end(Object var1);

    protected abstract Object collect(Object var1, Object var2);

    private Object visitCollection(ScriptContext ctx, Iterable<?> c, ValueGetter expr) {
        Object buffer = null;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            Object value = expr.eval(ctx, it.next());
            buffer = this.collect(buffer, value);
        }
        return this.end(buffer);
    }

    private Object visitMap(ScriptContext ctx, Map<?, ?> c, ValueGetter expr) {
        Object buffer = null;
        for (Map.Entry<?, ?> e : c.entrySet()) {
            Object value = expr.eval(ctx, e);
            buffer = this.collect(buffer, value);
        }
        return this.end(buffer);
    }
}

