/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.op.compare.Equals;
import kd.isc.iscb.util.script.feature.op.compare.Less;
import kd.isc.iscb.util.script.feature.tool.collection.Util;

public class Sort
implements NativeFunction {
    public static final Sort INS = new Sort();

    private Sort() {
    }

    @Override
    public String name() {
        return "sort";
    }

    @Override
    public List<Object> call(ScriptContext ctx, Object[] args) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] buffer = this.getValues(args, result);
        this.sortArray(ctx, args, buffer);
        this.assembleResult(ctx, args, result, buffer);
        return result;
    }

    private void assembleResult(ScriptContext ctx, Object[] args, ArrayList<Object> result, Object[] buffer) {
        NativeFunction valueGetter = Util.getValueGetter(args, 2);
        Object[] params = new Object[1];
        int i = 0;
        while (i < buffer.length) {
            params[0] = buffer[i];
            Object value = valueGetter.call(ctx, params);
            result.set(i, value);
            ++i;
        }
    }

    private void sortArray(ScriptContext ctx, Object[] args, Object[] buffer) {
        Comparator comparator = this.getComparator(ctx, args);
        Arrays.sort(buffer, comparator);
    }

    private Object[] getValues(Object[] args, ArrayList<Object> result) {
        Iterator<?> it = Util.getIterator(args[0]);
        while (it.hasNext()) {
            result.add(it.next());
        }
        Object[] buffer = result.toArray();
        return buffer;
    }

    private Comparator getComparator(ScriptContext ctx, Object[] args) {
        Less comparer = args.length == 1 ? Less.INS : (NativeFunction)args[1];
        return Sort.getComparer(ctx, comparer);
    }

    public static Comparator getComparer(final ScriptContext ctx, final NativeFunction comparer) {
        return new Comparator(){

            public int compare(Object a, Object b) {
                Object[] params = new Object[]{a, b};
                if (Equals.INS.call(ctx, params).booleanValue()) {
                    return 0;
                }
                Object val = comparer.call(ctx, params);
                if (val instanceof Boolean) {
                    return (Boolean)val != false ? -1 : 1;
                }
                if (val instanceof Integer) {
                    return (Integer)val;
                }
                String message = val == null ? ResManager.loadKDString("\u6bd4\u8f83\u8fd4\u56de\u7ed3\u679c\u4e3aNULL\u3002", "Sort_1", "isc-iscb-util", new Object[0]) : String.format(ResManager.loadKDString("\u6bd4\u8f83\u8fd4\u56de\u7ed3\u679c(%1$s)\u662f%2$s; \u8981\u6c42\u662f\u6574\u6570\u6216\u5e03\u5c14\u503c\u3002", "Sort_6", "isc-iscb-util", new Object[0]), val, val.getClass().getSimpleName());
                throw new UnsupportedOperationException(message);
            }
        };
    }
}

