/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.date;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.tool.date.DateToolKit;

public class DateDiff
implements NativeFunction {
    private static final long MILLISECONDS_OF_A_WEEK = 604800000L;
    public static final DateDiff INS = new DateDiff();
    private static final long MILLISECONDS_OFFSET = TimeZone.getDefault().getRawOffset() + 172800000;

    private DateDiff() {
    }

    @Override
    public String name() {
        return "diff";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Date a = (Date)args[0];
        Date b = (Date)args[1];
        if (a == null || b == null) {
            return null;
        }
        Object type = this.getType(args);
        return DateDiff.calc(a, b, type);
    }

    public static int calc(Date a, Date b, Object type) {
        Calendar from = Calendar.getInstance();
        from.setTime(a);
        Calendar to = Calendar.getInstance();
        to.setTime(b);
        int sign = 1;
        if (from.after(to)) {
            Calendar bak = to;
            to = from;
            from = bak;
            sign = -1;
        }
        if (type == DateToolKit.DAY) {
            return sign * DateDiff.days(from, to);
        }
        if (type == DateToolKit.HOUR) {
            return sign * DateDiff.hours(from, to);
        }
        if (type == DateToolKit.MINUTE) {
            return sign * DateDiff.minutes(from, to);
        }
        if (type == DateToolKit.SECOND) {
            return sign * DateDiff.seconds(from, to);
        }
        if (type == DateToolKit.MONTH) {
            return sign * DateDiff.months(from, to);
        }
        if (type == DateToolKit.YEAR) {
            return sign * DateDiff.years(from, to);
        }
        if (type == DateToolKit.WEEK) {
            return sign * DateDiff.weeks(from, to);
        }
        if (type == DateToolKit.QUARTER) {
            return sign * DateDiff.quarters(from, to);
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static int quarters(Calendar from, Calendar to) {
        int quarter_of_to;
        double m = DateDiff.months(from, to);
        int quarter_of_from = from.get(2) / 3;
        if (quarter_of_from != (quarter_of_to = to.get(2) / 3)) {
            return (int)Math.ceil(m / 3.0);
        }
        return (int)Math.floor(m / 3.0);
    }

    private static int weeks(Calendar from, Calendar to) {
        int week_of_to;
        double d = DateDiff.days(from, to);
        int week_of_from = (int)((from.getTimeInMillis() - MILLISECONDS_OFFSET) / 604800000L);
        if (week_of_from != (week_of_to = (int)((to.getTimeInMillis() - MILLISECONDS_OFFSET) / 604800000L))) {
            return (int)Math.ceil(d / 7.0);
        }
        return (int)Math.floor(d / 7.0);
    }

    private static int years(Calendar from, Calendar to) {
        return to.get(1) - from.get(1);
    }

    private static int months(Calendar from, Calendar to) {
        int months = to.get(2) - from.get(2);
        return DateDiff.years(from, to) * 12 + months;
    }

    private static long milliseconds(Calendar from, Calendar to) {
        return to.getTimeInMillis() - from.getTimeInMillis();
    }

    private static int seconds(Calendar from, Calendar to) {
        return (int)(DateDiff.milliseconds(from, to) / 1000L);
    }

    private static int minutes(Calendar from, Calendar to) {
        return (int)(DateDiff.milliseconds(from, to) / 60000L);
    }

    private static int hours(Calendar from, Calendar to) {
        return (int)(DateDiff.milliseconds(from, to) / 3600000L);
    }

    private static int days(Calendar from, Calendar to) {
        int d = (int)(DateDiff.milliseconds(from, to) / 86400000L);
        return d;
    }

    private Object getType(Object[] args) {
        if (args.length > 2) {
            return args[2];
        }
        return DateToolKit.MILLISECOND;
    }
}

