/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.util.ExportAllUtils;
import com.kingdee.shr.customer.gtiit.util.RptUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class FacultyAbseceReporttoMorisListHandler
extends ListHandler {
    Context ctx = SHRContext.getInstance().getContext();
    private int totalCount;
    static BigDecimal hours = new BigDecimal(3600000);

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        try {
            String parameter = request.getParameter("postData");
            JSONObject paramJson = JSON.parseObject((String)parameter);
            JSONObject fastJson = paramJson.getJSONObject("fastFilterItems");
            JSONObject qeryTimeJson = fastJson.getJSONObject("queryTime");
            JSONObject valuesJson = qeryTimeJson.getJSONObject("values");
            String tostartDate = null;
            String toendDate = null;
            if (valuesJson != null && !valuesJson.equals((Object)"")) {
                tostartDate = valuesJson.getString("startDate");
                toendDate = valuesJson.getString("endDate");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date startDates = sdf.parse(tostartDate);
            java.util.Date endDates = sdf.parse(toendDate);
            ArrayList<String> colNames = this.getcolNamesAction(startDates, endDates);
            List<Map<String, Object>> colModel = this.getcolModelAction(startDates, endDates);
            LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
            map.put("colNames", colNames);
            map.put("colModel", colModel);
            JSONUtils.writeJson((HttpServletResponse)response, map);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, ParseException {
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        int num = 0;
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        JSONObject queyTimeJson = paramJson.getJSONObject("queryTime");
        String pervalues = queyTimeJson.getString("values");
        String tostartDate = null;
        String toendDate = null;
        if (pervalues != null && !pervalues.equals("")) {
            JSONObject queryTimeValues = queyTimeJson.getJSONObject("values");
            tostartDate = queryTimeValues.getString("startDate");
            toendDate = queryTimeValues.getString("endDate");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date startDates = sdf.parse(tostartDate);
        java.util.Date endDates = sdf.parse(toendDate);
        List<String> fiterDate = this.getDateList(startDates, endDates, "dd/MM");
        String sqlInfo = this.getSql(rptSQLFilterate);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlInfo);
        HashSet<String> numberSet = new HashSet<String>();
        Map<String, Map<String, String>> numberMap = this.getAllmap(rs, numberSet, fiterDate);
        ArrayList tomaplist = new ArrayList();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String fnumber = rs.getString("StaffID");
            String name = rs.getString("name");
            String title = rs.getString("title");
            String academic = rs.getString("AcademicTitle");
            String program = rs.getString("program");
            if (!numberSet.contains(fnumber)) continue;
            Map<String, String> tofnumberMap = numberMap.get(fnumber);
            map.put("StaffID", fnumber);
            map.put("Name", name);
            map.put("Title", title);
            map.put("Academic Title", academic);
            map.put("Program", program);
            for (Map.Entry<String, String> entry : tofnumberMap.entrySet()) {
                String key = entry.getKey();
                String subKey = key.substring(0, 5);
                String value = entry.getValue();
                map.put(subKey, value);
            }
            numberSet.remove(fnumber);
            tomaplist.add(map);
        }
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", tomaplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public static List<LinkedHashMap<String, java.util.Date>> splitDateRange(java.util.Date start, java.util.Date end) {
        ArrayList<LinkedHashMap<String, java.util.Date>> rs = new ArrayList<LinkedHashMap<String, java.util.Date>>();
        LinkedHashMap<String, java.util.Date> dateMap = new LinkedHashMap<String, java.util.Date>();
        long daysBetween = (end.getTime() - start.getTime()) / 86400000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year, month, day, 12, 0, 0);
        java.util.Date lunchStartDate = calendar.getTime();
        dateMap.put("lunchStartDate", lunchStartDate);
        calendar.set(year, month, day, 13, 30, 0);
        java.util.Date lunchEndDate = calendar.getTime();
        dateMap.put("lunchEndDate", lunchEndDate);
        if (daysBetween == 0L) {
            calendar.set(year, month, day, 8, 30, 0);
            java.util.Date toDayMinStartTime = calendar.getTime();
            if (start.compareTo(toDayMinStartTime) < 1) {
                start = toDayMinStartTime;
            }
            calendar.set(year, month, day, 17, 30, 0);
            java.util.Date toDayMinEndTime = calendar.getTime();
            if (end.compareTo(toDayMinEndTime) == 1) {
                end = toDayMinEndTime;
            }
            dateMap.put("startDate", start);
            dateMap.put("endDate", end);
            rs.add(dateMap);
            return rs;
        }
        calendar.set(year, month, day, 17, 30, 0);
        dateMap.put("startDate", start);
        dateMap.put("endDate", calendar.getTime());
        rs.add(dateMap);
        int i = 1;
        while ((long)i <= daysBetween) {
            LinkedHashMap<String, java.util.Date> nextDateMap = new LinkedHashMap<String, java.util.Date>();
            Calendar calendarStart = Calendar.getInstance();
            calendarStart.set(year, month, day, 8, 30, 0);
            calendarStart.add(5, 1);
            java.util.Date newStartDate = calendarStart.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.set(year, month, day, 17, 30, 0);
            calendarEnd.add(5, 1);
            java.util.Date newEndDate = calendarEnd.getTime();
            year = calendarStart.get(1);
            month = calendarStart.get(2);
            day = calendarStart.get(5);
            java.util.Date newLunchStartDate = new java.util.Date(lunchStartDate.getTime() + 86400000L);
            nextDateMap.put("lunchStartDate", newLunchStartDate);
            lunchStartDate = newLunchStartDate;
            java.util.Date newLunchEndDate = new java.util.Date(lunchEndDate.getTime() + 86400000L);
            nextDateMap.put("lunchEndDate", newLunchEndDate);
            lunchEndDate = newLunchEndDate;
            if (newEndDate.compareTo(end) < 1) {
                nextDateMap.put("startDate", newStartDate);
                nextDateMap.put("endDate", newEndDate);
                rs.add(nextDateMap);
            } else {
                nextDateMap.put("startDate", newStartDate);
                nextDateMap.put("endDate", end);
                rs.add(nextDateMap);
            }
            ++i;
        }
        return rs;
    }

    public static double getLeaveHoursBetween(java.util.Date startTime, java.util.Date endTime, java.util.Date lunchStart, java.util.Date lunchEnd) {
        long workDiffInMilliseconds = Math.abs(endTime.getTime() - startTime.getTime());
        BigDecimal work = new BigDecimal(workDiffInMilliseconds);
        BigDecimal workHour = work.divide(hours, 2, RoundingMode.HALF_UP);
        if (startTime.before(lunchStart) && endTime.after(lunchEnd)) {
            long diffInMilliseconds = Math.abs(lunchEnd.getTime() - lunchStart.getTime());
            BigDecimal noWork = new BigDecimal(diffInMilliseconds);
            BigDecimal noWorkHours = noWork.divide(hours, 2, RoundingMode.HALF_UP);
            return workHour.subtract(noWorkHours).doubleValue();
        }
        if (startTime.after(lunchStart) && startTime.before(lunchEnd) && endTime.after(lunchEnd)) {
            long diffInMilliseconds = Math.abs(lunchEnd.getTime() - startTime.getTime());
            BigDecimal noWork = new BigDecimal(diffInMilliseconds);
            BigDecimal noWorkHours = noWork.divide(hours, 2, RoundingMode.HALF_UP);
            return workHour.subtract(noWorkHours).doubleValue();
        }
        if (startTime.before(lunchStart) && endTime.before(lunchEnd) && endTime.after(lunchStart)) {
            long diffInMilliseconds = Math.abs(endTime.getTime() - lunchStart.getTime());
            BigDecimal noWork = new BigDecimal(diffInMilliseconds);
            BigDecimal noWorkHours = noWork.divide(hours, 2, RoundingMode.HALF_UP);
            return workHour.subtract(noWorkHours).doubleValue();
        }
        return workHour.doubleValue();
    }

    private List<java.util.Date> getBetweenDates(java.util.Date start, java.util.Date end) {
        ArrayList<java.util.Date> result = new ArrayList<java.util.Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public ArrayList<String> getcolNamesAction(java.util.Date startDate, java.util.Date endDate) throws SHRWebException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("StaffID");
        list.add("Name");
        list.add("Title");
        list.add("Academic Title");
        list.add("Program");
        List<String> dateList = this.getDateList(startDate, endDate, "dd/MM");
        for (String localDate : dateList) {
            list.add(localDate);
        }
        return list;
    }

    private static void getDate(String staffId, Map<String, Object> data, String type, SimpleDateFormat sdf, SimpleDateFormat sdf2, java.util.Date start, java.util.Date end, java.util.Date lunchStart, java.util.Date lunchEnd) {
        double leaveHoursBetween = FacultyAbseceReporttoMorisListHandler.getLeaveHoursBetween(start, end, lunchStart, lunchEnd);
        String key = sdf2.format(start);
        if (data.containsKey(key)) {
            HashMap<String, Double> holidayTypeAndHours = (HashMap<String, Double>)data.get(key);
            if (holidayTypeAndHours.containsKey(type)) {
                Double holidayHoursHis = (Double)holidayTypeAndHours.get(type);
                holidayTypeAndHours.put(type, holidayHoursHis + leaveHoursBetween);
            } else {
                holidayTypeAndHours = new HashMap<String, Double>();
                holidayTypeAndHours.put(type, leaveHoursBetween);
            }
            data.put(key, holidayTypeAndHours);
        } else {
            HashMap<String, Double> holidayTypeAndHours = new HashMap<String, Double>();
            holidayTypeAndHours.put(type, leaveHoursBetween);
            data.put(key, holidayTypeAndHours);
        }
    }

    public List<String> getDateList(java.util.Date startDate, java.util.Date endDate, String format) {
        ArrayList<String> dateList = new ArrayList<String>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        LocalDate startLocal = Instant.ofEpochMilli(startDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endLocal = Instant.ofEpochMilli(endDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        long daysBetween = ChronoUnit.DAYS.between(startLocal, endLocal);
        int i = 0;
        while ((long)i <= daysBetween) {
            LocalDate date = startLocal.plusDays(i);
            String tofromat = date.format(formatter);
            dateList.add(tofromat);
            ++i;
        }
        return dateList;
    }

    public String getLeaveType(String type) {
        String leavetype = null;
        leavetype = type.equals("\u5e74\u5047") ? "A" : (type.equals("\u51fa\u5dee") ? "B" : "O");
        return leavetype;
    }

    public List<Map<String, Object>> getcolModelAction(java.util.Date startDate, java.util.Date endDate) {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("StaffID", "StaffID", 120));
        modelColList.add(this.buildColModelMap("Name", "Name", 120));
        modelColList.add(this.buildColModelMap("Title", "Title", 120));
        modelColList.add(this.buildColModelMap("Academic Title", "Academic Title", 120));
        modelColList.add(this.buildColModelMap("Program", "Program", 120));
        List<String> dateList = this.getDateList(startDate, endDate, "dd/MM");
        Iterator<String> iterator = dateList.iterator();
        while (iterator.hasNext()) {
            String localDate;
            String local = localDate = iterator.next();
            modelColList.add(this.buildColModelMap(localDate, localDate, 60));
        }
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> getAllmap(IRowSet rs, Set<String> numberSet, List<String> fiterDate) throws SQLException {
        boolean first = true;
        HashMap<String, Map<String, String>> numberMap = new HashMap<String, Map<String, String>>();
        while (rs.next()) {
            ConcurrentHashMap<String, String> dateMap = new ConcurrentHashMap<String, String>();
            String fnumber = rs.getString("StaffID");
            numberSet.add(fnumber);
            Date fbegintime = rs.getDate("FBEGINTIME");
            Date fendtime = rs.getDate("FENDTIME");
            String atsType = rs.getString("ATSTYPE");
            List<String> dateList = this.getDateList(fbegintime, fendtime, "dd/MM");
            String leaveType = this.getLeaveType(atsType);
            if (first) {
                first = false;
                for (String fiterdate : fiterDate) {
                    for (String string : dateList) {
                        if (!fiterdate.equals(string)) continue;
                        dateMap.put(String.valueOf(string) + fnumber, leaveType);
                    }
                }
                numberMap.put(fnumber, dateMap);
                continue;
            }
            if (numberMap.containsKey(fnumber)) {
                Map todatemap = (Map)numberMap.get(fnumber);
                Map map = todatemap;
                synchronized (map) {
                    for (Map.Entry entry : todatemap.entrySet()) {
                        String key = (String)entry.getKey();
                        String subKey = key.substring(0, 5);
                        String value = (String)entry.getValue();
                        for (String datelist : dateList) {
                            if (subKey.equals(datelist)) {
                                if (value.equals(leaveType)) continue;
                                todatemap.put(key, String.valueOf(value) + leaveType);
                                continue;
                            }
                            todatemap.put(String.valueOf(datelist) + fnumber, leaveType);
                        }
                    }
                }
                numberMap.put(fnumber, todatemap);
                continue;
            }
            for (String fiterdate : fiterDate) {
                for (String string : dateList) {
                    if (!fiterdate.equals(string)) continue;
                    dateMap.put(String.valueOf(string) + fnumber, leaveType);
                }
            }
            numberMap.put(fnumber, dateMap);
        }
        return numberMap;
    }

    private String getSql(Map<String, Object> params) {
        StringBuffer sql = new StringBuffer();
        Map contractDateMap = (Map)params.get("queryTime");
        Object startDate = contractDateMap.get("startDate");
        Object endDate = contractDateMap.get("endDate");
        sql.append("SELECT  b.FPERSONID,b.FBEGINTIME,b.FENDTIME,d.fnumber as StaffID,d.fname_l1 name,e.FName_L1 as Program,c.FName_L1 as Title,p.FName_L1 as AcademicTitle,\r\nf.fnumber holidayTypeNumber,f.fname_l2 as atsType, f.fname_l1 HolidayName FROM T_HR_ATS_LeaveBill a \r\nleft join T_HR_ATS_LeaveBillentry b on a.fid=b.fbillid \r\n\t\tleft join (select b.fpersonid, d.cflongname_l1 positionName,e.fname_l1 depName  ,at.FName_l1 as AcademicTitle,c.CFAcademicTitleID,d.FName_L1  from \r\n\t\t(SELECT FPERSONID,max(FleFFDT) as maxDate FROM T_HR_EmpOrgRelation where fassignType = '1' group by FPERSONID ) b \r\n\t\tleft join T_HR_EmpOrgRelation c on b.fpersonid = c.fpersonid and b.maxdate=FleFFDT \r\n\t\tleft join CT_MP_AcademicTitle at on at.fid = c.CFAcademicTitleID\r\n\t\tleft join T_ORG_Position d on c.fpositionid=d.fid \r\n\t\tleft join T_ORG_BaseUnit e on e.fid = c.FAdminOrgID \r\n\t\tleft join CT_MP_WorkerCategory f on f.fid=c.CFWorkercategoryID where c.fassignType = '1' and f.fnumber = 'GTIIT_FACULTY') c \r\n\t\ton b.fpersonid = c.fpersonid \r\n\tleft join T_BD_Person d on d.fid=b.fpersonid \r\nleft join T_HR_ATS_HolidayPolicy e on e.fid=b.fpolicyid \r\nleft join T_HR_ATS_HolidayType f on f.fid=e.fholidaytypeid\r\nleft join CT_MP_AcademicTitle p on c.CFAcademicTitleID=p.fid");
        sql.append(" where b.FBeginTime>=");
        sql.append("'");
        sql.append(startDate);
        sql.append("'");
        sql.append(" and b.FEndTime<=");
        sql.append("'");
        sql.append(endDate);
        sql.append("'");
        System.out.println(sql.toString());
        return sql.toString();
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, ParseException {
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        JSONObject queyTimeJson = paramJson.getJSONObject("queryTime");
        String pervalues = queyTimeJson.getString("values");
        String tostartDate = null;
        String toendDate = null;
        if (pervalues != null && !pervalues.equals("")) {
            JSONObject queryTimeValues = queyTimeJson.getJSONObject("values");
            tostartDate = queryTimeValues.getString("startDate");
            toendDate = queryTimeValues.getString("endDate");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date startDates = sdf.parse(tostartDate);
        java.util.Date endDates = sdf.parse(toendDate);
        SimpleDateFormat tosdf = new SimpleDateFormat("dd/MM/yyyy");
        String formatstartDate = tosdf.format(startDates);
        String formatendDate = tosdf.format(endDates);
        List<String> fiterDate = this.getDateList(startDates, endDates, "dd/MM");
        String sqlInfo = this.getSql(rptSQLFilterate);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlInfo);
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        selectFieldsTypeMap.put("StaffID", stringType);
        selectFieldsTypeMap.put("name", stringType);
        selectFieldsTypeMap.put("title", stringType);
        selectFieldsTypeMap.put("AcademicTitle", stringType);
        selectFieldsTypeMap.put("program", stringType);
        List<String> dateList = this.getDateList(startDates, endDates, "dd/MM");
        for (String localDate : dateList) {
            selectFieldsTypeMap.put(localDate, stringType);
        }
        HashSet<String> numberSet = new HashSet<String>();
        while (rs.next()) {
            String fnumber = rs.getString("StaffID");
            numberSet.add(fnumber);
        }
        rs.beforeFirst();
        Map<String, Map<String, String>> allmap = this.getAllmap(rs, numberSet, fiterDate);
        ArrayList<String> list = this.getcolNamesAction(startDates, endDates);
        ExportAllUtils.morisExportData(response, rs, "FacultyAbsenceReport.xlsx", selectFieldsTypeMap, list, allmap, numberSet, formatstartDate, formatendDate);
        return null;
    }
}

