/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.ats.AtsLeaveBillDetailSameFactory;
import com.kingdee.eas.custom.ats.AtsLeaveBillDetailSameInfo;
import com.kingdee.eas.custom.ats.IAtsLeaveBillDetailSame;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemFactory;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.BreastFeedingTypeCollection;
import com.kingdee.eas.hr.ats.BreastFeedingTypeFactory;
import com.kingdee.eas.hr.ats.BreastFeedingTypeInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IAtsLeaveBillDetail;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.calculate.AtsCacheUtil;
import com.kingdee.eas.hr.ats.calcutePrepareData.AtsPrepareDataHelper;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtsLeaveBillSameSplitHelper {
    private AtsLeaveBillInfo billInfo;
    private AtsLeaveBillEntryInfo atsLeaveBillEntryInfo;
    private Context ctx;
    private String personId;
    private Boolean isIncludeLegal;
    private Boolean isIncludeRest;
    private HolidayPolicyInfo holidayPolicyInfo;
    private BigDecimal sourceLen = new BigDecimal(0);
    private BigDecimal defaultStandardHour = BigDecimal.valueOf(24L);
    private int decimalPlaceValue = 2;
    private static final Logger logger = LoggerFactory.getLogger(AtsLeaveBillSameSplitHelper.class);

    public AtsLeaveBillSameSplitHelper(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        this.billInfo = AtsLeaveBillFactory.getLocalInstance((Context)ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance((Context)ctx).getAtsLeaveBillEntryCollection(" where bill='" + this.billInfo.getId().toString() + "'");
        this.atsLeaveBillEntryInfo = billEntryColl.get(0);
        this.ctx = ctx;
        this.personId = this.atsLeaveBillEntryInfo.getPerson().getId().toString();
        this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance((Context)ctx).getHolidayPolicyInfo(" where id='" + this.atsLeaveBillEntryInfo.getPolicy().getId().toString() + "'");
        this.isIncludeLegal = this.holidayPolicyInfo.isIsIncludeLegal();
        this.isIncludeRest = this.holidayPolicyInfo.isIsIncludeRest();
        this.decimalPlaceValue = DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx);
    }

    public AtsLeaveBillSameSplitHelper(Context ctx, AtsLeaveBillInfo billInfo, AtsLeaveBillEntryInfo atsLeaveBillEntryInfo) throws EASBizException, BOSException {
        this.billInfo = billInfo;
        this.atsLeaveBillEntryInfo = atsLeaveBillEntryInfo;
        this.ctx = ctx;
        this.personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
        this.holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance((Context)ctx).getHolidayPolicyInfo(" where id='" + atsLeaveBillEntryInfo.getPolicy().getId().toString() + "'");
        this.isIncludeLegal = this.holidayPolicyInfo.isIsIncludeLegal();
        this.isIncludeRest = this.holidayPolicyInfo.isIsIncludeRest();
    }

    public void splitLeaveBill() throws EASBizException, BOSException {
        logger.info("AtsLeaveBillSameSplitHelper....splitLeaveBill....start");
        logger.info(String.valueOf(MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.StartSplitLeaveBill, (Context)this.ctx)) + "...");
        Timestamp beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
        Timestamp endTime = this.atsLeaveBillEntryInfo.getRealEndTime();
        List dateList = this.getLeaveDateColl(beginTime, endTime);
        List dateListAfter = this.dealDateNew(dateList);
        String oql = " select holidayPolicySet.isHalfDayOff,holidayPolicySet.isHalfDayOff,holidayPolicySet.amStartWorkTime,holidayPolicySet.amEndWorkTime,holidayPolicySet.pmStartWorkTime,holidayPolicySet.pmEndWorkTime where proposer.id='" + this.personId + "' and attendFileState='1' ";
        AtsHolidayFileInfo holidayFileInfo = AtsHolidayFileFactory.getLocalInstance((Context)this.ctx).getAtsHolidayFileInfo(oql);
        Map<String, Object> dateLenMap = null;
        HolidayPolicySetInfo holidayPolicySetInfo = holidayFileInfo.getHolidayPolicySet();
        dateLenMap = this.holidayPolicyInfo != null && this.holidayPolicyInfo.getHolidayType() != null && this.holidayPolicyInfo.getHolidayType().getId().toString().equals("8r0AAAAMhrv9LVKY") && this.atsLeaveBillEntryInfo.getBfType() != null && !this.atsLeaveBillEntryInfo.getBfType().getId().toString().equals("8r0AAAA09p9IT3K3") ? this.calRealLeaveLengthOfBF(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, holidayPolicySetInfo, this.holidayPolicyInfo) : (this.holidayPolicyInfo != null && this.holidayPolicyInfo.isIsHalfDayOff() ? this.calRealLeaveLengthOfDay(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, holidayPolicySetInfo, this.holidayPolicyInfo) : this.calRealLeaveLengthInfo(dateListAfter, beginTime, endTime, this.atsLeaveBillEntryInfo.getRealUnit(), holidayFileInfo, this.holidayPolicyInfo));
        this.insertleaveBillDetail(dateLenMap);
        logger.info("AtsLeaveBillSameSplitHelper....splitLeaveBill....end");
        logger.info(String.valueOf(MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.EndSplitLeaveBill, (Context)this.ctx)) + "...");
    }

    private void insertleaveBillDetailHour(List<Date> dateListAfter) throws BOSException, EASBizException {
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo((Context)this.ctx, (String)this.personId);
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit((Context)this.ctx, (String)personInfo.getId().toString());
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        if (dateListAfter.size() != 0) {
            BigDecimal standardHour = this.getStandardHour(this.personId, dateListAfter.get(0));
            Double standardHourDouble = standardHour.doubleValue();
            Double tempDouble = leaveLengthDouble % standardHourDouble;
            tempDouble = BigDecimal.valueOf(tempDouble).setScale(2, 4).doubleValue();
            AtsLeaveBillDetailInfo leaveBillDetailInfofirst = new AtsLeaveBillDetailInfo();
            int i = 0;
            while (i < dateListAfter.size()) {
                if (leaveLengthDouble > 0.0) {
                    AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
                    leaveBillDetailInfo.setLeavebill(this.billInfo);
                    leaveBillDetailInfo.setProposer(personInfo);
                    leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
                    leaveBillDetailInfo.setLeaveUnit(this.atsLeaveBillEntryInfo.getRealUnit());
                    leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo);
                    leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
                    if (i == 0) {
                        if (tempDouble != 0.0) {
                            leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
                            leaveBillDetailInfofirst = leaveBillDetailInfo;
                            leaveLengthDouble = leaveLengthDouble - tempDouble;
                        } else {
                            leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
                            leaveBillDetailInfofirst = leaveBillDetailInfo;
                            leaveLengthDouble = leaveLengthDouble - standardHourDouble;
                        }
                    } else {
                        leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(standardHourDouble));
                        leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
                        leaveLengthDouble = leaveLengthDouble - standardHourDouble;
                    }
                }
                ++i;
            }
            if (leaveLengthDouble > 0.0) {
                leaveBillDetailInfofirst.setLeaveLength(leaveBillDetailInfofirst.getLeaveLength().add(BigDecimal.valueOf(leaveLengthDouble)));
            }
            leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfofirst);
            IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance((Context)this.ctx);
            leaveBillDetail.addnewBatchData(leaveBillDetailColl);
        }
    }

    private void insertleaveBillDetailDay(List<Date> dateListAfter) throws BOSException, EASBizException {
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo((Context)this.ctx, (String)this.personId);
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit((Context)this.ctx, (String)personInfo.getId().toString());
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        int i = 0;
        while (i < dateListAfter.size()) {
            if (leaveLengthDouble > 0.0) {
                AtsLeaveBillDetailInfo leaveBillDetailInfo = new AtsLeaveBillDetailInfo();
                leaveBillDetailInfo.setLeavebill(this.billInfo);
                leaveBillDetailInfo.setProposer(personInfo);
                leaveBillDetailInfo.setLeaveDate(dateListAfter.get(i));
                leaveBillDetailInfo.setLeaveUnit(this.atsLeaveBillEntryInfo.getRealUnit());
                leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo);
                leaveBillDetailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
                Double tempDouble = leaveLengthDouble % 1.0;
                if (i == 0 && tempDouble != 0.0) {
                    leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(tempDouble));
                    leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
                    leaveLengthDouble = leaveLengthDouble - tempDouble;
                } else {
                    leaveBillDetailInfo.setLeaveLength(BigDecimal.valueOf(1L));
                    leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
                    leaveLengthDouble = leaveLengthDouble - 1.0;
                }
            }
            ++i;
        }
        IAtsLeaveBillDetail leaveBillDetail = AtsLeaveBillDetailFactory.getLocalInstance((Context)this.ctx);
        leaveBillDetail.addnewBatchData(leaveBillDetailColl);
    }

    private void insertleaveBillDetail(Map<String, Object> dateLenMap) throws BOSException, EASBizException {
        logger.info("AtsLeaveBillSameSplitHelper....insertleaveBillDetail....start");
        Double leaveLengthDouble = this.atsLeaveBillEntryInfo.getRealLeaveLength().doubleValue();
        PersonInfo personInfo = SHRBillServerUtil.getPersonDetailInfo((Context)this.ctx, (String)this.personId);
        CoreBaseCollection leaveBillDetailColl = new CoreBaseCollection();
        HolidayTypeUnitEnum holidayTypeUnit = this.atsLeaveBillEntryInfo.getRealUnit();
        Object[] key = dateLenMap.keySet().toArray();
        Arrays.sort(key);
        BigDecimal leavelen = this.atsLeaveBillEntryInfo.getRealLeaveLength();
        Map<Object, Object> map = new HashMap();
        try {
            AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo((Context)this.ctx, (Timestamp)HRTimeWebUtils.stringShortToTimestamp((String)key[0].toString()), (Timestamp)HRTimeWebUtils.stringShortToTimestamp((String)key[key.length - 1].toString()), (String)this.personId, null);
            AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = null;
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance((Context)this.ctx).getAtsHolidayFileHisCollection("where proposer.id='" + this.personId + "'  order by effdt asc");
            if (atsHolidayFileHisCollection != null && atsHolidayFileHisCollection.size() > 0) {
                int i = 0;
                while (i < atsHolidayFileHisCollection.size()) {
                    AtsHolidayFileHisInfo atsHolidayFileHis = atsHolidayFileHisCollection.get(i);
                    if (HRTimeWebUtils.stringShortToTimestamp((String)key[0].toString()).getTime() >= atsHolidayFileHis.getEFFDT().getTime() && HRTimeWebUtils.stringShortToTimestamp((String)key[key.length - 1].toString()).getTime() <= atsHolidayFileHis.getLEFFDT().getTime()) {
                        atsHolidayFileHisInfo = atsHolidayFileHisCollection.get(i);
                    }
                    ++i;
                }
            }
            map = AtsLeaveBillSameSplitHelper.getWorkCalendarItemInfoByDate(this.ctx, key[0].toString(), key[key.length - 1].toString(), attendanceFileHisInfo, atsHolidayFileHisInfo);
        }
        catch (Exception var21) {
            var21.printStackTrace();
        }
        int len = key.length;
        int i = 0;
        while (i < len) {
            String keyStr;
            WorkCalendarItemInfo workCalendarItemInfo;
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)this.ctx, (String)this.personId, (Date)new Date(HRTimeWebUtils.stringToTimestamp((String)(key[i] + " 00:00:00")).getTime()));
            if (scheduleShiftInfo != null || (workCalendarItemInfo = (WorkCalendarItemInfo)((Map)map).get(keyStr = key[i].toString().substring(0, 10))) != null && workCalendarItemInfo.getDayType() != null && (this.holidayPolicyInfo.isIsIncludeRest() || workCalendarItemInfo != null && workCalendarItemInfo.getDayType() != DayTypeEnum.restDay && workCalendarItemInfo.getDayType() != DayTypeEnum.legalHoliday)) {
                BigDecimal tempLen;
                Map dateMap = (Map)dateLenMap.get(key[i]);
                new BigDecimal(0);
                if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                    tempLen = BigDecimal.valueOf((Double)dateMap.get("calDay"));
                    if (this.holidayPolicyInfo.isIsRoundSum()) {
                        tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(this.holidayPolicyInfo, tempLen));
                    }
                    if (leavelen.compareTo(tempLen) > 0 && i != len - 1) {
                        leavelen = leavelen.subtract(tempLen);
                    } else {
                        tempLen = leavelen;
                    }
                } else {
                    tempLen = BigDecimal.valueOf((Double)dateMap.get("calHour"));
                    if (this.holidayPolicyInfo.isIsRoundSum()) {
                        tempLen = BigDecimal.valueOf(this.getValueByMinLeaveLength(this.holidayPolicyInfo, tempLen));
                    }
                    if (leavelen.compareTo(tempLen) > 0 && i != len - 1) {
                        leavelen = leavelen.subtract(tempLen);
                    } else {
                        tempLen = leavelen;
                    }
                }
                List<Map<String, Object>> dateList = this.getLeaveSuchScheduleDetal(HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(key[i].toString().substring(0, 10)) + " 00:00:00")), this.personId, tempLen);
                int j = 0;
                while (j < dateList.size()) {
                    Map<String, Object> mapSplit = dateList.get(j);
                    AtsLeaveBillDetailSameInfo leaveBillDetailInfo = new AtsLeaveBillDetailSameInfo();
                    Date currDate = AtsDateUtils.stringToShortDate((String)((String)key[i]));
                    leaveBillDetailInfo.setLeavebill(this.billInfo.getId().toString());
                    leaveBillDetailInfo.setProposer(personInfo.getId().toString());
                    leaveBillDetailInfo.setLeaveDate(currDate);
                    leaveBillDetailInfo.setLeaveUnit(String.valueOf(holidayTypeUnit.getValue()));
                    leaveBillDetailInfo.setPolicy(this.holidayPolicyInfo.getId().toString());
                    leaveBillDetailInfo.setAdminOrgUnit(this.atsLeaveBillEntryInfo.getAdminOrgUnit().getId().toString());
                    leaveBillDetailInfo.setLeavebillEntry(this.atsLeaveBillEntryInfo.getId().toString());
                    BigDecimal leaveLength = (BigDecimal)mapSplit.get("leaveLength");
                    leaveBillDetailInfo.setLeaveLenght(leaveLength);
                    leaveBillDetailInfo.setPreTime((String)mapSplit.get("beginTime"));
                    leaveBillDetailInfo.setNextTime((String)mapSplit.get("endTime"));
                    String attAdminOrgUnitid = (String)mapSplit.get("attAdminOrgUnit");
                    AdminOrgUnitInfo info = AdminOrgUnitFactory.getLocalInstance((Context)this.ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(attAdminOrgUnitid));
                    leaveBillDetailInfo.setAttAdminOrgUnit(info.getId().toString());
                    leaveBillDetailColl.add((CoreBaseInfo)leaveBillDetailInfo);
                    ++j;
                }
                if (leavelen.compareTo(BigDecimal.valueOf(0L)) == 0) break;
            }
            ++i;
        }
        IAtsLeaveBillDetailSame leaveBillDetail = AtsLeaveBillDetailSameFactory.getLocalInstance(this.ctx);
        leaveBillDetail.addnewBatchData(leaveBillDetailColl);
        logger.info("AtsLeaveBillSameSplitHelper....insertleaveBillDetail....end");
    }

    public static Map<String, WorkCalendarItemInfo> getWorkCalendarItemInfoByDate(Context ctx, String beginDate, String endDate, AttendanceFileHISInfo attendanceFileHisInfo, AtsHolidayFileHisInfo atsHolidayFileHisInfo) throws BOSException, UuidException, SQLException {
        String oql;
        String itemCollKey;
        HashMap<String, WorkCalendarItemInfo> infoMap = new HashMap<String, WorkCalendarItemInfo>();
        WorkCalendarItemCollection itemColl = null;
        if (attendanceFileHisInfo != null && attendanceFileHisInfo.getCalendar().getId() != null) {
            itemCollKey = attendanceFileHisInfo.getCalendar().getId().toString();
            oql = " where date >='" + beginDate + "' and date <='" + endDate + "' and calendargroup.id = '" + itemCollKey + "'";
            itemColl = WorkCalendarItemFactory.getLocalInstance((Context)ctx).getWorkCalendarItemCollection(oql);
        } else if (atsHolidayFileHisInfo != null && atsHolidayFileHisInfo.getCalendar().getId() != null) {
            itemCollKey = atsHolidayFileHisInfo.getCalendar().getId().toString();
            oql = " where date >='" + beginDate + "' and date <='" + endDate + "' and calendargroup.id = '" + itemCollKey + "'";
            itemColl = WorkCalendarItemFactory.getLocalInstance((Context)ctx).getWorkCalendarItemCollection(oql);
        } else {
            itemCollKey = "workCalendarItem_" + beginDate + "_" + endDate;
            itemColl = (WorkCalendarItemCollection)AtsCacheUtil.get((String)itemCollKey);
        }
        int i = 0;
        while (i < itemColl.size()) {
            WorkCalendarItemInfo itemInfo = itemColl.get(i);
            String datestr = AtsDateUtils.dateShortToString((Date)itemInfo.getDate());
            infoMap.put(datestr, itemInfo);
            ++i;
        }
        return infoMap;
    }

    private List<Map<String, Object>> getLeaveSuchScheduleDetal(Timestamp date, String personId, BigDecimal dataLen) throws BOSException {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo((Context)this.ctx, (Timestamp)date, (Timestamp)date, (String)personId, null);
        ScheduleShiftInfo scheduleShiftInfo = null;
        new HashMap();
        AtsShiftItemCollection shiftItemColl = new AtsShiftItemCollection();
        try {
            Timestamp shiftItemEndTime;
            String curBeginTime;
            AtsShiftItemInfo shiftItemInfo;
            HashMap dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate((Context)this.ctx, (String)personId, (Date)date, (Boolean)this.holidayPolicyInfo.isIsFixOTAllowLeave());
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");
            if (scheduleShiftItemColl != null && scheduleShiftItemColl.size() != 0) {
                this.defaultStandardHour = (BigDecimal)dateMap.get("standardHour");
                int i = 0;
                while (i < scheduleShiftItemColl.size()) {
                    AdminOrgUnitInfo attAdminOrgUnit;
                    Object info = null;
                    AtsShiftItemInfo shiftItemInfo2 = null;
                    ScheduleShiftItemInfo info1 = scheduleShiftItemColl.get(i);
                    ScheduleShiftItemCollection scheduleShiftItemcolls = ScheduleShiftItemFactory.getLocalInstance((Context)this.ctx).getScheduleShiftItemCollection(" where id = '" + info1.getId().toString() + "'");
                    if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftItemcolls)) {
                        attAdminOrgUnit = attendanceFileHisInfo.getAttAdminOrgUnit();
                        shiftItemInfo2 = AtsShiftItemFactory.getLocalInstance((Context)this.ctx).getAtsShiftItemInfo((IObjectPK)new ObjectUuidPK(info1.getShiftItem().getId().toString()));
                    } else {
                        ScheduleShiftItemInfo newinfo = ScheduleShiftItemFactory.getLocalInstance((Context)this.ctx).getScheduleShiftItemInfo((IObjectPK)new ObjectUuidPK(info1.getId().toString()));
                        shiftItemInfo2 = this.createScheduleShiftItemToAtsShiftItem(this.ctx, newinfo);
                        attAdminOrgUnit = newinfo.getAttAdminOrgUnit();
                    }
                    shiftItemInfo2.setString("adminOrgUnit", attAdminOrgUnit.getId().toString());
                    String groupId = info1.getGroup().getId().toString();
                    scheduleShiftInfo = ScheduleShiftFactory.getLocalInstance((Context)this.ctx).getScheduleShiftInfo((IObjectPK)new ObjectUuidPK(groupId));
                    shiftItemInfo2.getGroup().setIsElastic(scheduleShiftInfo.isIsElastic());
                    shiftItemColl.add(shiftItemInfo2);
                    ++i;
                }
            } else {
                HashMap defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis((Context)this.ctx, (AttendanceFileHISInfo)attendanceFileHisInfo, (HolidayPolicyInfo)this.holidayPolicyInfo);
                shiftItemColl = (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");
                int i = 0;
                while (i < shiftItemColl.size()) {
                    AtsShiftItemInfo info = shiftItemColl.get(i);
                    info.setString("adminOrgUnit", attendanceFileHisInfo.getAttAdminOrgUnit().getId().toString());
                    ++i;
                }
            }
            Timestamp beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
            Timestamp endTime = this.atsLeaveBillEntryInfo.getEndTime();
            if (shiftItemColl.size() <= 0 && scheduleShiftItemColl.size() <= 0) {
                HashMap<String, Object> dataSpiltMap = new HashMap<String, Object>();
                dataSpiltMap.put("beginTime", "00:00");
                dataSpiltMap.put("endTime", "23:59");
                dataSpiltMap.put("leaveLength", dataLen);
                dataSpiltMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                list.add(dataSpiltMap);
                return list;
            }
            shiftItemColl.sort("segment");
            String curDate = HRTimeWebUtils.timestampToString((Timestamp)date);
            String dateBeginTime = HRTimeWebUtils.timestampToString((Timestamp)beginTime);
            String dateEndTime = HRTimeWebUtils.timestampToString((Timestamp)endTime);
            Map<String, Object> res = this.getIsCtrlHalfDayOff(this.ctx);
            boolean isHalfDayOff = (Boolean)res.get("isHalfDayOff");
            if (curDate.equals(String.valueOf(dateBeginTime.substring(0, 10)) + " 00:00:00")) {
                if (isHalfDayOff) {
                    beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
                    endTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate.substring(0, 10)) + " " + res.get("pmEndTime") + ":00"));
                } else {
                    shiftItemInfo = shiftItemColl.get(0);
                    curBeginTime = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate);
                    shiftItemEndTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curBeginTime) + " " + shiftItemInfo.getPreTime() + ":00"));
                    if (shiftItemEndTime.getTime() > beginTime.getTime()) {
                        beginTime = shiftItemEndTime;
                    }
                    shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
                    if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
                        String nextTime = this.getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate);
                        endTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(nextTime) + " " + shiftItemInfo.getNextTime() + ":00"));
                    }
                }
            }
            if (curDate.equals(String.valueOf(dateEndTime.substring(0, 10)) + " 00:00:00")) {
                if (isHalfDayOff) {
                    if (!curDate.equals(String.valueOf(dateBeginTime.substring(0, 10)) + " 00:00:00")) {
                        beginTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate.substring(0, 10)) + " " + res.get("amBeginTime") + ":00"));
                    }
                    endTime = this.atsLeaveBillEntryInfo.getRealEndTime();
                } else {
                    boolean elasticCalLen;
                    shiftItemInfo = shiftItemColl.get(0);
                    if (!dateBeginTime.substring(0, 10).equals(dateEndTime.substring(0, 10))) {
                        curBeginTime = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
                        beginTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curBeginTime) + " " + shiftItemInfo.getPreTime() + ":00"));
                    }
                    shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
                    curBeginTime = this.getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), dateEndTime.substring(0, 10));
                    shiftItemEndTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curBeginTime.substring(0, 10)) + " " + shiftItemInfo.getNextTime() + ":00"));
                    boolean bl = elasticCalLen = scheduleShiftInfo != null && scheduleShiftInfo.isIsElastic() && this.atsLeaveBillEntryInfo.isIsElasticCalLen();
                    if (shiftItemEndTime.getTime() < endTime.getTime() && !elasticCalLen) {
                        endTime = shiftItemEndTime;
                    }
                }
            }
            if (!curDate.substring(0, 10).equals(dateEndTime.substring(0, 10)) && !curDate.substring(0, 10).equals(dateBeginTime.substring(0, 10))) {
                if (isHalfDayOff) {
                    beginTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate.substring(0, 10)) + " " + res.get("amBeginTime") + ":00"));
                    endTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate.substring(0, 10)) + " " + res.get("pmEndTime") + ":00"));
                } else {
                    shiftItemInfo = shiftItemColl.get(0);
                    curBeginTime = this.getCurDate(shiftItemInfo.getPreTimeDayType().getValue(), curDate.substring(0, 10));
                    beginTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curBeginTime) + " " + shiftItemInfo.getPreTime() + ":00"));
                    if (beginTime.getTime() <= this.atsLeaveBillEntryInfo.getRealBeginTime().getTime()) {
                        beginTime = this.atsLeaveBillEntryInfo.getRealBeginTime();
                    }
                    shiftItemInfo = shiftItemColl.get(shiftItemColl.size() - 1);
                    String curEndTime = this.getCurDate(shiftItemInfo.getNextTimeDayType().getValue(), curDate.substring(0, 10));
                    endTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curEndTime.substring(0, 10)) + " " + shiftItemInfo.getNextTime() + ":00"));
                }
            }
            list = this.getSpiltDate(beginTime, endTime, shiftItemColl, dataLen, curDate.substring(0, 10));
        }
        catch (EASBizException var22) {
            var22.printStackTrace();
        }
        return list;
    }

    private List<Map<String, Object>> getSpiltDate(Timestamp beginDate, Timestamp endDate, AtsShiftItemCollection shiftItemColl, BigDecimal dataLen, String curDate) {
        List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        AtsShiftItemCollection collection = new AtsShiftItemCollection();
        AtsShiftItemCollection overTimecoll = new AtsShiftItemCollection();
        int i = 0;
        while (i < shiftItemColl.size()) {
            AtsShiftItemInfo info = shiftItemColl.get(i);
            String preDay = this.getCurDate(info.getPreTimeDayType().getValue(), curDate);
            Timestamp perTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(preDay) + " " + info.getPreTime() + ":00"));
            String nextDay = this.getCurDate(info.getNextTimeDayType().getValue(), curDate);
            Timestamp nextTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(nextDay) + " " + info.getNextTime() + ":00"));
            if (beginDate.getTime() <= nextTime.getTime() && perTime.getTime() <= endDate.getTime() || info.getGroup().isIsElastic() && this.atsLeaveBillEntryInfo.isIsElasticCalLen()) {
                if (!this.holidayPolicyInfo.isIsFixOTAllowLeave()) {
                    if (info.getAttendanceType() == AttendanceTypeEnum.normalAttance || info.getAttendanceType() == AttendanceTypeEnum.normalAttanceExcludExcep) {
                        collection.add(info);
                    }
                } else if (info.getAttendanceType() != AttendanceTypeEnum.normalAttance && info.getAttendanceType() != AttendanceTypeEnum.normalAttanceExcludExcep) {
                    overTimecoll.add(info);
                } else {
                    collection.add(info);
                }
            }
            ++i;
        }
        BigDecimal billTime = this.defaultStandardHour.multiply(new BigDecimal(3600000));
        this.sourceLen = dataLen.setScale(this.decimalPlaceValue, RoundingMode.HALF_UP);
        Map<String, Object> res = this.getIsCtrlHalfDayOff(this.ctx);
        boolean isHalfDayOff = (Boolean)res.get("isHalfDayOff");
        if (isHalfDayOff) {
            HashMap<String, Object> amMap;
            if (beginDate.getTime() == HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate) + " " + res.get("amBeginTime") + ":00")).getTime() && endDate.getTime() == HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate) + " " + res.get("pmEndTime") + ":00")).getTime()) {
                amMap = new HashMap<String, Object>();
                amMap.put("leaveLength", new BigDecimal(1));
                amMap.put("beginTime", res.get("amBeginTime"));
                amMap.put("endTime", res.get("pmEndTime"));
                amMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(amMap);
            } else if ((beginDate.getTime() != HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate) + " " + res.get("amBeginTime") + ":00")).getTime() || endDate.getTime() != HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate) + " " + res.get("amEndTime") + ":00")).getTime()) && endDate.getTime() != HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(curDate) + " " + res.get("pmBeginTime") + ":00")).getTime()) {
                amMap = new HashMap();
                amMap.put("leaveLength", this.sourceLen);
                amMap.put("beginTime", res.get("pmBeginTime"));
                amMap.put("endTime", res.get("pmEndTime"));
                amMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(amMap);
            } else {
                amMap = new HashMap();
                amMap.put("leaveLength", this.sourceLen);
                amMap.put("beginTime", res.get("amBeginTime"));
                amMap.put("endTime", res.get("amEndTime"));
                amMap.put("attAdminOrgUnit", this.billInfo.getAdminOrg().getId().toString());
                dataList.add(amMap);
            }
        } else {
            dataList = this.getDataSpiltMap(dataList, collection, curDate, beginDate, endDate, billTime, this.defaultStandardHour);
            if (overTimecoll.size() > 0) {
                dataList = this.getDataSpiltMap(dataList, overTimecoll, curDate, beginDate, endDate, billTime, this.defaultStandardHour);
            }
            if (this.sourceLen.compareTo(new BigDecimal(0)) == 1) {
                Map<String, Object> dataSpiltMap = dataList.get(dataList.size() - 1);
                BigDecimal leaveLength = this.sourceLen.add((BigDecimal)dataSpiltMap.get("leaveLength"));
                dataList.get(dataList.size() - 1).put("leaveLength", leaveLength);
            }
        }
        return dataList;
    }

    private List<Map<String, Object>> getDataSpiltMap(List<Map<String, Object>> dataList, AtsShiftItemCollection collection, String curDate, Timestamp beginDate, Timestamp endDate, BigDecimal billTime, BigDecimal defaultHour) {
        int i = 0;
        while (i < collection.size()) {
            block6: {
                AtsShiftItemInfo info;
                HashMap<String, Object> dataSpiltMap;
                block10: {
                    BigDecimal time;
                    BigDecimal item;
                    Timestamp nextTime;
                    Timestamp perTime;
                    block11: {
                        block7: {
                            block9: {
                                block8: {
                                    if (this.sourceLen.compareTo(new BigDecimal(0)) != 1) break block6;
                                    dataSpiltMap = new HashMap<String, Object>();
                                    info = collection.get(i);
                                    String beginTime = this.getCurDate(info.getPreTimeDayType().getValue(), curDate);
                                    perTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(beginTime) + " " + info.getPreTime() + ":00"));
                                    String endTime = this.getCurDate(info.getNextTimeDayType().getValue(), curDate);
                                    nextTime = HRTimeWebUtils.stringToTimestamp((String)(String.valueOf(endTime) + " " + info.getNextTime() + ":00"));
                                    if (i != 0) break block7;
                                    new BigDecimal(0);
                                    if (nextTime.getTime() < endDate.getTime()) break block8;
                                    if (beginDate.getTime() <= perTime.getTime()) {
                                        beginDate = perTime;
                                    }
                                    if ((item = new BigDecimal(endDate.getTime() - beginDate.getTime())).compareTo(BigDecimal.ZERO) <= 0) break block6;
                                    time = item.divide(billTime, this.decimalPlaceValue, 4);
                                    dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString((Timestamp)beginDate).substring(11, 16));
                                    dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString((Timestamp)endDate).substring(11, 16));
                                    break block9;
                                }
                                item = new BigDecimal(nextTime.getTime() - beginDate.getTime());
                                if (item.compareTo(BigDecimal.ZERO) <= 0) break block6;
                                time = item.divide(billTime, this.decimalPlaceValue, 4);
                                dataSpiltMap.put("beginTime", HRTimeWebUtils.timestampToString((Timestamp)beginDate).substring(11, 16));
                                dataSpiltMap.put("endTime", info.getNextTime());
                            }
                            this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, time);
                            break block10;
                        }
                        if (i == collection.size() - 1 || endDate.getTime() <= nextTime.getTime()) break block11;
                        time = new BigDecimal(nextTime.getTime() - perTime.getTime());
                        if (time.compareTo(BigDecimal.ZERO) <= 0) break block6;
                        item = time.divide(billTime, this.decimalPlaceValue, 4);
                        dataSpiltMap.put("beginTime", info.getPreTime());
                        dataSpiltMap.put("endTime", info.getNextTime());
                        this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, item);
                        break block10;
                    }
                    if (endDate.getTime() >= nextTime.getTime()) {
                        endDate = nextTime;
                    }
                    if ((time = new BigDecimal(endDate.getTime() - perTime.getTime())).compareTo(BigDecimal.ZERO) <= 0) break block6;
                    item = time.divide(billTime, this.decimalPlaceValue, 4);
                    dataSpiltMap.put("beginTime", info.getPreTime());
                    dataSpiltMap.put("endTime", HRTimeWebUtils.timestampToString((Timestamp)endDate).substring(11, 16));
                    this.sourceLen = this.getBigDecimal(defaultHour, dataSpiltMap, item);
                }
                dataSpiltMap.put("attAdminOrgUnit", info.getString("adminOrgUnit"));
                dataList.add(dataSpiltMap);
            }
            ++i;
        }
        return dataList;
    }

    private String getCurDate(int dateType, String curDate) {
        Date date = HRTimeWebUtils.stringToShortDate((String)curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (dateType == 0) {
            calendar.add(5, -1);
        } else if (dateType == 2) {
            calendar.add(5, 1);
        }
        return simpleDateFormat.format(calendar.getTime());
    }

    private BigDecimal getBigDecimal(BigDecimal defaultHour, Map<String, Object> dataSpiltMap, BigDecimal time) {
        new BigDecimal(0);
        BigDecimal value = this.holidayPolicyInfo.getUnit().getValue() == 1 ? time : defaultHour.multiply(time).setScale(this.decimalPlaceValue, 4);
        if (this.sourceLen.compareTo(value) == 1) {
            dataSpiltMap.put("leaveLength", value);
            this.sourceLen = this.sourceLen.subtract(value);
        } else {
            dataSpiltMap.put("leaveLength", this.sourceLen);
            this.sourceLen = new BigDecimal(0);
        }
        return this.sourceLen;
    }

    private double getValueByMinLeaveLength(HolidayPolicyInfo holidayPolicyInfo, BigDecimal realLengthBigDecimal) {
        int saveLength = this.getSaveLength(this.ctx, holidayPolicyInfo);
        double length = realLengthBigDecimal.setScale(saveLength, 4).doubleValue();
        if (holidayPolicyInfo != null && holidayPolicyInfo.isEnableLeaveLength()) {
            double M = holidayPolicyInfo.getMinLeaveLength().doubleValue();
            int minLeaveLengthMtd = holidayPolicyInfo.getMinLeaveLengthVMtd().getValue();
            int ZNum = (int)(length / M);
            double XSNum = length % M;
            if (minLeaveLengthMtd == 1) {
                length = ((double)ZNum + Math.floor(XSNum / M)) * M;
            } else if (minLeaveLengthMtd == 2) {
                length = ((double)ZNum + Math.ceil(XSNum / M)) * M;
            } else if (minLeaveLengthMtd == 3) {
                length = (double)((long)ZNum + Math.round(XSNum / M)) * M;
            }
        }
        return length;
    }

    public int getSaveLength(Context ctx, HolidayPolicyInfo holidayPolicyInfo) {
        int saveLength;
        if (holidayPolicyInfo != null && holidayPolicyInfo.isEnableLeaveLength()) {
            Double MinLeaveLength = holidayPolicyInfo.getMinLeaveLength().stripTrailingZeros().doubleValue();
            saveLength = AtsLeaveBillSameSplitHelper.getNumberDecimalDigits(MinLeaveLength);
        } else {
            saveLength = DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx);
        }
        return saveLength;
    }

    public static int getNumberDecimalDigits(double number) {
        if (number == (double)((long)number)) {
            return 0;
        }
        int i = 0;
        while (number * Math.pow(10.0, ++i) % 1.0 != 0.0) {
        }
        return i;
    }

    private int getDayType(String personId, Date date) throws BOSException, EASBizException {
        java.sql.Date dateSql = new java.sql.Date(date.getTime());
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)this.ctx, (String)personId, (Date)date);
        if (scheduleShiftInfo != null) {
            return scheduleShiftInfo.getDayType().getValue();
        }
        AttendanceFileCollection attendanceFileColl = AtsServerUtils.getAttendanceFileByPersonId((Context)this.ctx, (String)personId);
        if (attendanceFileColl != null && attendanceFileColl.get(0) != null && attendanceFileColl.get(0).getAttencePolicy() != null) {
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFactory.getLocalInstance((Context)this.ctx).getAttencePolicyInfo(" where id='" + attendanceFileColl.get(0).getAttencePolicy().getId().toString() + "'");
            WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance((Context)this.ctx).getWorkCalendarInfo(" where id='" + attencePolicyInfo.getWorkCalendar().getId().toString() + "'");
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance((Context)this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + workCalendarInfo.getId().toString() + "' and date='" + dateSql + "'");
            if (workCalendarItemColl.size() > 0) {
                return workCalendarItemColl.get(0).getDayType().getValue();
            }
        } else if (this.holidayPolicyInfo.getHolidayPolicySet() != null) {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance((Context)this.ctx).getHolidayPolicySetInfo("where id = '" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "'");
            WorkCalendarInfo workCalendarInfo = WorkCalendarFactory.getLocalInstance((Context)this.ctx).getWorkCalendarInfo(" where id='" + holidayPolicySetInfo.getWorkCalendar().getId().toString() + "'");
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance((Context)this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + workCalendarInfo.getId().toString() + "' and date='" + dateSql + "'");
            if (workCalendarItemColl.size() > 0) {
                return workCalendarItemColl.get(0).getDayType().getValue();
            }
        }
        return 0;
    }

    private BigDecimal getStandardHour(String personId, Date date) throws BOSException, EASBizException {
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)this.ctx, (String)personId, (Date)date);
        if (scheduleShiftInfo != null) {
            return scheduleShiftInfo.getDefaultShift().getStandardHour();
        }
        AttendanceFileCollection attendanceFileColl = AtsServerUtils.getAttendanceFileByPersonId((Context)this.ctx, (String)personId);
        AtsShiftCollection atsShiftColl = new AtsShiftCollection();
        if (attendanceFileColl.get(0).getAtsShift() != null) {
            atsShiftColl = AtsShiftFactory.getLocalInstance((Context)this.ctx).getAtsShiftCollection(" where id='" + attendanceFileColl.get(0).getAtsShift().getId() + "'");
        }
        return atsShiftColl.size() > 0 ? atsShiftColl.get(0).getStandardHour() : this.defaultStandardHour;
    }

    private List dealDateNew(List<Date> dateList) throws EASBizException, BOSException {
        int length = dateList.size();
        String beginDate = AtsDateUtils.dateShortToString((Date)dateList.get(0));
        String endDate = AtsDateUtils.dateShortToString((Date)dateList.get(length - 1));
        String personIds = "'" + this.personId + "'";
        Map scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)this.ctx, (String)personIds, (String)beginDate, (String)endDate);
        Map attendanceFileMap = AtsServerUtils.getAttendanceFileInfoByPersonId((Context)this.ctx, (String)personIds, (String)beginDate, (String)endDate);
        if (AtsCollectionUtile.isEmpty((Map)attendanceFileMap)) {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance((Context)this.ctx).getHolidayPolicySetInfo("select workCalendar.id where id = '" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "'");
            WorkCalendarItemCollection workCalendarItemColl = WorkCalendarItemFactory.getLocalInstance((Context)this.ctx).getWorkCalendarItemCollection(" where calendarGroup='" + holidayPolicySetInfo.getWorkCalendar().getId().toString() + "' and date>={ts'" + beginDate + "'} and date <={ts'" + endDate + "'} order by date asc ");
            if (this.holidayPolicyInfo.getHolidayPolicySet() != null) {
                int i = 0;
                while (i < dateList.size()) {
                    if (workCalendarItemColl.get(i) != null && workCalendarItemColl.get(i).getDayType() != null) {
                        int dayType = workCalendarItemColl.get(i).getDayType().getValue();
                        if (!this.isIncludeLegal.booleanValue() && dayType == 2) {
                            dateList.remove(i);
                            workCalendarItemColl.remove(workCalendarItemColl.get(i));
                            --i;
                        } else if (!this.isIncludeRest.booleanValue() && dayType == 1) {
                            dateList.remove(i);
                            workCalendarItemColl.remove(workCalendarItemColl.get(i));
                            --i;
                        }
                    }
                    ++i;
                }
            }
        } else {
            HashSet<String> unScheduleDateSet = new HashSet<String>();
            Iterator<Date> var19 = dateList.iterator();
            while (true) {
                if (!var19.hasNext()) {
                    Map<String, Map> workCalendarItemMap = null;
                    if (unScheduleDateSet.size() > 0) {
                        workCalendarItemMap = this.getWorkCalendarItembyID(attendanceFileMap, unScheduleDateSet);
                    }
                    int i = 0;
                    while (i < dateList.size()) {
                        Date currentDate = dateList.get(i);
                        int dayType = 0;
                        String scheduleShiftKey1 = String.valueOf(this.personId) + "_" + AtsDateUtils.dateShortToString((Date)currentDate);
                        if (scheduleShiftMap != null && scheduleShiftMap.get(scheduleShiftKey1) != null) {
                            ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)scheduleShiftMap.get(scheduleShiftKey1);
                            if (scheduleShiftInfo.getDayType() != null) {
                                dayType = scheduleShiftInfo.getDayType().getValue();
                            }
                        } else {
                            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileMap.get(scheduleShiftKey1);
                            if (attendanceFileInfo != null && attendanceFileInfo.getAttencePolicy() != null && attendanceFileInfo.getAttencePolicy().getWorkCalendar() != null) {
                                WorkCalendarItemInfo info;
                                Map infoMap;
                                String workCalendarId = ((AttendanceFileInfo)attendanceFileMap.get(scheduleShiftKey1)).getAttencePolicy().getWorkCalendar().getId().toString();
                                if (workCalendarItemMap != null && (infoMap = workCalendarItemMap.get(workCalendarId)) != null && (info = (WorkCalendarItemInfo)infoMap.get(AtsDateUtils.dateShortToString((Date)currentDate))) != null && info.getDayType() != null) {
                                    dayType = info.getDayType().getValue();
                                }
                            }
                        }
                        if (!this.isIncludeLegal.booleanValue() && dayType == 2) {
                            dateList.remove(i);
                            --i;
                        } else if (!this.isIncludeRest.booleanValue() && dayType == 1) {
                            dateList.remove(i);
                            --i;
                        }
                        ++i;
                    }
                    break;
                }
                Date date = var19.next();
                String scheduleShiftKey = String.valueOf(this.personId) + "_" + AtsDateUtils.dateShortToString((Date)date);
                if (scheduleShiftMap != null && scheduleShiftMap.size() != 0 && scheduleShiftMap.get(scheduleShiftKey) != null) continue;
                unScheduleDateSet.add(AtsDateUtils.dateShortToString((Date)date));
            }
        }
        return dateList;
    }

    private Map<String, Map> getWorkCalendarItembyID(Map<String, AttendanceFileInfo> attendanceFileMap, Set<String> unScheduleDateSet) throws BOSException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        HashSet<String> workCalendarIds = new HashSet<String>();
        for (Map.Entry<String, AttendanceFileInfo> entry : attendanceFileMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().getCalendar() == null) continue;
            workCalendarIds.add(entry.getValue().getCalendar().getId().toString());
        }
        String workCalendarIdStr = AtsCollectionUtile.joinForSql(workCalendarIds);
        System.out.println("splitHelperError:" + AtsLeaveBillSameSplitHelper.convertSetToString(unScheduleDateSet));
        StringBuffer buffer = new StringBuffer();
        buffer.append("select FDayType,fid,FDate,FCalendarGroupID ").append(" from T_HR_ATS_WorkCalendarItem ").append(" where FCalendarGroupID in (").append(workCalendarIdStr).append(") ").append(" and FDate in(").append(AtsLeaveBillSameSplitHelper.convertSetToString(unScheduleDateSet)).append(") ");
        WorkCalendarItemCollection workCalendarItemColl = new WorkCalendarItemCollection();
        try {
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)buffer.toString());
            while (row.next()) {
                WorkCalendarItemInfo info = new WorkCalendarItemInfo();
                WorkCalendarInfo dar = new WorkCalendarInfo();
                info.setDayType(DayTypeEnum.getEnum((int)row.getInt("FDayType")));
                info.setId(BOSUuid.read((String)row.getString("fid")));
                dar.setId(BOSUuid.read((String)row.getString("FCalendarGroupID")));
                info.setCalendarGroup(dar);
                info.setDate((Date)row.getDate("FDate"));
                workCalendarItemColl.add(info);
            }
        }
        catch (SQLException var14) {
            var14.printStackTrace();
        }
        for (String workCalendarId : workCalendarIds) {
            HashMap<String, WorkCalendarItemInfo> workCalendarMap = new HashMap<String, WorkCalendarItemInfo>();
            for (String dateStr : unScheduleDateSet) {
                int j = 0;
                while (j < workCalendarItemColl.size()) {
                    if (workCalendarItemColl.get(j).getCalendarGroup().getId().toString().equals(workCalendarId) && workCalendarItemColl.get(j).getDate().toString().equals(dateStr)) {
                        workCalendarMap.put(dateStr, workCalendarItemColl.get(j));
                    }
                    ++j;
                }
            }
            result.put(workCalendarId, workCalendarMap);
        }
        return result;
    }

    public static String convertSetToString(Set set) {
        if (set != null && set.size() > 0) {
            Iterator iter = set.iterator();
            StringBuffer sql = new StringBuffer();
            while (iter.hasNext()) {
                String date = iter.next().toString();
                if (date.length() > 0) {
                    date = date.substring(0, 10);
                }
                sql.append("{ts'");
                sql.append(date);
                sql.append("'},");
            }
            sql.deleteCharAt(sql.length() - 1);
            return sql.toString();
        }
        return "''";
    }

    private List getLeaveDateColl(Timestamp beginTime, Timestamp endTime) throws EASBizException, BOSException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Date beginDate = AtsDateUtils.stringToShortDate((String)AtsDateUtils.dateLongToString((Date)beginTime));
        Date endDate = AtsDateUtils.stringToShortDate((String)AtsDateUtils.dateLongToString((Date)endTime));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int temp = (int)((endDate.getTime() - beginDate.getTime()) / 86400000L + 1L);
        int i = 0;
        while (i < temp) {
            int year = beginCal.get(1);
            int month = beginCal.get(2);
            int day = beginCal.get(5);
            Date tempDate = new Date(year - 1900, month, day);
            dateList.add(tempDate);
            beginCal.add(5, 1);
            ++i;
        }
        return dateList;
    }

    public Map<String, Object> calRealLeaveLengthInfo(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicyInfo holidayPolicyInfo) {
        int tempAfterDealDateListSize = afterDealDateList.size();
        new AtsShiftItemCollection();
        Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp((Date)beginTimeCount);
        Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp((Date)endTimeCount);
        HashMap defaultItemMap = new HashMap();
        try {
            AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo((Context)this.ctx, (Timestamp)beginTimeCountTs, (Timestamp)endTimeCountTs, (String)this.personId, null);
            defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis((Context)this.ctx, (AttendanceFileHISInfo)attendanceFileHisInfo, (HolidayPolicyInfo)holidayPolicyInfo);
        }
        catch (BOSException var23) {
            var23.printStackTrace();
        }
        AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");
        this.defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
        String beginDate = AtsDateUtils.dateLongToString((Date)beginTimeCount).substring(0, 10);
        String endDate = AtsDateUtils.dateLongToString((Date)endTimeCount).substring(0, 10);
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
        BigDecimal standardHour = new BigDecimal(0);
        try {
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance((Context)this.ctx).getAtsHolidayFileHisCollection("where proposer.id='" + this.personId + "'  order by effdt asc");
            if (atsHolidayFileHisCollection != null && atsHolidayFileHisCollection.size() > 0) {
                int i = 0;
                while (i < atsHolidayFileHisCollection.size()) {
                    AtsHolidayFileHisInfo atsHolidayFileHisInfo = atsHolidayFileHisCollection.get(i);
                    if (beginTimeCount.getTime() >= atsHolidayFileHisInfo.getEFFDT().getTime() && endTimeCount.getTime() <= atsHolidayFileHisInfo.getLEFFDT().getTime()) {
                        String id = atsHolidayFileHisInfo.getHolidayPolicySet().getId().toString();
                        HolidayPolicySetInfo holidayPolicyInfo_1 = HolidayPolicySetFactory.getLocalInstance((Context)this.ctx).getHolidayPolicySetInfo(" where id = '" + id + "'");
                        standardHour = holidayPolicyInfo_1.getDefaultStandardHour();
                    }
                    ++i;
                }
            }
        }
        catch (Exception var24) {
            var24.printStackTrace();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personId", this.personId);
        paramMap.put("beginDate", beginDate);
        paramMap.put("endDate", endDate);
        paramMap.put("endTimeCount", endTimeCount);
        paramMap.put("beginTimeCount", beginTimeCount);
        paramMap.put("defaultStandardHour", this.defaultStandardHour);
        paramMap.put("holidayTypeUnit", holidayTypeUnit);
        paramMap.put("isFixOTAllowLeave", holidayPolicyInfo.isIsFixOTAllowLeave());
        paramMap.put("afterDealDateList", afterDealDateList);
        paramMap.put("defaultAtsShiftItemCollection", defaultAtsShiftItemCollection);
        paramMap.put("dayStandardHour", standardHour);
        HashMap<String, Object> DateLeaveLenMap = new HashMap<String, Object>();
        if (tempAfterDealDateListSize != 0) {
            if (afterDealDateList.size() == 1 && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime())) && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()))) {
                paramMap.put("curDate", beginDate);
                paramMap.put("index", "index");
                this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
            } else {
                Date nowDate;
                String nowDateStr;
                boolean isPreEndDate;
                boolean isContainBeginDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime()));
                boolean isContainEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()));
                if (isContainBeginDate) {
                    paramMap.put("curDate", beginDate);
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                if (isContainEndDate) {
                    paramMap.put("curDate", endDate);
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                if (tempAfterDealDateListSize >= 3 && (isPreEndDate = afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(nowDateStr = AtsDateUtils.dateShortToString((Date)(nowDate = AtsDateUtils.getPreDay((Date)AtsDateUtils.stringToShortDate((String)endDate))))) + " 00:00:00")).getTime())))) {
                    paramMap.put("curDate", nowDateStr);
                    paramMap.put("nowDate", nowDate);
                    paramMap.put("index", "calPreEndDate");
                    afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(nowDateStr) + " 00:00:00")).getTime()));
                    this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
                }
                this.getMidleDateLength(this.ctx, paramMap, DateLeaveLenMap);
            }
        }
        Date nowDate1 = AtsDateUtils.getPreDay((Date)AtsDateUtils.stringToShortDate((String)beginDate));
        String nowDateStr1 = AtsDateUtils.dateShortToString((Date)nowDate1);
        paramMap.put("curDate", nowDateStr1);
        paramMap.put("nowDate", nowDate1);
        paramMap.put("index", "calPrebeginDate");
        this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
        nowDate1 = AtsDateUtils.getNextDay((Date)AtsDateUtils.stringToShortDate((String)endDate));
        nowDateStr1 = AtsDateUtils.dateShortToString((Date)nowDate1);
        paramMap.put("curDate", nowDateStr1);
        paramMap.put("nowDate", nowDate1);
        paramMap.put("index", "calNextendDate");
        this.getBeginDateOrEndDateLength(this.ctx, paramMap, DateLeaveLenMap);
        return DateLeaveLenMap;
    }

    public void getMidleDateLength(Context ctx, Map<String, Object> paramMap, Map<String, Object> DateLeaveLenMap) {
        block13: {
            BigDecimal dayStandardHour;
            BigDecimal defaultStandardHour;
            Boolean isFixOTAllowLeave;
            String endDate;
            String beginDate;
            String personId;
            AtsShiftItemCollection defaultAtsShiftItemCollection;
            List afterDealDateList;
            HolidayTypeUnitEnum holidayTypeUnit;
            block14: {
                holidayTypeUnit = (HolidayTypeUnitEnum)paramMap.get("holidayTypeUnit");
                afterDealDateList = (List)paramMap.get("afterDealDateList");
                defaultAtsShiftItemCollection = (AtsShiftItemCollection)paramMap.get("defaultAtsShiftItemCollection");
                personId = (String)paramMap.get("personId");
                beginDate = (String)paramMap.get("beginDate");
                endDate = (String)paramMap.get("endDate");
                isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");
                defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
                dayStandardHour = (BigDecimal)paramMap.get("dayStandardHour");
                new BigDecimal(0);
                if (afterDealDateList.size() <= 0) break block13;
                if (holidayTypeUnit != HolidayTypeUnitEnum.day) break block14;
                int i = 0;
                while (i < afterDealDateList.size()) {
                    boolean isHalfDay = AtsLeaveBillUtils.isHalfDay((Context)ctx, (String)personId, (Date)((Date)afterDealDateList.get(i)));
                    String curDate = AtsDateUtils.dateShortToString((Date)((Date)afterDealDateList.get(i)));
                    HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                    if (isHalfDay) {
                        curDateMap.put("calDay", 0.5);
                    } else {
                        curDateMap.put("calDay", 1.0);
                    }
                    curDateMap.put("calHour", 0.0);
                    DateLeaveLenMap.put(curDate, curDateMap);
                    ++i;
                }
                break block13;
            }
            if (holidayTypeUnit != HolidayTypeUnitEnum.hour) break block13;
            try {
                Map scheduleShiftInfoMap = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)ctx, (String)personId, (String)beginDate, (String)endDate);
                ScheduleShiftInfo scheduleShiftInfo = null;
                int i = 0;
                while (i < afterDealDateList.size()) {
                    HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                    Date currentDate = (Date)afterDealDateList.get(i);
                    String curDate = AtsDateUtils.dateShortToString((Date)currentDate);
                    curDateMap.put("calDay", 0.0);
                    String key = String.valueOf(personId) + "_" + AtsDateUtils.dateShortToString((Date)currentDate);
                    DateLeaveLenMap.put(curDate, curDateMap);
                    if (scheduleShiftInfoMap != null) {
                        scheduleShiftInfo = (ScheduleShiftInfo)scheduleShiftInfoMap.get(key);
                    }
                    if (scheduleShiftInfo != null) {
                        BigDecimal standardHour = scheduleShiftInfo.getStandardHour();
                        curDateMap.put("calHour", standardHour.doubleValue());
                        if (isFixOTAllowLeave.booleanValue()) {
                            curDateMap.put("calHour", standardHour.doubleValue() + this.getFixOTSegHour(scheduleShiftInfo.getItems()));
                        }
                    } else if (defaultAtsShiftItemCollection.size() != 0) {
                        curDateMap.put("calHour", defaultStandardHour.doubleValue());
                        if (isFixOTAllowLeave.booleanValue()) {
                            curDateMap.put("calHour", defaultStandardHour.doubleValue() + this.getFixOTSegHour(defaultAtsShiftItemCollection));
                        }
                    } else {
                        curDateMap.put("calHour", dayStandardHour.doubleValue());
                    }
                    ++i;
                }
            }
            catch (Exception var21) {
                var21.printStackTrace();
            }
        }
    }

    public double getFixOTSegHour(ScheduleShiftItemCollection item) {
        double otSegHour = 0.0;
        ScheduleShiftItemInfo info = null;
        int i = 0;
        int len = item.size();
        while (i < len) {
            info = item.get(i);
            if (info.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) {
                otSegHour += (double)((info.getNextDateTime().getTime() - info.getPreDateTime().getTime()) / 3600000L);
            }
            ++i;
        }
        return otSegHour;
    }

    public double getFixOTSegHour(AtsShiftItemCollection item) {
        double otSegHour = 0.0;
        AtsShiftItemInfo info = null;
        int i = 0;
        int len = item.size();
        while (i < len) {
            info = item.get(i);
            if (info.getAttendanceType().equals((Object)AttendanceTypeEnum.fixedOverTime)) {
                String nextTime;
                String preTime = String.valueOf(info.getPreTime()) + ":00";
                if (preTime.compareTo(nextTime = String.valueOf(info.getNextTime()) + ":00") > 0) {
                    preTime = "1900-01-01 " + preTime;
                    nextTime = "1900-01-02 " + nextTime;
                } else {
                    preTime = "1900-01-01 " + preTime;
                    nextTime = "1900-01-01 " + nextTime;
                }
                otSegHour += (double)((HRTimeWebUtils.stringToTimestamp((String)nextTime).getTime() - HRTimeWebUtils.stringToTimestamp((String)preTime).getTime()) / 3600000L);
            }
            ++i;
        }
        return otSegHour;
    }

    public void getBeginDateOrEndDateLength(Context ctx, Map<String, Object> paramMap, Map<String, Object> DateLeaveLenMap) {
        HolidayTypeUnitEnum holidayTypeUnit = (HolidayTypeUnitEnum)paramMap.get("holidayTypeUnit");
        AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)paramMap.get("defaultAtsShiftItemCollection");
        String personId = (String)paramMap.get("personId");
        String beginDate = (String)paramMap.get("beginDate");
        String endDate = (String)paramMap.get("endDate");
        String curDate = (String)paramMap.get("curDate");
        Boolean isFixOTAllowLeave = (Boolean)paramMap.get("isFixOTAllowLeave");
        Timestamp beginTimeCount = (Timestamp)paramMap.get("beginTimeCount");
        Timestamp endTimeCount = (Timestamp)paramMap.get("endTimeCount");
        BigDecimal defaultStandardHour = (BigDecimal)paramMap.get("defaultStandardHour");
        BigDecimal standardHour = (BigDecimal)paramMap.get("dayStandardHour");
        long leaveLength = 0L;
        try {
            HashMap dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate((Context)ctx, (String)personId, (Date)new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(curDate) + " 00:00:00")).getTime()), (Boolean)isFixOTAllowLeave);
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");
            if (scheduleShiftItemColl.size() == 0 && defaultAtsShiftItemCollection.size() == 0) {
                standardHour = new BigDecimal(24);
                String index = (String)paramMap.get("index");
                if (!StringUtils.isEmpty((String)index) && index.equals("index")) {
                    leaveLength = endTimeCount.getTime() - beginTimeCount.getTime();
                } else if (curDate.equals(endDate)) {
                    leaveLength = leaveLength + endTimeCount.getTime() - AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime();
                } else if (curDate.equals(beginDate)) {
                    leaveLength = leaveLength + AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 23:59:59")).getTime() - beginTimeCount.getTime();
                } else if (!StringUtils.isEmpty((String)index) && index.equals("calPreEndDate")) {
                    leaveLength = (long)((double)standardHour.longValue() * 60.0 * 60.0 * 1000.0);
                }
            } else {
                List shift = null;
                if (scheduleShiftItemColl.size() != 0) {
                    standardHour = (BigDecimal)dateMap.get("standardHour");
                    shift = AtsLeaveBillUtils.getShiftItemInfos((Object)scheduleShiftItemColl, (String)curDate, this.atsLeaveBillEntryInfo == null ? null : Boolean.valueOf(this.atsLeaveBillEntryInfo.isIsElasticCalLen()));
                } else {
                    standardHour = defaultStandardHour;
                    shift = AtsLeaveBillUtils.getShiftItemInfos((Object)defaultAtsShiftItemCollection, (String)curDate, this.atsLeaveBillEntryInfo == null ? null : Boolean.valueOf(this.atsLeaveBillEntryInfo.isIsElasticCalLen()));
                }
                Map res = AtsLeaveBillUtils.calSegmentLength((Context)ctx, (List)shift, (Timestamp)beginTimeCount, (Timestamp)endTimeCount, (long)leaveLength, (HolidayPolicyInfo)this.holidayPolicyInfo, (BigDecimal)standardHour);
                leaveLength = (Long)res.get("realLen");
            }
        }
        catch (EASBizException var21) {
            var21.printStackTrace();
        }
        catch (BOSException var22) {
            var22.printStackTrace();
        }
        HashMap<String, Double> curDateMap = new HashMap<String, Double>();
        if (leaveLength > 0L) {
            if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                boolean isHalfDay = AtsLeaveBillUtils.isHalfDay((Context)ctx, (String)personId, (Date)HRTimeWebUtils.stringToShortDate((String)curDate));
                if (isHalfDay) {
                    curDateMap.put("calDay", (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0 * 2.0) > 0.5 ? 0.5 : (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0 * 2.0));
                } else {
                    curDateMap.put("calDay", (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0) > 1.0 ? 1.0 : (double)leaveLength / (standardHour.doubleValue() * 60.0 * 60.0 * 1000.0));
                }
            } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                curDateMap.put("calHour", (double)leaveLength / 3600000.0 > standardHour.doubleValue() ? standardHour.doubleValue() : (double)leaveLength / 3600000.0);
            }
            DateLeaveLenMap.put(curDate, curDateMap);
        }
    }

    public Map<String, Object> calRealLeaveLengthOfDay(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicySetInfo holidayPolicySetInfo, HolidayPolicyInfo holidayPolicyInfo) throws BOSException, EASBizException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (afterDealDateList.size() == 0) {
            return retMap;
        }
        Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp((Date)beginTimeCount);
        Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp((Date)endTimeCount);
        AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo((Context)this.ctx, (Timestamp)beginTimeCountTs, (Timestamp)endTimeCountTs, (String)this.personId, null);
        HashMap defaultItemMap = AtsLeaveBillUtils.getdefaultShiftItemByHis((Context)this.ctx, (AttendanceFileHISInfo)attendanceFileHisInfo, (HolidayPolicyInfo)holidayPolicyInfo);
        AtsShiftItemCollection defaultAtsShiftItemCollection = (AtsShiftItemCollection)defaultItemMap.get("scheduleShiftItemColl");
        BigDecimal defaultStandardHour = (BigDecimal)defaultItemMap.get("standardHour");
        new BigDecimal(8);
        String beginDate = AtsDateUtils.dateLongToString((Date)beginTimeCount).substring(0, 10);
        String endDate = AtsDateUtils.dateLongToString((Date)endTimeCount).substring(0, 10);
        String amStartTime = holidayPolicySetInfo.getAmStartWorkTime();
        String amEndTime = holidayPolicySetInfo.getAmEndWorkTime();
        String pmStartTime = holidayPolicySetInfo.getPmStartWorkTime();
        String pmEndTime = holidayPolicySetInfo.getPmEndWorkTime();
        HolidayTypeUnitEnum holidayUnit = holidayPolicyInfo.getUnit();
        Boolean isFixOTAllowLeave = holidayPolicyInfo.isIsFixOTAllowLeave();
        double realLength = 0.0;
        double leaveLengthDay = 0.0;
        double leaveLengthHour = 0.0;
        if (afterDealDateList.size() == 1 && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime())) && afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()))) {
            boolean isHalfDay = AtsLeaveBillUtils.isHalfDay((Context)this.ctx, (String)this.personId, (Date)HRTimeWebUtils.stringToShortDate((String)beginDate));
            String amEndTimeTemp = AtsDateUtils.dateLongToString((Date)beginTimeCount).substring(11, 16);
            String endTimeTemp = AtsDateUtils.dateLongToString((Date)endTimeCount).substring(11, 16);
            realLength = !(amEndTimeTemp.equals(amStartTime) && endTimeTemp.equals(amEndTime) || amEndTimeTemp.equals(pmStartTime) && endTimeTemp.equals(pmEndTime) || amEndTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmStartTime) || amEndTimeTemp.equals(amEndTime) && endTimeTemp.equals(pmEndTime)) ? (amEndTimeTemp.equals(amStartTime) && endTimeTemp.equals(pmEndTime) ? 1.0 : 0.0) : 0.5;
            if (realLength > 0.0) {
                HashMap<String, Double> curDateMap = new HashMap<String, Double>();
                if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                    leaveLengthDay = isHalfDay ? 0.5 : realLength;
                    curDateMap.put("calDay", leaveLengthDay);
                    curDateMap.put("calHour", 0.0);
                } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                    BigDecimal standardHour = this.getStandardHourOfDay(this.ctx, this.personId, beginDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                    leaveLengthHour = realLength * standardHour.doubleValue();
                    curDateMap.put("calDay", 0.0);
                    curDateMap.put("calHour", leaveLengthHour);
                }
                retMap.put(beginDate, curDateMap);
            }
        } else {
            BigDecimal standardHour;
            HashMap<String, Double> curDateMap;
            String amEndTimeTemp;
            boolean isHalfDay;
            if (afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime()))) {
                isHalfDay = AtsLeaveBillUtils.isHalfDay((Context)this.ctx, (String)this.personId, (Date)HRTimeWebUtils.stringToShortDate((String)beginDate));
                amEndTimeTemp = AtsDateUtils.dateLongToString((Date)beginTimeCount).substring(11, 16);
                afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(beginDate) + " 00:00:00")).getTime()));
                realLength = amEndTimeTemp.equals(amStartTime) ? 1.0 : (amEndTimeTemp.equals(pmStartTime) ? 0.5 : 0.0);
                if (realLength > 0.0) {
                    curDateMap = new HashMap<String, Double>();
                    if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                        leaveLengthDay = isHalfDay ? 0.5 : realLength;
                        curDateMap.put("calDay", leaveLengthDay);
                        curDateMap.put("calHour", 0.0);
                    } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                        standardHour = this.getStandardHourOfDay(this.ctx, this.personId, beginDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                        leaveLengthHour = realLength * standardHour.doubleValue();
                        curDateMap.put("calDay", 0.0);
                        curDateMap.put("calHour", leaveLengthHour);
                    }
                    retMap.put(beginDate, curDateMap);
                }
            }
            if (afterDealDateList.contains(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()))) {
                isHalfDay = AtsLeaveBillUtils.isHalfDay((Context)this.ctx, (String)this.personId, (Date)HRTimeWebUtils.stringToShortDate((String)endDate));
                afterDealDateList.remove(new Date(AtsDateUtils.stringToTimestamp((String)(String.valueOf(endDate) + " 00:00:00")).getTime()));
                amEndTimeTemp = AtsDateUtils.dateLongToString((Date)endTimeCount).substring(11, 16);
                realLength = 0.0;
                realLength = !amEndTimeTemp.equals(amEndTime) && !amEndTimeTemp.equals(pmStartTime) ? (amEndTimeTemp.equals(pmEndTime) ? 1.0 : 0.0) : 0.5;
                if (realLength > 0.0) {
                    curDateMap = new HashMap();
                    if (holidayTypeUnit == HolidayTypeUnitEnum.day) {
                        leaveLengthDay = isHalfDay ? 0.5 : realLength;
                        curDateMap.put("calDay", leaveLengthDay);
                        curDateMap.put("calHour", 0.0);
                    } else if (holidayTypeUnit == HolidayTypeUnitEnum.hour) {
                        standardHour = this.getStandardHourOfDay(this.ctx, this.personId, endDate, defaultAtsShiftItemCollection, defaultStandardHour, holidayPolicyInfo.isIsFixOTAllowLeave());
                        leaveLengthHour = realLength * standardHour.doubleValue();
                        curDateMap.put("calDay", 0.0);
                        curDateMap.put("calHour", leaveLengthHour);
                    }
                    retMap.put(endDate, curDateMap);
                }
            }
            if (afterDealDateList.size() > 0) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("leaveLengthDay", leaveLengthDay);
                paramMap.put("leaveLengthHour", leaveLengthHour);
                paramMap.put("personId", this.personId);
                paramMap.put("beginDate", beginDate);
                paramMap.put("endDate", endDate);
                paramMap.put("defaultStandardHour", defaultStandardHour);
                paramMap.put("holidayTypeUnit", holidayUnit);
                paramMap.put("isFixOTAllowLeave", isFixOTAllowLeave);
                paramMap.put("afterDealDateList", afterDealDateList);
                paramMap.put("defaultAtsShiftItemCollection", defaultAtsShiftItemCollection);
                paramMap.put("dayStandardHour", new BigDecimal(8));
                this.getMidleDateLength(this.ctx, paramMap, retMap);
            }
        }
        return retMap;
    }

    public BigDecimal getStandardHourOfDay(Context ctx, String personId, String curDate, AtsShiftItemCollection defaultAtsShiftItemCollection, BigDecimal defaultStandardHour, Boolean isFixOTAllowLeave) {
        BigDecimal standardHour = new BigDecimal(8);
        try {
            HashMap dateMap = AtsLeaveBillUtils.getScheduleShiftItemCollByDate((Context)ctx, (String)personId, (Date)new Date(AtsDateUtils.stringToShortDate((String)curDate).getTime()), (Boolean)isFixOTAllowLeave);
            ScheduleShiftItemCollection scheduleShiftItemColl = (ScheduleShiftItemCollection)dateMap.get("scheduleShiftItemColl");
            if (scheduleShiftItemColl.size() != 0 || defaultAtsShiftItemCollection.size() != 0) {
                standardHour = scheduleShiftItemColl.size() != 0 ? (BigDecimal)dateMap.get("standardHour") : defaultStandardHour;
            }
        }
        catch (EASBizException var10) {
            var10.printStackTrace();
        }
        catch (BOSException var11) {
            var11.printStackTrace();
        }
        return standardHour;
    }

    public Map<String, Object> calRealLeaveLengthOfBF(List<Date> afterDealDateList, Date beginTimeCount, Date endTimeCount, HolidayTypeUnitEnum holidayTypeUnit, AtsHolidayFileInfo holidayFileInfo, HolidayPolicySetInfo holidayPolicySetInfo, HolidayPolicyInfo holidayPolicyInfo) throws BOSException, EASBizException {
        String curDate;
        HashMap curDateMap;
        HashMap<String, Object> DateLeaveLenMap = new HashMap<String, Object>();
        if (this.atsLeaveBillEntryInfo.getBfType() == null) {
            return DateLeaveLenMap;
        }
        String bfTypeId = this.atsLeaveBillEntryInfo.getBfType().getId().toString();
        BreastFeedingTypeCollection bfTypeColl = BreastFeedingTypeFactory.getLocalInstance((Context)this.ctx).getBreastFeedingTypeCollection("where id = '" + bfTypeId + "'");
        double leaveLengthOfSplit = 1.0;
        if (bfTypeColl.size() > 0) {
            BreastFeedingTypeInfo bfTypeInfo = bfTypeColl.get(0);
            leaveLengthOfSplit = bfTypeInfo.getLeaveLength().multiply(new BigDecimal(bfTypeInfo.getFetusNum())).doubleValue();
        }
        Map scheduleShiftMap = null;
        if (holidayTypeUnit.getValue() == 1) {
            Timestamp beginTimeCountTs = AtsDateUtils.dateToTimestamp((Date)beginTimeCount);
            Timestamp endTimeCountTs = AtsDateUtils.dateToTimestamp((Date)endTimeCount);
            curDateMap = new HashMap();
            try {
                AttendanceFileHISInfo attendanceFileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo((Context)this.ctx, (Timestamp)beginTimeCountTs, (Timestamp)endTimeCountTs, (String)this.personId, null);
                curDateMap = AtsLeaveBillUtils.getdefaultShiftItemByHis((Context)this.ctx, (AttendanceFileHISInfo)attendanceFileHisInfo, (HolidayPolicyInfo)holidayPolicyInfo);
            }
            catch (BOSException var23) {
                var23.printStackTrace();
            }
            this.defaultStandardHour = (BigDecimal)curDateMap.get("standardHour");
            curDate = AtsDateUtils.dateLongToString((Date)beginTimeCount).substring(0, 10);
            String endDate = AtsDateUtils.dateLongToString((Date)endTimeCount).substring(0, 10);
            Map fileInfoRenturn = AtsPrepareDataHelper.getAttendanceFileInfoByPersonId((Context)this.ctx, (String)("'" + this.personId + "'"), (String)curDate, (String)endDate, null);
            Map fileInfoObject = (Map)fileInfoRenturn.get("fileInfoMap");
            scheduleShiftMap = AtsScheduleShiftUtil.getScheduleShiftMapByPriority((Context)this.ctx, (Map)fileInfoObject, (String)this.personId, (String)curDate, (String)endDate);
        }
        if (afterDealDateList.size() == 0) {
            return DateLeaveLenMap;
        }
        for (Date date : afterDealDateList) {
            curDateMap = new HashMap();
            if (holidayTypeUnit.getValue() == 1) {
                new BigDecimal(0);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String ds = sdf.format(date);
                String key = String.valueOf(this.personId) + "_" + ds;
                List scheduleShiftList = scheduleShiftMap == null ? null : (List)scheduleShiftMap.get(key);
                BigDecimal standardhour = scheduleShiftList != null && scheduleShiftList.size() > 0 ? (BigDecimal)((ScheduleShiftInfo)scheduleShiftList.get(0)).get("standardhour") : this.defaultStandardHour;
                BigDecimal dayRealLength = BigDecimal.valueOf(leaveLengthOfSplit).divide(standardhour, 8, RoundingMode.HALF_UP);
                curDateMap.put("calDay", dayRealLength.doubleValue());
                curDateMap.put("calHour", 0.0);
            } else {
                curDateMap.put("calDay", 0.0);
                curDateMap.put("calHour", leaveLengthOfSplit);
            }
            curDate = AtsDateUtils.dateLongToString((Date)date);
            DateLeaveLenMap.put(curDate, curDateMap);
        }
        return DateLeaveLenMap;
    }

    public Map<String, Object> getIsCtrlHalfDayOff(Context ctx) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            HolidayPolicySetInfo holidayPolicySetInfo = HolidayPolicySetFactory.getLocalInstance((Context)ctx).getHolidayPolicySetInfo(" where id='" + this.holidayPolicyInfo.getHolidayPolicySet().getId().toString() + "' ");
            res.put("amBeginTime", holidayPolicySetInfo.getAmStartWorkTime());
            res.put("amEndTime", holidayPolicySetInfo.getAmEndWorkTime());
            res.put("pmBeginTime", holidayPolicySetInfo.getPmStartWorkTime());
            res.put("pmEndTime", holidayPolicySetInfo.getPmEndWorkTime());
            res.put("isHalfDayOff", this.holidayPolicyInfo.isIsHalfDayOff());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private AtsShiftItemInfo createScheduleShiftItemToAtsShiftItem(Context ctx, ScheduleShiftItemInfo scheduleShiftItemInfo) {
        AtsShiftItemInfo info = new AtsShiftItemInfo();
        info.setPreTime(scheduleShiftItemInfo.getPreTime());
        info.setNextTime(scheduleShiftItemInfo.getNextTime());
        info.setPreIsPunchCard(scheduleShiftItemInfo.getPreIsPunchCard());
        info.setNextIsPunchCard(scheduleShiftItemInfo.getNextIsPunchCard());
        info.setPreTimeDayType(scheduleShiftItemInfo.getPreTimeDayType());
        info.setNextTimeDayType(scheduleShiftItemInfo.getNextTimeDayType());
        info.setSegment(scheduleShiftItemInfo.getSegment());
        info.setPreFloatAdjusted(scheduleShiftItemInfo.getPreFloatAdjusted());
        info.setNextFloatAdjusted(scheduleShiftItemInfo.getNextFloatAdjusted());
        info.setRestPreTime(scheduleShiftItemInfo.getRestPreTime());
        info.setRestNextTime(scheduleShiftItemInfo.getRestNextTime());
        info.setSegmentInRest(scheduleShiftItemInfo.getSegmentInRest());
        info.setAttendanceType(scheduleShiftItemInfo.getAttendanceType());
        info.setGroup(new AtsShiftInfo());
        return info;
    }
}

