/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.facade.abnormal;

import com.aliyun.odps.utils.StringUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.custom.entity.AbnormaAttendanceDetailInfo;
import com.kingdee.eas.custom.entity.AbnormaAttendanceInfo;
import com.kingdee.eas.custom.entity.AbnormalInfo;
import com.kingdee.eas.custom.facade.abnormal.AbstractAbnormalFacadeControllerBean;
import com.kingdee.eas.custom.utils.SendUtils;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbnormalFacadeControllerBean
extends AbstractAbnormalFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger(AbnormalFacadeControllerBean.class);

    @Override
    public void _abnormalAttendance(Context ctx) throws BOSException {
        String attendanceSql = "/*dialect*/SELECT\r\n\ttemp.attendDate attendDate,\r\n\ttemp.personId personId,\r\n\tthpc.fpersondep orgId,\r\n\ttemp.abnormalCount abnormalCount,\r\n\ttemp.reason reason \r\nFROM\r\n\t(\r\n\tSELECT DISTINCT\r\n\t\ta.FAttendanceDate attendDate,\r\n\t\ta.FProposer personId,\r\n\t\ta.FAttendanceValue abnormalCount,\r\n\t\tc.fname_l1 reason \r\n\tFROM\r\n\t\tT_HR_ATS_AbnormalAttendance a\r\n\t\tLEFT JOIN (\r\n\t\tSELECT\r\n\t\t\tFProposer,\r\n\t\t\tSUM ( FAttendanceValue ) AS COUNT \r\n\t\tFROM\r\n\t\t\tT_HR_ATS_AbnormalAttendance \r\n\t\tWHERE\r\n\t\t\tFAttendanceDate >= date_trunc ( 'month', CURRENT_DATE - INTERVAL '1 month' ) \r\n\t\t\tAND FAttendanceDate <= LAST_DAY (\r\n\t\t\tDATE_TRUNC ( 'month', CURRENT_DATE - INTERVAL '1 month' ))  and FStatus= '1' and FOperationStatus= '1' \r\n\t\tGROUP BY\r\n\t\t\tFProposer \r\n\t\tHAVING\r\n\t\t\tSUM ( FAttendanceValue ) > 3 \r\n\t\t) b ON a.FProposer= b.FProposer\r\n\t\tLEFT JOIN T_HR_ATS_AttendanceProject c ON c.fid= a.FattendanceProject \r\n\tWHERE\r\n\t\ta.FStatus= '1' \r\n\t\tAND a.FOperationStatus= '1' \r\n\t\tAND a.FAttendanceDate >= date_trunc ( 'month', CURRENT_DATE - INTERVAL '1 month' ) \r\n\t\tAND a.FAttendanceDate <= LAST_DAY (\r\n\t\tDATE_TRUNC ( 'month', CURRENT_DATE - INTERVAL '1 month' )) \r\n\t\tAND b.count > 3 \r\n\t) temp\r\n\tLEFT JOIN (\r\n\tSELECT\r\n\t\tthpa.fpersonid,\r\n\t\tthpa.fpersondep \r\n\tFROM\r\n\t\tT_HR_PersonPosition thpa\r\n\t\tINNER JOIN ( SELECT fpersonid fpersonid, MAX ( fjoindate ) maxDate FROM T_HR_PersonPosition GROUP BY fpersonid ) thpb ON thpa.fjoindate= thpb.maxDate \r\n\tAND thpa.fpersonid= thpb.fpersonid \r\n\t) thpc ON thpc.fpersonid= temp.personId";
        try {
            logger.info("AbnormalFacadeControllerBean->attendanceSql->{} ", (Object)attendanceSql);
            IRowSet kqRowSet = DbUtil.executeQuery((Context)ctx, (String)attendanceSql);
            HashSet<String> kqSet = new HashSet<String>();
            ArrayList<AbnormalInfo> dataList = new ArrayList<AbnormalInfo>();
            while (kqRowSet.next()) {
                AbnormalInfo info = new AbnormalInfo();
                String fAdminOrgUnitId = kqRowSet.getString("orgId");
                kqSet.add(fAdminOrgUnitId);
                info.setAttendDate(kqRowSet.getString("attendDate"));
                info.setPersonId(kqRowSet.getString("personId"));
                info.setOrgId(kqRowSet.getString("orgId"));
                info.setReason(kqRowSet.getString("reason"));
                info.setAbnormalCount(Integer.valueOf(kqRowSet.getString("abnormalCount")));
                dataList.add(info);
            }
            String processStr = this.processStr(kqSet);
            Map<String, String> headMap = this.getHead(ctx, processStr);
            Map<String, String> pvcMap = this.getPvc(ctx, processStr);
            Map<String, Set<String>> sendPersonIds = this.mergerPerson(headMap, pvcMap);
            Map<String, String> orgMap = this.initOrg(ctx);
            Map<String, String> personMap = this.initPerson(ctx);
            this.sendEmail(ctx, sendPersonIds, dataList, this.getTitle(this.getCurrenLastDayDate()), orgMap, personMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> initOrg(Context ctx) throws BOSException, SQLException {
        String sql = "select fid orgId,fname_l1 orgName from T_ORG_ADMIN";
        HashMap<String, String> orgMap = new HashMap<String, String>();
        IRowSet orgRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (orgRowSet.next()) {
            orgMap.put(orgRowSet.getString("orgId"), orgRowSet.getString("orgName"));
        }
        return orgMap;
    }

    private Map<String, String> initPerson(Context ctx) throws BOSException, SQLException {
        String sql = "select fid pId,fname_l1 pName from T_BD_PERSON ";
        HashMap<String, String> personMap = new HashMap<String, String>();
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (personRowSet.next()) {
            personMap.put(personRowSet.getString("pId"), personRowSet.getString("pName"));
        }
        return personMap;
    }

    private Map<String, String> getHead(Context ctx, String processStr) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\ta.fid AS oId,\r\n\ta.fnumber AS oNumber,\r\n\td.fnumber AS pNumber,\r\n\td.fid AS pId,\r\n\td.fname_L1 AS pNameL1,\r\n\td.fname_L2 AS pNameL2 \r\nFROM\r\n\tT_ORG_Admin a\r\n\tLEFT JOIN T_ORG_POSITION b ON a.FResponPositionID= b.fid\r\n\tLEFT JOIN (\r\n\tSELECT\r\n\t\tca.fpositionid,\r\n\t\tca.fpersonid, \r\n\t\tca.fislatestinaday, \r\n\t\tca.fadminorgid, \r\n\t\tca.flastupdatetime \r\n\tFROM\r\n\t\tT_HR_EmpOrgRelation ca\r\n\t\tINNER JOIN ( SELECT fpositionid, MAX ( fleffdt ) maxDate FROM T_HR_EmpOrgRelation GROUP BY fpositionid ) cb ON ca.fpositionid= cb.fpositionid \r\n\t\tAND ca.fleffdt= cb.maxDate \r\n\t) c ON c.fpositionid= b.fid\r\n\tLEFT JOIN T_BD_Person d ON d.fid= c.fpersonid\r\n\tLEFT JOIN T_HR_BDEmployeeType e ON e.fid= d.femployeetypeid \r\nWHERE\r\n\ta.fid IN (" + processStr + ") \r\n" + "\tAND b.FIsRespPosition= 1 \r\n" + "\tAND e.finservice= 1 \r\n" + "\tAND b.fdeletedstatus= 1 \r\n" + "\tAND c.fislatestinaday=1  \r\n";
        logger.info("AbnormalFacadeControllerBean->getHead->sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String pId = rs.getString("pId");
            if (StringUtils.isBlank((String)pId)) continue;
            if (StringUtils.isNotBlank((String)((String)resultMap.get(pId)))) {
                resultMap.put(pId, String.valueOf((String)resultMap.get(pId)) + "," + rs.getString("oId"));
                continue;
            }
            resultMap.put(pId, rs.getString("oId"));
        }
        return resultMap;
    }

    private Map<String, String> getPvc(Context ctx, String processStr) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\torg.fid oId,\r\n\torg.fnumber orgNumber,\r\n\torg.Fname_l1 orgName,\r\n\tbp.fnumber pNumber,\r\n\tbp.fid pId,\r\n\tbp.Fname_l1 pName\r\nFROM\r\n\tT_WFR_WFROLE wf\r\n\tLEFT JOIN T_WFR_PERSONROLE wp ON wp.froleid= wf.fid\r\n\tLEFT JOIN T_BD_Person bp ON bp.fid= wp.fpsersonid\r\n\tLEFT JOIN T_ORG_Admin org ON org.fid= wp.forgid \r\nWHERE\r\n\twf.fnumber= '106' and org.fid in(" + processStr + ")";
        logger.info("AbnormalFacadeControllerBean->getPvc->sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String pId = rs.getString("pId");
            if (StringUtils.isBlank((String)pId)) continue;
            if (StringUtils.isNotBlank((String)((String)resultMap.get(pId)))) {
                resultMap.put(pId, String.valueOf((String)resultMap.get(pId)) + "," + rs.getString("oId"));
                continue;
            }
            resultMap.put(pId, rs.getString("oId"));
        }
        return resultMap;
    }

    private Map<String, Set<String>> mergerPerson(Map<String, String> headMap, Map<String, String> pvcMap) {
        String str;
        int n;
        int n2;
        String[] stringArray;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : headMap.entrySet()) {
            String[] split;
            HashSet<String> set = new HashSet<String>();
            String key = entry.getKey();
            String headValues = entry.getValue();
            if (StringUtils.isBlank((String)headValues)) continue;
            stringArray = split = headValues.split(",");
            n2 = split.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                set.add(str);
                ++n;
            }
            map.put(key, set);
        }
        for (Map.Entry<String, String> entry : pvcMap.entrySet()) {
            String key = entry.getKey();
            String pvcValues = entry.getValue();
            if (StringUtils.isBlank((String)pvcValues)) continue;
            String[] split = pvcValues.split(",");
            HashSet<String> set = (HashSet<String>)map.get(key);
            if (set == null || set.size() == 0) {
                set = new HashSet<String>();
            }
            stringArray = split;
            n2 = split.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                set.add(str);
                ++n;
            }
            map.put(key, set);
        }
        return map;
    }

    private String processStr(Set<String> ids) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (String s : ids) {
            sb.append("'").append(s).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
            result = sb.toString();
        }
        return result;
    }

    private void sendEmail(Context ctx, Map<String, Set<String>> sendPersonIds, List<AbnormalInfo> dataList, String title, Map<String, String> orgMap, Map<String, String> personMap) throws SQLException {
        if (sendPersonIds == null) {
            return;
        }
        try {
            Set<Map.Entry<String, Set<String>>> entrySet = sendPersonIds.entrySet();
            for (Map.Entry<String, Set<String>> entry : entrySet) {
                String personId = entry.getKey();
                Set<String> deptIds = entry.getValue();
                if (deptIds == null || deptIds.size() == 0) continue;
                StringBuilder totalContent = new StringBuilder("<html><head></head><body>");
                totalContent.append("<span>Dear Sir/Madam,</span><br>\r\n\t\t<span>This is attendance exception report of the last month.</span><br>\r\n\t\t<span>Admin employees who has more than 3 abnormal records per month, it will be recorded in this exception report. It\u2019s suggested to remind your team members to complete the leave application, business trip through Kingdee system by the end of each month to ensure the accuracy of the report.</span><br>\r\n\t\t<span>Should you have any question, please do not hesitate to contact HR " + this.getHrEmail(ctx) + ".</span><br>");
                StringBuilder detailContent = new StringBuilder();
                totalContent.append("<table border='1' cellspacing='0' style='border:solid 1px #E8F2F9;font-size=8px;;font-size:10px;'>");
                totalContent.append("<tr style='background-color: #428BCA; color:#ffffff'><th>Month\u6708\u4efd</th><th>Name\u59d3\u540d</th><th>Department\u90e8\u95e8</th><th>AbnormalTimes\u8003\u52e4\u5f02\u5e38\u6b21\u6570</th></tr>");
                for (String deptId : deptIds) {
                    Map<String, List<AbnormaAttendanceDetailInfo>> detailMap = this.processDetail(dataList, deptId, orgMap, personMap);
                    Map<String, AbnormaAttendanceInfo> totalMap = this.processInfo(detailMap);
                    if (totalMap == null || detailMap == null) continue;
                    if (totalMap != null && totalMap.size() > 0) {
                        Set<Map.Entry<String, AbnormaAttendanceInfo>> totalEntrySet = totalMap.entrySet();
                        for (Map.Entry<String, Object> entry2 : totalEntrySet) {
                            AbnormaAttendanceInfo info = (AbnormaAttendanceInfo)entry2.getValue();
                            totalContent.append("<tr>");
                            totalContent.append("<td>" + this.getCurrenLastDayDate() + "</td>");
                            totalContent.append("<td>" + info.getName() + "</td>");
                            totalContent.append("<td>" + info.getDept() + "</td>");
                            totalContent.append("<td>" + info.getCount() + "</td>");
                            totalContent.append("</tr>");
                        }
                    }
                    if (detailMap == null || detailMap.size() <= 0) continue;
                    Set<Map.Entry<String, List<AbnormaAttendanceDetailInfo>>> detailEntrySet = detailMap.entrySet();
                    for (Map.Entry<String, Object> entry3 : detailEntrySet) {
                        String personName = entry3.getKey();
                        List detailList = (List)entry3.getValue();
                        detailContent.append("<p style=\"font-size:10px;\">" + totalMap.get(personName).getName() + " of " + ((AbnormaAttendanceDetailInfo)detailList.get(0)).getDept() + " had " + totalMap.get(personName).getCount() + " abnormal records in " + this.getCurrenLastDayDate() + "</p>");
                        detailContent.append("<table border='1' cellspacing='0' style='border:solid 1px #E8F2F9;font-size=8px;;font-size:10px;'>");
                        detailContent.append("<tr style='background-color: #428BCA; color:#ffffff'><th>Name\u59d3\u540d</th><th>Department\u90e8\u95e8</th><th>AbnormalDate\u65e5\u671f </th><th>AbnoralReason\u8003\u52e4\u5f02\u5e38\u539f\u56e0</th></tr>");
                        if (detailList == null || detailList.size() == 0) continue;
                        for (AbnormaAttendanceDetailInfo info : detailList) {
                            detailContent.append("<tr>");
                            detailContent.append("<td>" + info.getName() + "</td>");
                            detailContent.append("<td>" + info.getDept() + "</td>");
                            detailContent.append("<td>" + info.getDate().substring(0, 10) + "</td>");
                            detailContent.append("<td>" + info.getReason() + ";" + info.getAbnormalCount() + "</td>");
                            detailContent.append("</tr>");
                        }
                        detailContent.append("</table>");
                    }
                }
                totalContent.append("</table>");
                String content = totalContent.append((CharSequence)detailContent).append("</body></html>").toString();
                logger.info("GtiitOrgAdminService->sendHead->content{} ", (Object)content);
                try {
                    try {
                        SendUtils.msgSend(ctx, title, 20, false, content, personId, 2, null, null, MimeTypeEnum.HTML);
                    }
                    catch (Exception e) {
                        logger.info("AbnormalFacadeControllerBean->SendUtils.msgSend->{} ", (Throwable)e);
                        totalContent = new StringBuilder();
                        detailContent = new StringBuilder();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    totalContent = new StringBuilder();
                    detailContent = new StringBuilder();
                    throw throwable;
                }
                totalContent = new StringBuilder();
                detailContent = new StringBuilder();
            }
        }
        catch (Exception e) {
            logger.info("AbnormalFacadeControllerBean->sendHead->{} ", (Throwable)e);
        }
    }

    private Map<String, List<AbnormaAttendanceDetailInfo>> processDetail(List<AbnormalInfo> dataList, String deptId, Map<String, String> orgMap, Map<String, String> personMap) throws SQLException {
        HashMap<String, List<AbnormaAttendanceDetailInfo>> map = new HashMap<String, List<AbnormaAttendanceDetailInfo>>();
        if (dataList == null || StringUtils.isBlank((String)deptId)) {
            return null;
        }
        for (AbnormalInfo ab : dataList) {
            String orgId = ab.getOrgId();
            if (!deptId.equals(orgId)) continue;
            String personName = personMap.get(ab.getPersonId());
            ArrayList<AbnormaAttendanceDetailInfo> list = (ArrayList<AbnormaAttendanceDetailInfo>)map.get(personName);
            AbnormaAttendanceDetailInfo info = new AbnormaAttendanceDetailInfo();
            if (list == null || list.size() == 0) {
                list = new ArrayList<AbnormaAttendanceDetailInfo>();
            }
            info.setDate(ab.getAttendDate());
            info.setName(personMap.get(ab.getPersonId()));
            info.setDept(orgMap.get(ab.getOrgId()));
            info.setReason(ab.getReason());
            info.setPersonId(ab.getPersonId());
            info.setAbnormalCount(ab.getAbnormalCount());
            list.add(info);
            map.put(personName, list);
        }
        return map;
    }

    private Map<String, AbnormaAttendanceInfo> processInfo(Map<String, List<AbnormaAttendanceDetailInfo>> detailMap) {
        HashMap<String, AbnormaAttendanceInfo> map = new HashMap<String, AbnormaAttendanceInfo>();
        if (detailMap == null) {
            return null;
        }
        Set<Map.Entry<String, List<AbnormaAttendanceDetailInfo>>> entrySet = detailMap.entrySet();
        for (Map.Entry<String, List<AbnormaAttendanceDetailInfo>> entry : entrySet) {
            String personName = entry.getKey();
            List<AbnormaAttendanceDetailInfo> detailList = entry.getValue();
            if (detailList == null || detailList.size() == 0) continue;
            for (AbnormaAttendanceDetailInfo detailInfo : detailList) {
                AbnormaAttendanceInfo info = (AbnormaAttendanceInfo)map.get(personName);
                if (info != null) {
                    info.setCount(info.getCount() + detailInfo.getAbnormalCount());
                } else {
                    info = new AbnormaAttendanceInfo();
                    info.setName(detailInfo.getName());
                    info.setDept(detailInfo.getDept());
                    info.setMonth(this.getCurrenLastDayDate());
                    info.setCount(detailInfo.getAbnormalCount());
                }
                map.put(personName, info);
            }
        }
        return map;
    }

    private String getCurrenLastDayDate() {
        LocalDate today = LocalDate.now();
        System.out.println("\u4eca\u5929\u7684\u65e5\u671f\u662f: " + today);
        LocalDate firstDayOfLastMonth = today.minusMonths(1L);
        System.out.println("\u4e0a\u4e2a\u6708\u7684\u7b2c\u4e00\u5929\u662f: " + firstDayOfLastMonth);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM");
        return firstDayOfLastMonth.format(formatter);
    }

    private String getTitle(String formattedDate) {
        String replace = formattedDate.replace("/", "");
        return "Attendance Alert Report \u2013 " + replace;
    }

    private String getHrEmail(Context ctx) throws BOSException, SQLException {
        String sql = "select fname_l1 name from T_HR_ATS_OverTimeReason where fnumber='GTYJ001'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String hrEmial = "";
        while (rs.next()) {
            String name = rs.getString("name");
            hrEmial = StringUtils.isBlank((String)name) ? "Carleen(carleen.wu@gtiit.edu.cn,88077081)" : name;
        }
        return hrEmial;
    }
}

