/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.framework.ServerCenterFactory;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.List;

public class SendUtils
extends MsgUtil {
    public static boolean msgSend(Context ctx, String title, int priority, boolean revertible, String content, String personId, int msgType, KDMessageAttachment[] attachment, String assignID) throws EASBizException, BOSException {
        return SendUtils.msgSend(ctx, title, priority, revertible, content, personId, msgType, attachment, assignID, null);
    }

    public static boolean msgSend(Context ctx, String title, int priority, boolean revertible, String content, String personId, int msgType, KDMessageAttachment[] attachment, String assignID, MimeTypeEnum mimeType) throws EASBizException, BOSException {
        PersonInfo person = null;
        String address = null;
        if (!StringUtils.isEmpty((String)personId)) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(personId);
            person = iPerson.getPersonInfo((IObjectPK)pk);
            boolean succeed = false;
            switch (msgType) {
                case 1: {
                    address = person.getCell();
                    if (StringUtils.isEmpty((String)address)) {
                        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN);
                    }
                    succeed = SendUtils.sendMobileMsg(ctx, title, priority, revertible, content, address, assignID);
                    return succeed;
                }
                case 2: {
                    address = person.getEmail();
                    if (StringUtils.isEmpty((String)address)) {
                        return succeed;
                    }
                    succeed = SendUtils.sendMail(ctx, title, priority, revertible, content, address, attachment, assignID, mimeType);
                    ServerCenterFactory.getServerCenter((Context)ctx);
                    return succeed;
                }
                case 3: {
                    address = person.getRtx();
                    if (StringUtils.isEmpty((String)address)) {
                        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN_RTX);
                    }
                    succeed = SendUtils.sendRTXMsg(ctx, title, priority, revertible, content, address);
                    ServerCenterFactory.getServerCenter((Context)ctx);
                    return succeed;
                }
            }
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN);
    }

    private static boolean sendMail(Context ctx, String title, int priority, boolean revertible, String content, String address, KDMessageAttachment[] attachment, String assignID) throws EASBizException, BOSException {
        return SendUtils.sendMail(ctx, title, priority, revertible, content, address, attachment, assignID, null);
    }

    private static boolean sendMail(Context ctx, String title, int priority, boolean revertible, String content, String address, KDMessageAttachment[] attachment, String assignID, MimeTypeEnum mimeType) throws EASBizException, BOSException {
        EmailSendMessageInfo emailSendMsgInfo = new EmailSendMessageInfo();
        if (mimeType != null) {
            emailSendMsgInfo.setMimeType(mimeType);
        }
        emailSendMsgInfo.setPriority(AppMsgUtil.getPriorityEnum((int)priority));
        emailSendMsgInfo.setRevertible(revertible);
        emailSendMsgInfo.setAssignID(assignID);
        emailSendMsgInfo.setContent(content);
        emailSendMsgInfo.setTitle(title);
        EmailAddressInfo addressInfo = new EmailAddressInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null) {
            addressInfo.setSendBizUser(userInfo);
            PersonInfo sendPersonInfo = AppMsgUtil.getPersonByUser((Context)ctx, (UserInfo)userInfo);
            if (sendPersonInfo != null && !StringUtils.isEmpty((String)sendPersonInfo.getEmail())) {
                addressInfo.setFrom(sendPersonInfo.getEmail());
            }
            emailSendMsgInfo.setTitle(title);
        } else {
            emailSendMsgInfo.setTitle(title);
        }
        addressInfo.setTo(address);
        emailSendMsgInfo.setAddress(addressInfo);
        boolean sendSuccess = false;
        IObjectPK pk = DefaultEmailMessageDAO.addNew((Context)ctx, (EmailSendMessageInfo)emailSendMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    private static boolean sendMobileMsg(Context ctx, String title, int priority, boolean revertible, String content, String receiveMobileNumber, String assignID) throws EASBizException, BOSException {
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        sendMoMsgInfo.setSendHandcraft(true);
        sendMoMsgInfo.setRevertible(revertible);
        sendMoMsgInfo.setPriority(AppMsgUtil.getPriorityEnum((int)priority));
        sendMoMsgInfo.setContent(title);
        sendMoMsgInfo.setTitle(content);
        sendMoMsgInfo.setAssignID(assignID);
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null) {
            addressInfo.setSendBizUser(userInfo);
            PersonInfo sendPersonInfo = AppMsgUtil.getPersonByUser((Context)ctx, (UserInfo)userInfo);
            if (sendPersonInfo != null && !StringUtils.isEmpty((String)sendPersonInfo.getCell())) {
                addressInfo.setSendMobileNumber(sendPersonInfo.getCell());
                addressInfo.setSendCellNumberType(CellphoneNumberTypeEnum.getEnum((int)MobileUtil.getCellphoneNumberType((String)sendPersonInfo.getCell())));
            }
            sendMoMsgInfo.setTitle(title);
        } else {
            sendMoMsgInfo.setTitle(content);
        }
        addressInfo.setReceiveMobileNumber(receiveMobileNumber);
        addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum((int)MobileUtil.getCellphoneNumberType((String)receiveMobileNumber)));
        UserInfo receiveUserInfo = null;
        String receiveUserId = AppMsgUtil.getUserIdByMobileNumber((Context)ctx, (String)receiveMobileNumber);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)receiveUserId)) {
            try {
                receiveUserInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(receiveUserId));
            }
            catch (Exception var15) {
                receiveUserInfo = null;
            }
        }
        addressInfo.setReceiveBizUser(receiveUserInfo);
        sendMoMsgInfo.setAddress(addressInfo);
        IObjectPK pk = null;
        boolean sendSuccess = false;
        pk = DefaultSendMoMsgDao.addNew((Context)ctx, (SendMobileMessageInfo)sendMoMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    private static boolean sendRTXMsg(Context ctx, String title, int priority, boolean revertible, String content, String address) throws EASBizException, BOSException {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static int msgGroupSend(Context ctx, String title, int priority, boolean revertible, String content, List userList, int msgType, KDMessageAttachment[] attachment) throws EASBizException, BOSException {
        if (msgType != 2 && msgType != 1) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        iUser = UserFactory.getLocalInstance((Context)ctx);
        pk = null;
        uuid = null;
        receiveUser = null;
        receivePerson = null;
        address = null;
        userNum = userList.size();
        sentNum = 0;
        sendSucceed = false;
        i = 0;
        while (i < userNum) {
            block10: {
                try {
                    if (userList.get(i) == null || StringUtils.isEmpty((String)userList.get(i).toString()) || (receiveUser = iUser.getUserInfo((IObjectPK)(pk = new ObjectUuidPK(uuid = BOSUuid.read((String)userList.get(i).toString().trim()))))).getPerson() == null || (receivePerson = AppMsgUtil.getPersonByUser((Context)ctx, (UserInfo)receiveUser)) == null) break block10;
                    switch (msgType) {
                        case 2: {
                            address = receivePerson.getEmail();
                            if (StringUtils.isEmpty((String)address)) break;
                            sendSucceed = SendUtils.sendMail(ctx, title, priority, revertible, content, address, attachment, null);
                        }
                        case 1: {
                            address = receivePerson.getCell();
                            if (StringUtils.isEmpty((String)address)) break;
                        }
                        default: {
                            if (sendSucceed) {
                                ++sentNum;
                                sendSucceed = false;
                                ** break;
                            }
                        }
lbl-1000:
                        // 3 sources

                        {
                        }
                    }
                }
                catch (Exception var18_18) {
                    // empty catch block
                }
            }
            ++i;
        }
        return sentNum;
    }
}

