/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.util.ArrayList;
import java.util.Collection;
import kd.isc.iscb.util.data.LRUMap;
import kd.isc.iscb.util.misc.Pair;

public class LocalCache<K, V> {
    private LRUMap<K, V> map;
    private volatile boolean empty;

    public LocalCache(int capacity) {
        this(capacity, LRUMap.Type.Normal);
    }

    public LocalCache(int capacity, LRUMap.Type type) {
        this.map = new LRUMap(capacity, type);
        this.empty = true;
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public synchronized V remove(K key) {
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.empty = this.map.isEmpty();
        }
    }

    public synchronized void put(K key, V value) {
        this.map.put(key, value);
        this.empty = false;
    }

    public synchronized void clear() {
        this.map.clear();
        this.empty = true;
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized Pair<K, V> first() {
        return this.map.first();
    }

    public synchronized Pair<K, V> last() {
        return this.map.last();
    }

    public synchronized Collection<V> values() {
        return new ArrayList<V>(this.map.values());
    }
}

