/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.trace;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.core.i.model.AbstractVariableScope;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.trace.FlowDebuggerResource;
import kd.isc.iscb.util.script.context.Context;

public class FlowDebuggerTrace
implements FlowTrace {
    private FlowDebuggerResource res;

    public FlowDebuggerTrace(FlowDebuggerResource res) {
        this.res = res;
    }

    @Override
    public void begin(Execution e) {
        DebugCoordinator c = DebugCoordinator.REF.get();
        if (!c.isDebuggerEnabled()) {
            return;
        }
        if (!this.res.hasBreakpoint(e)) {
            return;
        }
        DebuggableRuntime runtime = this.newDebuggableRuntime(e);
        c.handleBreakpoint(runtime, this.res.getLine(e), this.res.collectBreakpoints());
    }

    private DebuggableRuntime newDebuggableRuntime(final Execution e) {
        return new DebuggableRuntime(){

            @Override
            public DebuggableResource getResource() {
                return FlowDebuggerTrace.this.res;
            }

            @Override
            public Context getContext() {
                return new Context(){

                    @Override
                    public Object get(String property) {
                        if ("#vars".equals(property)) {
                            return this.getVariables(e);
                        }
                        Object value = e.getRuntime().getTransientProperty(property);
                        if (value != null) {
                            return value;
                        }
                        return e.get(property);
                    }

                    private Object getVariables(Execution e2) {
                        AbstractVariableScope scope = (AbstractVariableScope)e2.getDefine();
                        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
                        for (Map.Entry<String, VariableImpl> i : scope.getAvailableVariables().entrySet()) {
                            vars.put(i.getKey(), i.getValue().getTitle());
                        }
                        return vars;
                    }

                    @Override
                    public boolean set(String property, Object value) {
                        return false;
                    }

                    @Override
                    public boolean contains(String property) {
                        return false;
                    }
                };
            }
        };
    }

    @Override
    public boolean end(Execution e, boolean success) {
        return false;
    }

    @Override
    public void endFlow() {
    }
}

