/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.math.BigInteger;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.misc.mem.c.DefaultClassSizeInfo;

public class BigIntegerClassSizeInfo
implements ClassSizeInfo {
    private final long fixedObjectSize = new DefaultClassSizeInfo(BigInteger.class).getObjectSize();

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        BigInteger s = (BigInteger)obj;
        int bytes = s.bitLength() + 7 >>> 3;
        long intArraySize = ObjectSizeCalculator.roundTo(ObjectSizeCalculator.ARRAY_HEADER_SIZE + bytes, ObjectSizeCalculator.OBJECT_PADDING);
        calc.increaseSize(this.fixedObjectSize + intArraySize);
    }

    @Override
    public Class<?> forClass() {
        return BigInteger.class;
    }
}

