/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Util {
    public static Object calc(Object a, Object b, NativeFunction fn) {
        if (a instanceof List) {
            if (b instanceof List) {
                return Util.calc((List)a, (List)b, fn);
            }
            if (!(b instanceof Collection)) {
                return Util.calc((List)a, b, fn);
            }
        } else if (b instanceof List) {
            return Util.calc(a, (List)b, fn);
        }
        String v1 = Json.toString(a, true);
        String v2 = Json.toString(b, true);
        String message = "(" + v1 + " " + fn.name() + " " + v2 + ") is invalid.";
        throw new UnsupportedOperationException(message);
    }

    public static List<?> calc(Object a, List<?> lb, NativeFunction fn) {
        ArrayList<Object> list = new ArrayList<Object>(lb.size());
        Object[] args = new Object[2];
        for (Object b : lb) {
            args[0] = a;
            args[1] = b;
            Object result = fn.call(null, args);
            list.add(result);
        }
        return list;
    }

    public static List<?> calc(List<?> la, Object b, NativeFunction fn) {
        ArrayList<Object> list = new ArrayList<Object>(la.size());
        Object[] args = new Object[2];
        for (Object a : la) {
            args[0] = a;
            args[1] = b;
            Object result = fn.call(null, args);
            list.add(result);
        }
        return list;
    }

    public static List<?> calc(List<?> la, List<?> lb, NativeFunction fn) {
        if (la.size() != lb.size()) {
            throw new UnsupportedOperationException("Lists not compatible. la size: " + la.size() + ", lb size: " + lb.size());
        }
        ArrayList<Object> list = new ArrayList<Object>(la.size());
        Iterator<?> ia = la.iterator();
        Iterator<?> ib = lb.iterator();
        Object[] args = new Object[2];
        while (ia.hasNext()) {
            args[0] = ia.next();
            args[1] = ib.next();
            Object result = fn.call(null, args);
            list.add(result);
        }
        return list;
    }

    public static void checkZero(int b) {
        if (b == 0) {
            throw new IscBizException(ResManager.loadKDString("\u9664\u6570\u4e0d\u53ef\u4e3a0", "Util_2", "isc-iscb-util", new Object[0]));
        }
    }

    public static void checkZero(long b) {
        if (b == 0L) {
            throw new IscBizException(ResManager.loadKDString("\u9664\u6570\u4e0d\u53ef\u4e3a0", "Util_2", "isc-iscb-util", new Object[0]));
        }
    }

    public static void checkZero(double b) {
        if (b == 0.0) {
            throw new IscBizException(ResManager.loadKDString("\u9664\u6570\u4e0d\u53ef\u4e3a0.0", "Util_3", "isc-iscb-util", new Object[0]));
        }
    }

    public static void checkZero(BigInteger b) {
        if (BigInteger.ZERO.compareTo(b) == 0) {
            throw new IscBizException(ResManager.loadKDString("\u9664\u6570\u4e0d\u53ef\u4e3a0", "Util_2", "isc-iscb-util", new Object[0]));
        }
    }

    public static void checkZero(BigDecimal b) {
        if (BigDecimal.ZERO.compareTo(b) == 0) {
            throw new IscBizException(ResManager.loadKDString("\u9664\u6570\u4e0d\u53ef\u4e3a0.0", "Util_3", "isc-iscb-util", new Object[0]));
        }
    }
}

