/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove.microsoft;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.encryptalgorithm.DesCrypto;
import com.kingdee.bos.workflow.extscheme.mailApprove.mailConfig.MailConfigInfo;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.ApproveMail;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.ApproveNidInfo;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.AttachmentWorker;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.EmailApproveConfig;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.H;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.MSParamsBuilder;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.MSToken;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.MailAttachment;
import com.kingdee.bos.workflow.metas.MailApproveAgentFactory;
import com.kingdee.bos.workflow.metas.MailApproveAgentInfo;
import com.kingdee.bos.workflow.metas.MailApproveState;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class MicroSoftGraphWorker
implements Runnable {
    protected static final Logger logger = Logger.getLogger(MicroSoftGraphWorker.class);
    private int interval = 1;
    private int count = 0;
    private DesCrypto des = new DesCrypto();
    private Context ctx;
    private EmailApproveConfig config = null;
    private MSToken msToken = new MSToken();
    private boolean stop = false;

    public MicroSoftGraphWorker(Context ctx) {
        this.ctx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
    }

    public void initConfig() throws Exception {
        if (this.config == null) {
            String mailAddr;
            String sql = "select FRENTERID,FAPPID,FSECRET,FMAILADDR,flastMailReceiveTime from t_wfr_mailconf where fkey = 'approve'";
            ArrayList list = null;
            try {
                list = SQL.executeQuery((Context)this.ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error((Object)"query t_wfr_mailconf error", (Throwable)e);
            }
            if (list == null || list.size() == 0) {
                logger.info((Object)"MicroSoftGraphWorker load t_wfr_mailconf, no config");
                return;
            }
            String tenantId = (String)((Map)list.get(0)).get("frenterid");
            String clientId = (String)((Map)list.get(0)).get("fappid");
            String secret = (String)((Map)list.get(0)).get("fsecret");
            if (secret != null && !"".equals(secret)) {
                secret = MailConfigInfo.decrypt(secret);
            }
            if ((mailAddr = (String)((Map)list.get(0)).get("fmailaddr")) != null && !"".equals(mailAddr)) {
                mailAddr = MailConfigInfo.decrypt(mailAddr);
            }
            String ts = (String)((Map)list.get(0)).get("flastmailreceivetime");
            this.config = new EmailApproveConfig(tenantId, clientId, secret, mailAddr);
            this.config.setLastMailReceiveTime(ts);
        }
    }

    public void initToken() throws IOException {
        if (this.msToken.isExpire()) {
            String url = "https://login.microsoftonline.com/" + this.config.getTenantId() + "/oauth2/v2.0/token";
            JSONObject data = new JSONObject();
            data.put("client_id", (Object)this.config.getClientId());
            data.put("client_secret", (Object)this.config.getSecret());
            data.put("scope", (Object)"https://graph.microsoft.com/.default");
            data.put("grant_type", (Object)"client_credentials");
            String result = H.postJob(url, data);
            this.msToken = (MSToken)JSON.parseObject((String)result, MSToken.class);
        }
    }

    public void work() {
        try {
            this.initConfig();
            if (this.config == null) {
                if (this.count++ == 60) {
                    this.stop = true;
                    logger.info((Object)"after 60min wait,MicroSoftGraphWorker stop cause mailconf is null");
                }
                return;
            }
            this.initToken();
            JSONArray mails = new JSONArray();
            this.listData(mails, null);
            if (mails.size() == 0) {
                return;
            }
            List<ApproveMail> approveMails = this.toApproveMails(mails);
            this.parseAndProcess(approveMails);
            this.updateLastReceiveTime(this.ctx);
        }
        catch (Throwable e) {
            logger.error((Object)"MicroSoftGraphWorker work error", e);
        }
    }

    private void count() {
        if (this.count < 100) {
            this.interval = this.count % 5 + 1;
            ++this.count;
        } else {
            this.count = 0;
        }
    }

    private void updateLastReceiveTime(Context ctx) throws BOSException {
        String sql = "update t_wfr_mailconf set flastMailReceiveTime = ? where fkey = 'approve'";
        SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{this.config.getLastMailReceiveTime()});
    }

    private List<ApproveMail> toApproveMails(JSONArray mails) throws IOException {
        ArrayList<ApproveMail> approveMails = new ArrayList<ApproveMail>();
        int i = 0;
        while (i < mails.size()) {
            JSONObject jo = mails.getJSONObject(i);
            ApproveMail approveMail = new ApproveMail();
            approveMail.setSubject(jo.getString("subject"));
            approveMail.setContent(jo.getJSONObject("body").getString("content"));
            approveMail.setSender(jo.getJSONObject("from").getJSONObject("emailAddress").getString("address"));
            if (jo.getBoolean("hasAttachments").booleanValue()) {
                String id = jo.getString("id");
                String url = "https://graph.microsoft.com/v1.0/users/" + this.config.getMaillAddr() + "/mailFolders/inbox/messages/";
                url = String.valueOf(url) + id + "/attachments";
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Authorization", this.msToken.getAccess_token());
                String result = H.GET(url, header);
                JSONArray attachments = JSON.parseObject((String)result).getJSONArray("value");
                approveMail.setAttachments(new ArrayList<MailAttachment>());
                int j = 0;
                while (j < attachments.size()) {
                    JSONObject att = attachments.getJSONObject(j);
                    approveMail.getAttachments().add(new MailAttachment(att.getString("name"), att.getString("contentType"), att.getBytes("contentBytes")));
                    ++j;
                }
            }
            approveMails.add(approveMail);
            if (i == mails.size() - 1) {
                String nextQueryTime = this.getNextQueryTime(jo.getString("receivedDateTime"));
                this.config.setLastMailReceiveTime(nextQueryTime);
            }
            ++i;
        }
        return approveMails;
    }

    public void parseAndProcess(List<ApproveMail> approveMails) throws Exception {
        for (ApproveMail approveMail : approveMails) {
            String html = approveMail.getContent();
            if (!html.contains("Approve:[[NID]]") && !html.contains("Reject:[[NID]]")) continue;
            try {
                Document doc = Jsoup.parse((String)html);
                String text = doc.getElementsByTag("body").html().replaceAll("&nbsp;", "{{nbsp}}");
                doc = Jsoup.parse((String)text);
                text = doc.getElementsByTag("body").text();
                if (!text.contains("[[NID]]")) {
                    return;
                }
                String warn = "CAUTION: External Message! Beware of scam or virus! \u5916\u90e8\u90ae\u4ef6\uff0c\u8c28\u9632\u8bc8\u9a97\u6216\u75c5\u6bd2";
                text = text.replaceFirst(warn, "");
                String[] textArray = text.split("------please type your comments above this line------");
                String[] texts = textArray[0].split(" ");
                String approveOpinion = "";
                String[] stringArray = texts;
                int n = texts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (approveOpinion.length() > 0) {
                        approveOpinion = String.valueOf(approveOpinion) + "\n";
                    }
                    approveOpinion = String.valueOf(approveOpinion) + s.replaceAll("\\{\\{nbsp\\}\\}", " ");
                    ++n2;
                }
                textArray = text.split("----Do not edit below this line----");
                String nidStr = textArray[1];
                String[] nidStrArray = nidStr.split(":");
                int index = 0;
                int i = 0;
                while (i < nidStrArray.length) {
                    if (nidStrArray[i].equals("[[NID]]")) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                ApproveNidInfo nid = new ApproveNidInfo(this.des.decrypt(null, nidStrArray[index + 1]));
                if (!nid.getDc().equals(this.ctx.getAIS())) continue;
                ObjectUuidPK pk = new ObjectUuidPK(nid.getFid());
                MailApproveAgentInfo agentIfo = MailApproveAgentFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)pk);
                if (agentIfo.getState() == MailApproveState.DO_MAIL_APPROVE) {
                    logger.warn((Object)("subject mail\uff1a[" + approveMail.getSubject() + "] has been approved,return"));
                    continue;
                }
                String sql = "select 1 from t_wfr_assign where FASSIGNID =? and FSTATE = 1";
                ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{agentIfo.getAssignid()});
                if (list.size() == 0) {
                    agentIfo.setState(MailApproveState.ASSIGN_CANCELD);
                } else {
                    agentIfo.setRawmail(html);
                    agentIfo.setReceivermail(approveMail.getSenderEmail());
                    agentIfo.setState(MailApproveState.READ_APPROVE_MAIL);
                    if (!agentIfo.getSendmail().equalsIgnoreCase(approveMail.getSenderEmail())) {
                        agentIfo.setState(MailApproveState.SR_NOT_EQUAL);
                        MailApproveAgentFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)pk, agentIfo);
                        continue;
                    }
                    MultiApproveInfo multiApproveInfo = this.generateApproveInfo(nid, approveOpinion);
                    try {
                        Context submitCtx = new Context((IObjectPK)new ObjectUuidPK(nid.getUserId()), this.ctx.getSolution(), this.ctx.getAIS(), this.ctx.getLocale());
                        MultiApproveFactory.getLocalInstance((Context)submitCtx).submit((CoreBaseInfo)multiApproveInfo);
                        agentIfo.setState(MailApproveState.DO_MAIL_APPROVE);
                        if (approveMail.getAttachments() != null) {
                            new AttachmentWorker(submitCtx, nid, approveMail.getAttachments()).work();
                        }
                    }
                    catch (Exception e) {
                        agentIfo.setState(MailApproveState.MAIL_APPROVE_ERROR);
                        String errorInfo = "ERROR_TIME:" + new Timestamp(System.currentTimeMillis()) + "\n\r";
                        errorInfo = String.valueOf(errorInfo) + StringUtils.stackToString((Exception)e);
                        agentIfo.setErrorInfo(errorInfo);
                    }
                }
                MailApproveAgentFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)pk, agentIfo);
            }
            catch (Throwable t) {
                logger.error((Object)("parse email error:" + html), t);
            }
        }
    }

    private String getNextQueryTime(String receivedDateTime) {
        String isoDateTime = receivedDateTime;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(formatter.parse(isoDateTime));
        }
        catch (Exception exception) {
            // empty catch block
        }
        long timestampMillis = calendar.getTimeInMillis();
        Date date = new Date(timestampMillis += 1000L);
        return formatter.format(date);
    }

    private MultiApproveInfo generateApproveInfo(ApproveNidInfo nid, String opinion) throws EASBizException, BOSException {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(nid.getAssignId());
        info.setBillId(BOSUuid.read((String)nid.getBillId()));
        info.setExtendedProperty("businuessObjectId", nid.getBillId());
        info.setExtendedProperty("assignmentID", nid.getAssignId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        info.setOpinion(opinion, new Locale("L1"));
        info.setOpinion(opinion, new Locale("L2"));
        info.setOpinion(opinion, new Locale("L3"));
        info.setIsPass(ApproveResult.getEnum((String)nid.getApproveResult()));
        String handlerOpinion = nid.getHandlerOpinion();
        info.setHandlerOpinion(Integer.parseInt(handlerOpinion));
        String handlerContent = nid.getHandlerContent();
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        ObjectUuidPK pk = new ObjectUuidPK(nid.getUserId());
        UserInfo user = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo((IObjectPK)pk);
        info.setCreator(user);
        info.setLastUpdateUser(user);
        info.setInputType(InputType.EMAIL);
        return info;
    }

    private String getUTCTime() {
        String format = null;
        if (StringUtils.isEmpty((String)this.config.getLastMailReceiveTime())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            format = sdf.format(Calendar.getInstance().getTime());
            format = String.valueOf(format) + "T00:00:00Z";
        } else {
            format = this.config.getLastMailReceiveTime();
        }
        if (!format.endsWith("Z")) {
            format = String.valueOf(format) + "Z";
        }
        return format;
    }

    private void listData(JSONArray values, String url) throws IOException {
        if (url == null) {
            url = "https://graph.microsoft.com/v1.0/users/" + this.config.getMaillAddr() + "/mailFolders/inbox/messages";
            MSParamsBuilder builder = new MSParamsBuilder();
            String params = builder.select("from,isRead,receivedDateTime,subject,body,attachments,hasAttachments").filter("receivedDateTime gt " + this.getUTCTime()).orderBy("receivedDateTime ASC").build();
            url = String.valueOf(url) + "?" + params;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.msToken.getAccess_token());
        String result = H.GET(url, header);
        JSONObject jsonObject = JSON.parseObject((String)result);
        values.addAll((Collection)jsonObject.getJSONArray("value"));
        String nextLink = jsonObject.getString("@odata.nextLink");
        if (nextLink != null && nextLink.length() > 0) {
            this.listData(values, nextLink);
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.work();
            try {
                Thread.sleep((long)(this.interval * 60) * 1000L);
            }
            catch (Exception e) {
                logger.error((Object)"MicroSoftGraphWorker run error", (Throwable)e);
            }
        }
    }
}

