/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.date;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.script.ScriptContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DataTypeError;
import kd.isc.iscb.util.script.core.NativeFunction;

public class DateNew
implements NativeFunction {
    @Override
    public String name() {
        return "new";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        try {
            return DateNew.parse(args);
        }
        catch (ParseException e) {
            throw DataTypeError.INVALID_DATE_STRING.create(e, D.s(args[0]));
        }
    }

    static Object parse(Object[] args) throws ParseException {
        if (args.length == 0) {
            return new Timestamp(System.currentTimeMillis());
        }
        Object value = args[0];
        if (value instanceof Date) {
            return value;
        }
        String s = (String)value;
        if (args.length == 1) {
            if (s.indexOf(32) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(s);
            }
            if (s.indexOf(45) > 0) {
                long ms = new SimpleDateFormat("yyyy-MM-dd").parse(s).getTime();
                return new java.sql.Date(ms);
            }
            if (s.indexOf(58) > 0) {
                long ms = new SimpleDateFormat("HH:mm:ss").parse(s).getTime();
                return new Time(ms);
            }
            throw new IllegalArgumentException(s);
        }
        return new SimpleDateFormat((String)args[1]).parse(s);
    }

    public String toString() {
        return this.name();
    }
}

