/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.util.ExportAllUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;

public class AbsenceSummaryForAllLeaveListHandler
extends ListHandler {
    private static final Logger log = LoggerFactory.getLogger(AbsenceSummaryForAllLeaveListHandler.class);
    Context ctx = SHRContext.getInstance().getContext();
    private int totalCount;

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        List<String> colNames = this.getcolNamesAction();
        List<Map<String, Object>> colModel = this.getcolModelAction();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        JSONUtils.writeJson((HttpServletResponse)response, map);
        return null;
    }

    public List<String> getcolNamesAction() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Dept");
        list.add("Staff No.");
        list.add("Name");
        list.add("Position");
        list.add("Work Category");
        list.add("Person Type");
        list.add("Full Time or Part Time");
        list.add("Hire Date");
        list.add("Ter Date");
        list.add("Status");
        list.add("Annual Entitlement (Days)");
        list.add("Faculty Sick Entitlement (Days)");
        list.add("Faculty Sick Max Entitlement (Days)");
        list.add("Child care Entitlement (Days)");
        list.add("Elderly care Entitlement (Days)");
        list.add("Annual Leave (Days)");
        list.add("Sick Leave (Days)");
        list.add("Marriage Leave (Days)");
        list.add("Paternity Leave (Days)");
        list.add("Maternity Leave (Days)");
        list.add("Bereavement Leave (Days)");
        list.add("Miscarriage Leave (Days)");
        list.add("Leave Of Family Planning Birth Control (Days)");
        list.add("Work-related Injury Leave (Days)");
        list.add("Medical Treatment Leave (Days)");
        list.add("Unpaid Leave (H)");
        list.add("Compensatory Leave (H)");
        list.add("Child Care Leave (Days)");
        list.add("Elderly Care Leave (Days)");
        list.add("Annual Leave Balance (Days)");
        list.add("sick leave balance");
        list.add("Compensatory Leave Balance(H)");
        list.add("Child Care Leave Balance");
        list.add("Elderly Care Leave Balance");
        return list;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, JSONException, org.json.JSONException {
        log.info(">>> Enter AbsenceSummaryForAllLeaveListHandler...getGridDataAction");
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        IRowSet rs = this.getIRowSet(request);
        if (null == rs) {
            return;
        }
        int num = 0;
        ArrayList maplist = new ArrayList();
        while (rs.next()) {
            if (++num < rows * (page - 1) + 1 || num > rows * page) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Dept", rs.getString("Dept"));
            map.put("Staff No.", rs.getString("StaffNo"));
            map.put("Name", rs.getString("Name"));
            map.put("Position", rs.getString("Position"));
            map.put("Work Category", rs.getString("WorkCategory"));
            map.put("Person Type", rs.getString("PersonType"));
            map.put("Full Time or Part Time", rs.getString("FullTimeOrPartTime"));
            map.put("Hire date", StringUtils.isEmpty((CharSequence)rs.getString("HireDate")) ? null : this.getDateString(rs.getString("HireDate")));
            map.put("Ter  Date", StringUtils.isEmpty((CharSequence)rs.getString("TerDate")) ? null : this.getDateString(rs.getString("TerDate")));
            map.put("Status", rs.getString("Status"));
            map.put("Annual Entitlement", rs.getBigDecimal("AnnualEntitlement") != null ? rs.getBigDecimal("AnnualEntitlement").setScale(2, 4) : Integer.valueOf(0));
            map.put("Faculty Sick Entitlement", rs.getBigDecimal("FacultySickEntitlement") != null ? rs.getBigDecimal("FacultySickEntitlement").setScale(2, 4) : Integer.valueOf(0));
            map.put("Faculty Sick Max Entitlement", rs.getBigDecimal("FacultySickMaxEntitlement") != null ? rs.getBigDecimal("FacultySickMaxEntitlement").setScale(2, 4) : Integer.valueOf(0));
            map.put("Child care Entitlement", rs.getBigDecimal("ChildCareEntitlement") != null ? rs.getBigDecimal("ChildCareEntitlement").setScale(2, 4) : Integer.valueOf(0));
            map.put("Elderly care Entitlement", rs.getBigDecimal("ElderlyCareEntitlement") != null ? rs.getBigDecimal("ElderlyCareEntitlement").setScale(2, 4) : Integer.valueOf(0));
            map.put("annual leave", rs.getBigDecimal("AnnualLeave") != null ? rs.getBigDecimal("AnnualLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("sick leave", rs.getBigDecimal("SickLeave") != null ? rs.getBigDecimal("SickLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("marriage leave", rs.getBigDecimal("MarriageLeave") != null ? rs.getBigDecimal("MarriageLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("paternity leave", rs.getBigDecimal("PaternityLeave") != null ? rs.getBigDecimal("PaternityLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("maternity leave", rs.getBigDecimal("MaternityLeave") != null ? rs.getBigDecimal("MaternityLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("bereavement leave", rs.getBigDecimal("BereavementLeave") != null ? rs.getBigDecimal("BereavementLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("miscarriage leave", rs.getBigDecimal("MiscarriageLeave") != null ? rs.getBigDecimal("MiscarriageLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("leave of family planning birth control", rs.getBigDecimal("LeaveOfFamilyPlanningBirthControl") != null ? rs.getBigDecimal("LeaveOfFamilyPlanningBirthControl").setScale(2, 4) : Integer.valueOf(0));
            map.put("work-related injury leave", rs.getBigDecimal("WorkRelatedInjuryLeave") != null ? rs.getBigDecimal("WorkRelatedInjuryLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("medical treatment leave", rs.getBigDecimal("MedicalTreatmentLeave") != null ? rs.getBigDecimal("MedicalTreatmentLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("unpaid leave(H)", rs.getBigDecimal("UnpaidLeaveH") != null ? rs.getBigDecimal("UnpaidLeaveH").setScale(2, 4) : Integer.valueOf(0));
            map.put("compensatory leave(H)", rs.getBigDecimal("CompensatoryLeaveH") != null ? rs.getBigDecimal("CompensatoryLeaveH").setScale(2, 4) : Integer.valueOf(0));
            map.put("Child Care Leave", rs.getBigDecimal("ChildCareLeave") != null ? rs.getBigDecimal("ChildCareLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("Elderly Care Leave", rs.getBigDecimal("ElderlyCareLeave") != null ? rs.getBigDecimal("ElderlyCareLeave").setScale(2, 4) : Integer.valueOf(0));
            map.put("Annual Leave Balance", rs.getBigDecimal("AnnualLeaveBalance") != null ? rs.getBigDecimal("AnnualLeaveBalance").setScale(2, 4) : Integer.valueOf(0));
            map.put("sick leave balance", rs.getBigDecimal("SickLeaveBalance") != null ? rs.getBigDecimal("SickLeaveBalance").setScale(2, 4) : Integer.valueOf(0));
            map.put("Compensatory Leave Balance(H)", rs.getBigDecimal("CompensatoryLeaveBalanceH") != null ? rs.getBigDecimal("CompensatoryLeaveBalanceH").setScale(2, 4) : Integer.valueOf(0));
            map.put("Child Care Leave Balance", rs.getBigDecimal("ChildCareLeaveBalance") != null ? rs.getBigDecimal("ChildCareLeaveBalance").setScale(2, 4) : Integer.valueOf(0));
            map.put("Elderly Care Leave Balance", rs.getBigDecimal("ElderlyCareLeaveBalance") != null ? rs.getBigDecimal("ElderlyCareLeaveBalance").setScale(2, 4) : Integer.valueOf(0));
            maplist.add(map);
        }
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", maplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
        log.info(">>> complete AbsenceSummaryForAllLeaveListHandler...getGridDataAction!!!");
    }

    public IRowSet getIRowSet(HttpServletRequest request) throws BOSException, org.json.JSONException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        JSONObject tofastFilterItems = new JSONObject(fastFilterItems);
        log.info("ASFALH...tofastFilterItems = " + tofastFilterItems);
        JSONObject status = tofastFilterItems.getJSONObject("status");
        log.info("ASFALH...status = " + status);
        String statusValues = status.getString("values");
        log.info("ASFALH...statusValues = " + statusValues);
        JSONObject cutOffDateJSON = tofastFilterItems.getJSONObject("cutOffDate");
        JSONObject cutOffDateValues = cutOffDateJSON.getJSONObject("values");
        if (ObjectUtils.isEmpty((Object)cutOffDateValues)) {
            return null;
        }
        JSONObject fullOrPart = tofastFilterItems.getJSONObject("fullOrPart");
        String fullOrPartValues = fullOrPart.getString("values");
        String cutOffDate = cutOffDateValues.getString("date");
        SimpleDateFormat dat = new SimpleDateFormat("yyyy-MM-dd");
        String yearFirstDate = null;
        String year = "";
        try {
            Date cfDate = dat.parse(cutOffDate);
            Calendar ins = Calendar.getInstance();
            ins.setTime(cfDate);
            int yearDate = ins.get(1);
            year = String.valueOf(yearDate);
            Date yearFirst = this.getYearFirst(yearDate);
            yearFirstDate = dat.format(yearFirst);
        }
        catch (ParseException e) {
            return null;
        }
        String where = "";
        if (ObjectUtils.isNotEmpty((Object)statusValues)) {
            where = "1".equals(statusValues) ? "  where final.Status='Active' " : "  where final.Status='Negative' ";
        }
        if (ObjectUtils.isNotEmpty((Object)fullOrPartValues)) {
            if ("1".equals(fullOrPartValues)) {
                where = where + "   and ftorpt =(select fid from CT_MP_Fullorpart where fnumber = 'FULL') ";
            } else if ("2".equals(fullOrPartValues)) {
                where = where + "   and ftorpt =(select fid from CT_MP_Fullorpart where fnumber = 'PART')";
            }
        }
        JSONObject queryTime = tofastFilterItems.getJSONObject("queryTime");
        String queryTimeValues = queryTime.getString("values");
        String startDate = null;
        String endDate = null;
        if (ObjectUtils.isNotEmpty((Object)queryTimeValues)) {
            JSONObject periodEmploymentValues = queryTime.getJSONObject("values");
            startDate = periodEmploymentValues.getString("startDate");
            endDate = periodEmploymentValues.getString("endDate");
            log.info("FASRH...getGridDataAction : startDate = " + startDate + "; endDate = " + endDate);
        }
        if (null == startDate || null == endDate) {
            return null;
        }
        startDate = this.getDateString(startDate) + " 00:00:00";
        endDate = this.getDateString(endDate) + " 23:59:59";
        String sql = this.getSql(startDate, endDate, cutOffDate, yearFirstDate, year, where);
        log.info("AbsenceSummaryForAllLeaveListHandler...sql---{}", (Object)sql);
        log.error("AbsenceSummaryForAllLeaveListHandler...sql---error-" + sql);
        return DbUtil.executeQuery((Context)this.ctx, (String)sql);
    }

    private String getSql(String startDate, String endDate, String cutoffDate, String firstYearDate, String year, String where) {
        return "/*dialect*/select final.Dept Dept,\r\nfinal.StaffNo StaffNo,\r\nfinal.Name Name,\r\nfinal.ftorpt ftorpt,\r\nfinal.POSITION POSITION,\r\nfinal.WorkCategory WorkCategory,\r\nfinal.PersonType PersonType,\r\nfinal.FullTimeOrPartTime FullTimeOrPartTime,\r\nfinal.HireDate HireDate,\r\nfinal.TerDate TerDate,\r\nfinal.Status Status,\r\ncase when final.FullTimeOrPartTime='Part Time' then 0 else COALESCE(final.AnnualEntitlement,0) end \r\nAnnualEntitlement,\r\ncase when (final.WorkCategory='General Administrative Staff' or final.WorkCategory='Professional Supervisory Staff' or final.WorkCategory='Senior Administrative Staff') and final.FacultySickEntitlement='0' then 15 else COALESCE(final.FacultySickEntitlement,0) end FacultySickEntitlement,\r\ncase when (final.WorkCategory='General Administrative Staff' or final.WorkCategory='Professional Supervisory Staff' or final.WorkCategory='Senior Administrative Staff') and final.FacultySickMaxEntitlement='0' then 75 else COALESCE(final.FacultySickMaxEntitlement,0) end FacultySickMaxEntitlement,\r\nCOALESCE(final.ChildCareEntitlement,0) ChildCareEntitlement,\r\nCOALESCE(final.ElderlyCareEntitlement,0) ElderlyCareEntitlement,\r\nCOALESCE(final.AnnualLeave,0)  AnnualLeave,\r\nCOALESCE(final.SickLeave,0) SickLeave,\r\nCOALESCE(final.MarriageLeave,0) MarriageLeave,\r\nCOALESCE(final.PaternityLeave,0) PaternityLeave,\r\nCOALESCE(final.MaternityLeave,0) MaternityLeave,\r\nCOALESCE(final.BereavementLeave,0) BereavementLeave,\r\nCOALESCE(final.MiscarriageLeave,0) MiscarriageLeave,\r\nCOALESCE(final.LeaveOfFamilyPlanningBirthControl,0) LeaveOfFamilyPlanningBirthControl,\r\nCOALESCE(final.WorkRelatedInjuryLeave,0) WorkRelatedInjuryLeave,\r\nCOALESCE(final.MedicalTreatmentLeave,0) MedicalTreatmentLeave,\r\nCOALESCE(final.UnpaidLeaveH,0) UnpaidLeaveH,\r\nCOALESCE(final.CompensatoryLeaveH,0) CompensatoryLeaveH,\r\nCOALESCE(final.ChildCareLeave,0) ChildCareLeave,\r\nCOALESCE(final.ElderlyCareLeave,0) ElderlyCareLeave,\r\ncase when final.FullTimeOrPartTime='Part Time' then 0 else COALESCE(final.AnnualLeaveBalance,0) end \r\n AnnualLeaveBalance,\r\n\r\nCASE \r\n\t\tWHEN final.WorkCategory= 'Academic Staff' \r\n\t\tOR final.WorkCategory= 'Others' THEN\r\n\t\t\tCOALESCE ( final.SickLeaveBalance, 0 ) when \r\n\t\t\t(  COALESCE ( final.SickLeaveBalance, 0 ) >case when (final.WorkCategory='General Administrative Staff' or final.WorkCategory='Professional Supervisory Staff' or final.WorkCategory='Senior Administrative Staff') and final.FacultySickMaxEntitlement='0' then 75 else COALESCE(final.FacultySickMaxEntitlement,0) end) then case when (final.WorkCategory='General Administrative Staff' or final.WorkCategory='Professional Supervisory Staff' or final.WorkCategory='Senior Administrative Staff') and final.FacultySickMaxEntitlement='0' then 75 else COALESCE(final.FacultySickMaxEntitlement,0) end \r\n\t\t\t\r\n\t\t\twhen ( COALESCE ( final.SickLeaveBalance, 0 ) <=case when (final.WorkCategory='General Administrative Staff' or final.WorkCategory='Professional Supervisory Staff' or final.WorkCategory='Senior Administrative Staff') and final.FacultySickMaxEntitlement='0' then 75 else COALESCE(final.FacultySickMaxEntitlement,0) end) then COALESCE ( final.SickLeaveBalance, 0 ) end SickLeaveBalance,\r\n\r\nCOALESCE(final.CompensatoryLeaveBalanceH,0) CompensatoryLeaveBalanceH,\r\nCOALESCE(final.ChildCareLeaveBalance,0) ChildCareLeaveBalance,\r\nCOALESCE(final.ElderlyCareLeaveBalance,0) ElderlyCareLeaveBalance\r\nfrom (\r\nselect * from \r\n(select \r\ntbp.fid fpersonid,\r\nbcc.fname_l1 AS Dept,\r\n\ttbp.fnumber AS StaffNo,\r\n\ttbp.fname_l1 AS Name,\r\n\ttbp.cfftorptid AS ftorpt,\r\n\tbd.fname_l1 AS POSITION,\r\n\tbe.fname_l1 AS WorkCategory,\r\n\thepc.fname_l1 AS PersonType,\r\n\tbg.fname_l1 AS FullTimeOrPartTime,\r\n\thmrc.joinDate AS HireDate,\r\n\tbb.fleftdate AS TerDate,\r\n\r\n  case  when bh.finservice='1' then CAST ('Active' AS VARCHAR ( 10 ))\r\n\twhen bh.finservice='0' then CAST ('Negative' AS VARCHAR ( 10 )) \r\n\twhen bh.finservice='2' then CAST ('Negative' AS VARCHAR ( 10 )) \r\n\twhen bh.finservice='3' then CAST ('Negative' AS VARCHAR ( 10 ))  \r\n\twhen bh.finservice='4' then CAST ('Active' AS VARCHAR ( 10 ))  END AS Status\r\n from \t(select * from T_BD_PERSON where fhiredate<='2024-02-25') tbp left join (select bahis.* from T_HR_EmpOrgRelation bahis where bahis.fid in \r\n(select hera.fid from  T_HR_EmpOrgRelation hera inner join (select MAX(fleffdt) maxDate,fpersonid fpersonid,fid fid from T_HR_EmpOrgRelation where FIsLatestInAday = '1' and  FAssignType = '1' and (feffdt <='" + cutoffDate + "' and fleffdt>='" + cutoffDate + "')  group by fpersonid,fid) herb on hera.fid=herb.fid)) temp on tbp.fid=temp.fpersonid\r\n" + "LEFT JOIN T_ORG_Admin bcc ON bcc.fid= temp.fadminorgid\r\n" + "left join T_HR_EmployeeClassify hepc on hepc.fid=temp.cfpersontypeid\r\n" + "\t\tLEFT JOIN T_ORG_Position bd ON temp.fpositionid = bd.fid\r\n" + "\t\tLEFT JOIN CT_MP_WorkerCategory be ON be.fid = temp.cfworkercategoryid\r\n" + "\t\tLEFT JOIN CT_MP_Fullorpart bg ON bg.fid = tbp.CFFtorptID\r\n" + "\t\tLEFT JOIN (select hebr.fpersonid fpersonid, bem.finservice finservice from  T_HR_EmpLaborRelation hebr left join T_HR_BDEmployeeType bem on bem.fid=hebr.flaborrelationstateid) bh ON bh.fpersonid = temp.fpersonid\r\n" + "\t\tLEFT JOIN (select hpipa.fleftdate fleftdate, hpipa.fpersonid fpersonid from T_HR_PersonPositionHis hpipa inner join (select Max(fleffdt) maxDate,fpersonid fpersonid from  T_HR_PersonPositionHis group by fpersonid) hpipb on hpipa.fleffdt=hpipb.maxDate and hpipa.fpersonid=hpipb.fpersonid\r\n" + "\t) bb ON temp.fpersonid = bb.fpersonid\r\n" + "\tleft join (select hmra.fpersonid,hmra.fenterdate joinDate  from T_HR_EmpLaborRelationHis hmra inner join  (select Max(fleffdt) maxDate,fpersonid fpersonid from T_HR_EmpLaborRelationHis where fenterdate<='" + cutoffDate + "' group by fpersonid ) hmrb on hmra.fleffdt=hmrb.maxDate and hmra.fpersonid=hmrb.fpersonid) hmrc on hmrc.fpersonid=temp.fpersonid) tep\r\n" + "\t\r\n" + "\tleft join (\r\n" + "\tSELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(cfentitlementlimit,0) AnnualEntitlement \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\tfcyclebegindate<='" + cutoffDate + "' and fcycleenddate>='" + cutoffDate + "'\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\t )\r\n" + ") htmab on htmab.fpersonid=tep.fpersonid \r\n" + "\r\n" + "left join (select hera.fhistoryrelateid fpersonid,hera.cffse FacultySickEntitlement from  T_BD_PersonHis hera inner join (select MAX(fleffdt) maxDate,fhistoryrelateid fpersonid from T_BD_PersonHis where feffdt <='" + cutoffDate + "' and fleffdt>='" + cutoffDate + "'  group by fpersonid) herb on hera.fhistoryrelateid=herb.fpersonid and hera.fleffdt=herb.maxDate) htma on htma.fpersonid=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(select hera.fhistoryrelateid fpersonid,hera.cffsme FacultySickMaxEntitlement,hera.fleffdt fleffdt  from  T_BD_PersonHis hera inner join (select MAX(fleffdt) maxDate,fhistoryrelateid fpersonid from T_BD_PersonHis where feffdt <='" + cutoffDate + "' and fleffdt>='" + cutoffDate + "'  group by fpersonid) herb on hera.fhistoryrelateid=herb.fpersonid and hera.fleffdt=herb.maxDate) htmb on htmb.fpersonid=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(sum(fstandardlimit),0) ChildCareEntitlement \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\tfcyclebegindate<='" + cutoffDate + "' and fcycleenddate>='" + cutoffDate + "'\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\t ) group by fproposerid) htmc on htmc.fpersonid=tep.fpersonid\r\n" + "\t\t\t \r\n" + "\t\t\t left join(SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(sum(fstandardlimit),0) ElderlyCareEntitlement \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\tEXTRACT(YEAR FROM fcyclebegindate)= '" + year + "' \r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\t ) group by fproposerid) htmd on htmd.fpersonid=tep.fpersonid\r\n" + "\t\t\t \r\n" + "\t\t\t left join (\tSELECT\r\n" + "\ttema.FPERSONID,\r\n" + "\tSUM ( tema.AnnualLeave ) AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\tSELECT\r\n" + "\t\ttem.fpersonId FPERSONID,\r\n" + "\t\ttem.leavedate leavedate,\r\n" + "\tCASE\r\n" + "\t\t\t\r\n" + "\t\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\t\tSUM ( tem.fleavelength ) \r\n" + "\t\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\t\tSUM ( tem.cfleavelenght ) \r\n" + "\t\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\tdistinct\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tb.fleavedate leavedate,\r\n" + "\t\t\t b.fleavelength  fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\tdistinct\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\tc.cfleavedate leavedate,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tc.cfleavelenght  cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId,\r\n" + "tem.leavedate\t\r\n" + "\t) tema \r\n" + "GROUP BY\r\n" + "\ttema.FPERSONID ) htme on htme.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join (\tselect tema.FPERSONID  FPERSONID,sum(tema.SickLeave) SickLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND SickLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000003Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000003Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID ) htmf on htmf.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(\tselect tema.FPERSONID FPERSONID , sum(tema.MarriageLeave) MarriageLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND MarriageLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000005Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000005Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID ) htmh on htmh.FPERSONID=tep.fpersonid\r\n" + "\tleft join(\tselect tema.FPERSONID FPERSONID,sum(tema.PaternityLeave) PaternityLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND PaternityLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000007Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000007Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmi on htmi.FPERSONID=tep.fpersonid\r\n" + "\tleft join(\tselect tema.FPERSONID FPERSONID,sum(tema.MaternityLeave) MaternityLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND MaternityLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000006Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000006Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmj on htmj.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(\tselect tema.FPERSONID FPERSONID,sum(tema.BereavementLeave) BereavementLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND BereavementLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000011Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000011Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmk on htmk.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join( select tema.FPERSONID FPERSONID,sum(tema.MiscarriageLeave) MiscarriageLeave from (\tSELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND MiscarriageLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000013Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000013Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) html on html.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join (\tselect tema.FPERSONID FPERSONID, sum(tema.LeaveOfFamilyPlanningBirthControl) LeaveOfFamilyPlanningBirthControl from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND LeaveOfFamilyPlanningBirthControl \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000008Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000008Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmm on htmm.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join ( select tema.FPERSONID FPERSONID, sum(tema.WorkRelatedInjuryLeave) WorkRelatedInjuryLeave from(\tSELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND WorkRelatedInjuryLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000009Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000009Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmn on htmn.FPERSONID=tep.fpersonid\r\n" + "\tleft join(\tselect tema.FPERSONID FPERSONID, sum(tema.MedicalTreatmentLeave) MedicalTreatmentLeave from(SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND MedicalTreatmentLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000012Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000012Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmo on htmo.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join( select tema.FPERSONID FPERSONID,sum(tema.UnpaidLeaveH) UnpaidLeaveH from (\tSELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND UnpaidLeaveH \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000002Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000002Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmp on htmp.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join (\tselect tema.FPERSONID FPERSONID, sum(tema.CompensatoryLeaveH) CompensatoryLeaveH from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND CompensatoryLeaveH \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000004Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000004Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) htmq on htmq.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join (SELECT\r\n" + "\ttema.FPERSONID,\r\n" + "\tSUM ( tema.AnnualLeave ) ChildCareLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\tSELECT\r\n" + "\t\ttem.fpersonId FPERSONID,\r\n" + "\t\ttem.leavedate leavedate,\r\n" + "\tCASE\r\n" + "\t\t\t\r\n" + "\t\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\t\tSUM ( tem.fleavelength ) \r\n" + "\t\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\t\tSUM ( tem.cfleavelenght ) \r\n" + "\t\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\tdistinct\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tb.fleavedate leavedate,\r\n" + "\t\t\t b.fleavelength  fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\tdistinct\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\tc.cfleavedate leavedate,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tc.cfleavelenght  cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId,\r\n" + "tem.leavedate\t\r\n" + "\t) tema \r\n" + "GROUP BY\r\n" + "\ttema.FPERSONID) htmqa on htmqa.FPERSONID=tep.fpersonid\r\n" + "\t\tleft join (SELECT\r\n" + "\ttema.FPERSONID,\r\n" + "\tSUM ( tema.AnnualLeave ) ElderlyCareLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\tSELECT\r\n" + "\t\ttem.fpersonId FPERSONID,\r\n" + "\t\ttem.leavedate leavedate,\r\n" + "\tCASE\r\n" + "\t\t\t\r\n" + "\t\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\t\tSUM ( tem.fleavelength ) \r\n" + "\t\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\t\tSUM ( tem.cfleavelenght ) \r\n" + "\t\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\tdistinct\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tb.fleavedate leavedate,\r\n" + "\t\t\t b.fleavelength  fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + endDate + "' \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\tdistinct\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\tc.cfleavedate leavedate,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tc.cfleavelenght  cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + startDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + endDate + "' \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId,\r\n" + "tem.leavedate\t\r\n" + "\t) tema \r\n" + "GROUP BY\r\n" + "\ttema.FPERSONID) htmqb on htmqb.FPERSONID=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(select tempa.fpersonid fpersonid,COALESCE(tempa.freallimit,0)-COALESCE(tempb.AnnualLeave,0) AnnualLeaveBalance from (select tbp.fid fpersonid,COALESCE(temp.freallimit,0) freallimit  from T_BD_PERSON tbp left join (\r\n" + "SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(freallimit,0) freallimit \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\tfcyclebegindate<='" + cutoffDate + "' and fcycleenddate>='" + cutoffDate + "'\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\t )) temp on tbp.fid=temp.fpersonid) tempa left join ( SELECT\r\n" + "\ttema.FPERSONID,\r\n" + "\tSUM ( tema.AnnualLeave ) AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\tSELECT\r\n" + "\t\ttem.fpersonId FPERSONID,\r\n" + "\t\ttem.leavedate leavedate,\r\n" + "\tCASE\r\n" + "\t\t\t\r\n" + "\t\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\t\tSUM ( tem.fleavelength ) \r\n" + "\t\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\t\tSUM ( tem.cfleavelenght ) \r\n" + "\t\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\tdistinct\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tb.fleavedate leavedate,\r\n" + "\t\t\t b.fleavelength  fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + cutoffDate + "' \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\tdistinct\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\tc.cfleavedate leavedate,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tc.cfleavelenght  cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000001Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + cutoffDate + "' \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId,\r\n" + "tem.leavedate\t\r\n" + "\t) tema \r\n" + "GROUP BY\r\n" + "\ttema.FPERSONID ) tempb on tempa.fpersonid=tempb.FPERSONID\r\n" + ") htmw on htmw.fpersonid=tep.fpersonid\r\n" + "\r\n" + "left join(select tempa.fpersonid fpersonid,COALESCE(tempa.FacultySickEntitlement,0)-COALESCE(tempb.SickLeave,0) SickLeaveBalance from (select tbp.fid fpersonid,COALESCE(sick.limitCount,0) FacultySickEntitlement from T_BD_PERSON tbp left join (SELECT\r\n" + "\tcfpersonid fpersonid,\r\n" + "\tSUM (\r\n" + "\tCOALESCE ( cfinitiallimit, 0 ) + COALESCE ( cfrealitygrantlimit, 0 )) limitCount \r\n" + "FROM\r\n" + "\tCT_CUS_SickLeaveLimit \r\n" + "WHERE\r\n" + "\tcfmonth <= date_trunc('month', '" + cutoffDate + "'::DATE) - INTERVAL '1 day'\r\n" + "GROUP BY\r\n" + "\tcfpersonid) sick on sick.fpersonid=tbp.fid) tempa \r\n" + "\tleft join(select tema.FPERSONID FPERSONID,sum(tema.SickLeave) SickLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND SickLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000003Y' ) \r\n" + "\t\t\tAND b.fleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000003Y' ) \r\n" + "\t\t\tAND cfleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID) tempb on tempb.FPERSONID=tempa.fpersonid) htmx on htmx.fpersonid=tep.fpersonid\r\n" + "\t\r\n" + "\tleft join(select tempa.fpersonid fpersonid, COALESCE(tempa.CompensatoryLeava)-COALESCE(tempb.AnnualLeave,0) CompensatoryLeaveBalanceH from (select tbp.fid fpersonid,COALESCE(child.CompensatoryLeava,0) CompensatoryLeava from T_BD_PERSON tbp left join(SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(freallimit,0) CompensatoryLeava \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\tEXTRACT(YEAR FROM fcyclebegindate)= '" + year + "'\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000004Y' ) \r\n" + "\t\t\t )) child on child.fpersonid=tbp.fid) tempa left join( select tema.FPERSONID FPERSONID,sum(tema.AnnualLeave)  AnnualLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000004Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000004Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID\r\n" + ") tempb on tempb.FPERSONID=tempa.fpersonid) htmy on htmy.fpersonid=tep.fpersonid\r\n" + "\r\n" + "left join(select tempa.fpersonid fpersonid, COALESCE(tempa.ChildCareLeave)-COALESCE(tempb.AnnualLeave,0) ChildCareLeaveBalance from (select tbp.fid fpersonid,COALESCE(child.ChildCareLeave,0) ChildCareLeave from T_BD_PERSON tbp left join(SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(sum(freallimit),0) ChildCareLeave \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\t\t(fcyclebegindate, fcycleenddate) overlaps (to_date('" + firstYearDate + "','yyyy-MM-dd'), to_date('" + cutoffDate + "','yyyy-MM-dd'))\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\t ) group by fproposerid) child on child.fpersonid=tbp.fid) tempa left join( select tema.FPERSONID FPERSONID,sum(tema.AnnualLeave) AnnualLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000015Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID\r\n" + ") tempb on tempb.FPERSONID=tempa.fpersonid) htmz on htmz.fpersonid=tep.fpersonid\r\n" + "\r\n" + "left join(select tempa.fpersonid fpersonid, COALESCE(tempa.ElderlyCareLeave)-COALESCE(tempb.AnnualLeave,0) ElderlyCareLeaveBalance from (select tbp.fid fpersonid,COALESCE(child.ElderlyCareLeave,0) ElderlyCareLeave from T_BD_PERSON tbp left join(SELECT\r\n" + "\t\t\tfproposerid fpersonid,\r\n" + "\t\t\tCOALESCE(sum(freallimit),0) ElderlyCareLeave \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_HolidayLimit \r\n" + "\t\tWHERE\r\n" + "\t\t\t\t\t(fcyclebegindate, fcycleenddate) overlaps (to_date('" + firstYearDate + "','yyyy-MM-dd'), to_date('" + cutoffDate + "','yyyy-MM-dd'))\r\n" + "\t\t\tAND fstatus = '1' \r\n" + "\t\t\tAND (\r\n" + "\t\t\t\tfholidaypolicyid IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\t ) group by fproposerid) child on child.fpersonid=tbp.fid) tempa left join( select tema.FPERSONID FPERSONID,sum(tema.AnnualLeave) AnnualLeave from (SELECT\r\n" + "\ttem.fpersonId FPERSONID,\r\n" + "CASE\r\n" + "\t\t\r\n" + "\t\tWHEN tem.status IN ( '3', '4' ) THEN\r\n" + "\t\tSUM ( tem.fleavelength ) \r\n" + "\t\tWHEN tem.status IN ( '1', '2' ) THEN\r\n" + "\t\tSUM ( tem.cfleavelenght ) \r\n" + "\tEND AnnualLeave \r\n" + "FROM\r\n" + "\t(\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tb.fproposerid fpersonId,\r\n" + "\t\t\tSUM ( b.fleavelength ) fleavelength,\r\n" + "\t\t\t0 cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN T_HR_ATS_LeaveBillDetail b ON b.FLEAVEBILLID = a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tb.FPOLICYID IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\tAND b.fleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND b.fleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tb.fproposerid \r\n" + "\t\t) UNION\r\n" + "\t\t(\r\n" + "\t\tSELECT\r\n" + "\t\t\ta.fbillstate status,\r\n" + "\t\t\tc.cfproposer fpersonId,\r\n" + "\t\t\t0 fleavelength,\r\n" + "\t\t\tSUM ( c.cfleavelenght ) cfleavelenght \r\n" + "\t\tFROM\r\n" + "\t\t\tT_HR_ATS_LeaveBill a\r\n" + "\t\t\tLEFT JOIN CT_ATS_AtsLeaveBillDetailSame c ON c.cfleavebill= a.fid \r\n" + "\t\tWHERE\r\n" + "\t\t\tc.cfpolicy IN ( SELECT ua.fid FROM T_HR_ATS_HolidayPolicy ua LEFT JOIN T_HR_ATS_HolidayType ub ON ub.FID = ua.FHOLIDAYTYPEID WHERE ub.FNUMBER = 'JQLX000016Y' ) \r\n" + "\t\t\tAND c.cfleavedate >= '" + firstYearDate + "' \r\n" + "\t\t\tAND cfleavedate <= '" + cutoffDate + "' \r\n" + "\t\tGROUP BY\r\n" + "\t\t\ta.fbillstate,\r\n" + "\t\t\tc.cfproposer \r\n" + "\t\t) \r\n" + "\t) tem \r\n" + "GROUP BY\r\n" + "\ttem.status,\r\n" + "\ttem.fpersonId) tema group by tema.FPERSONID\r\n" + ") tempb on tempb.FPERSONID=tempa.fpersonid) htmma on htmma.fpersonid=tep.fpersonid\r\n" + "\r\n" + ") final " + where;
    }

    public String getDateString(String dateStr) {
        return dateStr.substring(0, 10).toString();
    }

    public List<Map<String, Object>> getcolModelAction() {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("Dept", "Dept", 120));
        modelColList.add(this.buildColModelMap("Staff No.", "Staff No.", 120));
        modelColList.add(this.buildColModelMap("Name", "Name", 120));
        modelColList.add(this.buildColModelMap("Position", "Position", 120));
        modelColList.add(this.buildColModelMap("Work Category", "Work Category", 120));
        modelColList.add(this.buildColModelMap("Person Type", "Person Type", 120));
        modelColList.add(this.buildColModelMap("Full Time or Part Time", "Full Time or Part Time", 120));
        modelColList.add(this.buildColModelMap("Hire date", "Hire date", 120));
        modelColList.add(this.buildColModelMap("Ter  Date", "Ter  Date", 120));
        modelColList.add(this.buildColModelMap("Status", "Status", 120));
        modelColList.add(this.buildColModelMap("Annual Entitlement", "Annual Entitlement", 120));
        modelColList.add(this.buildColModelMap("Faculty Sick Entitlement", "Faculty Sick Entitlement", 120));
        modelColList.add(this.buildColModelMap("Faculty Sick Max Entitlement", "Faculty Sick Max Entitlement", 120));
        modelColList.add(this.buildColModelMap("Child care Entitlement", "Child care Entitlement", 120));
        modelColList.add(this.buildColModelMap("Elderly care Entitlement", "Elderly care Entitlement", 120));
        modelColList.add(this.buildColModelMap("annual leave", "annual leave", 120));
        modelColList.add(this.buildColModelMap("sick leave", "sick leave", 120));
        modelColList.add(this.buildColModelMap("marriage leave", "marriage leave", 120));
        modelColList.add(this.buildColModelMap("paternity leave", "paternity leave", 120));
        modelColList.add(this.buildColModelMap("maternity leave", "maternity leave", 120));
        modelColList.add(this.buildColModelMap("bereavement leave", "bereavement leave", 120));
        modelColList.add(this.buildColModelMap("miscarriage leave", "miscarriage leave", 120));
        modelColList.add(this.buildColModelMap("leave of family planning birth control", "leave of family planning birth control", 120));
        modelColList.add(this.buildColModelMap("work-related injury leave", "work-related injury leave", 120));
        modelColList.add(this.buildColModelMap("medical treatment leave", "medical treatment leave", 120));
        modelColList.add(this.buildColModelMap("unpaid leave(H)", "unpaid leave(H)", 120));
        modelColList.add(this.buildColModelMap("compensatory leave(H)", "compensatory leave(H)", 120));
        modelColList.add(this.buildColModelMap("Child Care Leave", "Child Care Leave", 120));
        modelColList.add(this.buildColModelMap("Elderly Care Leave", "Elderly Care Leave", 120));
        modelColList.add(this.buildColModelMap("Annual Leave Balance", "Annual Leave Balance", 120));
        modelColList.add(this.buildColModelMap("sick leave balance", "sick leave balance", 120));
        modelColList.add(this.buildColModelMap("Compensatory Leave Balance(H)", "Compensatory Leave Balance(H)", 120));
        modelColList.add(this.buildColModelMap("Child Care Leave Balance", "Child Care Leave Balance", 120));
        modelColList.add(this.buildColModelMap("Elderly Care Leave Balance", "Elderly Care Leave Balance", 120));
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, org.json.JSONException {
        IRowSet rs = this.getIRowSet(request);
        if (null == rs) {
            return null;
        }
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        String stringDateType = "StringDate_@";
        String numberType = "Number_.";
        selectFieldsTypeMap.put("Dept", stringType);
        selectFieldsTypeMap.put("StaffNo", stringType);
        selectFieldsTypeMap.put("Name", stringType);
        selectFieldsTypeMap.put("Position", stringType);
        selectFieldsTypeMap.put("WorkCategory", stringType);
        selectFieldsTypeMap.put("PersonType", stringType);
        selectFieldsTypeMap.put("FullTimeOrPartTime", stringType);
        selectFieldsTypeMap.put("HireDate", stringDateType);
        selectFieldsTypeMap.put("TerDate", stringDateType);
        selectFieldsTypeMap.put("Status", stringType);
        selectFieldsTypeMap.put("AnnualEntitlement", numberType);
        selectFieldsTypeMap.put("FacultySickEntitlement", numberType);
        selectFieldsTypeMap.put("FacultySickMaxEntitlement", numberType);
        selectFieldsTypeMap.put("ChildCareEntitlement", numberType);
        selectFieldsTypeMap.put("ElderlyCareEntitlement", numberType);
        selectFieldsTypeMap.put("AnnualLeave", numberType);
        selectFieldsTypeMap.put("SickLeave", numberType);
        selectFieldsTypeMap.put("MarriageLeave", numberType);
        selectFieldsTypeMap.put("PaternityLeave", numberType);
        selectFieldsTypeMap.put("MaternityLeave", numberType);
        selectFieldsTypeMap.put("BereavementLeave", numberType);
        selectFieldsTypeMap.put("MiscarriageLeave", numberType);
        selectFieldsTypeMap.put("LeaveOfFamilyPlanningBirthControl", numberType);
        selectFieldsTypeMap.put("WorkRelatedInjuryLeave", numberType);
        selectFieldsTypeMap.put("MedicalTreatmentLeave", numberType);
        selectFieldsTypeMap.put("UnpaidLeaveH", numberType);
        selectFieldsTypeMap.put("CompensatoryLeaveH", numberType);
        selectFieldsTypeMap.put("ChildCareLeave", numberType);
        selectFieldsTypeMap.put("ElderlyCareLeave", numberType);
        selectFieldsTypeMap.put("AnnualLeaveBalance", numberType);
        selectFieldsTypeMap.put("SickLeaveBalance", numberType);
        selectFieldsTypeMap.put("CompensatoryLeaveBalanceH", numberType);
        selectFieldsTypeMap.put("ChildCareLeaveBalance", numberType);
        selectFieldsTypeMap.put("ElderlyCareLeaveBalance", numberType);
        List<String> list = this.getcolNamesAction();
        ExportAllUtil.exportData(response, rs, "AbsenceSummaryForAllLeaveList.xlsx", selectFieldsTypeMap, list);
        return null;
    }

    public Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }
}

