/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.EnactmentService;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.Profile;
import kd.isc.iscb.util.flow.core.i.c.common.Pause;
import kd.isc.iscb.util.flow.core.i.c.composite.StartSubNodes;
import kd.isc.iscb.util.flow.core.i.model.AbstractExecutable;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ControllerImpl;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;
import kd.isc.iscb.util.flow.core.i.runtime.EnactmentServiceImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.PropertyContainerImpl;
import kd.isc.iscb.util.flow.core.plugin.Callback;
import kd.isc.iscb.util.misc.mem.MemoryControl;
import kd.isc.iscb.util.misc.mem.RuntimeContext;

public class RuntimeImpl
extends PropertyContainerImpl
implements FlowRuntime,
RuntimeContext {
    private static final String LAST_EXECUTION = "last-execution";
    private static final String BREAK_POINTS = "BREAK_POINTS";
    private String id;
    private FlowImpl flow;
    private int counter = 0;
    private volatile FlowRuntime.State state = FlowRuntime.State.Created;
    private HashMap<String, ExecutionImpl> executions = new HashMap();
    private LinkedList<ExecutionImpl> executionQueue = new LinkedList();
    private DataAreaImpl rootMemory;
    private ExecutionImpl rootExecution;
    private ExecutionImpl lastExecution;
    private Profile profile = Profile.NONE;
    private FlowTrace trace = Profile.NONE.getTrace(this);
    private transient LinkedList<Throwable> errors = new LinkedList();
    private Logger.Level loggerLevel = Logger.Level.WARN;
    private transient Boolean memoryControlEnabled = null;

    @Override
    public boolean isMemoryControlEnabled() {
        if (this.memoryControlEnabled == null) {
            Object v = this.get("__MEMORY_CTRL_ENABLED");
            this.memoryControlEnabled = v != null ? Boolean.valueOf(D.x(v)) : Boolean.valueOf(MemoryControl.REF.get().isEnabled());
        }
        return this.memoryControlEnabled;
    }

    private RuntimeImpl() {
    }

    public static RuntimeImpl fromJson(FlowImpl flow, Map<String, Object> root) {
        HashMap<String, FlowImpl> flows = new HashMap<String, FlowImpl>();
        flows.put(flow.getId(), flow);
        RuntimeImpl runtime = new RuntimeImpl();
        runtime.flow = flow;
        runtime.state = FlowRuntime.State.valueOf((String)root.get("state"));
        runtime.id = (String)root.get("id");
        runtime.counter = Integer.parseInt((String)root.get("counter"));
        runtime.profile = Profile.valueOf((String)root.get("profile"));
        runtime.restoreProperties(root);
        RuntimeImpl.restoreRootDataArea(flows, runtime, root);
        RuntimeImpl.restoreLastExecution(runtime, root);
        RuntimeImpl.restoreExecutionQueue(runtime, root);
        return runtime;
    }

    private static void restoreExecutionQueue(RuntimeImpl runtime, Map<String, Object> root) {
        List ids = (List)root.get("execution-queue");
        if (ids != null) {
            for (String id : ids) {
                ExecutionImpl e = runtime.getExecution(id);
                if (e == null) continue;
                runtime.executionQueue.add(e);
            }
        }
    }

    private static void restoreLastExecution(RuntimeImpl runtime, Map<String, Object> root) {
        String id = (String)root.get(LAST_EXECUTION);
        runtime.lastExecution = runtime.getExecution(id);
    }

    private static void restoreRootDataArea(HashMap<String, FlowImpl> flows, RuntimeImpl runtime, Map<String, Object> root) {
        Map mem = (Map)root.get("memory");
        runtime.rootMemory = DataAreaImpl.fromJson(flows, runtime, mem, null);
    }

    @Override
    public Map<String, Object> toJson() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", this.id);
        FlowRuntime.State state = this.isRunning() ? FlowRuntime.State.Waiting : this.state;
        data.put("state", state.name());
        data.put("counter", String.valueOf(this.counter));
        data.put("profile", this.profile.name());
        this.saveDataAreas(data);
        this.saveProperties(data);
        this.saveLastExecution(data);
        this.saveExecutionQueue(data);
        return data;
    }

    private void saveDataAreas(HashMap<String, Object> data) {
        HashMap<String, Object> mem = new HashMap<String, Object>();
        data.put("memory", mem);
        this.rootMemory.toJson(mem);
    }

    private void saveLastExecution(HashMap<String, Object> data) {
        if (this.lastExecution != null) {
            data.put(LAST_EXECUTION, this.lastExecution.getId());
        }
    }

    private void saveExecutionQueue(HashMap<String, Object> data) {
        ArrayList<String> list = new ArrayList<String>(this.executionQueue.size());
        if (this.isRunning()) {
            list.add(this.getLastExecution().getId());
        }
        for (ExecutionImpl e : this.executionQueue) {
            list.add(e.getId());
        }
        data.put("execution-queue", list);
    }

    public RuntimeImpl(FlowImpl flow, String id) {
        this.flow = flow;
        this.id = id;
        this.rootMemory = new DataAreaImpl(this);
        new ExecutionImpl(null, flow.getRoot(), this.rootMemory);
    }

    public void assignInput(Object[] input) {
        List<VariableImpl> variables = this.flow.getInputVariables();
        if (variables.size() != input.length) {
            throw new IscBizException(ResManager.loadKDString("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!", "RuntimeImpl_0", "isc-iscb-util", new Object[0]));
        }
        try {
            int i = 0;
            while (i < input.length) {
                VariableImpl v = variables.get(i);
                this.rootMemory.clear(v);
                this.rootMemory.innerSetAt(v, input[i]);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IscBizException(ResManager.loadKDString("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3002", "RuntimeImpl_1", "isc-iscb-util", new Object[0]), e);
        }
    }

    void setStopped(boolean stoppedOnly) {
        if (!stoppedOnly && this.isRunning() && this.lastExecution != null) {
            this.executionQueue.addFirst(this.lastExecution);
        }
        if (this.isRunning()) {
            this.state = this.rootExecution.current().getLabel() == Pause.CMD_AFTER_SUSPENDED.getLabel() ? FlowRuntime.State.Suspended : FlowRuntime.State.Waiting;
        }
    }

    public void push(ExecutionImpl e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.executionQueue.contains(e)) {
            return;
        }
        switch (e.getDefine().getQueueMode()) {
            case FIRST: {
                this.executionQueue.addFirst(e);
                break;
            }
            case LAST: {
                this.executionQueue.addLast(e);
                break;
            }
            default: {
                throw new IscBizException("Impossible error!");
            }
        }
    }

    public boolean executionQueueIsEmpty() {
        return this.executionQueue.isEmpty();
    }

    public void pushAtFirst(ExecutionImpl e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.executionQueue.addFirst(e);
    }

    @Override
    public ExecutionImpl getRootExecution() {
        return this.rootExecution;
    }

    ExecutionImpl pop() {
        ExecutionImpl e = null;
        if (this.executionQueue.size() > 0) {
            e = this.lastExecution = this.executionQueue.removeFirst();
        }
        return e;
    }

    @Override
    public ExecutionImpl getNext() {
        if (this.executionQueue.size() > 0) {
            return this.executionQueue.getFirst();
        }
        return this.rootExecution;
    }

    @Override
    public ExecutionImpl getLastExecution() {
        return this.lastExecution;
    }

    public int nextId() {
        return this.counter++;
    }

    @Override
    public void setProfile(Profile profile) {
        this.profile = profile;
        this.trace = profile.getTrace(this);
    }

    @Override
    public void setFlowTrace(FlowTrace trace) {
        this.trace = trace;
    }

    @Override
    public FlowTrace getFlowTrace() {
        return this.trace;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    void register(ExecutionImpl e) {
        this.checkAndSetRootExecution(e);
        if (this.executions.containsKey(e.getId())) {
            throw new IscBizException("Identifier (" + e.getId() + ") already exists!");
        }
        this.executions.put(e.getId(), e);
    }

    private void checkAndSetRootExecution(ExecutionImpl e) {
        if (e.getParent() == null) {
            if (this.rootExecution != null) {
                throw new IscBizException("Root execution already exists!");
            }
            this.rootExecution = e;
        }
    }

    void unregister(ExecutionImpl e) {
        this.executions.remove(e.getId());
    }

    @Override
    public ExecutionImpl getExecution(String id) {
        return this.executions.get(id);
    }

    @Override
    public List<Execution> findExecution(Node node) {
        ArrayList<Execution> list = new ArrayList<Execution>();
        for (Execution execution : this.executions.values()) {
            if (!execution.getDefine().equals(node)) continue;
            list.add(execution);
        }
        return list;
    }

    public ExecutionImpl getNodeExecution(String id) {
        ExecutionImpl e = this.executions.get(id);
        if (e == null) {
            throw new IscBizException("Execution {" + id + "} doesn't exist!");
        }
        AbstractExecutable def = e.getDefine();
        if (def instanceof NodeImpl) {
            return e;
        }
        throw new IscBizException("{" + e + "} isn't node instance!");
    }

    public List<ExecutionImpl> getExecutions(String defId) {
        ArrayList<ExecutionImpl> list = new ArrayList<ExecutionImpl>();
        for (ExecutionImpl e : this.executions.values()) {
            if (!e.getDefine().getId().equals(defId)) continue;
            list.add(e);
        }
        return list;
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FlowImpl getFlow() {
        return this.flow;
    }

    @Override
    public boolean isClosed() {
        return this.state == FlowRuntime.State.Closed;
    }

    public void setClosed() {
        this.state = FlowRuntime.State.Closed;
    }

    @Override
    public boolean isStarted() {
        return this.state != FlowRuntime.State.Created;
    }

    @Override
    public boolean isRunning() {
        return this.state == FlowRuntime.State.Running;
    }

    @Override
    public void execute(Object ... args) {
        this.checkInterrupted();
        this.checkRunning();
        this.prepare4execute(args);
        ControllerImpl.execute(this);
    }

    @Override
    public void prepare(Object[] args) {
        this.assignInput(args);
        this.push(this.rootExecution);
    }

    private void prepare4execute(Object[] args) {
        this.setStarted();
        this.assignInput(args);
        this.push(this.rootExecution);
    }

    private void checkRunning() {
        if (this.isRunning()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5f53\u524d\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u7981\u6b62\u8c03\u7528\u672c\u65b9\u6cd5\u3002", "RuntimeImpl_2", "isc-iscb-util", new Object[0]));
        }
    }

    private void checkInterrupted() {
        if (this.isInterrupted()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u4e0a\u6b21\u6267\u884c\u88ab\u4e2d\u6b62\uff0c\u7981\u6b62\u8c03\u7528\u672c\u65b9\u6cd5\u3002", "RuntimeImpl_3", "isc-iscb-util", new Object[0]));
        }
    }

    private void setStarted() {
        if (this.isStarted()) {
            throw new IscBizException(ResManager.loadKDString("\u5df2\u542f\u52a8\u3002", "RuntimeImpl_4", "isc-iscb-util", new Object[0]));
        }
        this.state = FlowRuntime.State.Running;
    }

    boolean setRunning() {
        if (this.isRunning()) {
            return false;
        }
        this.state = FlowRuntime.State.Running;
        return true;
    }

    @Override
    public void signal(String executionId) {
        ExecutionImpl e = this.checkState(executionId);
        this.signalBeforePartiallyCompleted(e);
        e.signal();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public boolean prepare(String executionId, Object params) {
        ExecutionImpl e = this.checkState(executionId);
        boolean isContinue = this.handleInjection(e, params);
        this.signalBeforePartiallyCompleted(e);
        return isContinue;
    }

    @Override
    public boolean inject(String executionId, Object params) {
        boolean isContinue = this.prepare(executionId, params);
        if (isContinue) {
            ExecutionImpl e = this.checkState(executionId);
            e.signal();
        }
        return isContinue;
    }

    private void signalBeforePartiallyCompleted(ExecutionImpl e) {
        if (e.isBeforePartiallyCompleted()) {
            e.signal();
            if (this.setRunning()) {
                ControllerImpl.execute(this);
            }
        }
    }

    private ExecutionImpl checkState(String executionId) {
        if (this.isClosed()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u5524\u9192\uff01", "RuntimeImpl_5", "isc-iscb-util", new Object[0]));
        }
        ExecutionImpl e = this.getExecution(executionId);
        if (e == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u6267\u884c\u5bf9\u8c61{%s}\u4e0d\u5b58\u5728\uff01", "RuntimeImpl_11", "isc-iscb-util", new Object[0]), executionId));
        }
        return e;
    }

    private boolean handleInjection(ExecutionImpl e, Object params) {
        Callback callback;
        AbstractExecutable def = e.getDefine();
        if (def instanceof NodeImpl && (callback = ((NodeImpl)def).getCallback()) != null) {
            return callback.inject(e, params);
        }
        return true;
    }

    @Override
    public void terminate() {
        if (this.isClosed()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u7ec8\u6b62\uff01", "RuntimeImpl_8", "isc-iscb-util", new Object[0]));
        }
        this.rootExecution.terminate();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
            if (this.isClosed()) {
                this.state = FlowRuntime.State.Terminated;
            }
        }
    }

    @Override
    public boolean isTerminated() {
        return this.state == FlowRuntime.State.Terminated;
    }

    @Override
    public boolean isSuspended() {
        return this.state == FlowRuntime.State.Suspended;
    }

    @Override
    public boolean queueIsEmpty() {
        return this.executionQueue.isEmpty();
    }

    @Override
    public FlowRuntime.State getState() {
        return this.state;
    }

    @Override
    public void suspend() {
        if (this.isClosed()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u6302\u8d77\uff01", "RuntimeImpl_9", "isc-iscb-util", new Object[0]));
        }
        if (this.isSuspended()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u6302\u8d77\uff01", "RuntimeImpl_10", "isc-iscb-util", new Object[0]));
        }
        this.rootExecution.suspend();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public void failed() {
        if (this.isClosed()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u6302\u8d77\uff01", "RuntimeImpl_9", "isc-iscb-util", new Object[0]));
        }
        if (this.isSuspended()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u6302\u8d77\uff01", "RuntimeImpl_10", "isc-iscb-util", new Object[0]));
        }
        this.rootExecution.bizFailed();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public void resume() {
        if (this.isClosed()) {
            throw new IscBizException(ResManager.loadKDString("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u5524\u9192\uff01", "RuntimeImpl_5", "isc-iscb-util", new Object[0]));
        }
        if (this.rootExecution.current() instanceof Pause) {
            this.rootExecution.resume();
        } else {
            RuntimeImpl.pushAll(this, this.rootExecution);
        }
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    private static void pushAll(RuntimeImpl runtime, ExecutionImpl e) {
        for (ExecutionImpl c : e.getChildren()) {
            RuntimeImpl.pushAll(runtime, c);
        }
        runtime.push(e);
    }

    @Override
    public List<?> getOutput() {
        if (!this.isClosed()) {
            return null;
        }
        List<VariableImpl> variables = this.flow.getOutputVariables();
        ArrayList<Object> output = new ArrayList<Object>(variables.size());
        int i = 0;
        while (i < variables.size()) {
            output.add(this.rootMemory.getAt(variables.get(i)));
            ++i;
        }
        return output;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    public boolean existsInterrupt(AbstractExecutable scope, int index) {
        HashSet breakPoints = (HashSet)this.getProperty(String.valueOf(scope.getId()) + "_" + BREAK_POINTS);
        if (breakPoints != null) {
            return breakPoints.contains(String.valueOf(index));
        }
        return false;
    }

    @Override
    public boolean isInterrupted() {
        return this.executionQueue.size() > 0;
    }

    void resetError() {
        this.errors.clear();
    }

    public void popError() {
        this.errors.removeFirst();
    }

    public void pushError(Throwable error) {
        if (error == null) {
            throw new NullPointerException("error is null.");
        }
        this.errors.addFirst(error);
    }

    @Override
    public Throwable getError() {
        return this.errors.isEmpty() ? null : this.errors.getFirst();
    }

    @Override
    public EnactmentService getService() {
        return new EnactmentServiceImpl(this);
    }

    @Override
    public boolean contains(String property) {
        if ("#EXECUTION".equals(property)) {
            return true;
        }
        if ("#DEFINE".equals(property)) {
            return true;
        }
        if ("#ID".equals(property)) {
            return true;
        }
        if ("$error".equals(property)) {
            return true;
        }
        return this.getRootExecution().contains(property);
    }

    @Override
    public Object get(String property) {
        if ("#EXECUTION".equals(property)) {
            return this.getLastExecution().getId();
        }
        if ("#DEFINE".equals(property)) {
            return this.getFlow();
        }
        if ("#ID".equals(property)) {
            return this.getId();
        }
        if ("$error".equals(property)) {
            return this.getError();
        }
        return this.getRootExecution().get(property);
    }

    @Override
    public boolean set(String var, Object value) {
        return this.getRootExecution().set(var, value);
    }

    @Override
    public void setLoggerLevel(Logger.Level level) {
        if (level == null) {
            throw new NullPointerException("Level is null.");
        }
        this.loggerLevel = level;
    }

    @Override
    public Logger.Level getLoggerLevel() {
        return this.loggerLevel;
    }

    @Override
    public void setStartup(String ... startup) {
        StartSubNodes.setStartupChildren(this.rootExecution, startup);
    }

    @Override
    public DataAreaImpl getRootMemory() {
        return this.rootMemory;
    }
}

