/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfDirectCreateProcessEvent;
import com.kingdee.bos.workflow.cust.app.startsheme.SQLUtils;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;

public final class InvokeWorkFlow
extends AbstractCommandExecutor {
    public String getCommand() {
        return "invoke_workflow";
    }

    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        String proxy_user = D.s((Object)params.get("proxyUser"));
        Context context = Util.generateBosCtx(ctx, proxy_user);
        if (proxy_user == null) {
            EasContext easContext = (EasContext)ctx;
            proxy_user = easContext.getUserId();
        }
        List idList = (List)params.get("idList");
        String[] billIds = new String[idList.size()];
        idList.toArray(billIds);
        int i = 0;
        while (i < idList.size()) {
            WfDirectCreateProcessEvent wfProcessEvent = new WfDirectCreateProcessEvent();
            try {
                BOSObjectType bosType = BOSUuid.read((String)((String)idList.get(i))).getType();
                this.CheckWorkFlowById(context, (String)idList.get(i));
                String procDef = this.findProcDefByBillBosType(context, bosType.toString());
                if (procDef == null) {
                    throw new Exception("\u6839\u636e\u5355\u636eid\uff1a" + (String)idList.get(i) + "\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u72b6\u6001\u7684\u5de5\u4f5c\u6d41\u3002");
                }
                WfTxContext wfContext = WfTxContext.beginTx((Context)context);
                wfProcessEvent.setBoId((String)idList.get(i));
                wfProcessEvent.setUserId(proxy_user);
                wfProcessEvent.setProcDefId(procDef);
                WfEngine.getEngine((Context)context).acceptWfDirectCreateProcessEventSupport(wfProcessEvent);
                wfContext.endTx();
            }
            catch (Exception e) {
                EasContext.getErrLogger().warn((Object)"\u6267\u884cinvoke_workflow\u6307\u4ee4\u51fa\u9519", (Throwable)e);
                throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
            }
            ++i;
        }
        return null;
    }

    private void CheckWorkFlowById(Context context, String billId) throws Exception {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        if (procInsts.length > 0) {
            throw new Exception("\u5355\u636eid\uff1a" + billId + "\u5df2\u7ecf\u6709\u5de5\u4f5c\u6d41\u5728\u8fd0\u884c\uff0c\u7981\u6b62\u91cd\u65b0\u542f\u52a8\u5de5\u4f5c\u6d41\u3002");
        }
    }

    private String findProcDefByBillBosType(Context ctx, String billBosType) throws WfException {
        StringBuffer sql = new StringBuffer(300);
        sql.append("select top 1 FPROCDEFID ").append("from t_wfr_procdef a ").append("where a.finnerversion = ").append("(select max(finnerversion) ").append("from t_wfr_procdef ").append("where fprocdefid = a.fprocdefid) ").append("and a.FBillBosType = ? ").append("and a.FENABLE = 1 ").append("order by FCREATEDTIME desc ");
        String result = null;
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billBosType});
            if (rs.next()) {
                result = rs.getString("FPROCDEFID");
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return result;
    }
}

