/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class CreateAttachment
extends AbstractCommandExecutor {
    private static Method addNewAttachmentContainCtx;

    static {
        try {
            addNewAttachmentContainCtx = AttachmentServerManager.class.getMethod("addNewAttachmentContainCtx", Context.class, String.class, SimpleAttachmentInfo.class);
        }
        catch (Throwable e) {
            EasContext.getErrLogger().warn((Object)"\u627e\u4e0d\u5230\u57fa\u7840AttachmentServerManager\u7c7b\u7684addNewAttachmentContainCtx\u65b9\u6cd5", e);
        }
    }

    public String getCommand() {
        return "create_attachment";
    }

    protected synchronized Object exec(ConnectorContext ctx, Map<String, Object> params) {
        try {
            return this.innerExec(ctx, params);
        }
        catch (Exception e) {
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
    }

    private Object innerExec(ConnectorContext ctx, Map<String, Object> params) throws IOException, BOSException, EASBizException, IllegalAccessException, InvocationTargetException {
        int index;
        Object taskId = params.get("taskId");
        assert (taskId != null);
        byte[] completedContent = this.getCompletedContent(ctx, taskId);
        assert (completedContent.length > 0);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        Map fileInfo = (Map)params.get("fileInfo");
        sai.setCode(D.s(fileInfo.get("code")));
        String fileName = D.s(fileInfo.get("name"));
        String typeName = D.s(fileInfo.get("type"));
        if (typeName != null && (index = fileName.indexOf("." + typeName)) > -1) {
            fileName = fileName.substring(0, index);
        }
        sai.setMainName(fileName);
        sai.setExtName(typeName);
        sai.setDescription(D.s(fileInfo.get("desc")));
        sai.setContent(completedContent);
        String attachCreator = D.s(fileInfo.get("attachCreator"));
        Context bosContext = Util.generateBosCtx(ctx, attachCreator);
        AttachmentServerManager serverManager = AttachmentManagerFactory.getServerManager((Context)bosContext);
        String attachmentId = null;
        attachmentId = addNewAttachmentContainCtx == null ? serverManager.addNewAttachment(bosContext, BOSUuid.create((String)"F4AF4F03").toString(), sai) : (String)addNewAttachmentContainCtx.invoke((Object)serverManager, bosContext, BOSUuid.create((String)"F4AF4F03").toString(), sai);
        this.checkAttachmentHasInsert(bosContext, attachmentId);
        Timestamp attachCreateTime = D.t(fileInfo.get("attachCreateTime"));
        if (attachCreateTime != null) {
            this.updateCreateTime(bosContext, attachmentId, attachCreateTime);
        }
        return attachmentId;
    }

    private void updateCreateTime(Context bosContext, String attachmentId, Timestamp attachCreateTime) {
        String sql = "update t_bas_attachment set fcreatetime = ? where fid  = ?";
        ArrayList<Integer> types = new ArrayList<Integer>(2);
        ArrayList<Object> values = new ArrayList<Object>(2);
        types.add(93);
        values.add(attachCreateTime);
        types.add(12);
        values.add(attachmentId);
        Connection cn = this.getConnection(bosContext);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private Connection getConnection(Context bos_context) {
        try {
            return DbConnector.getConnection((Context)bos_context);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{bos_context.getAIS()});
        }
    }

    private void checkAttachmentHasInsert(Context bosContext, String attachmentId) throws BOSException, EASBizException {
        if (attachmentId == null) {
            EasContext.getErrLogger().error((Object)"\u8c03\u7528bos\u57fa\u7840\u521b\u5efa\u9644\u4ef6\u63a5\u53e3\u6ca1\u6709\u5f02\u5e38\u629b\u51fa\u5374\u8fd4\u56de\u4e86\u7a7a\u7684\u9644\u4ef6id\uff0c\u8bf7\u68c0\u67e5apusic\u65e5\u5fd7\u662f\u5426\u6709\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55\u3002");
            throw new IscBizException("\u8c03\u7528bos\u57fa\u7840\u521b\u5efa\u9644\u4ef6\u63a5\u53e3\u6ca1\u6709\u5f02\u5e38\u629b\u51fa\u5374\u8fd4\u56de\u4e86\u7a7a\u7684\u9644\u4ef6id\uff0c\u8bf7\u68c0\u67e5apusic\u65e5\u5fd7\u662f\u5426\u6709\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55\u3002");
        }
        IAttachment attachFactory = AttachmentFactory.getLocalInstance((Context)bosContext);
        if (!attachFactory.exists((IObjectPK)new ObjectUuidPK(attachmentId))) {
            EasContext.getErrLogger().error((Object)("\u8c03\u7528bos\u57fa\u7840bos\u57fa\u7840\u521b\u5efa\u9644\u4ef6\u63a5\u53e3\u8fd4\u56de\u9644\u4ef6id:" + attachmentId + "\uff0c\u67e5\u8be2\u6570\u636e\u5e93\u65f6\u5374\u4e0d\u5b58\u5728\u8be5\u884c\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5apusic\u65e5\u5fd7\u662f\u5426\u6709\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55\u3002"));
            throw new IscBizException("\u8c03\u7528bos\u57fa\u7840bos\u57fa\u7840\u521b\u5efa\u9644\u4ef6\u63a5\u53e3\u8fd4\u56de\u9644\u4ef6id:" + attachmentId + "\uff0c\u67e5\u8be2\u6570\u636e\u5e93\u65f6\u5374\u4e0d\u5b58\u5728\u8be5\u884c\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5apusic\u65e5\u5fd7\u662f\u5426\u6709\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55\u3002");
        }
    }

    private byte[] getCompletedContent(ConnectorContext ctx, Object taskId) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Connection cn = ctx.getConnection();
        try {
            List<Object> values = Arrays.asList(taskId);
            List<Integer> types = Arrays.asList(12);
            String sql = "select fid,fseq,fdata from T_ISCB_TMP_RETURNS where fid=? order by fseq";
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, values, types);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                byte[] data = Hex.decode((String)((String)row.getValue("fdata")));
                baos.write(data);
                row = (DataRow)reader.read();
            }
            sql = "delete from T_ISCB_TMP_RETURNS where fid=?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            ctx.dispose(cn);
        }
    }
}

