/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e.s;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.MissingMetaDataException;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FacadeInvoke {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.job.wrapper.FacadeInvoke");

    private FacadeInvoke() {
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args) throws BOSException {
        return FacadeInvoke.localInvoke(ctx, pk, methodName, args, false);
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args, boolean isHandleEvent) throws BOSException {
        return FacadeInvoke.innerLocalInvoke(ctx, pk, methodName, args, isHandleEvent, true);
    }

    public static Object localInvokeNoProxy(Context ctx, IMetaDataPK pk, String methodName, Object[] args) throws BOSException {
        return FacadeInvoke.innerLocalInvoke(ctx, pk, methodName, args, false, false);
    }

    private static Object innerLocalInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args, boolean isHandleEvent, boolean useProxy) throws BOSException {
        if (ctx == null || pk == null || args == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        try {
            return FacadeInvoke.innerLocalInvoke(ctx, pk, methodName, args, isHandleEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectException((Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException e) {
            throw new BOSClassNotFoundException((Throwable)e);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable e = invocationTargetException.getTargetException();
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            throw new BOSException(e);
        }
    }

    private static Object innerLocalInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args, boolean isHandleEvent) throws BOSException, ClassNotFoundException, FriendlyBOSException, IllegalAccessException, InvocationTargetException {
        String methodInnerId;
        boolean controllerBeanInvoke = false;
        Class<?>[] parameterTypes = null;
        FacadeInfo facade = FacadeInvoke.getFacade(ctx, pk);
        BOSObjectType bosType = facade.getType();
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        MethodInfo method = FacadeInvoke.getFacadeMehod(facade, methodName);
        BusinessObjectInfo boInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        method = boInfo.getInheritedMethodByID(methodInnerId = method.getInnerID());
        if (method.getAccessLevel() == AccessLevel.PUBLIC) {
            methodName = method.getName();
            parameterTypes = FacadeInvoke.getParameterTypes(ctx, method);
        }
        Class<?>[] argsClasses = parameterTypes;
        Object[] argsValues = args;
        if (controllerBeanInvoke) {
            argsClasses = new Class[parameterTypes.length + 1];
            argsValues = new Object[args.length + 1];
            FacadeInvoke.prepareArgumentTypesAndValues(ctx, args, parameterTypes, argsClasses, argsValues);
        }
        Method runMethod = FacadeInvoke.getMethod(obj, methodName, argsClasses);
        FacadeInvoke.checkArguments(methodName, facade, argsClasses, argsValues);
        if (!isHandleEvent) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        Object returnObj = null;
        try {
            returnObj = FacadeInvoke.innerLocalInvoke(obj, method, argsValues, runMethod);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
        if (returnObj != null) {
            return returnObj;
        }
        return null;
    }

    private static Object innerLocalInvoke(Object obj, MethodInfo method, Object[] argsValues, Method runMethod) throws BOSException, IllegalAccessException, InvocationTargetException {
        Object returnObj = TransactionAttribute.REQUIRED.equals((Object)method.getTransactionAttribute()) || TransactionAttribute.REQUIRESNEW.equals((Object)method.getTransactionAttribute()) ? ObjectFactory.invokeRequired((Object)obj, (Method)runMethod, (Object[])argsValues) : runMethod.invoke(obj, argsValues);
        return returnObj;
    }

    private static void prepareArgumentTypesAndValues(Context ctx, Object[] args, Class<?>[] parameterTypes, Class<?>[] argsClasses, Object[] argsValues) {
        argsClasses[0] = Context.class;
        if (parameterTypes.length > 0) {
            System.arraycopy(parameterTypes, 0, argsClasses, 1, parameterTypes.length);
        }
        if (ctx != null) {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        }
        argsValues[0] = ctx;
        if (args.length > 0) {
            System.arraycopy(args, 0, argsValues, 1, args.length);
        }
    }

    private static void checkArguments(String methodName, FacadeInfo facade, Class<?>[] argsClasses, Object[] argsValues) throws FriendlyBOSException {
        if (argsClasses != null && argsValues != null && argsClasses.length != argsValues.length) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_paramSizeNotMatched", null, null);
            exception.addArg(facade.getAlias());
            exception.addArg(facade.getFullName());
            exception.addArg(methodName);
            throw exception;
        }
    }

    private static Class<?>[] getParameterTypes(Context ctx, MethodInfo method) throws BOSException, ClassNotFoundException {
        ParameterCollection paramCol = method.getParameters();
        Class[] parameterTypes = new Class[paramCol.size()];
        int length = paramCol.size();
        int i = 0;
        while (i < length) {
            ParameterInfo param = paramCol.get(i);
            String temp = param.getDataType();
            if (temp.trim().equalsIgnoreCase(DataType.OBJECTVALUE.toString())) {
                Class<?> c;
                String objValueClassName = FacadeInvoke.getEntityOjbectByParam(ctx, param);
                parameterTypes[i] = c = Class.forName(objValueClassName);
            } else {
                Class paramClass;
                parameterTypes[i] = paramClass = ObjectUtils.getArgumentTypeClass((String)temp);
            }
            ++i;
        }
        return parameterTypes;
    }

    private static String getEntityOjbectByParam(Context ctx, ParameterInfo param) throws BOSException {
        String metaRef = param.getMetaDataRef();
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = MetaDataPK.create((String)metaPack, (String)metaName);
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)metaPK);
        String objValueClassName = String.valueOf(entity.getBusinessImplName()) + "Info";
        return objValueClassName;
    }

    public static Map<String, OperationInfo> getOperation(Context ctx, IMetaDataPK uiPK) throws BOSException {
        return FacadeInvoke.getOperation(ctx, uiPK, null);
    }

    public static Map<String, OperationInfo> getOperation(Context ctx, IMetaDataPK uiPK, String actionName) throws BOSException {
        if (uiPK == null) {
            throw new IllegalArgumentException("Parameter error!");
        }
        FunctionObjectCollection funcCol = FacadeInvoke.getRemoteFunctionRef(ctx, uiPK, MetaDataTypeList.UIOBJECT);
        if (funcCol == null) {
            throw new MissingMetaDataException("Get FunctionObject Collection error!");
        }
        HashMap<String, OperationInfo> map = new HashMap<String, OperationInfo>();
        int lengthFunc = funcCol.size();
        int i = 0;
        while (i < lengthFunc) {
            FunctionObjectInfo function = funcCol.get(i);
            OperationCollection operCol = function.getOperation();
            int lengthOper = operCol.size();
            int j = 0;
            while (j < lengthOper) {
                OperationInfo oper = operCol.get(j);
                if (actionName == null) {
                    map.put(String.valueOf(function.toString()) + "-" + j, oper);
                } else if (oper.getUiActionRef() != null && StringUtils.equalsIgnoreCase((String)oper.getUiActionRef().getActionRefName(), (String)actionName)) {
                    map.put(String.valueOf(function.toString()) + "-" + oper.getUiActionRef().getUIStatus(), oper);
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    public static FunctionObjectCollection getRemoteFunctionRef(Context ctx, IMetaDataPK refPK, BOSObjectType bosType) throws BOSException {
        if (refPK == null) {
            throw new IllegalArgumentException("Parameter error! refPK is null.");
        }
        FunctionObjectCollection reFuncCol = new FunctionObjectCollection();
        FunctionObjectCollection funcCol = FacadeInvoke.getFunctions(ctx);
        int length = funcCol.size();
        int i = 0;
        while (i < length) {
            FunctionObjectInfo function = funcCol.get(i);
            FacadeInvoke.getFunctionRef(refPK, bosType, reFuncCol, function);
            ++i;
        }
        if (reFuncCol.size() == 0) {
            throw new MissingMetaDataException("Error! Don't Found MetaData Object: " + refPK.getPackage() + "." + refPK.getName());
        }
        return reFuncCol;
    }

    private static void getFunctionRef(IMetaDataPK refPK, BOSObjectType bosType, FunctionObjectCollection reFuncCol, FunctionObjectInfo function) {
        OperationCollection opers = function.getOperation();
        int j = 0;
        while (j < opers.size()) {
            OperationInfo oper = opers.get(j);
            if (oper == null) {
                logger.warn((Object)("ERROR:operation is null. function :" + function.getName()));
            } else if (bosType == MetaDataTypeList.ENTITY && oper.getEntityObjectRef() != null) {
                FacadeInvoke.getEntityOperation(refPK, reFuncCol, function, oper);
            } else if (bosType == MetaDataTypeList.FACADE && oper.getFacadeObjectRef() != null) {
                FacadeInvoke.getFacadeOperation(refPK, reFuncCol, function, oper);
            } else if (bosType == MetaDataTypeList.UIOBJECT && oper.getUiActionRef() != null) {
                FacadeInvoke.getUIObjectInfoAction(refPK, reFuncCol, function, oper);
            }
            ++j;
        }
    }

    private static void getUIObjectInfoAction(IMetaDataPK refPK, FunctionObjectCollection reFuncCol, FunctionObjectInfo function, OperationInfo oper) {
        UIObjectInfo uiObjectInfo = oper.getUiActionRef().getUIObjectRef();
        if (uiObjectInfo == null) {
            logger.warn((Object)("UIObject not found! Please check Function[" + function.getFullName() + "] 's " + "UIAction [" + oper.getUiActionRef().getActionRefName() + "]."));
        } else if (StringUtils.equalsIgnoreCase((String)(String.valueOf(uiObjectInfo.getPackage()) + "." + uiObjectInfo.getName()), (String)(String.valueOf(refPK.getPackage()) + "." + refPK.getName()))) {
            reFuncCol.add(function);
        }
    }

    private static void getFacadeOperation(IMetaDataPK refPK, FunctionObjectCollection reFuncCol, FunctionObjectInfo function, OperationInfo oper) {
        if (StringUtils.equalsIgnoreCase((String)(String.valueOf(oper.getFacadeObjectRef().getPackage()) + "." + oper.getFacadeObjectRef().getName()), (String)(String.valueOf(refPK.getPackage()) + "." + refPK.getName()))) {
            reFuncCol.add(function);
        }
    }

    private static void getEntityOperation(IMetaDataPK refPK, FunctionObjectCollection reFuncCol, FunctionObjectInfo function, OperationInfo oper) {
        if (StringUtils.equalsIgnoreCase((String)(String.valueOf(oper.getEntityObjectRef().getPackage()) + "." + oper.getEntityObjectRef().getName()), (String)(String.valueOf(refPK.getPackage()) + "." + refPK.getName()))) {
            reFuncCol.add(function);
        }
    }

    private static MethodInfo getFacadeMehod(FacadeInfo facade, String methodName) throws BOSException {
        if (facade == null) {
            throw new IllegalArgumentException(facade + " is null!");
        }
        MethodCollection methodCol = facade.getAllMethods();
        MethodInfo oper = null;
        if (methodCol != null) {
            int length = methodCol.size();
            int i = 0;
            while (i < length) {
                if (StringUtils.equalsIgnoreCase((String)methodCol.get(i).getName(), (String)methodName)) {
                    oper = methodCol.get(i);
                    break;
                }
                ++i;
            }
            if (oper == null) {
                FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
                exception.addArg(facade.getAlias());
                exception.addArg(facade.getFullName());
                exception.addArg(methodName);
                throw exception;
            }
        } else if (oper == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
            exception.addArg(facade.getAlias());
            exception.addArg(facade.getFullName());
            exception.addArg(methodName);
            throw exception;
        }
        return oper;
    }

    private static Method getMethod(Object obj, String methodName, Class<?>[] parameterTypes) throws BOSException {
        if (obj == null || parameterTypes == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        try {
            return obj.getClass().getMethod(methodName, parameterTypes);
        }
        catch (SecurityException securityException) {
            throw new ReflectException((Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectException((Throwable)noSuchMethodException);
        }
    }

    public static FunctionObjectInfo getFunction(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataLoader.getFunction((Context)ctx, (IMetaDataPK)pk);
    }

    public static FacadeInfo getFacade(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataLoader.getFacade((Context)ctx, (IMetaDataPK)pk);
    }

    private static FunctionObjectCollection getFunctions(Context ctx) throws BOSException {
        return MetaDataLoader.getFunctions((Context)ctx);
    }

    protected static ServiceContext createServiceContext(BusinessObjectInfo boInfo, IMetaDataPK methodPK, Object[] params) {
        return new ServiceContext(boInfo.getType(), boInfo.getBOSType(), methodPK, params);
    }

    protected static void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("PERMISSION_SERVICE");
        ServiceStateManager.getInstance().setServiceState(state);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    protected static void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }
}

