/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateTimeUtils {
    public static String getDateByWeek(int week) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.set(3, week);
        calendar.set(7, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return sdf.format(calendar.getTime());
    }

    public static int getMouthByWeek(int week) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.set(3, week);
        calendar.set(7, 7);
        return calendar.get(2) + 1;
    }

    public static int getAllWeeks(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int week = calendar.get(3);
        if (week != 53) {
            week = 52;
        }
        return week;
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateTimeUtils.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getLastDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateTimeUtils.getLastDayOfWeek(cal.getTime());
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static int getweekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int weekOfYear = calendar.get(3);
        return weekOfYear;
    }

    public static Date getBeginDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        int day_of_week = cal.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        cal.add(5, -day_of_week + 1);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateTimeUtils.getBeginDayOfWeek(date));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateTimeUtils.getDayEndTime(weekEndSta);
    }

    public static Date getEndDayOfWeekcount(Date date, int count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.setTime(DateTimeUtils.getBeginDayOfWeek(date));
        calendar.add(5, (count - 1) * 7 + 6);
        return DateTimeUtils.getEndDayOfWeek(calendar.getTime());
    }

    public static Date yesterday(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.getTime();
    }

    public static Date tomorrow(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.getTime();
    }

    public static Date getDayBegin(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.getDayBegin());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.getDayEnd());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateTimeUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateTimeUtils.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 7);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateTimeUtils.getBeginDayOfLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateTimeUtils.getDayEndTime(weekEndSta);
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateTimeUtils.getEndDayOfWeek());
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date getNextWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateTimeUtils.getNextWeekMonday(date));
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 1, 1);
        return DateTimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getMonth(int year, int month) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, month);
        return c.getTime();
    }

    public static int getMonthOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekOfYear = calendar.get(2) + 1;
        return weekOfYear;
    }

    public static Date getBeginDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(date), DateTimeUtils.getNowMonth(date) - 1, 1);
        return DateTimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 1, day);
        return DateTimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(date), DateTimeUtils.getNowMonth(date) - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateTimeUtils.getNowYear(date), DateTimeUtils.getNowMonth(date) - 1, day);
        return DateTimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 2, 1);
        return DateTimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 2, day);
        return DateTimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOFNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() + 0, 1);
        return DateTimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() + 0, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() + 0, day);
        return DateTimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfThreeMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() - 4, 1);
        return DateTimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfThreeMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() + 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateTimeUtils.getNowYear(), DateTimeUtils.getNowMonth() + 2, day);
        return DateTimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfLastQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfThisQuarter());
        cal.set(2, cal.get(2) - 3);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfThisQuarter());
        cal.set(2, cal.get(2) - 1);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfThisQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        int currentMonth = cal.get(2) + 1;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                cal.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                cal.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                cal.set(2, 6);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                cal.set(2, 9);
            }
            cal.set(5, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfThisQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfThisQuarter());
        cal.set(2, cal.get(2) + 2);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfNextQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfThisQuarter());
        cal.set(2, cal.get(2) + 3);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfNextQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfNextQuarter());
        cal.set(2, cal.get(2) + 2);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getLastYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear() - 1);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear() - 1);
        cal.set(2, 11);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getBeginDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, DateTimeUtils.getNowYear(date));
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear());
        cal.set(2, 11);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getEndDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, DateTimeUtils.getNowYear(date));
        cal.set(2, 11);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Date getBeginDayOfNextYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear() + 1);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfNextYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateTimeUtils.getNowYear() + 1);
        cal.set(2, 11);
        cal.set(5, DateTimeUtils.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return DateTimeUtils.getDayEndTime(cal.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static Integer getNowYear(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getNowMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue();
        return days;
    }

    public static long dateDiff(Date beginDate, Date endDate) {
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return date2ms - date1ms;
    }

    public static Date max(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return beginDate;
        }
        return endDate;
    }

    public static Date min(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return endDate;
        }
        return beginDate;
    }

    public static Date getFirstSeasonDate(Date date) {
        int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = SEASON[cal.get(2)];
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getFrontDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static List getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int k) {
        ArrayList<List> list = new ArrayList<List>();
        if (beginYear == endYear) {
            int j = beginMonth;
            while (j <= endMonth) {
                list.add(DateTimeUtils.getTimeList(beginYear, j, k));
                ++j;
            }
        } else {
            int j = beginMonth;
            while (j < 12) {
                list.add(DateTimeUtils.getTimeList(beginYear, j, k));
                ++j;
            }
            int i = beginYear + 1;
            while (i < endYear) {
                int j2 = 0;
                while (j2 < 12) {
                    list.add(DateTimeUtils.getTimeList(i, j2, k));
                    ++j2;
                }
                ++i;
            }
            j = 0;
            while (j <= endMonth) {
                list.add(DateTimeUtils.getTimeList(endYear, j, k));
                ++j;
            }
        }
        return list;
    }

    public static List getTimeList(int beginYear, int beginMonth, int k) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)begincal).getActualMaximum(5);
        int i = 1;
        while (i < max) {
            list.add(begincal.getTime());
            ((Calendar)begincal).add(5, k);
            i += k;
        }
        begincal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(begincal.getTime());
        return list;
    }

    public static int getLastDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.get(5);
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date parseDate(String dateStr) {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u8f6c\u5316\u9519\u8bef");
        }
        return date;
    }

    public static Date parseDate(String dateStr, String format) {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u8f6c\u5316\u9519\u8bef");
        }
        return date;
    }

    public static String dateFormat(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String strDate = sdf.format(date);
        return strDate;
    }
}

