/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CustomerFunctionSalaryService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.service.CustomerFunctionSalaryService");

    public double getSalayBag(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String cmpItemId, String months, String mainTableRowFilter) throws BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String sql = "SELECT top 1 b.* FROM CT_SAL_SalaryBag a  left join CT_SAL_SalaryBagEntry b on a.fid = b.fbillId  where a.FBillState = 3 and CFPersonID = '" + personId + "' " + " and a.CFCmpItemID = (select fid from T_HR_SCmpItem where FNumber = '" + cmpItemId + "') and b.CFMonths = '" + months + "'";
        System.out.println("\u67e5\u8be2\u5de5\u8d44\u5305" + sql);
        String countSql = "SELECT count(1) count FROM CT_SAL_SalaryBag a  left join CT_SAL_SalaryBagEntry b on a.fid = b.fbillId  where a.FBillState = 1 and CFPersonID = '" + personId + "' " + " and a.CFCmpItemID = (select fid from T_HR_SCmpItem where FNumber = '" + cmpItemId + "') and b.CFMonths = '" + months + "'";
        IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
        int dataCount = 0;
        while (countRowSet.next()) {
            dataCount = countRowSet.getInt("count");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.next()) {
            if (dataCount > 0) {
                return rowSet.getDouble("CFAmountPayable");
            }
            return rowSet.getDouble("CFMoneys");
        }
        return 0.0;
    }

    public double getSalayTraceability(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String projectNumber, String date, String mainTableRowFilter) throws BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        int year = 0;
        int month = 0;
        try {
            Date parse = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            year = calendar.get(1);
            month = calendar.get(2) + 1;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String sql = "SELECT sum(cfreissuemonthpay) reissuemonthpay,sum(cfreissueoverpay) reissueoverpay,sum(cfreissuerestoverpay) reissuerestoverpay,sum(cfreissueholidaysoverpay) reissueholidaysoverpay,sum(cfreissueunleavededuction) reissueunleavededuction FROM CT_CUS_PersonPayForm where year(cfformmonth)=" + year + " and month(cfformmonth)=" + month + " and cfpersonid='" + personId + "'";
        System.out.println("\u5de5\u8d44\u8ffd\u6eaf\u67e5\u8be2sql\uff1a" + sql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.next()) {
            if (projectNumber.equals("0")) {
                return rowSet.getDouble("reissuemonthpay");
            }
            if (projectNumber.equals("1")) {
                return rowSet.getDouble("reissueoverpay");
            }
            if (projectNumber.equals("2")) {
                return rowSet.getDouble("reissuerestoverpay");
            }
            if (projectNumber.equals("3")) {
                return rowSet.getDouble("reissueholidaysoverpay");
            }
            if (projectNumber.equals("4")) {
                return rowSet.getDouble("reissueunleavededuction");
            }
        }
        return 0.0;
    }

    public double getPutForward(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String projectNumber, String date, String takeType, String isHour, String mainTableRowFilter) throws BOSException, SQLException {
        String amountSql;
        IRowSet schemeRow;
        Context ctx = Tools.getInstance().getCtx();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        int year = 0;
        int month = 0;
        try {
            Date parse = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            year = calendar.get(1);
            month = calendar.get(2) + 1;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String assignType = "";
        assignType = takeType.equals("0") ? "1" : "0";
        if (StringUtils.isNotBlank((CharSequence)isHour)) {
            String hourSql = "SELECT sum(b.CFTOTALWORKHOURS) sumHour FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid left join T_HR_SCmpEmpORelation c on b.FCMPEMPORELATIONID=c.fid left join T_HR_EmpOrgRelation d on d.fid=c.femporgrelationid where year(b.FEFFECTDATE)=" + year + " and month(b.FEFFECTDATE)=" + month + " " + "and d.FASSIGNTYPE='" + assignType + "' and a.FBILLSTATE = '3' and b.fpersonid='" + personId + "'";
            logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u5168\u804c\u603b\u5de5\u65f6SQL\uff1a" + hourSql));
            schemeRow = DbUtil.executeQuery((Context)ctx, (String)hourSql);
            if (schemeRow.next()) {
                return schemeRow.getDouble("sumHour");
            }
        }
        if (takeType.equals("0")) {
            if (StringUtils.isBlank((CharSequence)projectNumber)) {
                amountSql = "SELECT sum(b.CFTOTALAMOUNT) sumAmount FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid left join T_HR_SCmpEmpORelation c on b.FCMPEMPORELATIONID=c.fid left join T_HR_EmpOrgRelation d on d.fid=c.femporgrelationid where year(b.FEFFECTDATE)=" + year + " and month(b.FEFFECTDATE)=" + month + " " + "and d.FASSIGNTYPE='1' and a.FBILLSTATE = '3' and b.fpersonid='" + personId + "'";
                logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u5168\u804c\u603b\u91d1\u989dSQL\uff1a" + amountSql));
                schemeRow = DbUtil.executeQuery((Context)ctx, (String)amountSql);
                if (schemeRow.next()) {
                    return schemeRow.getDouble("sumAmount");
                }
            }
        } else {
            amountSql = "SELECT sum(b.CFTOTALAMOUNT) sumAmount FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid left join T_HR_SCmpEmpORelation c on b.FCMPEMPORELATIONID=c.fid left join T_HR_EmpOrgRelation d on d.fid=c.femporgrelationid where year(b.FEFFECTDATE)=" + year + " and month(b.FEFFECTDATE)=" + month + " " + "and d.FASSIGNTYPE='0' and a.FBILLSTATE = '3' and b.fpersonid='" + personId + "'";
            logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u517c\u804c\u603b\u91d1\u989dSQL\uff1a" + amountSql));
            schemeRow = DbUtil.executeQuery((Context)ctx, (String)amountSql);
            if (schemeRow.next()) {
                return schemeRow.getDouble("sumAmount");
            }
        }
        return 0.0;
    }

    public double getSeparationAllowance(String months) throws BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String sql = "select top 1 * from CT_COM_Compensationthreshold where CFEffectivedate <= '" + months + "' order by CFEffectivedate desc";
        System.out.println("\u83b7\u53d6\u6708\u4efd\u6700\u65b0\u7684\u79bb\u804c\u8865\u507f\u91d1sql\uff1a" + sql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.next()) {
            return rowSet.getDouble("FName_l2");
        }
        return 0.0;
    }

    public double getMianPosHour(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String date, String mainTableRowFilter) throws BOSException, SQLException {
        logger.error((Object)("\u83b7\u53d6\u4e3b\u8981\u4efb\u804c\u65f6\u85aa\u65e5\u671f\u53c2\u6570\uff1a" + date));
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String sql = "SELECT cfhourlywage FROM T_HR_EmpOrgRelation where fpersonid = '" + personId + "' and fassignType = '1' and fislatestinaday = '1' and feffdt <= '" + date + "' and fleffdt >= '" + date + "'";
        logger.error((Object)("\u83b7\u53d6\u4e3b\u8981\u4efb\u804c\u65f6\u85aaSQL\uff1a" + sql));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int count = 0;
        Double hour = 0.0;
        if (rowSet.next()) {
            hour = rowSet.getDouble("cfhourlywage");
            ++count;
        }
        logger.error((Object)("\u65f6\u85aa\uff1a" + hour + ", \u6b21\u6570\uff1a" + count));
        if (count > 1) {
            return 0.0;
        }
        return hour;
    }

    public String getDepartDate(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String beginDate, String endDate, String mainTableRowFilter) throws BOSException, SQLException {
        logger.error((Object)("\u83b7\u53d6\u79bb\u804c\u65e5\u671f\u53c2\u6570\uff1a\u5f00\u59cb\u65e5\u671f\uff1a" + beginDate + ",\u7ed3\u675f\u65e5\u671f\uff1a" + endDate));
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String departDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "SELECT top 1 b.FBIZDATE FROM T_HR_ResignBizBill a left join T_HR_ResignBizBillEntry b on a.FID = b.FBILLID where b.FBIZDATE >= '" + beginDate + "' and b.FBIZDATE <= '" + endDate + "' and a.FBILLSTATE = '3' and b.FPERSONID = '" + personId + "'";
        logger.error((Object)("\u83b7\u53d6\u79bb\u804c\u65e5\u671fSQL\uff1a" + sql));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.next()) {
            java.sql.Date date = rowSet.getDate("FBIZDATE");
            departDate = sdf.format(date);
        }
        if (StringUtils.isNotBlank((CharSequence)departDate)) {
            logger.error((Object)("\u4eba\u5458ID\uff1a" + personId + ",\u79bb\u804c\u65e5\u671f\uff1a" + departDate));
        }
        return departDate;
    }
}

