/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.erp.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsReqUtil {
    private static Logger log = LoggerFactory.getLogger(HttpsReqUtil.class);
    private static CloseableHttpClient httpClient;

    public static String postByHttps(String sendUrl, String param) throws Exception {
        URL url = new URL(sendUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        byte[] outputInBytes = param.getBytes("UTF-8");
        OutputStream os = conn.getOutputStream();
        os.write(outputInBytes);
        os.close();
        int responseCode = conn.getResponseCode();
        log.info("postByHttps.POST Response Code :: " + responseCode);
        if (responseCode == 200) {
            log.info("POST request succeeded");
        } else {
            log.info("POST request failed");
        }
        StringBuilder response = new StringBuilder();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            log.info("postByHttps.POST Response:" + response.toString());
        } else {
            log.info("POST NOT Worked");
        }
        conn.disconnect();
        return response.toString();
    }

    public static String getByHttps(String httpUrl, String requestMethod) {
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL(httpUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
            } else {
                System.out.println("GET request not worked");
            }
            con.disconnect();
        }
        catch (Exception e) {
            log.error("getByHttps.e:" + e.getMessage());
        }
        return response.toString();
    }

    public static String postByHttps(String sendUrl, String param, String accessToken) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(sendUrl);
        String responseMsg = null;
        log.info("postByHttps.sendUrl:" + sendUrl);
        log.info("postByHttps.param:" + param);
        log.info("postByHttps.accessToken:" + accessToken);
        try {
            try {
                StringEntity re = new StringEntity(param, "utf-8");
                re.setContentType("application/json");
                httppost.setHeader("accessToken", accessToken);
                httppost.setEntity((HttpEntity)re);
                HttpResponse response = httpClient.execute((HttpUriRequest)httppost);
                HttpEntity entity = response.getEntity();
                responseMsg = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                log.info("postByHttps.responseMsg:" + responseMsg);
            }
            catch (Exception e) {
                throw new Exception("\u8bf7\u6c42\u661f\u701a\u63a5\u53e3\u629b\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseMsg;
    }

    public static String doPost(String url, JSONObject json) {
        try {
            httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(url);
            post.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.81 Safari/537.36");
            StringEntity s = new StringEntity(json.toString(), "UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            response.setHeader("Content-type", "text/html;charset=UTF-8");
            if (response.getStatusLine().getStatusCode() == 200) {
                String res;
                String string = res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

