/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CmpCalTableWFRecordCollection;
import com.kingdee.shr.compensation.CmpWFPerDetailGridConfInfo;
import com.kingdee.shr.compensation.CmpWorkFlowMainBillInfo;
import com.kingdee.shr.compensation.CmpWorkFlowOrgLayerEntryCollection;
import com.kingdee.shr.compensation.CmpWorkFlowOrgLayerEntryFactory;
import com.kingdee.shr.compensation.exception.CmpEASHRException;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.permission.CmpOrgRangeAPI;
import com.kingdee.shr.compensation.request.ParseRequestHelper;
import com.kingdee.shr.compensation.util.BaseUtils;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.compensation.util.CmpCalUtils;
import com.kingdee.shr.compensation.util.workflow.CalParameter;
import com.kingdee.shr.compensation.util.workflow.CmpSendBillUtil;
import com.kingdee.shr.compensation.util.workflow.ext.CmpSendBillExtUtil;
import com.kingdee.shr.compensation.web.handler.CmpWorkFlowMainEditHandler;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class CmpWorkFlowMainEditHandlerEx
extends CmpWorkFlowMainEditHandler {
    private static Logger logger = Logger.getLogger(CmpWorkFlowMainEditHandler.class);
    private static final CmpCalUtils util = new CmpCalUtils();
    private static final BaseUtils baseUtil = new BaseUtils();

    public static CmpCalTableWFRecordCollection getCmpCalTableWFRecords(HttpServletRequest request) throws SHRWebException {
        String billId = request.getParameter("billId");
        CmpCalTableWFRecordCollection coll = null;
        coll = StringUtils.isEmpty((String)billId) ? CmpSendBillUtil.assembleCmpCalTableWFRecords((HttpServletRequest)request) : CmpSendBillUtil.assembleCmpCalTableWFRecords((String)billId);
        return coll;
    }

    protected void afterCreateNewModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        CmpSendBillUtil.checkIsOpenNewDynamicPage((HttpServletRequest)request);
        this.doCreateNewModel(request, coreBaseInfo);
    }

    public String getReWriteFieldContentAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            String description = CmpSendBillExtUtil.getReWriteFieldContent((HttpServletRequest)request);
            com.kingdee.shr.base.syssetting.web.json.JSONUtils.SUCCESS((Object)description);
            return null;
        }
        catch (Exception var5) {
            logger.error((Object)var5.getMessage(), (Throwable)var5);
            throw new ShrWebBizException(var5.getMessage(), (Throwable)var5);
        }
    }

    protected void afterSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String permItemId = ParseRequestHelper.getRequestPermItemId((HttpServletRequest)request);
        CmpSendBillUtil.doUpadateCalTableCalState((Context)ctx, (String)permItemId, (String)model.getId().toString(), (String)"T_HR_SCmpWorkFlowMainBill", (CalState)CalState.NOGIVE);
        CmpWorkFlowMainBillInfo billInfo = (CmpWorkFlowMainBillInfo)model;
        String calSchemeId = billInfo.getCalScheme().getId().toString();
        CmpCalUtil.updateNewCalSchemeState((Context)ctx, (String)calSchemeId);
        CmpCalUtils var10000 = util;
        CmpCalUtils.clearCacheMap();
        super.afterSubmit(request, response, model);
    }

    public int getSameCount(List<String> list1, List<String> list2) {
        int count = 0;
        for (String str : list1) {
            if (!list2.contains(str)) continue;
            ++count;
        }
        return count;
    }

    protected void beforeSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        CmpWorkFlowMainBillInfo billInfo = (CmpWorkFlowMainBillInfo)model;
        String billId = billInfo.getId() == null ? "" : billInfo.getId().toString();
        this.checkBillNumber(String.valueOf(billInfo.getNumber()) + "_" + billId);
        request.setAttribute(CmpConstants.CMP_LOG_OPERATE, (Object)(String.valueOf(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpWorkFlowResource", (String)"label1", (Locale)ctx.getLocale())) + billInfo.getNumber()));
        CmpCalTableWFRecordCollection coll = null;
        if (StringUtils.isEmpty((String)billId)) {
            CmpSendBillUtil.checkIsOpenNewDynamicPage((HttpServletRequest)request);
            coll = CmpWorkFlowMainEditHandlerEx.getCmpCalTableWFRecords(request);
            billInfo.setBillState(HRBillStateEnum.SAVED);
        } else {
            coll = CmpSendBillUtil.assembleCmpCalTableWFRecords((String)billId);
        }
        billInfo.getCalTableRecord().addCollection(coll);
        if (billInfo.getInstruction() != null && billInfo.getInstruction().length() > 255) {
            billInfo.setDescription(billInfo.getInstruction().substring(0, 255));
            System.out.println("setDescription1:" + billInfo.getInstruction().substring(0, 255));
        } else {
            billInfo.setDescription(billInfo.getInstruction());
            System.out.println("setDescription2:" + billInfo.getInstruction());
        }
        System.out.println("\u4fdd\u5b58\u524dbillInfo:" + billInfo.toString());
        this.savePersonalDetailGridConfig(request, billInfo);
    }

    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        try {
            CmpSendBillUtil.checkCanAddNewBill((HttpServletRequest)request);
        }
        catch (ShrWebBizException var7) {
            throw new ShrWebBizException(var7.getMessage());
        }
        CmpWorkFlowMainBillInfo billInfo = (CmpWorkFlowMainBillInfo)model;
        String billId = billInfo.getId() == null ? "" : billInfo.getId().toString();
        this.checkBillNumber(String.valueOf(billInfo.getNumber()) + "_" + billId);
        CmpCalTableWFRecordCollection coll = null;
        if (StringUtils.isEmpty((String)billId)) {
            CmpSendBillUtil.checkIsOpenNewDynamicPage((HttpServletRequest)request);
            coll = CmpWorkFlowMainEditHandlerEx.getCmpCalTableWFRecords(request);
        } else {
            coll = CmpSendBillUtil.assembleCmpCalTableWFRecords((String)billId);
        }
        billInfo.getCalTableRecord().addCollection(coll);
        billInfo.setBillState(HRBillStateEnum.SUBMITED);
        if (billInfo.getInstruction() != null && billInfo.getInstruction().length() > 255) {
            billInfo.setDescription(billInfo.getInstruction().substring(0, 255));
        } else {
            billInfo.setDescription(billInfo.getInstruction());
        }
        System.out.println("\u63d0\u4ea4\u524dbillInfo:" + billInfo.toString());
        this.savePersonalDetailGridConfig(request, billInfo);
    }

    public void checkBillNumber(String currentBill) throws SHRWebException {
        try {
            String[] billInfo = currentBill.split("_");
            String currentNumber = billInfo[0];
            String sql = "";
            if (billInfo.length == 1) {
                sql = "select * from T_HR_SCmpWorkFlowMainBill where fnumber='" + currentNumber + "'";
            } else {
                String billId = billInfo[1];
                sql = "select * from T_HR_SCmpWorkFlowMainBill where fnumber='" + currentNumber + "' and fid != '" + billId + "'";
            }
            IRowSet hasSameNumberRs = util.exeQuerySql(sql);
            if (hasSameNumberRs.next()) {
                throw new ShrWebBizException((Throwable)new CmpEASHRException(CmpEASHRException.HASSAME));
            }
        }
        catch (Exception var6) {
            util.handleException(var6);
            var6.printStackTrace();
        }
    }

    public void doCreateNewModel(HttpServletRequest request, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        String hrOrgUnitId;
        Context ctx = SHRContext.getInstance().getContext();
        CmpWorkFlowMainBillInfo billInfo = (CmpWorkFlowMainBillInfo)coreBaseInfo;
        CalParameter calParama = CmpSendBillUtil.getRequsetParameter((HttpServletRequest)request);
        CalSchemeInfo calSchemeInfo = CalSchemeBizUtil.getCalSchemeInfo((Context)ctx, (String)calParama.getCmpschemeId());
        AdminOrgUnitInfo adminOrgUnit = calSchemeInfo.getAdminOrgUnit();
        String adminOrgId = adminOrgUnit.getId().toString();
        HROrgUnitInfo delegateHrOrg = CmpOrgRangeAPI.getHROrgDelegateRange((Context)ctx, (String)adminOrgId);
        HROrgUnitInfo hrOrgUnit = calSchemeInfo.getHrOrgUnit();
        String string = hrOrgUnitId = hrOrgUnit == null ? "" : hrOrgUnit.getId().toString();
        if (HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)delegateHrOrg, (CoreBaseInfo)hrOrgUnit)) {
            billInfo.setIsUseDefault(true);
        } else {
            billInfo.setIsUseDefault(false);
        }
        billInfo.setCalScheme(calSchemeInfo);
        billInfo.setHrOrgUnit(hrOrgUnit);
        billInfo.getCalTableRecord().addCollection(CmpWorkFlowMainEditHandlerEx.getCmpCalTableWFRecords(request));
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        billInfo.setBeginDate(calSchemeInfo.getBeginDate());
        billInfo.setEndDate(calSchemeInfo.getEndDate());
        billInfo.setTime(calSchemeInfo.getCalTime());
        billInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
        billInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        billInfo.setBizDate(nowDate);
        billInfo.setAdminOrg(adminOrgUnit);
        String number = this.createBillNumber(hrOrgUnitId, billInfo);
        billInfo.setNumber(number);
    }

    private String createBillNumber(String hrOrgUnitId, CmpWorkFlowMainBillInfo cmpWorkFlowMainBillInfo) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String currentCUID = HRFilterUtils.getCurrentCUID((Context)ctx);
        String codeOrgId = StringUtil.isEmpty((String)hrOrgUnitId) ? currentCUID : hrOrgUnitId;
        boolean isUseCodingRule = this.isUseCodingRule((IObjectValue)cmpWorkFlowMainBillInfo, codeOrgId);
        if (isUseCodingRule) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                return iCodingRuleManager.readNumber((IObjectValue)cmpWorkFlowMainBillInfo, codeOrgId);
            }
            catch (BOSException var8) {
                throw new SHRWebException((Throwable)var8);
            }
            catch (EASBizException var9) {
                throw new SHRWebException((Throwable)var9);
            }
        }
        return null;
    }

    private boolean isUseCodingRule(IObjectValue model, String orgId) {
        ICodingRuleManager iCodingRuleManager;
        block3: {
            try {
                Context ctx = SHRContext.getInstance().getContext();
                iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (orgId == null || orgId.trim().length() <= 0 || !iCodingRuleManager.isExist(model, orgId)) break block3;
                return true;
            }
            catch (Exception var6) {
                var6.printStackTrace();
                return false;
            }
        }
        String companyId = this.getNextCompanyId();
        return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
    }

    private String getNextCompanyId() throws Exception {
        ObjectUuidPK pk;
        Context ctx = SHRContext.getInstance().getContext();
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        return rootCU != null ? rootCU.getId().toString() : null;
    }

    protected SelectorItemCollection getSelectors() throws SHRWebException {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnitLayers.orgUnitLayer.name");
        sic.add("orgUnitLayers.orgUnitLayer.id");
        return sic;
    }

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        super.setInitData(request, response, modelMap, initData);
        try {
            CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)"model");
            Context ctx = SHRContext.getInstance().getContext();
            if (model != null && model.getId() != null) {
                CmpWorkFlowOrgLayerEntryCollection entry = CmpWorkFlowOrgLayerEntryFactory.getLocalInstance((Context)ctx).getCmpWorkFlowOrgLayerEntryCollection("where billId = '" + model.getId().toString() + "'");
                StringBuffer idStr = new StringBuffer();
                StringBuffer nameStr = new StringBuffer();
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                int size = entry.size();
                while (i < size) {
                    OrgUnitLayerTypeInfo orgUnitLayer = entry.get(i).getOrgUnitLayer();
                    OrgUnitLayerTypeInfo orgUnitLayerTypeInfo = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(orgUnitLayer.getId()));
                    if (orgUnitLayer != null) {
                        idStr.append(orgUnitLayerTypeInfo.getId()).append(",");
                        nameStr.append(orgUnitLayerTypeInfo.getName()).append(",");
                    }
                    ++i;
                }
                if (idStr.length() > 0 && nameStr.length() > 0) {
                    map.put("id", idStr.substring(0, idStr.lastIndexOf(",")));
                    map.put("name", nameStr.substring(0, nameStr.lastIndexOf(",")));
                }
                initData.put("orgunitlayers", map);
            }
        }
        catch (BOSException var15) {
            var15.printStackTrace();
        }
        catch (EASBizException var16) {
            var16.printStackTrace();
        }
    }

    public String viewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String re = super.viewAction(request, response, modelMap);
        request.setAttribute(CmpConstants.CMP_LOG_OPERATE, (Object)this.queryBillNumber(request));
        return re;
    }

    private String queryBillNumber(HttpServletRequest request) {
        Context ctx = SHRContext.getInstance().getContext();
        String billId = request.getParameter("billId");
        if (StringUtil.isEmpty((String)billId)) {
            return "";
        }
        String operate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpWorkFlowResource", (String)"label1", (Locale)ctx.getLocale());
        String sql = "select FNumber from T_HR_SCmpWorkFlowMainBill where Fid = '" + billId + "'";
        try {
            IRowSet re = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (re.next()) {
                operate = String.valueOf(operate) + re.getString("FNumber");
            }
        }
        catch (BOSException var7) {
            var7.printStackTrace();
        }
        catch (SQLException var8) {
            var8.printStackTrace();
        }
        return operate;
    }

    protected String getBreadcrumbValue(HttpServletRequest request, ModelMap modelMap) throws SHRWebException {
        if ("ADDNEW".equalsIgnoreCase(this.getOperateStatus(request, modelMap))) {
            return super.getBreadcrumbValue(request, modelMap);
        }
        CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)"model");
        Object number = model.get("number");
        return number != null ? number.toString() : "";
    }

    private void savePersonalDetailGridConfig(HttpServletRequest request, CmpWorkFlowMainBillInfo billInfo) {
        String billId;
        String string = billId = billInfo.getId() == null ? "" : billInfo.getId().toString();
        if (StringUtils.isEmpty((String)billId)) {
            HttpSession session = request.getSession();
            String cmpGiveGridParam = session.getAttribute("cmpGiveGridParam").toString();
            HashMap<String, List> colModelMap = new HashMap<String, List>();
            HashMap<String, List> colNameMap = new HashMap<String, List>();
            Context ctx = SHRContext.getInstance().getContext();
            HashMap cmpGiveGridParamMap = JSONUtils.convertJsonToObject((Context)ctx, (String)cmpGiveGridParam);
            CmpWFPerDetailGridConfInfo perDetailGridConfInfo = new CmpWFPerDetailGridConfInfo();
            List colModel = (List)cmpGiveGridParamMap.get("colModel");
            colModelMap.put("colModel", colModel);
            List colNames = (List)cmpGiveGridParamMap.get("colNames");
            colNameMap.put("colNames", colNames);
            String sorterItems = cmpGiveGridParamMap.get("defaultSortname").toString();
            perDetailGridConfInfo.setColModel(JSONUtils.convertObjectToJson((Context)ctx, colModelMap));
            perDetailGridConfInfo.setColNames(JSONUtils.convertObjectToJson((Context)ctx, colNameMap));
            perDetailGridConfInfo.setSorterItems(sorterItems);
            billInfo.getPersonDetailGridConf().add(perDetailGridConfInfo);
            System.out.println("\u4fdd\u5b58\u524d\u53d1\u8d77\u6dfb\u52a0savePersonalDetailGridConfig:" + billInfo.toString());
        }
    }
}

