/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.service.job.wrapper.FunctionHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.EasThreadParamUtil;
import kd.isc.connector.eas.InvokeProxy;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.GetServiceInfo;
import kd.isc.connector.eas.e.ServiceInfo;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class CallService
extends AbstractCommandExecutor {
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        String service = D.s((Object)params.get("service"));
        if (!ctx.isValid(service, ConnectorContext.Operation.EXECUTE)) {
            throw EasSideError.OUT_OF_PERMISSION.create(new String[]{service});
        }
        ServiceInfo serviceInfo = new ServiceInfo(service);
        Context bos_context = this.createContext(ctx, params);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)bos_context);
        Map args = (Map)params.get("args");
        try {
            EasThreadParamUtil.setThreadCtx(bos_context);
            Object object = this.invokeMethod(loader, serviceInfo, bos_context, args);
            return object;
        }
        finally {
            EasThreadParamUtil.removeThreadCtx();
        }
    }

    private Object invokeMethod(IMetaDataLoader loader, ServiceInfo serviceInfo, Context ctx, Map<String, Object> args) {
        Object result;
        BusinessObjectInfo busInfo = loader.getBusinessObject((IMetaDataPK)serviceInfo.getMetaPK());
        MethodInfo method = GetServiceInfo.getMethod(busInfo, serviceInfo.getMethodName(), serviceInfo.getParamCount());
        Object[] values = this.convertParam(ctx, args, method);
        try {
            result = InvokeProxy.getProxy(ctx, (IMetaDataPK)serviceInfo.getMetaPK(), busInfo.getType()).callCmethod(method, values);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        return this.simplifyData(result);
    }

    private Context createContext(ConnectorContext ctx, Map<String, Object> params) {
        String proxy_user = D.s((Object)params.get("proxy_user"));
        Context bos_context = Util.generateBosCtx(ctx, proxy_user);
        return bos_context;
    }

    public Object simplifyData(Object result) {
        String json = JSON.toJSONString((Object)result);
        return Script.parseJson((String)json);
    }

    public Object[] convertParam(Context ctx, Map<String, Object> args, MethodInfo method) {
        ParameterCollection pc = method.getParameters();
        String metaDataRef = method.getMetaDataRef();
        Object[] values = new Object[pc.size()];
        int k = 0;
        while (k < values.length) {
            ParameterInfo p = pc.get(k);
            Object value = args.get(p.getName());
            String paramMetaRef = p.getMetaDataRef();
            if (paramMetaRef == null) {
                paramMetaRef = metaDataRef;
            }
            values[k] = this.cast(p.getDataType(), value, ctx, paramMetaRef);
            ++k;
        }
        return values;
    }

    private Object cast(String type, Object value, Context ctx, String paramMetaRef) {
        try {
            return this.innerCast(ctx, type, value, paramMetaRef);
        }
        catch (Exception e) {
            throw EasSideError.VALUE_ERROR.create((Throwable)e, new String[]{D.s((Object)value), type, e.getMessage()});
        }
    }

    private Object innerCast(Context ctx, String type, Object value, String paramMetaRef) throws BOSException {
        if (value == null) {
            return null;
        }
        if (type.equalsIgnoreCase("Integer")) {
            return D.i((Object)value);
        }
        if (type.equalsIgnoreCase("Float")) {
            return new Float(value.toString());
        }
        if (type.equalsIgnoreCase("Boolean")) {
            return D.x((Object)value);
        }
        if (type.equalsIgnoreCase("Long")) {
            return D.l((Object)value);
        }
        if (type.equalsIgnoreCase("Double")) {
            return new Double(value.toString());
        }
        if (type.equalsIgnoreCase("BOID") || type.equalsIgnoreCase("BOSUuid")) {
            return BOSUuid.read((String)D.s((Object)value));
        }
        if (type.equalsIgnoreCase("BigDecimal")) {
            return new BigDecimal(value.toString());
        }
        if (type.equalsIgnoreCase("ObjectPK")) {
            return FunctionHelper.createPKbyBoId((String)D.s((Object)value));
        }
        if (type.equalsIgnoreCase("ObjectValue")) {
            return this.handleObjectValue(ctx, value, paramMetaRef);
        }
        if (type.equalsIgnoreCase("ObjectCollection")) {
            return this.handleObjectCollection(ctx, value, paramMetaRef);
        }
        if (type.equalsIgnoreCase("Date") || type.equalsIgnoreCase("Time") || type.equalsIgnoreCase("TimeStamp")) {
            return D.t((Object)value);
        }
        if (type.equalsIgnoreCase("String")) {
            return D.s((Object)value);
        }
        if (type.equalsIgnoreCase("String[]")) {
            return this.handleStringArray(value);
        }
        if (value instanceof Map) {
            if ("java.util.Map".equals(type) || "Map".equals(type)) {
                return value;
            }
        } else if (value instanceof List) {
            if ("java.util.Set".equals(type)) {
                return new HashSet((List)value);
            }
            return (List)value;
        }
        throw new UnsupportedOperationException("TODO - " + type);
    }

    private Object handleObjectCollection(Context ctx, Object value, String metaRef) throws BOSException {
        if (value instanceof Collection) {
            ICoreBase fn = Util.createFinder(ctx, metaRef);
            CoreBaseCollection collection = fn.getCollection();
            Collection c = (Collection)value;
            for (Object o : c) {
                Object objectValue = this.handleObjectValue(ctx, o, metaRef);
                collection.addObject((IObjectValue)objectValue);
            }
            return collection;
        }
        throw new IscBizException("\u65b9\u6cd5\u53c2\u6570\u662fObjectColletion\u7c7b\u578b\uff0c\u4f46\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u662flist");
    }

    private Object handleObjectValue(Context ctx, Object value, String metaRef) throws BOSException {
        if (value instanceof Map) {
            Map data = (Map)value;
            return Util.constructInfo(ctx, metaRef, data, null);
        }
        if (value instanceof String) {
            return FunctionHelper.createObjectValueByBoId((String)D.s((Object)value), (Context)ctx);
        }
        throw new UnsupportedOperationException("ObjectValue\u7c7b\u578b\u53c2\u6570\u4e0d\u652f\u6301\u7684\u8d4b\u503c\u7c7b\u578b:" + value.getClass());
    }

    private Object handleStringArray(Object value) {
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            String[] array = new String[c.size()];
            int index = -1;
            for (Object v : c) {
                array[++index] = D.s(v);
            }
            return array;
        }
        return new String[]{D.s((Object)value)};
    }

    public String getCommand() {
        return "call_service";
    }
}

