/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt.i;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.AbstractSimpleDataType;
import kd.isc.iscb.util.except.IscBizException;

public class TimeType
extends AbstractSimpleDataType {
    @Override
    public Time narrow(Object value) {
        if (value == null) {
            return null;
        }
        return this.innerParse(value);
    }

    public String toString() {
        return "time";
    }

    private Time innerParse(Object value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Date) {
            return new Time(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Time((Long)value);
        }
        String s = value.toString().trim();
        if (s.length() == 0) {
            return null;
        }
        if (D.isLong(s)) {
            return new Time(Long.parseLong(s));
        }
        String format = D.getDateFormat(s);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return new Time(sdf.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new IscBizException(e);
        }
    }
}

