/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.helper;

import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CmpDisplayViewAnalyzing {
    public static List<FieldInfo> getAdjSalaryApplyListFields(Context ctx, String display) throws SHRWebException {
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK((Context)ctx, (String)display);
        if (uiViewInfo == null) {
            return null;
        }
        String content = uiViewInfo.getContent();
        List<FieldInfo> fields = null;
        try {
            fields = CmpDisplayViewAnalyzing.parseFieldByUIViewContent(content);
        }
        catch (DocumentException e) {
            throw new SHRWebException((Throwable)e);
        }
        return fields;
    }

    public static List<FieldInfo> parseFieldByUIViewContent(String content) throws DocumentException {
        List<FieldInfo> fields = new ArrayList<FieldInfo>();
        Document doc = DocumentHelper.parseText((String)content);
        Element root = doc.getRootElement();
        Element body = root.element("body");
        List elements = body.elements("field");
        if (elements == null || elements.size() == 0) {
            return fields;
        }
        fields = CmpDisplayViewAnalyzing.parseFields(elements);
        return fields;
    }

    public static List<FieldInfo> parseFields(List<Element> elements) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (Element element : elements) {
            FieldInfo field = new FieldInfo();
            field.setName(element.attributeValue("name"));
            field.setAlias(element.attributeValue("label"));
            field.setType(element.attributeValue("type"));
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("required", element.attributeValue("required"));
            attributes.put("frozen", element.attributeValue("frozen"));
            attributes.put("filter", element.attributeValue("filter"));
            field.setAttributes(attributes);
            fields.add(field);
        }
        return fields;
    }

    public static Map<String, Map<String, Boolean>> complementDefaultField(Context ctx, String display) throws SHRWebException {
        List<FieldInfo> listFields = CmpDisplayViewAnalyzing.getAdjSalaryApplyListFields(ctx, display);
        if (listFields == null) {
            return null;
        }
        LinkedHashMap<String, Map<String, Boolean>> attrMap = new LinkedHashMap<String, Map<String, Boolean>>();
        for (FieldInfo listField : listFields) {
            String type = listField.getType();
            Map attributes = listField.getAttributes();
            HashMap valueMap = Maps.newHashMap();
            if (type != null && type.equals("hidden")) {
                valueMap.put("hidden", Boolean.TRUE);
            }
            if ("true".equalsIgnoreCase((String)attributes.get("frozen"))) {
                valueMap.put("frozen", Boolean.TRUE);
            }
            if ("true".equalsIgnoreCase((String)attributes.get("required"))) {
                valueMap.put("required", Boolean.TRUE);
            }
            attrMap.put(listField.getName(), valueMap);
        }
        return attrMap;
    }
}

