/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.compensation.handler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WordVariableExtractor {
    public static void main(String[] args) {
        String filePath = "C:/Users/59279/Desktop/aa.docx";
        try {
            Set<String> variables = WordVariableExtractor.extractVariablesFromWord(filePath);
            System.out.println("\u627e\u5230\u7684\u53d8\u91cf:");
            for (String var : variables) {
                System.out.println(var);
            }
        }
        catch (IOException e) {
            System.err.println("\u5904\u7406\u6587\u6863\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public static Set<String> extractVariablesFromWord(String filePath) throws IOException {
        HashSet<String> variables = new HashSet<String>();
        try (FileInputStream fis = new FileInputStream(filePath);
             XWPFDocument document = new XWPFDocument((InputStream)fis);){
            for (XWPFTable table : document.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            WordVariableExtractor.extractVariablesFromText(paragraph.getText(), variables);
                        }
                    }
                }
            }
            for (XWPFParagraph paragraph : document.getParagraphs()) {
                WordVariableExtractor.extractVariablesFromText(paragraph.getText(), variables);
            }
        }
        return variables;
    }

    private static void extractVariablesFromText(String text, Set<String> variables) {
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String variable = matcher.group(1);
            variables.add(variable);
        }
    }
}

