/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.compensation.utils;

import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.compensation.util.columnModel.CmpColumnModels;
import com.kingdee.shr.compensation.web.handler.integrate.entry.BaseSubmitBillEntryGenerator;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;

public class TemplateUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> extractVariablesFromWord(String filePath) throws IOException {
        HashSet<String> variables = new HashSet<String>();
        FileInputStream fis = null;
        XWPFDocument document = null;
        try {
            fis = new FileInputStream(filePath);
            document = new XWPFDocument((InputStream)fis);
            for (XWPFTable table : document.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            TemplateUtil.extractVariablesFromText(paragraph.getText(), variables);
                        }
                    }
                }
            }
            for (XWPFParagraph paragraph : document.getParagraphs()) {
                TemplateUtil.extractVariablesFromText(paragraph.getText(), variables);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (document != null) {
                document.close();
            }
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> extractVariablesFromWord(byte[] file) throws IOException {
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        ByteArrayInputStream bis = null;
        XWPFDocument document = null;
        try {
            bis = new ByteArrayInputStream(file);
            document = new XWPFDocument((InputStream)bis);
            for (XWPFTable table : document.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            TemplateUtil.extractVariablesFromText(paragraph.getText(), variables);
                        }
                    }
                }
            }
            for (XWPFParagraph paragraph : document.getParagraphs()) {
                TemplateUtil.extractVariablesFromText(paragraph.getText(), variables);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (document != null) {
                document.close();
            }
        }
        return variables;
    }

    private static void extractVariablesFromText(String text, Set<String> variables) {
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String variable = matcher.group(1);
            variables.add(variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] processWordTemplate(byte[] file, Map<String, String> variables, List<Map<String, String>> tableData, List<Map<String, String>> approveList) throws IOException {
        ByteArrayInputStream bis = null;
        XWPFDocument document = null;
        try {
            byte[] byArray;
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream pdfBos;
            block16: {
                bis = new ByteArrayInputStream(file);
                document = new XWPFDocument((InputStream)bis);
                TemplateUtil.processTextboxes(document, variables);
                TemplateUtil.processParagraphs(document, variables);
                TemplateUtil.processHeadersAndFooters(document, variables);
                List tables = document.getTables();
                if (!tables.isEmpty()) {
                    if (tables.size() > 0) {
                        TemplateUtil.processTables((XWPFTable)tables.get(0), tableData);
                    }
                    if (tables.size() > 1) {
                        TemplateUtil.processApproveTables((XWPFTable)tables.get(1), approveList);
                    }
                }
                ByteArrayOutputStream bos = null;
                pdfBos = null;
                byteArrayInputStream = null;
                try {
                    bos = new ByteArrayOutputStream();
                    document.write((OutputStream)bos);
                    byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
                    pdfBos = new ByteArrayOutputStream();
                    Document doc = new Document();
                    doc.loadFromStream((InputStream)byteArrayInputStream, FileFormat.Doc);
                    doc.saveToStream((OutputStream)pdfBos, FileFormat.PDF);
                    byArray = pdfBos.toByteArray();
                    if (bos == null) break block16;
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        bos.close();
                    }
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    if (pdfBos != null) {
                        pdfBos.close();
                    }
                    throw throwable;
                }
                bos.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (pdfBos != null) {
                pdfBos.close();
            }
            return byArray;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (document != null) {
                document.close();
            }
        }
    }

    private static void processTextboxes(XWPFDocument document, Map<String, String> variables) {
        for (Object paragraph : document.getParagraphs()) {
            for (Object run : paragraph.getRuns()) {
                if (run.getEmbeddedPictures().size() <= 0 && run.getCTR().getDrawingList().size() <= 0) continue;
            }
        }
        List headers = document.getHeaderList();
        for (Object header : headers) {
            for (Object paragraph : header.getParagraphs()) {
                for (XWPFRun run : paragraph.getRuns()) {
                    if (run.getCTR().getDrawingList().size() <= 0) continue;
                }
            }
        }
        List footers = document.getFooterList();
        for (XWPFFooter footer : footers) {
            for (XWPFParagraph paragraph : footer.getParagraphs()) {
                for (XWPFRun run : paragraph.getRuns()) {
                    if (run.getCTR().getDrawingList().size() <= 0) continue;
                }
            }
        }
        try {
            XmlCursor cursor = document.getDocument().newCursor();
            cursor.toStartDoc();
            while (cursor.hasNextToken()) {
                CTR ctr;
                XmlObject obj;
                XmlCursor.TokenType token = cursor.toNextToken();
                if (!token.isStart() || !((obj = cursor.getObject()) instanceof CTR) || (ctr = (CTR)obj).getDrawingList().size() <= 0) continue;
                for (CTDrawing drawing : ctr.getDrawingList()) {
                    String replacedText;
                    String text;
                    XmlCursor drawingCursor = drawing.newCursor();
                    if ((drawingCursor.toChild("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "anchor") || drawingCursor.toChild("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "inline")) && drawingCursor.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", "txBox") && drawingCursor.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", "txBody") && drawingCursor.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", "p") && !(text = drawingCursor.getTextValue()).equals(replacedText = TemplateUtil.replaceVariables(text, variables))) {
                        drawingCursor.setTextValue(replacedText);
                    }
                    drawingCursor.dispose();
                }
            }
            cursor.dispose();
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u6587\u672c\u6846\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void processParagraphs(XWPFDocument document, Map<String, String> variables) {
        for (XWPFParagraph paragraph : document.getParagraphs()) {
            String replacedText;
            String text = paragraph.getText();
            if (text.equals(replacedText = TemplateUtil.replaceVariables(text, variables))) continue;
            for (int i = paragraph.getRuns().size() - 1; i >= 0; --i) {
                paragraph.removeRun(i);
            }
            XWPFRun run = paragraph.createRun();
            run.setText(replacedText);
        }
    }

    private static void processHeadersAndFooters(XWPFDocument document, Map<String, String> variables) {
        List headers = document.getHeaderList();
        for (XWPFHeader header : headers) {
            for (XWPFParagraph paragraph : header.getParagraphs()) {
                String replacedText;
                String text = paragraph.getText();
                if (text.equals(replacedText = TemplateUtil.replaceVariables(text, variables))) continue;
                for (int i = paragraph.getRuns().size() - 1; i >= 0; --i) {
                    paragraph.removeRun(i);
                }
                XWPFRun run = paragraph.createRun();
                run.setText(replacedText);
            }
        }
        List footers = document.getFooterList();
        for (XWPFFooter footer : footers) {
            for (XWPFParagraph paragraph : footer.getParagraphs()) {
                String replacedText;
                String text = paragraph.getText();
                if (text.equals(replacedText = TemplateUtil.replaceVariables(text, variables))) continue;
                for (int i = paragraph.getRuns().size() - 1; i >= 0; --i) {
                    paragraph.removeRun(i);
                }
                XWPFRun run = paragraph.createRun();
                run.setText(replacedText);
            }
        }
    }

    private static void processTables(XWPFTable table, List<Map<String, String>> tableData) {
        if (table.getNumberOfRows() >= 2) {
            XWPFTableRow templateRow = table.getRow(1);
            int num = 2;
            for (Map<String, String> rowData : tableData) {
                XWPFTableRow newRow = table.insertNewTableRow(2);
                for (int i = 0; i < templateRow.getTableCells().size(); ++i) {
                    XWPFTableCell templateCell = templateRow.getCell(i);
                    XWPFTableCell newCell = newRow.addNewTableCell();
                    for (int j = newCell.getParagraphs().size() - 1; j >= 0; --j) {
                        newCell.removeParagraph(j);
                    }
                    newCell.getCTTc().setTcPr(templateCell.getCTTc().getTcPr());
                    for (XWPFParagraph paragraph : templateCell.getParagraphs()) {
                        int fontSize;
                        XWPFParagraph newParagraph = newCell.addParagraph();
                        newParagraph.getCTP().setPPr(paragraph.getCTP().getPPr());
                        String text = paragraph.getText();
                        String replacedText = TemplateUtil.replaceVariables(text, rowData);
                        XWPFRun newRun = newParagraph.createRun();
                        newRun.setText(replacedText);
                        if (paragraph.getRuns().size() <= 0) continue;
                        XWPFRun templateRun = (XWPFRun)paragraph.getRuns().get(0);
                        newRun.setBold(templateRun.isBold());
                        newRun.setItalic(templateRun.isItalic());
                        String fontFamily = templateRun.getFontFamily();
                        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
                            newRun.setFontFamily(fontFamily);
                        }
                        if ((fontSize = templateRun.getFontSize()) > 0) {
                            newRun.setFontSize(fontSize);
                        }
                        newRun.setColor(templateRun.getColor());
                    }
                }
                ++num;
            }
            table.removeRow(1);
        }
    }

    private static void processApproveTables(XWPFTable table, List<Map<String, String>> tableData) {
        if (table.getNumberOfRows() >= 2) {
            XWPFTableRow templateRow = table.getRow(1);
            int num = 2;
            for (Map<String, String> rowData : tableData) {
                XWPFTableRow newRow = table.insertNewTableRow(2);
                for (int i = 0; i < templateRow.getTableCells().size(); ++i) {
                    XWPFTableCell templateCell = templateRow.getCell(i);
                    XWPFTableCell newCell = newRow.addNewTableCell();
                    for (int j = newCell.getParagraphs().size() - 1; j >= 0; --j) {
                        newCell.removeParagraph(j);
                    }
                    newCell.getCTTc().setTcPr(templateCell.getCTTc().getTcPr());
                    for (XWPFParagraph paragraph : templateCell.getParagraphs()) {
                        int fontSize;
                        XWPFParagraph newParagraph = newCell.addParagraph();
                        newParagraph.getCTP().setPPr(paragraph.getCTP().getPPr());
                        String text = paragraph.getText();
                        String replacedText = TemplateUtil.replaceVariables(text, rowData);
                        XWPFRun newRun = newParagraph.createRun();
                        newRun.setText(replacedText);
                        if (paragraph.getRuns().size() <= 0) continue;
                        XWPFRun templateRun = (XWPFRun)paragraph.getRuns().get(0);
                        newRun.setBold(templateRun.isBold());
                        newRun.setItalic(templateRun.isItalic());
                        String fontFamily = templateRun.getFontFamily();
                        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
                            newRun.setFontFamily(fontFamily);
                        }
                        if ((fontSize = templateRun.getFontSize()) > 0) {
                            newRun.setFontSize(fontSize);
                        }
                        newRun.setColor(templateRun.getColor());
                    }
                }
                ++num;
            }
            table.removeRow(1);
        }
    }

    private static String replaceVariables(String text, Map<String, String> variables) {
        if (text == null || variables == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String pattern = "\\$\\{" + entry.getKey() + "\\}";
            String value = entry.getValue() == null ? "" : entry.getValue();
            result = result.replaceAll(pattern, value);
        }
        return result;
    }

    public static CmpColumnModels getSubmitSchemeFields(Context ctx, String submitSchemeId) throws SHRWebException {
        boolean dynamicColmunRequired = true;
        HashMap params = Maps.newHashMap();
        params.put("datasource", 2);
        params.put("costTypeId", "");
        params.put("dynamicColmunRequired", dynamicColmunRequired);
        params.put("hrOrgUnitId", "");
        BaseSubmitBillEntryGenerator baseSubmitBillEntryGenerator = new BaseSubmitBillEntryGenerator();
        return baseSubmitBillEntryGenerator.getEntryColumnModels(ctx, submitSchemeId, (Map)params);
    }
}

