/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.affair.web.handler.hrman;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.affair.web.handler.hrman.EmpEnrollBizBillHrManEditHandler;
import com.kingdee.shr.affair.web.handler.util.EmployeeUtil;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;

public class EmpEnrollBizBillHrManEditHandlerEx
extends EmpEnrollBizBillHrManEditHandler {
    protected void beforeSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        super.beforeSave(request, response, model);
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        if (billInfo.getBillState() == null) {
            billInfo.setBillState(HRBillStateEnum.SAVED);
        }
        this.storefields(request, (CoreBaseInfo)billInfo);
    }

    private CoreBaseInfo storefields(HttpServletRequest request, CoreBaseInfo model) throws SHRWebException {
        EmpEnrollBizBillEntryInfo entryInfo;
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        if (billInfo.getId() == null) {
            billInfo.setIsMultiEntry(Boolean.TRUE.booleanValue());
        }
        if ((entryInfo = billInfo.getEntrys().get(0)).getPerson() != null && entryInfo.getPerson().getId() == null) {
            entryInfo.setPerson(null);
        }
        entryInfo.setBill(billInfo);
        EmpEnrollBizBillEntryCollection entryColl = null;
        if (!StringUtils.isEmpty((CharSequence)request.getParameter("multiEntryBillId"))) {
            try {
                String multiEntryBillId = URLDecoder.decode(request.getParameter("multiEntryBillId"), "utf-8");
                EmpEnrollBizBillInfo multiEntryBillInfo = EmpEnrollBizBillFactory.getRemoteInstance().getEmpEnrollBizBillInfo((IObjectPK)new ObjectUuidPK(multiEntryBillId));
                billInfo.setId(multiEntryBillInfo.getId());
                billInfo.setAdminOrg(multiEntryBillInfo.getAdminOrg());
                billInfo.setApplier(multiEntryBillInfo.getApplier());
                billInfo.setIsMulti(Boolean.TRUE.booleanValue());
                entryInfo.setBill(multiEntryBillInfo);
                String hrBizDefineId = multiEntryBillInfo.getString("hrBizDefine");
                Context ctx = SHRContext.getInstance().getContext();
                HRBizDefineInfo hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizDefineId));
                if (!"SHR02".equals(hrBizDefineInfo.getNumber())) {
                    EmployeeUtil employeeUtil = new EmployeeUtil();
                    int fnumber = employeeUtil.getFnumber();
                    entryInfo.setEmpNumber(String.valueOf(fnumber));
                }
                entryColl = multiEntryBillInfo.getEntrys();
                entryColl.add(entryInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new SHRWebException((Throwable)e);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new SHRWebException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new SHRWebException((Throwable)e);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            billInfo.setAdminOrg(entryInfo.getAdminOrg());
            billInfo.setIsMulti(Boolean.FALSE.booleanValue());
            entryColl = new EmpEnrollBizBillEntryCollection();
            entryColl.add(entryInfo);
        }
        try {
            HRUtilExtend.assableCell((CoreBaseInfo)entryInfo, (String)"telNum");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new SHRWebException(e.getMessage());
        }
        billInfo.getEntrys().clear();
        billInfo.getEntrys().addCollection(entryColl);
        return billInfo;
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        EmpEnrollBizBillEntryCollection coll = billInfo.getEntrys();
        try {
            EmployeeUtil employeeUtil = new EmployeeUtil();
            if (coll != null && coll.size() > 0) {
                int i = 0;
                int size = coll.size();
                while (i < size) {
                    EmpEnrollBizBillEntryInfo info = coll.get(i);
                    HRBizDefineInfo hrBizDefineInfo = info.getHrBizDefine();
                    System.out.print("\u5165\u804chrBizDefineInfo\uff1a" + hrBizDefineInfo.getNumber());
                    if (!"SHR02".equals(hrBizDefineInfo.getNumber())) {
                        String fid = billInfo.getString("id");
                        Boolean isUniqueCheck = employeeUtil.checkUserName(info.get("userName").toString(), fid, info.getEmpNumber());
                        if (!isUniqueCheck.booleanValue()) {
                            throw new ImportException("This user name \uff1a" + info.get("userName") + ",already exists");
                        }
                        Boolean emailCheck = employeeUtil.checkEmail(info.get("email").toString(), fid, info.getEmpNumber());
                        if (!emailCheck.booleanValue()) {
                            throw new ImportException("The user mailbox already exists. Procedure !");
                        }
                    }
                    ++i;
                }
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        super.verifyModel(request, response, model);
    }

    public void getEmpPreEntryDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        HashMap<String, String> map = new HashMap<String, String>();
        String preEntryId = request.getParameter("billId");
        String sql = " select b.fid as personTypeId , b.fname_l1 as personTypeName,  c.fid as wcategoryId , c.fname_l1 as wcategoryName,  d.fid as ftorptId , d.fname_l1 as ftorptName,  e.fid as lmanagerId , e.fname_l1 as lmanagerName,  f.fid as rmethodId , f.fname_l1 as rmethodName,  g.fid as jobsId , g.fname_l1 as jobsName,  h.fid as academictitleId , h.fname_l1 as academictitleName,  j.fname_l1 jobName, k.fname_l1 credentTypeName, l.fname_l1 countryName,  j.fid jobId, k.fid credentTypeId, l.fid countryId  from t_hr_preentry a  left join T_HR_EmployeeClassify b on a.CFPersontypeID = b.fid  left join CT_MP_WorkerCategory c on a.CFWcategoryID = c.fid  left join CT_MP_Fullorpart d on a.CFFtorptID = d.fid  left join t_bd_person e on a.CFLmanagerID = e.fid  left join CT_MP_Ratepayingmethod f on a.CFRmethodId = f.fid  left join CT_HR_Job2 g on a.cfjobsId = g.fid  left join CT_MP_AcademicTitle h on a.cfacademictitleId = h.fid  left join T_HR_JobGrade j on a.CFJOBGRADEID = j.fid  left join T_HR_CredentialsType k on a.CFDOCUMENTTYPEID = k.fid  left join T_HR_CountryRegion l on a.cfcountryregionid = l.fid  where a.fid = '" + preEntryId + "'";
        Context ctx = SHRContext.getInstance().getContext();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                map.put("personTypeId", rs.getString("personTypeId"));
                map.put("personTypeName", rs.getString("personTypeName"));
                map.put("wcategoryId", rs.getString("wcategoryId"));
                map.put("wcategoryName", rs.getString("wcategoryName"));
                map.put("ftorptId", rs.getString("ftorptId"));
                map.put("ftorptName", rs.getString("ftorptName"));
                map.put("lmanagerId", rs.getString("lmanagerId"));
                map.put("lmanagerName", rs.getString("lmanagerName"));
                map.put("rmethodId", rs.getString("rmethodId"));
                map.put("rmethodName", rs.getString("rmethodName"));
                map.put("jobsId", rs.getString("jobsId"));
                map.put("jobsName", rs.getString("jobsName"));
                map.put("academictitleId", rs.getString("academictitleId"));
                map.put("academictitleName", rs.getString("academictitleName"));
                map.put("jobName", rs.getString("jobName"));
                map.put("credentTypeName", rs.getString("credentTypeName"));
                map.put("countryName", rs.getString("countryName"));
                map.put("jobId", rs.getString("jobId"));
                map.put("credentTypeId", rs.getString("credentTypeId"));
                map.put("countryId", rs.getString("countryId"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONUtils.writeJson((HttpServletResponse)response, map);
    }

    public void getEmpNumberAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        EmployeeUtil employeeUtil = new EmployeeUtil();
        int fnumber = employeeUtil.getFnumber();
        map.put("empNumber", fnumber);
        JSONUtils.writeJson((HttpServletResponse)response, map);
    }

    public String getPersonNameAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String idEnitiy = request.getParameter("idEntity");
        String sql = "select cfsurname,cfmiddlenames,cfgivenname,cflocalname,cfusername from T_BD_Person where fpassportno = '" + idEnitiy + "' or fidcardno = '" + idEnitiy + "' order by flastupdatetime desc";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                modelMap.put((Object)"surName", (Object)rs.getString("cfsurname"));
                modelMap.put((Object)"middleName", (Object)rs.getString("cfmiddlenames"));
                modelMap.put((Object)"givenName", (Object)rs.getString("cfgivenname"));
                modelMap.put((Object)"localName", (Object)rs.getString("cflocalname"));
                modelMap.put((Object)"userName", (Object)rs.getString("cfusername"));
                JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
                return null;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"surName", (Object)"");
        modelMap.put((Object)"middleName", (Object)"");
        modelMap.put((Object)"givenName", (Object)"");
        modelMap.put((Object)"localName", (Object)"");
        modelMap.put((Object)"userName", (Object)"");
        return null;
    }
}

