/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.io.AbstractInputStream;

public class RemoteInputStream
extends AbstractInputStream {
    private RemoteContext ctx;
    private Map<String, Object> fileInfo;
    private byte[] data;
    private boolean hasMore;
    private int pos;
    private int count;
    private Map<String, Object> result;
    private boolean isError = false;

    public RemoteInputStream(RemoteContext ctx, Map<String, Object> fileInfo) {
        this.ctx = ctx;
        this.fileInfo = fileInfo;
        this.result = this.retrievePartialContent();
        String dataStr = D.s(this.result.get("data"));
        this.data = dataStr != null ? Hex.decode(dataStr) : null;
        this.count = D.i(this.result.get("length"));
        this.hasMore = D.x(this.result.get("$has_more"));
    }

    @Override
    public int read() {
        return this.readByte();
    }

    @Override
    public void close() throws IOException {
        if (this.isError && this.hasMore) {
            this.ctx.removeResult(this.result);
        }
    }

    private int readByte() {
        if (this.data != null) {
            return this.innerReadByte();
        }
        if (!this.hasMore) {
            return -1;
        }
        this.loadNextChunk();
        return this.readByte();
    }

    private int innerReadByte() {
        if (this.pos < this.count) {
            return this.data[this.pos++] & 0xFF;
        }
        this.data = null;
        return this.readByte();
    }

    private void loadNextChunk() {
        try {
            this.result = (Map)this.ctx.loadResult(this.result);
            this.hasMore = D.x(this.result.get("$has_more"));
            String dataStr = D.s(this.result.get("data"));
            this.data = dataStr != null ? Hex.decode(dataStr) : null;
            this.count = D.i(this.result.get("length"));
            this.pos = 0;
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    private Map<String, Object> retrievePartialContent() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "retrieve_attachment");
        params.put("fileInfo", this.fileInfo);
        return (Map)this.ctx.invoke(params);
    }

    @Override
    public void markError() {
        this.isError = true;
    }
}

