/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.composite;

import java.util.List;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.DebuggerBreakpoint;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.plugin.SubFlowLoader;

public class CallSubFlow
extends Command
implements DebuggerBreakpoint {
    private SubFlowLoader loader;
    private VariableImpl[] params;
    private VariableImpl[] returns;

    public CallSubFlow(SubFlowLoader loader, VariableImpl[] params, VariableImpl[] returns) {
        super(5000000);
        this.loader = loader;
        this.returns = (VariableImpl[])returns.clone();
        this.params = (VariableImpl[])params.clone();
    }

    public SubFlowLoader getLoader() {
        return this.loader;
    }

    @Override
    public int invoke(ExecutionImpl e) {
        FlowImpl subFlow = this.checkSubFlow(e);
        List<VariableImpl> formalParams = this.checkParams(subFlow);
        int[] input_a = new int[this.params.length];
        Object[] input_v = new Object[this.params.length];
        this.prepareParams(e, formalParams, input_a, input_v);
        DataAreaImpl mem = new DataAreaImpl(e, subFlow, input_a, input_v);
        ExecutionImpl sub = new ExecutionImpl(e, subFlow.getRoot(), mem);
        e.getRuntime().push(sub);
        return 1;
    }

    private void prepareParams(ExecutionImpl e, List<VariableImpl> formalParams, int[] input_a, Object[] input_v) {
        int i = 0;
        while (i < this.params.length) {
            VariableImpl var = formalParams.get(i);
            input_a[i] = var.getAddress();
            input_v[i] = var.getType().narrow(e.get(this.params[i]));
            ++i;
        }
    }

    private List<VariableImpl> checkParams(FlowImpl subFlow) {
        List<VariableImpl> formalParams = subFlow.getInputVariables();
        if (formalParams.size() != this.params.length) {
            throw new IscBizException("Input parameters dismatched!");
        }
        return formalParams;
    }

    private FlowImpl checkSubFlow(ExecutionImpl e) {
        FlowImpl subFlow = (FlowImpl)this.loader.getFlow(e);
        if (subFlow.getOutputVariables().size() != this.returns.length) {
            throw new IscBizException("Output parameters dismatched!");
        }
        return subFlow;
    }
}

