/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.Storer;
import kd.isc.iscb.util.script.feature.control.loop.RangeConstructor;
import kd.isc.iscb.util.script.misc.Consts;
import kd.isc.iscb.util.script.parser.Program;
import kd.isc.iscb.util.script.statement.Invocation;

public final class ListConstructor
implements Evaluator,
Storer {
    public static final ListConstructor EMPTY_LIST = new ListConstructor(Consts.EMPTY_OBJ_ARRAY);
    private Object[] values;

    public ListConstructor(Object[] values) {
        this.values = values;
    }

    @Override
    public Object eval(ScriptContext ctx) {
        ArrayList<Object> list = new ArrayList<Object>(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            Object value = Util.eval(ctx, this.values[i]);
            list.add(value);
            ++i;
        }
        return list;
    }

    public int length() {
        return this.values.length;
    }

    public Object get(int index) {
        return this.values[index];
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    static Object create(Statement smt) {
        Object[] values = smt.getElements();
        if (values.length == 0) {
            return EMPTY_LIST;
        }
        if (values.length > 1) {
            throw new IllegalArgumentException("Length is more than 1.");
        }
        if (values[0] instanceof RangeConstructor.RangeBuilder) {
            return values[0];
        }
        if (!(values[0] instanceof Statement)) {
            return new ListConstructor(values);
        }
        Statement smt2 = (Statement)values[0];
        if (smt2 instanceof Invocation && smt2.length() > 1 && smt2.get(0) instanceof Operator) {
            return new ListConstructor(values);
        }
        return new ListConstructor(smt2.getElements());
    }

    @Override
    public Object set(ScriptContext ctx, Object value) {
        if (value == null) {
            this.setNull(ctx, 0);
        } else if (value instanceof Collection) {
            this.setFromCollection(ctx, value);
        } else if (value.getClass().isArray()) {
            this.setFromArray(ctx, value);
        } else if (value instanceof Map) {
            this.setFromMap(ctx, (Map)value);
        } else if (value instanceof Context) {
            this.setFromContext(ctx, (Context)value);
        } else if (this.values.length == 1) {
            ((Storer)this.values[0]).set(ctx, value);
        } else {
            throw new IscBizException("'" + value.getClass().getName() + "' doesn't support multi-assign!");
        }
        return value;
    }

    private void setFromContext(ScriptContext ctx, Context context) {
        int i = 0;
        while (i < this.values.length) {
            Storer storer = (Storer)this.values[i];
            storer.set(ctx, context.get(storer.toString()));
            ++i;
        }
    }

    private void setFromMap(ScriptContext ctx, Map<?, ?> map) {
        int i = 0;
        while (i < this.values.length) {
            Storer storer = (Storer)this.values[i];
            storer.set(ctx, map.get(storer.toString()));
            ++i;
        }
    }

    private void setFromArray(ScriptContext ctx, Object value) {
        int i = 0;
        while (i < Array.getLength(value) && i < this.values.length) {
            Object el = Array.get(value, i);
            ((Storer)this.values[i]).set(ctx, el);
            ++i;
        }
        this.setNull(ctx, i);
    }

    private void setFromCollection(ScriptContext ctx, Object value) {
        int i = 0;
        for (Object el : (Collection)value) {
            if (i < this.values.length) {
                ((Storer)this.values[i]).set(ctx, el);
            }
            ++i;
        }
        this.setNull(ctx, i);
    }

    private void setNull(ScriptContext ctx, int start) {
        int i = start;
        while (i < this.values.length) {
            ((Storer)this.values[i]).set(ctx, null);
            ++i;
        }
    }

    public boolean isPredicate() {
        if (this.values.length != 1) {
            return false;
        }
        return Program.isPredicate(this.values[0]);
    }
}

