/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.thirdInvoke;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.thirdInvoke.ApprovalRecordInfo;
import com.kingdee.bos.workflow.thirdInvoke.ApproveInfo;
import com.kingdee.bos.workflow.thirdInvoke.DecisionInfo;
import com.kingdee.bos.workflow.thirdInvoke.OperationRecordInfo;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.ManualDecisionInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class WfInvokeTool {
    public static MultiApproveInfo generateApproveInfo(Context ctx, ApproveInfo approveInfo) throws Exception {
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(approveInfo.getAssignId());
        String billId = WfInvokeTool.getBizObjIdByAssignId(ctx, approveInfo.getAssignId());
        info.setBillId(BOSUuid.read((String)billId));
        info.setExtendedProperty("businuessObjectId", billId);
        info.setExtendedProperty("assignmentID", approveInfo.getAssignId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        info.setOpinion(approveInfo.getApproveContent(), new Locale("L1"));
        info.setOpinion(approveInfo.getApproveContent(), new Locale("L2"));
        info.setOpinion(approveInfo.getApproveContent(), new Locale("L3"));
        info.setIsPass(ApproveResult.getEnum((String)String.valueOf(approveInfo.isApprovePass())));
        info.setHandlerOpinion(approveInfo.getApproveOption());
        info.setHandlerContent(approveInfo.getApproveOptionContent());
        info.setInputType(InputType.OTHER);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        return info;
    }

    public static ManualDecisionInfo generateManualDecision(DecisionInfo decisionInfo) {
        ManualDecisionInfo info = new ManualDecisionInfo();
        info.setId(BOSUuid.create((String)"C7CEA331"));
        info.setSelectedOpinions(decisionInfo.getOpinionNumber());
        info.setSelectedItems(decisionInfo.getOpinionString());
        return info;
    }

    private static String getBizObjIdByAssignId(Context ctx, String assignId) throws Exception {
        String sql = "select fbizobjid from t_wfr_assign where fassignid=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignId});
        if (rowSet.next()) {
            String id = rowSet.getString("fbizobjid");
            return id;
        }
        throw new BOSException("\u5f53\u524d\u5f85\u529e\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5904\u7406");
    }

    public static String approvalRecord(HashSet<String> procInstIdSet) {
        return null;
    }

    public static HashSet<String> findParentAndChild(Context ctx, String procInstId) throws Exception {
        String procinstId;
        Object[] params;
        IRowSet rowSet;
        String parentId;
        Object[] params2;
        IRowSet rowSet2;
        HashSet<String> set = new HashSet<String>();
        set.add(procInstId);
        String sqlParent = "select fparentprocinstid from t_wfr_procinst where fprocinstid=?";
        String copyProcinstId = procInstId;
        while ((rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sqlParent, (Object[])(params2 = new Object[]{copyProcinstId}))).next() && !StringUtils.isEmpty((String)(parentId = rowSet2.getString("fparentprocinstid")))) {
            copyProcinstId = parentId;
            set.add(parentId);
        }
        String sqlChild = "select fprocinstid from t_wfr_procinst where fparentprocinstid=?";
        copyProcinstId = procInstId;
        while ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlChild, (Object[])(params = new Object[]{copyProcinstId}))).next() && !StringUtils.isEmpty((String)(procinstId = rowSet.getString("fprocinstid")))) {
            copyProcinstId = procinstId;
            set.add(procinstId);
        }
        return set;
    }

    public static List<ApprovalRecordInfo> getApprovalRecord(Context ctx, HashSet<String> ProcInstIdSet) throws Exception {
        ArrayList<ApprovalRecordInfo> list = new ArrayList<ApprovalRecordInfo>();
        String language = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        StringBuffer procinstids = new StringBuffer();
        for (String o : ProcInstIdSet) {
            if (procinstids.length() > 0) {
                procinstids.append(",");
            }
            procinstids.append("'").append((Object)o).append("'");
        }
        String sql = "SELECT o.fid,o.fopinion_" + language + ",o.FRESULT,u.FNAME_" + language + " ,a.FACTDEFNAME_" + language + ",o.FCREATETIME ,m.FISPASS FROM T_bas_option o LEFT OUTER JOIN t_pm_user u on o.FCREATORID  = u.FID LEFT OUTER JOIN t_wfr_actinstview a on o.FCurrentAcinstID= a.FACTINSTID left join t_bas_multiapprove m on m.FASSIGNMENTID = o.FASSIGNMENTID where o.FTYPE =9 and o.FPROCINSTID in(" + procinstids + ") order by o.FCREATETIME desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            ApprovalRecordInfo info = new ApprovalRecordInfo();
            info.setId(rowSet.getString(1));
            info.setApproveOpinion(rowSet.getString(2));
            String temp = rowSet.getString(3);
            info.setApproveResult(temp.substring(0, temp.indexOf(",")));
            info.setApproveDecisionItem(temp.substring(temp.indexOf(",") + 1));
            info.setApprover(rowSet.getString(4));
            info.setActivityNode(rowSet.getString(5));
            info.setApproveTime(rowSet.getDate(6));
            info.setPass("true".equals(rowSet.getString(7)));
            list.add(info);
        }
        return list;
    }

    public static List<OperationRecordInfo> getOperationRecord(Context ctx, HashSet<String> ProcInstIdSet) throws Exception {
        ArrayList<OperationRecordInfo> list = new ArrayList<OperationRecordInfo>();
        StringBuffer procinstids = new StringBuffer();
        Locale locale = ctx.getLocale();
        String language = LocaleUtils.getShortCode((Locale)locale);
        for (String o : ProcInstIdSet) {
            if (procinstids.length() > 0) {
                procinstids.append(",");
            }
            procinstids.append("'").append((Object)o).append("'");
        }
        String sql = "SELECT o.fid,o.fopinion_" + language + ",o.FRESULT,u.FNAME_" + language + " ,a.FACTDEFNAME_" + language + ",o.FCREATETIME,o.ftype FROM T_bas_option o LEFT OUTER JOIN t_pm_user u on o.FCREATORID  = u.FID LEFT OUTER JOIN t_wfr_actinstview a on o.FCurrentAcinstID= a.FACTINSTID where o.FPROCINSTID in(" + procinstids + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            OperationRecordInfo info = new OperationRecordInfo();
            info.setId(rowSet.getString(1));
            info.setOperatorOpinion(rowSet.getString(2));
            info.setOperatorResult(rowSet.getString(3));
            info.setOperator(rowSet.getString(4));
            info.setActivityNode(rowSet.getString(5));
            info.setOperatorTime(rowSet.getDate(6));
            int type = rowSet.getInt(7);
            info.setType(type);
            info.setAction(type, locale);
            list.add(info);
        }
        return list;
    }

    public static HashSet<String> getHistoryProcSet(Context ctx, String Id, HashSet<String> curProcInstIdSet) throws BOSException, WfException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] allProcInst = svc.getAllProcessInstancesByBizobjId(Id);
        HashSet<String> historyProcInstSet = new HashSet<String>();
        for (ProcessInstInfo p : allProcInst) {
            String procInstId = p.getProcInstId();
            if (curProcInstIdSet.contains(procInstId)) continue;
            historyProcInstSet.add(procInstId);
        }
        return historyProcInstSet;
    }
}

