/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.customer.gtiit.osf.util.DateUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtiitOrgPositionService
implements IHRMsfService {
    private static final Logger logger = LoggerFactory.getLogger(GtiitOrgPositionService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String sql = "SELECT\r\n\top.FID ID,\r\n\top.fnumber POSITION_CODE,\r\n\top.FNAME_L1 POSITION_NAME_EN,\r\n\top.FNAME_L2 POSITION_NAME_CN,\r\n\top.feffdt EFFECTIVE_START_DATE,\r\n\top.fleffdt EFFECTIVE_END_DATE,\r\n\tob.FNUMBER ORGANIZATION_CODE,\r\n\tob.FNAME_L1 ORGANIZATION_CODE_NAME,\r\n\toj.FNUMBER JOB_CODE,\r\n\toj.FNAME_L1 JOB_NAME_EN,\r\nCASE\r\n\t\t\r\n\t\tWHEN op.FDELETEDSTATUS= '1' THEN\r\n\t\t'\u662f' \r\n\t\tWHEN op.FDELETEDSTATUS= '2' THEN\r\n\t\t'\u5426' \r\n\tEND ACTIVE_STATUS,\r\nCASE\r\n\t\r\n\tWHEN op.FISRESPPOSITION= '0' THEN\r\n\t'\u5426' \r\n\tWHEN op.FISRESPPOSITION= '1' THEN\r\n\t'\u662f' \r\n\tEND DEPARTMENT_HEAD,\r\n\top.FCREATETIME ERP_CREATION_DATE,\r\n\top.FLASTUPDATETIME ERP_LAST_UPDATE_DATE \r\nFROM\r\n\tT_ORG_Position op\r\n\tLEFT JOIN T_ORG_BaseUnit ob ON op.FADMINORGUNITID = ob.FID\r\n\tLEFT JOIN T_ORG_Job oj ON oj.FID = op.FJOBID ";
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startDate = DateUtils.formatDate(startDate, true);
            endDate = DateUtils.formatDate(endDate, false);
            sql = String.valueOf(sql) + " where op.FLASTUPDATETIME >= '" + startDate + "' and op.FLASTUPDATETIME <= '" + endDate + "'";
        }
        List<String> fieldList = this.initMappingField();
        logger.info("GtiitOrgPositionService->excute->sql->" + sql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        List<Map<String, String>> dataList = this.getRsListData(fieldList, rs);
        return dataList;
    }

    private List<String> initMappingField() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("POSITION_CODE");
        list.add("POSITION_NAME_EN");
        list.add("POSITION_NAME_CN");
        list.add("EFFECTIVE_START_DATE");
        list.add("EFFECTIVE_END_DATE");
        list.add("ORGANIZATION_CODE");
        list.add("ORGANIZATION_CODE_NAME");
        list.add("JOB_CODE");
        list.add("JOB_NAME_EN");
        list.add("ACTIVE_STATUS");
        list.add("DEPARTMENT_HEAD");
        list.add("ERP_CREATION_DATE");
        list.add("ERP_LAST_UPDATE_DATE");
        return list;
    }

    private List<Map<String, String>> getRsListData(List<String> fieldList, IRowSet rs) throws BOSException {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        try {
            while (rs.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                int i = 0;
                int size = fieldList.size();
                while (i < size) {
                    String field = fieldList.get(i);
                    if ("ACTIVE_STATUS".equals(field) || "DEPARTMENT_HEAD".equals(field)) {
                        dataMap.put(field, "1".equals(rs.getString(field)) ? "\u662f" : "\u5426");
                    } else {
                        dataMap.put(field, rs.getString(field));
                    }
                    ++i;
                }
                dataList.add(dataMap);
            }
            return dataList;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }
}

