/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.facade.plurality;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.facade.plurality.AbstractPluralitySubFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.IPluralityAddBizBill;
import com.kingdee.eas.hr.affair.IPluralityDelBizBill;
import com.kingdee.eas.hr.affair.PluralityAddBizBillEntryCollection;
import com.kingdee.eas.hr.affair.PluralityAddBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PluralityAddBizBillFactory;
import com.kingdee.eas.hr.affair.PluralityAddBizBillInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryCollection;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillFactory;
import com.kingdee.eas.hr.affair.PluralityDelBizBillInfo;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PluralitySubFacadeControllerBean
extends AbstractPluralitySubFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.facade.plurality.PluralitySubFacadeControllerBean");

    @Override
    protected void _autoPluralitEnd(Context ctx, String personId, String curdate, int offset) throws BOSException, EASBizException {
        super._autoPluralitEnd(ctx, personId, curdate, offset);
        AffairActionReasonInfo reasonInfo = AffairActionReasonFactory.getLocalInstance((Context)ctx).getAffairActionReasonInfo(" where number = '0211' ");
        HRBizDefineInfo defineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo(" where number = 'SHR19' ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reasonInfo", reasonInfo);
        params.put("defineInfo", defineInfo);
        try {
            Date bizDate = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            if (StringUtils.isNotBlank((CharSequence)curdate)) {
                bizDate = DateTimeUtils.parseDate((String)curdate, (String)"yyyy-MM-dd");
            }
            Date startDate = bizDate;
            Date endDate = DateTimeUtils.addDay((Date)bizDate, (long)1L);
            if (offset > 0) {
                endDate = DateTimeUtils.addDay((Date)endDate, (long)offset);
            } else if (offset < 0) {
                startDate = DateTimeUtils.addDay((Date)startDate, (long)offset);
            }
            StringBuilder sbu = new StringBuilder();
            sbu.append(" select  bill.fid billId   from T_HR_PluralityAddBizBill bill ");
            sbu.append(" left join  T_HR_PluralityAddBizBillEntry entry on bill.FEntryId = entry.fbillid ");
            sbu.append(" where  bill.fbillstate = '3'  ");
            sbu.append(" and  entry.fenddate >= '" + startDate + "' ");
            sbu.append(" and  entry.fenddate < '" + endDate + "' ");
            if (StringUtils.isNotBlank((CharSequence)personId)) {
                sbu.append(" and  entry.fpersonid = " + personId);
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbu.toString());
            while (rowSet.next()) {
                String billId = rowSet.getString("billId");
                this.newDelBill(ctx, billId, params);
            }
        }
        catch (SQLException | ParseException e) {
            e.printStackTrace();
        }
    }

    private void newDelBill(Context ctx, String billId, HashMap<String, Object> params) throws BOSException, EASBizException {
        IPluralityAddBizBill addIns = PluralityAddBizBillFactory.getLocalInstance((Context)ctx);
        PluralityAddBizBillInfo addInfo = addIns.getPluralityAddBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        CoreBaseCollection delCol = new CoreBaseCollection();
        PluralityDelBizBillInfo delInfo = new PluralityDelBizBillInfo();
        delInfo.setHrOrgUnit(addInfo.getHrOrgUnit());
        delInfo.setBizDate(new Date());
        delInfo.setCU(addInfo.getCU());
        delInfo.setApplier(addInfo.getApplier());
        PluralityAddBizBillEntryCollection addEntrys = addInfo.getEntrys();
        PluralityDelBizBillEntryCollection addEntryData = this.addEntryData(addEntrys, params);
        delInfo.put("entrys", (Object)addEntryData);
        delInfo.setApplyDate(new Date());
        delInfo.setBizDate(new Date());
        delInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        delInfo.setHrOrgUnit(addInfo.getHrOrgUnit());
        delInfo.setIsMulti(addInfo.isIsMulti());
        delInfo.setUseDefault(addInfo.isUseDefault());
        delInfo.setIsMultiEntry(addInfo.isIsMultiEntry());
        delInfo.setBillState(HRBillStateEnum.SAVED);
        delInfo.setApproveType(ApproveTypeEnum.DIRECT);
        IPluralityDelBizBill delIns = PluralityDelBizBillFactory.getLocalInstance((Context)ctx);
        delIns.addnew((HRAffairBizBillInfo)delInfo);
        delInfo.setBillState(HRBillStateEnum.AUDITED);
        delIns.submitEffect((CoreBaseInfo)delInfo);
        logger.error((Object)"\u517c\u804c\u5355\u5ba1\u6838\u5b8c");
    }

    private PluralityDelBizBillEntryCollection addEntryData(PluralityAddBizBillEntryCollection addEntrys, HashMap<String, Object> params) {
        PluralityDelBizBillEntryCollection delEntryCol = new PluralityDelBizBillEntryCollection();
        int i = 0;
        while (i < addEntrys.size()) {
            PluralityAddBizBillEntryInfo addEntryInfo = addEntrys.get(i);
            PluralityDelBizBillEntryInfo delEntryInfo = new PluralityDelBizBillEntryInfo();
            delEntryInfo.setPerson(addEntryInfo.getPerson());
            delEntryInfo.setDescription("\u81ea\u52a8\u7ec8\u6b62");
            delEntryInfo.setAffairActionReason((AffairActionReasonInfo)params.get("reasonInfo"));
            delEntryInfo.setHrBizDefine((HRBizDefineInfo)params.get("defineInfo"));
            delEntryInfo.setDefaultLocale(addEntryInfo.getDefaultLocale());
            delEntryInfo.setHrOrgUnit(addEntryInfo.getHrOrgUnit());
            delEntryInfo.setOldEmpType(addEntryInfo.getEmpType());
            delEntryInfo.setOldAdminOrg(addEntryInfo.getAdminOrg());
            delEntryInfo.setOldPosition(addEntryInfo.getPosition());
            delEntryInfo.setOldCompany(addEntryInfo.getCompany());
            delEntryInfo.setEmpType(addEntryInfo.getOldEmpType());
            delEntryInfo.setMainPosition(addEntryInfo.getOldPosition());
            delEntryInfo.setMainAdminOrg(addEntryInfo.getOldAdminOrg());
            delEntryInfo.setMainDepartment(addEntryInfo.getOldAdminOrg());
            delEntryInfo.setMainCompany(addEntryInfo.getOldCompany());
            delEntryInfo.setBeginDate(addEntryInfo.getBizDate());
            delEntryInfo.setEmployerUnit(addEntryInfo.getEmployerUnit());
            delEntryInfo.put("pthwage", addEntryInfo.get("pthwage"));
            delEntryInfo.put("ptlmanager", addEntryInfo.get("ptlmanager"));
            if (params.containsKey("endDate")) {
                try {
                    Date endDate = DateTimeUtils.parseDate((String)params.get("endDate").toString(), (String)"yyyy-MM-dd");
                    delEntryInfo.setBizDate(endDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                delEntryInfo.setBizDate(addEntryInfo.getEndDate());
            }
            delEntryCol.add(delEntryInfo);
            ++i;
        }
        return delEntryCol;
    }

    @Override
    protected void _resignCreateEnd(Context ctx, String personId, String endDate) throws BOSException, EASBizException {
        super._resignCreateEnd(ctx, personId, endDate);
        if (StringUtils.isBlank((CharSequence)endDate)) {
            endDate = DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        }
        AffairActionReasonInfo reasonInfo = AffairActionReasonFactory.getLocalInstance((Context)ctx).getAffairActionReasonInfo(" where number = '0211' ");
        HRBizDefineInfo defineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo(" where number = 'SHR19' ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reasonInfo", reasonInfo);
        params.put("defineInfo", defineInfo);
        params.put("isResign", true);
        params.put("endDate", endDate);
        StringBuilder sbu = new StringBuilder();
        sbu.append(" select  bill.fid billId  , delen.fid  delId from T_HR_PluralityAddBizBill bill ");
        sbu.append(" left join  T_HR_PluralityAddBizBillEntry entry on bill.FId = entry.fbillid ");
        sbu.append(" left join T_HR_PluralityDelBizBillEntry  delen   ");
        sbu.append(" on  entry.fpersonid = delen.fpersonid   ");
        sbu.append(" and  entry.FBizDate = delen.FBeginDate  ");
        sbu.append(" and  entry.fpositionid = delen.FOldPositionID  ");
        sbu.append(" and   (   ");
        sbu.append(" entry.cfpthwage = delen.cfpthwage   ");
        sbu.append(" OR  ( entry.cfpthwage IS NULL AND delen.cfpthwage IS NULL  ) ");
        sbu.append("  )   ");
        sbu.append(" and   (   ");
        sbu.append(" entry.cfptlmanagerid = delen.cfptlmanagerid   ");
        sbu.append(" OR  ( entry.cfptlmanagerid IS NULL AND delen.cfptlmanagerid IS NULL  ) ");
        sbu.append("  )   ");
        sbu.append(" where  bill.fbillstate = '3'  ");
        sbu.append(" and  entry.fpersonid = '" + personId + "'");
        sbu.append(" and  ( entry.fenddate >= {" + endDate + "}  or entry.fenddate is null ) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbu.toString());
        try {
            while (rowSet.next()) {
                String billId = rowSet.getString("billId");
                String delId = rowSet.getString("delId");
                if (!StringUtils.isBlank((CharSequence)delId)) continue;
                this.newDelBill(ctx, billId, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

