/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Util {
    public static final NativeFunction DEFAULT_VALUE_GETTER = new NativeFunction(){

        @Override
        public String name() {
            return "self";
        }

        @Override
        public Object call(ScriptContext ctx, Object[] args) {
            return args[0];
        }
    };
    public static final NativeFunction TRUE = new NativeFunction(){

        @Override
        public String name() {
            return "true";
        }

        @Override
        public Object call(ScriptContext ctx, Object[] args) {
            return Boolean.TRUE;
        }
    };

    public static Object[] exludeNulls(Object[] args) {
        int nullCount = 0;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            if (a == null) {
                ++nullCount;
            }
            ++n2;
        }
        if (nullCount == 0) {
            return args;
        }
        Object[] array = new Object[args.length - nullCount];
        int i = 0;
        int j = 0;
        while (i < args.length) {
            Object a = args[i];
            if (a != null) {
                array[j] = a;
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static Iterator<?> getIterator(Object values) {
        if (values == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (values instanceof Collection) {
            return ((Collection)values).iterator();
        }
        if (values.getClass().isArray()) {
            return Util.createIterator4Array(values);
        }
        if (values instanceof Map) {
            return ((Map)values).entrySet().iterator();
        }
        throw new UnsupportedOperationException(values + " is not iteratable!");
    }

    static Iterator<?> createIterator4Array(final Object values) {
        return new Iterator<Object>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return Array.getLength(values) > this.index;
            }

            @Override
            public Object next() {
                int i = this.index++;
                return Array.get(values, i);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ResManager.loadKDString("\u6570\u7ec4\u6210\u5458\u4e0d\u53ef\u79fb\u9664\u3002\u6ce8\u610f\uff1a\u672c\u65b9\u6cd5\u539f\u6765\u7684\u5b9e\u73b0\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u65b9\u6cd5\u79fb\u9664\u6570\u7ec4\u6210\u5458\u3002", "Util_4", "isc-iscb-util", new Object[0]));
            }
        };
    }

    static ArrayList<Object> constructValueCollection(ScriptContext ctx, Object[] args, NativeFunction keyGetter, HashSet<Object> keySet, boolean expected) {
        NativeFunction valueGetter = Util.getValueGetter(args, 3);
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] params = new Object[1];
        Iterator<?> it = Util.getIterator(args[0]);
        while (it.hasNext()) {
            params[0] = it.next();
            Object key = keyGetter.call(ctx, params);
            if (keySet.contains(key) != expected) continue;
            result.add(valueGetter.call(ctx, params));
        }
        return result;
    }

    static HashSet<Object> constructKeySet(ScriptContext ctx, Object[] args, NativeFunction keyGetter) {
        Object[] params = new Object[1];
        HashSet<Object> set = new HashSet<Object>(64);
        Iterator<?> it = Util.getIterator(args[1]);
        while (it.hasNext()) {
            params[0] = it.next();
            set.add(keyGetter.call(ctx, params));
        }
        return set;
    }

    static NativeFunction getValueGetter(Object[] args, int index) {
        if (index >= args.length) {
            return DEFAULT_VALUE_GETTER;
        }
        NativeFunction fn = (NativeFunction)args[index];
        return fn != null ? fn : DEFAULT_VALUE_GETTER;
    }

    static NativeFunction getCriteriaGetter(Object[] args, int index) {
        if (index >= args.length) {
            return TRUE;
        }
        NativeFunction fn = (NativeFunction)args[index];
        return fn != null ? fn : TRUE;
    }

    public static Object[] prepare(Object[] args) {
        if (args.length != 1) {
            return args;
        }
        Object a = args[0];
        if (a instanceof Object[]) {
            return (Object[])a;
        }
        if (a instanceof Collection) {
            return ((Collection)a).toArray();
        }
        return new Object[]{a};
    }
}

