/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.web.handler.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.customer.gtiit.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BatchSubmitSchemeUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.web.handler.integrate.BatchSubmitSchemeUtils");

    public static void checkSubmitDate(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Calendar calendar = Calendar.getInstance();
        Date applyDate = info.getApplyDate();
        calendar.setTime(applyDate);
        int thisYear = calendar.get(1);
        int thisMonth = calendar.get(2);
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        int i = 0;
        while (i < entryColl.size()) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
            Date effectDate = entryInfo.getEffectDate();
            calendar.setTime(effectDate);
            int effectYear = calendar.get(1);
            int effectMonth = calendar.get(2);
            if (thisYear != effectYear || thisMonth != effectMonth) {
                throw new ShrWebBizException("The occurrence date of the entry should be consistent with the reporting date");
            }
            ++i;
        }
    }

    public static void checkSubmitAdjust(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String sql = "select top 1 * from T_HR_SHRRsvItem0 where fnumber = '1005' and FState = '1'";
        logger.error((Object)("\u83b7\u53d6\u8c03\u6574\u6708\u4efdSQL\uff1a" + sql));
        int adjustMonth = 0;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                adjustMonth = rs.getInt("FName_l2");
            }
            Date applyDate = info.getApplyDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(applyDate);
            calendar.add(2, adjustMonth);
            calendar.set(5, 1);
            String adjustDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
            BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
            ArrayList<String> personIdList = new ArrayList<String>();
            ArrayList<String> cmpEmpOrgIdList = new ArrayList<String>();
            int i = 0;
            while (i < entryColl.size()) {
                BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
                personIdList.add(entryInfo.getPerson().getId().toString());
                cmpEmpOrgIdList.add(entryInfo.getCmpEmpORelation().getId().toString());
                ++i;
            }
            StringBuffer strBuffer = new StringBuffer();
            int i2 = 0;
            while (i2 < cmpEmpOrgIdList.size()) {
                strBuffer.append("'" + (String)cmpEmpOrgIdList.get(i2) + "'");
                if (i2 != cmpEmpOrgIdList.size() - 1) {
                    strBuffer.append(", ");
                }
                ++i2;
            }
            String empOrgSql = "/*dialect*/SELECT c.fnumber,c.fid FROM T_HR_SCmpEmpORelation a left join T_HR_EmpOrgRelation b on a.femporgrelationid = b.fid left join T_BD_Person c on a.FPERSONID = c.fid where b.feffdt <= '" + adjustDate + "' and b.fleffdt >= '" + adjustDate + "' " + "and a.fid in (" + strBuffer.toString() + ")";
            logger.error((Object)("\u83b7\u53d6\u5458\u5de5\u53d1\u85aa\u4efb\u804c\u65e5\u671fSQL\uff1a" + empOrgSql));
            IRowSet empRowSet = DbUtil.executeQuery((Context)ctx, (String)empOrgSql);
            ArrayList<String> empPerIdList = new ArrayList<String>();
            while (empRowSet.next()) {
                empPerIdList.add(empRowSet.getString("fid"));
            }
            StringBuffer personIdBuffer = new StringBuffer();
            for (String personId : personIdList) {
                if (empPerIdList.contains(personId)) continue;
                personIdBuffer.append("'" + personId + "',");
            }
            if (personIdBuffer.length() > 0) {
                personIdBuffer = personIdBuffer.deleteCharAt(personIdBuffer.length() - 1);
                String personSql = "select fnumber from T_BD_Person where fid in (" + personIdBuffer + ")";
                IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
                StringBuffer numberBuffer = new StringBuffer();
                while (personRowSet.next()) {
                    numberBuffer.append("'" + personRowSet.getString("fnumber") + "',");
                }
                numberBuffer = numberBuffer.deleteCharAt(numberBuffer.length() - 1);
                throw new ShrWebBizException("The following employees: (" + numberBuffer.toString() + ") The adjusted occurrence date is not within the range of salary and employment dates");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void checkSubmitRepeat(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        String submitSchemeId = info.getSubmitScheme().getId().toString();
        StringBuffer personBuffer = new StringBuffer();
        int i = 0;
        while (i < entryColl.size()) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
            personBuffer.append("'" + entryInfo.getPerson().getId().toString() + "',");
            ++i;
        }
        personBuffer = personBuffer.deleteCharAt(personBuffer.length() - 1);
        Date applyDate = info.getApplyDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(applyDate);
        int applyYear = calendar.get(1);
        int applyMonth = calendar.get(2) + 1;
        String sql = "SELECT c.fnumber FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on  a.fid = b.fbillid left join T_BD_Person c on b.FPERSONID = c.fid where a.FSUBMITSCHEMEID = '" + submitSchemeId + "' and year(b.FEFFECTDATE) = " + applyYear + " and month(b.FEFFECTDATE) = " + applyMonth + " and a.FBILLSTATE in ('1','2','3') and a.FDATASOURCE = '2' and b.FPERSONID in (" + personBuffer.toString() + ") ";
        logger.error((Object)("\u83b7\u53d6\u5458\u5de5\u63d0\u62a5SQL\uff1a" + sql));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            StringBuffer numberBuffer = new StringBuffer();
            while (rowSet.next()) {
                numberBuffer.append("'" + rowSet.getString("fnumber") + "',");
            }
            if (numberBuffer.length() > 0) {
                numberBuffer = numberBuffer.deleteCharAt(numberBuffer.length() - 1);
                throw new ShrWebBizException("The following employees (" + numberBuffer + ") have submitted data for this plan with an occurrence date of that month");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void checkSubmitCount(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String proposerId = info.getProposer().getId().toString();
        String submitSchemeId = info.getSubmitScheme().getId().toString();
        if (!StringUtils.equals((CharSequence)personId, (CharSequence)proposerId)) {
            throw new ShrWebBizException("Only self created documents can be submitted");
        }
        Date applyDate = info.getApplyDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(applyDate);
        calendar.set(5, 1);
        String startDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
        calendar.add(2, 1);
        String endDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
        int count = 0;
        String sql = "select count(1) count from T_HR_SBatchSubmitShemeBill where FPROPOSERID  = '" + personId + "' and fbillstate in ('1','2','3') " + "and fdatasource = '2' and fapplydate >= '" + startDate + "' and fapplydate < '" + endDate + "' and FSUBMITSCHEMEID = '" + submitSchemeId + "'";
        logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u5f53\u6708\u63d0\u4ea4\u6b21\u6570SQL\uff1a" + sql));
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                count = iRowSet.getInt("count");
            }
            logger.error((Object)("\u5458\u5de5\u8be5\u65b9\u6848\u5f53\u6708\u63d0\u4ea4\u6b21\u6570\uff1a" + count));
            if (count > 0) {
                throw new ShrWebBizException("Your proposal has been submitted in the month of submission and cannot be resubmitted");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void checkPersonRepeat(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        HashSet<String> personIdSet = new HashSet<String>();
        int i = 0;
        while (i < entryColl.size()) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
            PersonInfo person = entryInfo.getPerson();
            if (person != null) {
                personIdSet.add(person.getId().toString());
            }
            ++i;
        }
        if (personIdSet.size() != entryColl.size()) {
            throw new ShrWebBizException("Entries can only have one row of data per person");
        }
    }

    public static void checkExists(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        int day = 0;
        Calendar calendar = Calendar.getInstance();
        int thisDay = calendar.get(5);
        try {
            String paramSql = "SELECT FNUMBER,fname_l2 name FROM T_HR_SHRRSVITEM0 where fstate = '1' and FNUMBER = '1002'";
            IRowSet paramRow = DbUtil.executeQuery((Context)ctx, (String)paramSql);
            while (paramRow.next()) {
                int n = day = paramRow.getObject("name") == null ? 0 : paramRow.getInt("name");
            }
            if (day != 0 && thisDay > day) {
                throw new ShrWebBizException(" documents have passed the last submission date !");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

