/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.imports;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.affair.AffairBizCheckFacadeFactory;
import com.kingdee.eas.hr.affair.IAffairBizCheckFacade;
import com.kingdee.eas.hr.emp.BankFactory;
import com.kingdee.eas.hr.emp.IBank;
import com.kingdee.eas.hr.emp.IPersonDataSourceOptFacade;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.PersonDataSourceOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseRowInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.DynamicModelHelper;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.app.io.impl.PersonDataSourceImportUtils;
import com.kingdee.shr.base.syssetting.app.io.impl.PersonOtherDataSourceImportService;
import com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicModelInfo;
import com.kingdee.shr.shrimport.SHRFileTemplateInfo;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class PersonOtherParttimeImport
extends PersonOtherDataSourceImportService {
    private boolean isRemovePersonEntity = false;
    private IPerson personLocalInstance;
    private IPersonDataSourceOptFacade PersonDataSourceOptFacadeLocalInstance;
    private IPersonOtherInfo PersonOtherInfoLocalInstance;
    private IAffairBizCheckFacade AffairBizCheckFacadeLocalInstance;
    private IBank bankLocalInstance;
    private String className = "";

    protected void importDataSource(BaseRowInfo row) throws ImportException {
        String graduation = row.getValueOfString("partperson.graduation");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)graduation)) {
            Date nowdate = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String sdate = sdf.format(nowdate);
            try {
                Date dateGraduation = sdf.parse(graduation);
                Date tonowDate = sdf.parse(sdate);
                if (tonowDate.before(dateGraduation)) {
                    throw new ImportException("The graduation time cannot be longer than the current time !");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        DynamicModelHelper dHelper = this.getDynamicModelHelper();
        Context ctx = this.getContext();
        try {
            this.handlerEachRow(ctx, row, dHelper, ctx.getLocale());
        }
        catch (Exception var5) {
            throw new ImportException(var5.getMessage(), (Throwable)var5);
        }
    }

    private void handlerEachRow(Context ctx, BaseRowInfo row, DynamicModelHelper helper, Locale locale) throws Exception {
        this.personLocalInstance = PersonFactory.getLocalInstance((Context)ctx);
        this.isRemovePersonEntity = PersonDataSourceImportUtils.checkPersonAssociatedAttributes((Context)ctx, (SHRFileTemplateInfo)this.getTemplateInfo(), (String)this.getScheme());
        this.personLocalInstance = PersonFactory.getLocalInstance((Context)ctx);
        this.PersonDataSourceOptFacadeLocalInstance = PersonDataSourceOptFacadeFactory.getLocalInstance((Context)ctx);
        this.PersonOtherInfoLocalInstance = PersonOtherInfoFactory.getLocalInstance((Context)ctx);
        this.AffairBizCheckFacadeLocalInstance = AffairBizCheckFacadeFactory.getLocalInstance((Context)ctx);
        this.bankLocalInstance = BankFactory.getLocalInstance((Context)ctx);
        this.className = ((Object)((Object)this)).getClass().getName();
        String personName = row.getValueOfString("person.name");
        String number = row.getValueOfString("person.number");
        String personBirthday = row.getValueOfString("person.birthday");
        Boolean setBirthdayByIdCard = false;
        setBirthdayByIdCard = !StringUtils.isEmpty((String)personBirthday) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        PersonInfo personInfo = PersonDataSourceImportUtils.getPersonInfo((Context)ctx, (IPerson)this.personLocalInstance, (String)personName, (String)number, (Locale)locale);
        helper.setCurrentBillid(personInfo.getId().toString());
        DynamicModelInfo model = helper.convertRowToDynamicModel(row);
        LinkedHashMap saveModels = model.getSaveModelMap();
        PersonInfo person = (PersonInfo)((HashMap)saveModels).get("com.kingdee.eas.basedata.person.app.Person");
        String permItemId = this.getPermItemId();
        PersonDataSourceImportUtils.checkPersonLeffdt((BaseRowInfo)row);
        PersonDataSourceImportUtils.calculateSocialServiceYears((Context)ctx, (HashMap)saveModels);
        PersonDataSourceImportUtils.checkProjectExperience((HashMap)saveModels);
        PersonDataSourceImportUtils.checkPersonWorkExp((HashMap)saveModels);
        PersonDataSourceImportUtils.checkPersonRewardPunish((HashMap)saveModels);
        PersonDataSourceImportUtils.validateDate((HashMap)saveModels);
        PersonDataSourceImportUtils.checkPersonBasicInformation((Context)ctx, (IPerson)this.personLocalInstance, (IAffairBizCheckFacade)this.AffairBizCheckFacadeLocalInstance, (IPersonOtherInfo)this.PersonOtherInfoLocalInstance, (HashMap)saveModels, (BaseRowInfo)row, (String)permItemId, (Boolean)setBirthdayByIdCard, (String)this.className);
        PersonDataSourceImportUtils.setPersonContactMethodInfo((HashMap)saveModels, (BaseRowInfo)row);
        PersonDataSourceImportUtils.verifyAndCheckMobileAndEmail((Context)ctx, (HashMap)saveModels, (String)person.getId().toString());
        PersonDataSourceImportUtils.dealPersonBankRecord((Context)ctx, (HashMap)saveModels, (IBank)this.bankLocalInstance);
        PersonDataSourceImportUtils.setPersonModel((DynamicModelInfo)model);
        PersonDataSourceImportUtils.removePersonEntity((HashMap)saveModels, (boolean)this.isRemovePersonEntity);
        PersonDataSourceImportUtils.checkPersonCredentialsTypeModel((Context)ctx, (HashMap)saveModels);
        this.PersonDataSourceOptFacadeLocalInstance.saveDataSource((Map)saveModels);
    }
}

