/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.customer.gtiit.osf.GtiitOrgPositionService;
import com.kingdee.shr.customer.gtiit.osf.util.DateUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtiitOrgAdminService
implements IHRMsfService {
    private static final Logger logger = LoggerFactory.getLogger(GtiitOrgPositionService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        List<Map<String, String>> dataList = null;
        try {
            String startDate = (String)param.get("startDate");
            String endDate = (String)param.get("endDate");
            logger.info(">>> GtiitOrgAdminService...\u5165\u53c2...startDate = " + startDate + "; endDate = " + endDate);
            String sql = "SELECT\r\n\toa.FID ID,\r\n\toa.fnumber ORGANIZATION_CODE,\r\n\toa.FNAME_L1 ORGANIZATION_NAME_EN,\r\n\toa.FNAME_L2 ORGANIZATION_NAME_CN,\r\n\toa.FSIMPLENAME ORGANIZATION_SHORT_NAME,\r\n\tp.FNUMBER DEPARTMENT_HEAD_PERSON_NUMBER,\r\n\tp.FNAME_L2 DEPARTMENT_HEAD_NAME,\r\n\toa.FCREATETIME ERP_CREATION_DATE,\r\n\toa.FLASTUPDATETIME ERP_LAST_UPDATE_DATE \r\n   FROM\r\n\tT_ORG_Admin oa\r\n\tLEFT JOIN t_bd_person p ON p.fid = oa.FPRINCIPALID";
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                startDate = DateUtils.formatDate(startDate, true);
                endDate = DateUtils.formatDate(endDate, false);
                logger.info(">>> GtiitOrgAdminService...\u4fee\u6539\u540e\u7684\u5165\u53c2...startDate = " + startDate + "; endDate = " + endDate);
                sql = String.valueOf(sql) + " where oa.FLASTUPDATETIME >= '" + startDate + "' and oa.FLASTUPDATETIME <= '" + endDate + "'";
            }
            logger.info(">>> GtiitOrgAdminService \u7684\u6267\u884c sql = " + sql);
            List<String> fieldList = this.initMappingField();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            dataList = this.getRsListData(fieldList, rs);
            if (dataList != null && dataList.size() > 0) {
                this.processHead(ctx, dataList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dataList;
    }

    private void processHead(Context ctx, List<Map<String, String>> dataList) throws BOSException, SQLException {
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < dataList.size()) {
            ids.add(dataList.get(i).get("ID"));
            ++i;
        }
        String processStr = this.processStr(ids);
        Map<String, String> heads = this.getHead(ctx, processStr);
        Map<String, String> pvcMap = this.getPvc(ctx, processStr);
        int i2 = 0;
        while (i2 < dataList.size()) {
            Map<String, String> data = dataList.get(i2);
            data.put("DEPARTMENT_HEAD_PERSON_NUMBER", heads.get(String.valueOf(data.get("ORGANIZATION_CODE")) + "-number"));
            data.put("DEPARTMENT_HEAD_NAME", heads.get(String.valueOf(data.get("ORGANIZATION_CODE")) + "-name"));
            data.put("PVC_PERSON_NUMBER", pvcMap.get(String.valueOf(data.get("ORGANIZATION_CODE")) + "-number"));
            data.put("PVC_NAME", pvcMap.get(String.valueOf(data.get("ORGANIZATION_CODE")) + "-name"));
            ++i2;
        }
    }

    private Map<String, String> getPvc(Context ctx, String processStr) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\torg.fnumber orgNumber,\r\n\torg.Fname_l1 orgName,\r\n\tbp.fnumber pNumber,\r\n\tbp.Fname_l1 pName\r\nFROM\r\n\tT_WFR_WFROLE wf\r\n\tLEFT JOIN T_WFR_PERSONROLE wp ON wp.froleid= wf.fid\r\n\tLEFT JOIN T_BD_Person bp ON bp.fid= wp.fpsersonid\r\n\tLEFT JOIN T_ORG_Admin org ON org.fid= wp.forgid \r\nWHERE\r\n\twf.fnumber= '02' and org.fid in(" + processStr + ")";
        logger.info("GtiitOrgAdminService->getPvc->sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String orgNumber = rs.getString("orgNumber");
            if (StringUtils.isBlank((CharSequence)orgNumber)) continue;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(String.valueOf(orgNumber) + "-number")))) {
                resultMap.put(String.valueOf(orgNumber) + "-number", String.valueOf((String)resultMap.get(String.valueOf(orgNumber) + "-number")) + "," + rs.getString("pNumber"));
            } else {
                resultMap.put(String.valueOf(orgNumber) + "-number", rs.getString("pNumber"));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(String.valueOf(orgNumber) + "-name")))) {
                resultMap.put(String.valueOf(orgNumber) + "-name", String.valueOf((String)resultMap.get(String.valueOf(orgNumber) + "-name")) + "," + rs.getString("pName"));
                continue;
            }
            resultMap.put(String.valueOf(orgNumber) + "-name", rs.getString("pName"));
        }
        return resultMap;
    }

    private Map<String, String> getHead(Context ctx, String processStr) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\ta.fid AS oId,\r\n\ta.fnumber AS oNumber,\r\n\td.fnumber AS pNumber,\r\n\td.fname_L1 AS pNameL1,\r\n\td.fname_L2 AS pNameL2 \r\nFROM\r\n\tT_ORG_Admin a\r\n\tLEFT JOIN T_ORG_POSITION b ON a.FResponPositionID= b.fid\r\n\tLEFT JOIN (\r\n\tSELECT\r\n\t\tca.fpositionid,\r\n\t\tca.fpersonid, \r\n\t\tca.fislatestinaday, \r\n\t\tca.fadminorgid, \r\n\t\tca.flastupdatetime \r\n\tFROM\r\n\t\tT_HR_EmpOrgRelation ca\r\n\t\tINNER JOIN ( SELECT fpositionid, MAX ( fleffdt ) maxDate FROM T_HR_EmpOrgRelation GROUP BY fpositionid ) cb ON ca.fpositionid= cb.fpositionid \r\n\t\tAND ca.fleffdt= cb.maxDate \r\n\t) c ON c.fpositionid= b.fid\r\n\tLEFT JOIN T_BD_Person d ON d.fid= c.fpersonid\r\n\tLEFT JOIN T_HR_BDEmployeeType e ON e.fid= d.femployeetypeid \r\nWHERE\r\n\ta.fid IN (" + processStr + ") \r\n" + "\tAND b.FIsRespPosition= 1 \r\n" + "\tAND e.finservice= 1 \r\n" + "\tAND b.fdeletedstatus= 1 \r\n" + "\tAND c.fislatestinaday=1  \r\n";
        logger.info("GtiitOrgAdminService->getHead->sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String oNumber = rs.getString("oNumber");
            if (StringUtils.isBlank((CharSequence)oNumber)) continue;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(String.valueOf(oNumber) + "-number")))) {
                resultMap.put(String.valueOf(oNumber) + "-number", String.valueOf((String)resultMap.get(String.valueOf(oNumber) + "-number")) + "," + rs.getString("pNumber"));
            } else {
                resultMap.put(String.valueOf(oNumber) + "-number", rs.getString("pNumber"));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(String.valueOf(oNumber) + "-name")))) {
                resultMap.put(String.valueOf(oNumber) + "-name", String.valueOf((String)resultMap.get(String.valueOf(oNumber) + "-name")) + "," + rs.getString("pNameL1"));
                continue;
            }
            resultMap.put(String.valueOf(oNumber) + "-name", rs.getString("pNameL1"));
        }
        return resultMap;
    }

    private String processStr(List<String> numbers) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (String s : numbers) {
            sb.append("'").append(s).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
            result = sb.toString();
        }
        return result;
    }

    private List<String> initMappingField() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("ORGANIZATION_CODE");
        list.add("ORGANIZATION_NAME_EN");
        list.add("ORGANIZATION_NAME_CN");
        list.add("ORGANIZATION_SHORT_NAME");
        list.add("DEPARTMENT_HEAD_PERSON_NUMBER");
        list.add("DEPARTMENT_HEAD_NAME");
        list.add("ERP_CREATION_DATE");
        list.add("ERP_LAST_UPDATE_DATE");
        return list;
    }

    private List<Map<String, String>> getRsListData(List<String> fieldList, IRowSet rs) throws BOSException {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        try {
            while (rs.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                int i = 0;
                int size = fieldList.size();
                while (i < size) {
                    String field = fieldList.get(i);
                    dataMap.put(field, rs.getString(field));
                    ++i;
                }
                dataList.add(dataMap);
            }
            return dataList;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }
}

