/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.util;

import com.cloudera.impala.jdbc4.internal.apache.log4j.Logger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportAllUtil {
    private static Logger logger1 = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.util.ExportAllUtils");

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, List<String> list) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue(list.get(j));
                    ++j;
                }
            }
            ++i;
            while (rs.next()) {
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        XSSFCell cell = dateRow.createCell(j);
                        String column = (String)keyList.get(j);
                        String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                        int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                        String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                        String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                        cell.setCellValue(rs.getString(column));
                        if ("Date".equals(fieldType)) {
                            Date date = rs.getDate(column);
                            cell.setCellValue((java.util.Date)date);
                            XSSFCellStyle stylee = workBook.createCellStyle();
                            stylee.setDataFormat(format.getFormat(cellStyleType));
                            cell.setCellStyle((CellStyle)stylee);
                        } else if ("Number".equals(fieldType)) {
                            BigDecimal value = rs.getBigDecimal(column) != null ? rs.getBigDecimal(column).setScale(2, 4) : BigDecimal.ZERO;
                            XSSFCellStyle style = workBook.createCellStyle();
                            if (cellStyleType.contains(".")) {
                                style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
                                cell.setCellStyle((CellStyle)style);
                                cell.setCellValue(value.doubleValue());
                            } else {
                                style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0"));
                                cell.setCellStyle((CellStyle)style);
                                cell.setCellValue((double)value.intValue());
                            }
                        } else if ("String".equals(fieldType)) {
                            if (rs.getString(column) != null && !"".equals(rs.getString(column))) {
                                cell.setCellValue(rs.getString(column));
                            }
                        } else if ("StringDate".equals(fieldType) && rs.getString(column) != null && !"".equals(rs.getString(column))) {
                            cell.setCellValue(rs.getString(column).substring(0, 10));
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception e) {
                    logger1.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                ExportAllUtil.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger1.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger1.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

