/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.integrate;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.integrate.dto.CalShemeSubmitItemDTO;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpIntegrateUtilsNew {
    private static Logger logger = Logger.getLogger(CmpIntegrateUtilsNew.class);

    public static void updateEntryBillState(Context ctx, String billId, HRBillStateEnum stateEnum, String billEntryTable) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo("where id = '" + billId + "'");
        String billEntryTableName = billEntryTable;
        if (StringUtils.isEmpty((CharSequence)billEntryTableName)) {
            Map<String, Object> map = CmpIntegrateUtilsNew.getBillColumnListAndBillEntryTableName(ctx, info.getSubmitScheme().getId().toString());
            billEntryTableName = map.get("fBillEntryTableName").toString();
        }
        String sqlTemplate = "UPDATE %s SET FBillState = ? WHERE FBILLID = ?";
        String sql = String.format(sqlTemplate, billEntryTableName);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{stateEnum.getValue(), info.getId().toString()});
    }

    public static String getUsableItemByHro(Context ctx, String hrOrgUnit, boolean isDisatribute) {
        StringBuffer personCmpItemPerm = new StringBuffer();
        personCmpItemPerm.append("select FBaseInfoId from T_HR_SCalSubmitItemRelHR  where T_HR_SCalSubmitItemRelHR.FHrOrgUseId ='");
        personCmpItemPerm.append(hrOrgUnit).append("'");
        if (isDisatribute) {
            personCmpItemPerm.append(" and FState=100 ");
        }
        return personCmpItemPerm.toString();
    }

    public static boolean checkSubmitSchemeIsUsingBill(Context ctx, String schemeId) {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "Select top 1 fid  from T_HR_SBatchSubmitShemeBill where fbillstate in (0,1,2)  and FSubmitSchemeID = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
            if (rs.size() > 0) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return flag;
    }

    public static boolean checkSubmitBillEntryIsExists(Context ctx, String billEntryTableName, String billId) {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)billId)) {
            return flag;
        }
        String sql = "Select top 1 fid  from " + billEntryTableName + " where fbillId = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            if (rs.size() > 0) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return flag;
    }

    public static boolean checkSubmitSchemeIsUsedBill(Context ctx, String schemeId) {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "Select top 1 fid  from T_HR_SBatchSubmitShemeBill where fbillstate in (1,2)  and FSubmitSchemeID = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
            if (rs.size() > 0) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return flag;
    }

    public static Map checkSubmitSchemesIsUsingBill(Context ctx, List<String> list) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String sql = "Select distinct FSubmitSchemeID from T_HR_SBatchSubmitShemeBill where fbillstate in (0,1,2)  and FSubmitSchemeID in( " + CmpStrUtil.convertListToString(list) + ") ";
        HashSet<String> snSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String submitSchemeID = rs.getString("FSubmitSchemeID");
                snSet.add(submitSchemeID);
            }
            for (String submitSchemeID : list) {
                map.put(submitSchemeID, snSet.contains(submitSchemeID));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return map;
    }

    public static Map<String, List> assembleSubmitSchemeColModel(Context ctx, String schemeId, Integer dataSource) throws BOSException {
        HashMap<String, List> map = new HashMap<String, List>();
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList colModel = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget, e.FIsEnableSubmitElement,e.FEFFECTDATEDISPLAY , m.fieldSn,m.fdataType,m.fname_" + language + " MNAME,t.FIsRequired ,m.FDataDot,m.FDataLength, " + " M.FDATETYPE,M.FFILTERFIELD,B.FENTITYNAME,B.FNAME_" + language + " BNAME,B.FUSEUIPK, B.FMAINTAINUIPK  " + " from  T_HR_SCalSubmitScheme e " + " inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid " + " inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID " + " left join  T_BS_SHRBasicItem b on m.FFilterField = b.fid " + " where e.fid = '" + schemeId + "' order by  FSortSn";
        try {
            String submitTarget = "";
            String dataType = "";
            int dateType = 0;
            int effectDateDisplay = 0;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean f7Flag = true;
            boolean isEnableSubmitElement = false;
            while (rs.next()) {
                JSONObject inputJson;
                JSONObject editoptions;
                HashMap<String, Object> schemeMap;
                submitTarget = rs.getString("FSubmitTarget");
                effectDateDisplay = rs.getInt("FEFFECTDATEDISPLAY");
                isEnableSubmitElement = rs.getBoolean("FIsEnableSubmitElement");
                dataType = rs.getString("fdataType");
                if (f7Flag) {
                    f7Flag = false;
                    HashMap<String, Object> gridMainKeyIdMap = new HashMap<String, Object>();
                    HashMap<String, Object> adminOrgUnitGridMainKeyIdMap = new HashMap<String, Object>();
                    HashMap<String, Object> positionGridMainKeyIdMap = new HashMap<String, Object>();
                    HashMap<String, Object> cmpEmpORGridMainKeyIdMap = new HashMap<String, Object>();
                    HashMap<String, Object> gridIdMap = new HashMap<String, Object>();
                    CmpIntegrateUtilsNew.assembleColModelId(gridIdMap);
                    colNames.add("id");
                    colModel.add(gridIdMap);
                    if ("02".equals(submitTarget)) {
                        CmpIntegrateUtilsNew.assembleColModelF7(gridMainKeyIdMap, "orgUnit", "\u63d0\u62a5\u7ec4\u7ec7", true);
                        gridMainKeyIdMap.put("editoptions", CmpIntegrateUtilsNew.assembleColModelF7("\u63d0\u62a5\u7ec4\u7ec7", "com.kingdee.eas.basedata.org.app.AdminOrgUnit.F7", true));
                        gridMainKeyIdMap.put("sortable", true);
                        colNames.add("\u63d0\u62a5\u7ec4\u7ec7");
                        colModel.add(gridMainKeyIdMap);
                    } else {
                        HashMap<String, Object> gridPersonNumberMap = new HashMap<String, Object>();
                        gridPersonNumberMap.put("name", "number");
                        gridPersonNumberMap.put("label", "\u5458\u5de5\u7f16\u7801");
                        gridPersonNumberMap.put("frozen", false);
                        gridPersonNumberMap.put("width", 90);
                        gridPersonNumberMap.put("align", "left");
                        gridPersonNumberMap.put("key", true);
                        gridPersonNumberMap.put("hidden", false);
                        gridPersonNumberMap.put("editable", false);
                        gridPersonNumberMap.put("sorttype", "string");
                        gridPersonNumberMap.put("classes", "disabled");
                        gridPersonNumberMap.put("edittype", "shrtext");
                        gridPersonNumberMap.put("sortable", true);
                        colNames.add("\u5458\u5de5\u7f16\u7801");
                        colModel.add(gridPersonNumberMap);
                        String CmpEmpORelF7Uipk = "com.kingdee.shr.compensation.app.integrate.CmpEmpORelation.F7";
                        if (3 == dataSource) {
                            CmpEmpORelF7Uipk = "com.kingdee.shr.compensation.app.integrate.stores.CmpEmpORelation.F7";
                        }
                        CmpIntegrateUtilsNew.assembleColModelF7(gridMainKeyIdMap, "person", "\u5458\u5de5\u59d3\u540d", true);
                        gridMainKeyIdMap.put("editoptions", CmpIntegrateUtilsNew.assembleColModelF7("\u5458\u5de5\u59d3\u540d", CmpEmpORelF7Uipk, true));
                        colNames.add("\u5458\u5de5\u59d3\u540d");
                        colModel.add(gridMainKeyIdMap);
                        CmpIntegrateUtilsNew.assembleColModelF7NotEdit(adminOrgUnitGridMainKeyIdMap, "adminOrgUnit", "\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7");
                        adminOrgUnitGridMainKeyIdMap.put("sortable", true);
                        colNames.add("\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7");
                        colModel.add(adminOrgUnitGridMainKeyIdMap);
                        CmpIntegrateUtilsNew.assembleColModelF7NotEdit(positionGridMainKeyIdMap, "position", "\u804c\u4f4d");
                        positionGridMainKeyIdMap.put("sortable", true);
                        colNames.add("\u804c\u4f4d");
                        colModel.add(positionGridMainKeyIdMap);
                        CmpIntegrateUtilsNew.assembleColModelF7Hidden(cmpEmpORGridMainKeyIdMap, "cmpEmpORelation", "\u53d1\u85aa\u4efb\u804c");
                        colNames.add("\u53d1\u85aa\u4efb\u804c");
                        colModel.add(cmpEmpORGridMainKeyIdMap);
                        HashMap<String, Object> gridPersonIdMap = new HashMap<String, Object>();
                        gridPersonIdMap.put("name", "tempId");
                        gridPersonIdMap.put("label", "\u5458\u5de5\u6216\u8005\u7ec4\u7ec7\u4e34\u65f6id");
                        gridPersonIdMap.put("frozen", false);
                        gridPersonIdMap.put("width", 90);
                        gridPersonIdMap.put("align", "left");
                        gridPersonIdMap.put("key", true);
                        gridPersonIdMap.put("hidden", true);
                        gridPersonIdMap.put("editable", false);
                        gridPersonIdMap.put("sorttype", "string");
                        gridPersonIdMap.put("classes", "disabled");
                        gridPersonIdMap.put("edittype", "shrtext");
                        colNames.add("tempId");
                        colModel.add(gridPersonIdMap);
                    }
                    if (isEnableSubmitElement) {
                        HashMap<String, Object> gridSubmitElementMap = new HashMap<String, Object>();
                        CmpIntegrateUtilsNew.assembleColModelF7(gridSubmitElementMap, "submitElement", "\u7533\u62a5\u8981\u7d20", true);
                        gridSubmitElementMap.put("editoptions", CmpIntegrateUtilsNew.assembleColModelF7("\u7533\u62a5\u8981\u7d20", "com.kingdee.shr.compensation.app.integrate.SubmitElement.SubmitBillEntry.F7", true));
                        colNames.add("\u7533\u62a5\u8981\u7d20");
                        colModel.add(gridSubmitElementMap);
                    }
                    HashMap<String, Object> gridCurrencyMap = new HashMap<String, Object>();
                    CmpIntegrateUtilsNew.assembleColModelF7(gridCurrencyMap, "currency", "\u5e01\u522b", true);
                    gridCurrencyMap.put("editoptions", CmpIntegrateUtilsNew.assembleColModelF7("\u5e01\u522b", "com.kingdee.eas.basedata.assistant.app.Currency.CMP.F7", true));
                    colNames.add("\u5e01\u522b");
                    colModel.add(gridCurrencyMap);
                    HashMap<String, Object> gridPersonNumberMap = new HashMap<String, Object>();
                    gridPersonNumberMap.put("name", "effectDay");
                    gridPersonNumberMap.put("label", "\u53d1\u751f\u65e5\u671f");
                    gridPersonNumberMap.put("frozen", false);
                    gridPersonNumberMap.put("width", 100);
                    gridPersonNumberMap.put("align", "left");
                    gridPersonNumberMap.put("key", true);
                    gridPersonNumberMap.put("hidden", false);
                    gridPersonNumberMap.put("editable", true);
                    gridPersonNumberMap.put("sorttype", "date");
                    gridPersonNumberMap.put("sortable", false);
                    gridPersonNumberMap.put("formatter", "shrDateTimePicker");
                    gridPersonNumberMap.put("edittype", "shrDateTimePicker");
                    gridPersonNumberMap.put("classes", "required");
                    StringBuffer datapickerjsonBuffer = new StringBuffer();
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"datepickerjson\":");
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"id\":\"dp_autoSize\",");
                    datapickerjsonBuffer.append("\"name\":\"dp_autoSize\",");
                    datapickerjsonBuffer.append("\"minuteStep\":\"\",");
                    datapickerjsonBuffer.append("\"showTimeZoneForCtrl\":false,");
                    datapickerjsonBuffer.append("\"isAutoTimeZoneTrans\":false,");
                    datapickerjsonBuffer.append("\"isShowUTC\":false,");
                    datapickerjsonBuffer.append("\"isReadonlyUTC\":true,");
                    datapickerjsonBuffer.append("\"isRemoveSeconds\":true,");
                    if (20 == effectDateDisplay) {
                        datapickerjsonBuffer.append("\"isRemoveDay\":true,");
                    } else if (10 == effectDateDisplay) {
                        datapickerjsonBuffer.append("\"isRemoveDay\":false,");
                    } else {
                        datapickerjsonBuffer.append("\"isRemoveDay\":true,");
                    }
                    datapickerjsonBuffer.append("\"ctrlType\":\"Date\"");
                    datapickerjsonBuffer.append("},");
                    datapickerjsonBuffer.append("\"validateJson\":");
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"errMsg\":\"\",");
                    datapickerjsonBuffer.append("\"rules\":\"required:true\",");
                    datapickerjsonBuffer.append("\"validatetrigger\":\"focus keyup datachange\"");
                    datapickerjsonBuffer.append("}");
                    datapickerjsonBuffer.append("}");
                    gridPersonNumberMap.put("editoptions", JSONObject.parseObject((String)datapickerjsonBuffer.toString()));
                    colNames.add("\u53d1\u751f\u65e5\u671f");
                    colModel.add(gridPersonNumberMap);
                }
                dataType = rs.getString("fdataType");
                int isRequired = rs.getInt("FIsRequired");
                int fDataDot = rs.getInt("FDataDot");
                int fDataLength = rs.getInt("FDataLength");
                if ("0".equals(dataType)) {
                    schemeMap = new HashMap<String, Object>();
                    schemeMap.put("name", "S" + rs.getString("fieldSn"));
                    schemeMap.put("label", rs.getString("MNAME"));
                    schemeMap.put("frozen", false);
                    schemeMap.put("width", 90);
                    schemeMap.put("align", "left");
                    schemeMap.put("key", false);
                    schemeMap.put("editable", true);
                    schemeMap.put("sorttype", "bigdecimal");
                    schemeMap.put("sortable", false);
                    schemeMap.put("formatter", "numberfield");
                    schemeMap.put("edittype", "numberfield");
                    editoptions = JSONObject.parseObject((String)"{ \"inputJson\": { \"id\": \"txt_money\", \"name\": \"money\", \"<formatTy></formatTy>pe\": \"number\" }}");
                    if (isRequired == 1) {
                        schemeMap.put("classes", "required");
                        editoptions.put("validateJson", (Object)JSONObject.parseObject((String)"{ \"errMsg\": \"\", \"rules\": \"required:true\", \"validatetrigger\": \"focus keyup datachange\" }"));
                    }
                    inputJson = editoptions.getJSONObject("inputJson");
                    inputJson.put("decimalPrecision", (Object)fDataDot);
                    inputJson.put("maxlength", (Object)fDataLength);
                    schemeMap.put("editoptions", editoptions);
                    colModel.add(schemeMap);
                    colNames.add(rs.getString("MNAME"));
                    continue;
                }
                if ("1".equals(dataType)) {
                    schemeMap = new HashMap();
                    schemeMap.put("name", "S" + rs.getString("fieldSn"));
                    schemeMap.put("label", rs.getString("MNAME"));
                    schemeMap.put("frozen", false);
                    schemeMap.put("width", 90);
                    schemeMap.put("align", "left");
                    schemeMap.put("key", false);
                    schemeMap.put("editable", true);
                    schemeMap.put("sorttype", "string");
                    schemeMap.put("sortable", false);
                    editoptions = JSONObject.parseObject((String)"{ \"inputJson\": {  } }");
                    if (isRequired == 1) {
                        schemeMap.put("classes", "required");
                        editoptions.put("validateJson", (Object)JSONObject.parseObject((String)"{ \"errMsg\": \"\", \"rules\": \"required:true\", \"validatetrigger\": \"focus keyup datachange\" }"));
                    } else {
                        editoptions.put("validateJson", (Object)JSONObject.parseObject((String)"{ \"errMsg\": \"\", \"rules\": \"required:false\", \"validatetrigger\": \"focus keyup datachange\" }"));
                    }
                    inputJson = editoptions.getJSONObject("inputJson");
                    inputJson.put("decimalPrecision", (Object)fDataDot);
                    inputJson.put("maxlength", (Object)fDataLength);
                    schemeMap.put("editoptions", editoptions);
                    schemeMap.put("edittype", "shrtext");
                    colModel.add(schemeMap);
                    colNames.add(rs.getString("MNAME"));
                    continue;
                }
                if ("2".equals(dataType)) {
                    dateType = rs.getInt("FDATETYPE");
                    schemeMap = new HashMap();
                    schemeMap.put("name", "S" + rs.getString("fieldSn"));
                    schemeMap.put("label", rs.getString("MNAME"));
                    schemeMap.put("frozen", false);
                    schemeMap.put("width", 100);
                    schemeMap.put("align", "left");
                    schemeMap.put("key", true);
                    schemeMap.put("hidden", false);
                    schemeMap.put("editable", true);
                    schemeMap.put("sorttype", "date");
                    schemeMap.put("sortable", false);
                    schemeMap.put("formatter", "shrDateTimePicker");
                    schemeMap.put("edittype", "shrDateTimePicker");
                    if (isRequired == 1) {
                        schemeMap.put("classes", "required");
                    }
                    StringBuffer datapickerjsonBuffer = new StringBuffer();
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"datepickerjson\":");
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"id\":\"dp_autoSize\",");
                    datapickerjsonBuffer.append("\"name\":\"dp_autoSize\",");
                    datapickerjsonBuffer.append("\"minuteStep\":\"\",");
                    datapickerjsonBuffer.append("\"showTimeZoneForCtrl\":false,");
                    datapickerjsonBuffer.append("\"isAutoTimeZoneTrans\":false,");
                    datapickerjsonBuffer.append("\"isShowUTC\":false,");
                    datapickerjsonBuffer.append("\"isReadonlyUTC\":true,");
                    datapickerjsonBuffer.append("\"isRemoveSeconds\":true,");
                    if (20 == dateType) {
                        datapickerjsonBuffer.append("\"isRemoveDay\":true,");
                    } else if (10 == dateType) {
                        datapickerjsonBuffer.append("\"isRemoveDay\":false,");
                    } else {
                        datapickerjsonBuffer.append("\"isRemoveDay\":false,");
                    }
                    datapickerjsonBuffer.append("\"ctrlType\":\"Date\"");
                    datapickerjsonBuffer.append("},");
                    datapickerjsonBuffer.append("\"validateJson\":");
                    datapickerjsonBuffer.append("{");
                    datapickerjsonBuffer.append("\"errMsg\":\"\",");
                    if (isRequired == 1) {
                        datapickerjsonBuffer.append("\"rules\":\"required:true\",");
                    } else {
                        datapickerjsonBuffer.append("\"rules\":\"required:false\",");
                    }
                    datapickerjsonBuffer.append("\"validatetrigger\":\"focus keyup datachange\"");
                    datapickerjsonBuffer.append("}");
                    datapickerjsonBuffer.append("}");
                    schemeMap.put("editoptions", JSONObject.parseObject((String)datapickerjsonBuffer.toString()));
                    colNames.add(rs.getString("MNAME"));
                    colModel.add(schemeMap);
                    continue;
                }
                if (!"3".equals(dataType)) continue;
                schemeMap = new HashMap();
                CmpIntegrateUtilsNew.assembleColModelF7(schemeMap, "S" + rs.getString("fieldSn"), rs.getString("MNAME"), isRequired == 1);
                editoptions = CmpIntegrateUtilsNew.assembleColModelF7(rs.getString("BNAME"), rs.getString("FMAINTAINUIPK"), isRequired == 1, "");
                schemeMap.put("editoptions", editoptions);
                colNames.add(rs.getString("MNAME"));
                colModel.add(schemeMap);
            }
            HashMap<String, Object> gridDescriptionMap = new HashMap<String, Object>();
            gridDescriptionMap.put("name", "description");
            gridDescriptionMap.put("label", "\u5907\u6ce8");
            gridDescriptionMap.put("frozen", false);
            gridDescriptionMap.put("width", 90);
            gridDescriptionMap.put("align", "left");
            gridDescriptionMap.put("key", false);
            gridDescriptionMap.put("editable", true);
            gridDescriptionMap.put("sortable", false);
            gridDescriptionMap.put("formatter", "shrMultiLangBox");
            gridDescriptionMap.put("edittype", "shrMultiLangBox");
            JSONObject editoptions = JSONObject.parseObject((String)"{ \"inputJson\": {  } }");
            JSONObject inputJson = editoptions.getJSONObject("inputJson");
            inputJson.put("maxlength", (Object)255);
            gridDescriptionMap.put("editoptions", editoptions);
            colNames.add("\u5907\u6ce8");
            colModel.add(gridDescriptionMap);
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        return map;
    }

    public static Map<String, Object> assembleColModelId(Map<String, Object> gridIdMap) {
        gridIdMap.put("name", "id");
        gridIdMap.put("label", "id");
        gridIdMap.put("frozen", false);
        gridIdMap.put("width", 90);
        gridIdMap.put("align", "left");
        gridIdMap.put("key", true);
        gridIdMap.put("hidden", true);
        gridIdMap.put("editable", false);
        gridIdMap.put("sorttype", "");
        gridIdMap.put("sortable", false);
        gridIdMap.put("classes", "disabled");
        return gridIdMap;
    }

    public static Map<String, Object> assembleColModelF7(String name, String uipk, boolean isRequired) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> f7JsonMap = new HashMap<String, Object>();
        HashMap<String, String> validateJsonMap = new HashMap<String, String>();
        HashMap<String, Object> uipkMap = new HashMap<String, Object>();
        uipkMap.put("title", name);
        uipkMap.put("uipk", uipk);
        uipkMap.put("query", "");
        uipkMap.put("filter", "");
        uipkMap.put("multiselect", false);
        uipkMap.put("isTree", false);
        uipkMap.put("treeUrl", "");
        uipkMap.put("isContainLowerOrg", false);
        uipkMap.put("isAdminOrg", false);
        f7JsonMap.put("subWidgetOptions", uipkMap);
        f7JsonMap.put("subWidgetName", "shrPromptGrid");
        f7JsonMap.put("searchFields", "");
        f7JsonMap.put("isHROrg", false);
        f7JsonMap.put("isAdminOrg", false);
        f7JsonMap.put("searchLikePattern", "any");
        resultMap.put("f7Json", f7JsonMap);
        validateJsonMap.put("errMsg", "");
        if (isRequired) {
            validateJsonMap.put("rules", "required:true");
        }
        validateJsonMap.put("validatetrigger", "focus keyup datachange");
        resultMap.put("validateJson", validateJsonMap);
        return resultMap;
    }

    public static Map<String, Object> assembleColModelF7(String name, String uipk, boolean isRequired, String filter) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> f7JsonMap = new HashMap<String, Object>();
        HashMap<String, String> validateJsonMap = new HashMap<String, String>();
        HashMap<String, Object> uipkMap = new HashMap<String, Object>();
        uipkMap.put("title", name);
        uipkMap.put("uipk", uipk);
        uipkMap.put("query", "");
        uipkMap.put("filter", filter);
        uipkMap.put("multiselect", false);
        uipkMap.put("isTree", false);
        uipkMap.put("treeUrl", "");
        uipkMap.put("isContainLowerOrg", false);
        uipkMap.put("isAdminOrg", false);
        f7JsonMap.put("subWidgetOptions", uipkMap);
        f7JsonMap.put("subWidgetName", "shrPromptGrid");
        f7JsonMap.put("searchFields", "");
        f7JsonMap.put("isHROrg", false);
        f7JsonMap.put("isAdminOrg", false);
        f7JsonMap.put("searchLikePattern", "any");
        resultMap.put("f7Json", f7JsonMap);
        validateJsonMap.put("errMsg", "");
        if (isRequired) {
            validateJsonMap.put("rules", "required:true");
        }
        validateJsonMap.put("validatetrigger", "focus keyup datachange");
        resultMap.put("validateJson", validateJsonMap);
        return resultMap;
    }

    public static Map<String, Object> assembleColModelF7(Map<String, Object> gridMainKeyIdMap, String name, String label, boolean isRequired) {
        gridMainKeyIdMap.put("name", name);
        gridMainKeyIdMap.put("label", label);
        gridMainKeyIdMap.put("frozen", false);
        gridMainKeyIdMap.put("width", 120);
        gridMainKeyIdMap.put("align", "left");
        gridMainKeyIdMap.put("key", false);
        gridMainKeyIdMap.put("edittype", "promptBox");
        gridMainKeyIdMap.put("editable", true);
        gridMainKeyIdMap.put("sorttype", "objectvalue");
        gridMainKeyIdMap.put("sortable", false);
        gridMainKeyIdMap.put("formatter", "promptBox");
        if (isRequired) {
            gridMainKeyIdMap.put("classes", "required");
        }
        return gridMainKeyIdMap;
    }

    public static Map<String, Object> assembleColModelF7NotEdit(Map<String, Object> gridMainKeyIdMap, String name, String label) {
        gridMainKeyIdMap.put("name", name);
        gridMainKeyIdMap.put("label", label);
        gridMainKeyIdMap.put("frozen", false);
        gridMainKeyIdMap.put("width", 120);
        gridMainKeyIdMap.put("align", "left");
        gridMainKeyIdMap.put("key", false);
        gridMainKeyIdMap.put("edittype", "promptBox");
        gridMainKeyIdMap.put("editable", false);
        gridMainKeyIdMap.put("sorttype", "objectvalue");
        gridMainKeyIdMap.put("sortable", false);
        gridMainKeyIdMap.put("formatter", "promptBox");
        gridMainKeyIdMap.put("classes", "disabled");
        return gridMainKeyIdMap;
    }

    public static Map<String, Object> assembleColModelF7Hidden(Map<String, Object> gridMainKeyIdMap, String name, String label) {
        gridMainKeyIdMap.put("name", name);
        gridMainKeyIdMap.put("label", label);
        gridMainKeyIdMap.put("frozen", false);
        gridMainKeyIdMap.put("width", 120);
        gridMainKeyIdMap.put("hidden", true);
        gridMainKeyIdMap.put("align", "left");
        gridMainKeyIdMap.put("key", false);
        gridMainKeyIdMap.put("edittype", "promptBox");
        gridMainKeyIdMap.put("editable", false);
        gridMainKeyIdMap.put("sorttype", "objectvalue");
        gridMainKeyIdMap.put("sortable", false);
        gridMainKeyIdMap.put("formatter", "promptBox");
        gridMainKeyIdMap.put("classes", "disabled");
        return gridMainKeyIdMap;
    }

    public static Map<String, Object> getBillColumnListAndQuerySql(Context ctx, String submitSchemeId, String billID) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget,e.FIsEnableSubmitElement , m.fieldSn,m.FDataDot,m.fdataType,m.fname_" + language + " ,n.FBillEntryTableName from  T_HR_SCalSubmitScheme e " + " inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid " + " inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID " + " inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid  " + " where e.fid = '" + submitSchemeId + "'  order by FSortSn ";
        StringBuilder sd = new StringBuilder(" select t.fid id ,  t.FEffectDate effectDay , t.FCmpEmpORelationID cmpEmpORelation,");
        colNames.add("id");
        colNames.add("effectDay");
        try {
            String submitTarget = "";
            String fBillEntryTableName = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean f7Flag = true;
            boolean personFlag = true;
            boolean isEnableSubmitElement = false;
            while (rs.next()) {
                submitTarget = rs.getString("FSubmitTarget");
                isEnableSubmitElement = rs.getBoolean("FIsEnableSubmitElement");
                if (f7Flag) {
                    f7Flag = false;
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                    if ("02".equals(submitTarget)) {
                        personFlag = false;
                        colNames.add("orgId");
                        colNames.add("name");
                        colNames.add("number");
                        sd.append("n.fid orgId , n.fname_").append(language).append(" name , n.fnumber number ");
                    } else {
                        colNames.add("personId");
                        colNames.add("name");
                        colNames.add("number");
                        colNames.add("admOrgId");
                        colNames.add("admOrgName");
                        colNames.add("positionId");
                        colNames.add("positionName");
                        colNames.add("cmpEmpORelation");
                        sd.append(" n.fid personId , n.fname_").append(language).append("  name, n.fnumber number, a.fid admOrgId, a.fname_").append(language).append(" admOrgName, p.fid positionId, p.fname_").append(language).append(" positionName  ");
                    }
                }
                sd.append(",S" + rs.getString("fieldSn"));
                colNames.add("S" + rs.getString("fieldSn"));
                if ("0".equals(rs.getString("fdataType"))) {
                    // empty if block
                }
                columnMap.put("S" + rs.getString("fieldSn"), rs.getInt("FDataDot"));
            }
            colNames.add("description");
            if (isEnableSubmitElement) {
                colNames.add("submitElement");
                sd.append(", t.FSubmitElementID submitElement,subele.Fname_").append(language).append(" submitElementName ");
            }
            colNames.add("currency");
            sd.append(",c.fid currency,c.fname_").append(language).append(" currencyName,t.fdescription_l1 description_l1,t.fdescription_l2 description_l2,t.fdescription_l3 description_l3");
            sd.append(" from   " + fBillEntryTableName + " ");
            if (personFlag) {
                sd.append(" t  inner join t_bd_person n on t.fpersonId = n.fid ");
                sd.append(" LEFT join T_ORG_Admin a on t.FAdminOrgUnitID = a.fid ");
                sd.append(" LEFT join T_ORG_Position p on t.FPositionID = p.fid ");
            } else {
                sd.append(" t on b.fid = t.fbillid  inner join T_ORG_Admin  n on t.FOrgUnitID = n.fid ");
            }
            sd.append(" LEFT join T_BD_Currency c on t.fCurrencyID = c.fid ");
            if (isEnableSubmitElement) {
                sd.append(" LEFT join T_HR_SSubmitElement subele on t.FSubmitElementID = subele.fid ");
            }
            sd.append(" where t.fbillid = '" + billID + "'");
            map.put("querySql", sd.toString());
            map.put("colNames", colNames);
            map.put("columnMap", columnMap);
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        return map;
    }

    public static Map<String, Object> getBillColumnListAndBillEntryTableName(Context ctx, String submitSchemeId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget , m.fieldSn,m.fdataType,m.fname_" + language + " ,n.FBillEntryTableName ,n.FCalShemeTableName ,t.FIsRequired from  T_HR_SCalSubmitScheme e " + " inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid " + " inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID " + " inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid  " + " where e.fid = '" + submitSchemeId + "'  order by FSortSn ";
        try {
            String fBillEntryTableName = "";
            logger.error((Object)("CmpIntegrateUtilsNew.getBillColumnListAndBillEntryTableName.sql:" + sql));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                if (StringUtils.isEmpty((CharSequence)fBillEntryTableName)) {
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                }
                colNames.add("S" + rs.getString("fieldSn"));
                colTypes.add(rs.getString("fdataType"));
            }
            map.put("fBillEntryTableName", fBillEntryTableName);
            map.put("colNames", colNames);
            map.put("colTypes", colTypes);
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        return map;
    }

    public static String getAssembleField1Sql(Context ctx, String billEntryTable, List<String> colNames, String billId) {
        StringBuilder insertCol = new StringBuilder(" insert into ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date date = new Date();
        insertCol.append(billEntryTable);
        insertCol.append(" (FID ,fparentid ");
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
        }
        insertCol.append(" )");
        return insertCol.toString();
    }

    public static String getAssembleField2Sql(Context ctx, String billEntryTable, List<String> colNames, String billId) {
        StringBuilder insertCol = new StringBuilder(" insert into ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date date = new Date();
        insertCol.append(billEntryTable);
        insertCol.append(" (FID ,fbillid ");
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
        }
        insertCol.append(" )");
        return insertCol.toString();
    }

    public static List<Map<String, Object>> getAssembleListByCmp(Context ctx, String billEntryTable, List<String> colNames, String billId) throws BOSException {
        ArrayList<Map<String, Object>> sValuelist = new ArrayList<Map<String, Object>>();
        StringBuilder sql = new StringBuilder(" SELECT ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        sql.append(" FID ,fbillid ");
        for (String schemeItem : colNames) {
            sql.append("," + schemeItem);
        }
        sql.append(" from ");
        sql.append(billEntryTable);
        sql.append(" where fbillid = '" + billId + "'");
        logger.error((Object)("BatchSubmitSchemeBillControllerBeanExt.getAssembleListByCmp.sql:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String fid = "";
            String fbillid = "";
            while (rs.next()) {
                HashMap<String, Object> sValueMap = new HashMap<String, Object>();
                fid = rs.getString("FID");
                fbillid = rs.getString("fbillid");
                sValueMap.put("fid", fid);
                sValueMap.put("fbillid", fbillid);
                for (String schemeItem : colNames) {
                    sValueMap.put(schemeItem, rs.getObject(schemeItem));
                }
                sValuelist.add(sValueMap);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        return sValuelist;
    }

    public static void updateSchemeBillEntryByCmpS(Context ctx, List<String> colNames, Map<String, Object> sValue) throws BOSException {
        Object fidObj;
        logger.error((Object)("into updateSchemeBillEntryByCmpS method.colNames.size:" + colNames.size()));
        StringBuilder sqlSb = new StringBuilder(" update T_HR_SchemeBillEntry set ");
        Object cmpObje = null;
        String s81ValueId = "";
        for (String schemeItem : colNames) {
            cmpObje = sValue.get(schemeItem);
            if (cmpObje instanceof String) {
                sqlSb.append(" CF" + schemeItem).append("='").append(cmpObje).append("',");
                if (!"S81".equals(schemeItem) || cmpObje == null) continue;
                s81ValueId = (String)cmpObje;
                continue;
            }
            sqlSb.append(" CF" + schemeItem).append("=").append(cmpObje).append(",");
        }
        String sqlSbStr = sqlSb.toString();
        if (sqlSbStr.endsWith(",")) {
            sqlSbStr = sqlSbStr.substring(0, sqlSbStr.length() - 1);
        }
        if ((fidObj = sValue.get("fid")) == null) {
            logger.error((Object)"BatchSubmitSchemeBillControllerBeanExt.updateSchemeBillEntryByCmpS:fidObj\u4e3a\u7a7a");
            return;
        }
        String fid = (String)fidObj;
        sqlSbStr = String.valueOf(sqlSbStr) + " where fid = '" + fid + "'";
        logger.error((Object)("BatchSubmitSchemeBillControllerBeanExt.updateSchemeBillEntryByCmpS:sqlSbStr:" + sqlSbStr));
        DbUtil.execute((Context)ctx, (String)sqlSbStr);
        CmpIntegrateUtilsNew.updateSchemeBillEntryCFTaxExemptionStrByEntryFid(ctx, s81ValueId, fid);
    }

    private static void updateSchemeBillEntryCFTaxExemptionStrByEntryFid(Context ctx, String s81ValueId, String fid) throws BOSException {
        String sql = "update T_HR_SchemeBillEntry set cftaxexemptionstr = (select fname_l1 from CT_CUS_TaxExemption where fid ='" + s81ValueId + "' ) where fid ='" + fid + "'";
        logger.error((Object)("BatchSubmitSchemeBillControllerBeanExt.updateSchemeBillEntryCFTaxExemptionStrByEntryFid:sql:" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static Map<String, Object> getBillColumnListAndBillEntryTableNameByDataType(Context ctx, String submitSchemeId, String dataType) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget , m.fieldSn,m.fdataType,m.fname_" + language + " ,n.FBillEntryTableName ,n.FCalShemeTableName ,t.FIsRequired from  T_HR_SCalSubmitScheme e " + " inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid " + " inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID " + " inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid  " + " where e.fid = '" + submitSchemeId + "' and m.fdataType = '" + dataType + "'  order by FSortSn ";
        try {
            String fBillEntryTableName = "";
            String fCalShemeTableName = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                if (StringUtils.isEmpty((CharSequence)fBillEntryTableName)) {
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                    fCalShemeTableName = rs.getString("FCalShemeTableName");
                }
                colNames.add("S" + rs.getString("fieldSn"));
            }
            map.put("fBillEntryTableName", fBillEntryTableName);
            map.put("fCalShemeTableName", fCalShemeTableName);
            map.put("colNames", colNames);
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        return map;
    }

    public static String getSchemeEntryTableName(Context ctx, String submitSchemeId) {
        String fBillEntryTableName = "";
        String sql = "Select n.FBillEntryTableName  from  T_HR_SCalSubmitScheme e  inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid   where e.fid = '" + submitSchemeId + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                fBillEntryTableName = rs.getString("FBillEntryTableName");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return fBillEntryTableName;
    }

    public static String getCalShemeTableName(Context ctx, String submitSchemeId) {
        String calShemeTableName = "";
        String sql = "Select n.FBillEntryTableName  from  T_HR_SCalSubmitScheme e  inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid   where e.fid = '" + submitSchemeId + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                calShemeTableName = rs.getString("FBillEntryTableName");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return calShemeTableName;
    }

    public static boolean deleteSubmitSchemeRelationDate(Context ctx, String schemeId) throws BOSException, SQLException {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "select FBillEntryTableName , FCalShemeTableName  from T_HR_SCalShemeTableRelation where FSubmitSchemeID = '" + schemeId + "'";
        String calShemeTableName = "";
        String billEntryTableName = "";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (list.next()) {
            billEntryTableName = list.getString("FBillEntryTableName");
            calShemeTableName = list.getString("FCalShemeTableName");
        }
        if (!CmpStrUtil.isEmpty((String)calShemeTableName)) {
            DbUtil.execute((Context)ctx, (String)("If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + calShemeTableName + "') drop table " + calShemeTableName));
            DbUtil.execute((Context)ctx, (String)("If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + billEntryTableName + "') drop table " + billEntryTableName));
        }
        DbUtil.execute((Context)ctx, (String)("delete   from T_HR_SCalShemeTableRelation where FSubmitSchemeID = '" + schemeId + "'"));
        return flag;
    }

    public static boolean dropSubmitSchemeEntryTableCol(Context ctx, String schemeId, String itemId) throws BOSException, SQLException {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "select FBillEntryTableName , FCalShemeTableName  from T_HR_SCalShemeTableRelation where FSubmitSchemeID = '" + schemeId + "'";
        String sqlItem = "select fieldSn from  T_HR_SCalSubmitItem m  inner join  T_HR_SCalSubmitSchemeItem t on m.fid = t.FCalSubmitItemID  where t.fid  = '" + itemId + "'";
        String calShemeTableName = "";
        String billEntryTableName = "";
        String col = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            billEntryTableName = rs.getString("FBillEntryTableName");
            calShemeTableName = rs.getString("FCalShemeTableName");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
        while (rs.next()) {
            col = "S" + rs.getString("fieldSn");
        }
        StringBuilder calShemeTable = new StringBuilder("If  exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + col + "' " + " and KSQL_COL_TABNAME='" + calShemeTableName + "')");
        calShemeTable.append("ALTER TABLE " + calShemeTableName + " drop column " + col + " ");
        StringBuilder billEntryTable = new StringBuilder("If  exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + col + "' " + " and KSQL_COL_TABNAME='" + billEntryTableName + "')");
        billEntryTable.append("ALTER TABLE " + billEntryTableName + " drop column " + col + " ");
        if (!CmpStrUtil.isEmpty((String)calShemeTableName)) {
            DbUtil.execute((Context)ctx, (String)calShemeTable.toString());
            DbUtil.execute((Context)ctx, (String)billEntryTable.toString());
        }
        return flag;
    }

    public static Map<String, Object> getRequiredColumns(Context ctx, String submitSchemeId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList colNames = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget , m.fieldSn,m.fdataType,m.fname_" + language + " MNAME,n.FBillEntryTableName ,n.FCalShemeTableName ,t.FIsRequired" + " from  T_HR_SCalSubmitScheme e " + " inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid " + " inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID " + " inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid  " + " where e.fid = '" + submitSchemeId + "' order by fieldSn ";
        String submitTarget = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                HashMap<String, String> gridIdMap = new HashMap<String, String>();
                gridIdMap.put("rename", rs.getString("MNAME"));
                gridIdMap.put("name", "CMP_SMT002.S" + rs.getString("fieldSn"));
                gridIdMap.put("label", rs.getString("MNAME"));
                gridIdMap.put("type", "String");
                submitTarget = rs.getString("FSubmitTarget");
                colNames.add(gridIdMap);
            }
            map.put("colNames", colNames);
            map.put("submitTarget", submitTarget);
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u63d0\u62a5\u65b9\u6848\u7684\u63d0\u62a5\u9879\u76ee\u5217\u51fa\u9519\uff01");
        }
        return map;
    }

    public static List<CalShemeSubmitItemDTO> getDynamicSubmitItemBySchemeId(Context ctx, String schemeId) {
        ArrayList<CalShemeSubmitItemDTO> calShemeSubmitItemDTOS = new ArrayList<CalShemeSubmitItemDTO>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT E.FID AS SCHEMEID, M.FID as ITEMID,  M.FIELDSN,M.FDATATYPE,M.FNAME_" + language + " AS ITEMNAME,T.FISREQUIRED ,M.FDATADOT,M.FDATALENGTH ");
        sqlBuffer.append(" FROM  T_HR_SCALSUBMITSCHEME E  ");
        sqlBuffer.append(" INNER JOIN  T_HR_SCALSUBMITSCHEMEITEM T ON T.FCALSUBMITSCHEMEID = E.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_SCALSUBMITITEM M ON  M.FID = T.FCALSUBMITITEMID WHERE E.FID = '");
        sqlBuffer.append(schemeId);
        sqlBuffer.append("' ORDER BY T.FSORTSN");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            CalShemeSubmitItemDTO calShemeSubmitItemDTO = null;
            while (rs.next()) {
                calShemeSubmitItemDTO = new CalShemeSubmitItemDTO();
                calShemeSubmitItemDTO.setSubmitSchemeId(rs.getString("SCHEMEID"));
                calShemeSubmitItemDTO.setItemId(rs.getString("ITEMID"));
                calShemeSubmitItemDTO.setFieldSn(Integer.valueOf(rs.getInt("FIELDSN")));
                calShemeSubmitItemDTO.setDataType(rs.getString("FDATATYPE"));
                calShemeSubmitItemDTO.setSubmitItemName(rs.getString("ITEMNAME"));
                calShemeSubmitItemDTO.setIsRequired(Integer.valueOf(rs.getInt("FISREQUIRED")));
                calShemeSubmitItemDTO.setDataDot(Integer.valueOf(rs.getInt("FDATADOT")));
                calShemeSubmitItemDTO.setDataLength(Integer.valueOf(rs.getInt("FDATALENGTH")));
                calShemeSubmitItemDTOS.add(calShemeSubmitItemDTO);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return calShemeSubmitItemDTOS;
    }

    public static List<CalShemeSubmitItemDTO> getDynamicSubmitItemBySchemeIdNotCenter(Context ctx, String schemeId) {
        ArrayList<CalShemeSubmitItemDTO> calShemeSubmitItemDTOS = new ArrayList<CalShemeSubmitItemDTO>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT E.FID AS SCHEMEID, M.FID as ITEMID,  M.FIELDSN,M.FDATATYPE,M.FNAME_" + language + " AS ITEMNAME," + "T.FISREQUIRED ,M.FDATADOT,M.FDATALENGTH ");
        sqlBuffer.append(" FROM  T_HR_SCALSUBMITSCHEME E  ");
        sqlBuffer.append(" INNER JOIN  T_HR_SCALSUBMITSCHEMEITEM T ON T.FCALSUBMITSCHEMEID = E.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_SCALSUBMITITEM M ON  M.FID = T.FCALSUBMITITEMID WHERE E.FID = '");
        sqlBuffer.append(schemeId);
        sqlBuffer.append("'  and M.Fnumber not in('DormFee027','DormFee026')");
        sqlBuffer.append("   AND T.FState=1 ORDER BY T.FSORTSN");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            CalShemeSubmitItemDTO calShemeSubmitItemDTO = null;
            while (rs.next()) {
                calShemeSubmitItemDTO = new CalShemeSubmitItemDTO();
                calShemeSubmitItemDTO.setSubmitSchemeId(rs.getString("SCHEMEID"));
                calShemeSubmitItemDTO.setItemId(rs.getString("ITEMID"));
                calShemeSubmitItemDTO.setFieldSn(Integer.valueOf(rs.getInt("FIELDSN")));
                calShemeSubmitItemDTO.setDataType(rs.getString("FDATATYPE"));
                calShemeSubmitItemDTO.setSubmitItemName(rs.getString("ITEMNAME"));
                calShemeSubmitItemDTO.setIsRequired(Integer.valueOf(rs.getInt("FISREQUIRED")));
                calShemeSubmitItemDTO.setDataDot(Integer.valueOf(rs.getInt("FDATADOT")));
                calShemeSubmitItemDTO.setDataLength(Integer.valueOf(rs.getInt("FDATALENGTH")));
                calShemeSubmitItemDTOS.add(calShemeSubmitItemDTO);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return calShemeSubmitItemDTOS;
    }

    public static List<CalShemeSubmitItemDTO> getDynamicSubmitItemBySchemeIdExcludePaid(Context ctx, String schemeId) {
        ArrayList<CalShemeSubmitItemDTO> calShemeSubmitItemDTOS = new ArrayList<CalShemeSubmitItemDTO>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT E.FID AS SCHEMEID, M.FID as ITEMID,  M.FIELDSN,M.FDATATYPE,M.FNAME_" + language + " AS ITEMNAME,T.FISREQUIRED ,M.FDATADOT,M.FDATALENGTH ");
        sqlBuffer.append(" FROM  T_HR_SCALSUBMITSCHEME E  ");
        sqlBuffer.append(" INNER JOIN  T_HR_SCALSUBMITSCHEMEITEM T ON T.FCALSUBMITSCHEMEID = E.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_SCALSUBMITITEM M ON  M.FID = T.FCALSUBMITITEMID WHERE E.FID = '");
        sqlBuffer.append(schemeId);
        sqlBuffer.append("' and M.fnumber not in('DormFee026','DormFee027') ORDER BY T.FSORTSN");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            CalShemeSubmitItemDTO calShemeSubmitItemDTO = null;
            while (rs.next()) {
                calShemeSubmitItemDTO = new CalShemeSubmitItemDTO();
                calShemeSubmitItemDTO.setSubmitSchemeId(rs.getString("SCHEMEID"));
                calShemeSubmitItemDTO.setItemId(rs.getString("ITEMID"));
                calShemeSubmitItemDTO.setFieldSn(Integer.valueOf(rs.getInt("FIELDSN")));
                calShemeSubmitItemDTO.setDataType(rs.getString("FDATATYPE"));
                calShemeSubmitItemDTO.setSubmitItemName(rs.getString("ITEMNAME"));
                calShemeSubmitItemDTO.setIsRequired(Integer.valueOf(rs.getInt("FISREQUIRED")));
                calShemeSubmitItemDTO.setDataDot(Integer.valueOf(rs.getInt("FDATADOT")));
                calShemeSubmitItemDTO.setDataLength(Integer.valueOf(rs.getInt("FDATALENGTH")));
                calShemeSubmitItemDTOS.add(calShemeSubmitItemDTO);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return calShemeSubmitItemDTOS;
    }

    public static Map<String, Integer> getCellLength(Context ctx, String schemeId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "Select m.fieldSn,m.FDataLength from  T_HR_SCalSubmitScheme e  inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid  inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID  where e.fid = '" + schemeId + "' and FDataType = '1' order by  FSortSn";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String fieldSn = String.valueOf(rs.getInt(1));
                Integer dataLength = rs.getInt(2);
                map.put(fieldSn, dataLength);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

