/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e.util;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class WorkflowHandleUtil {
    private static final String NOT_RUNNING = "open.not_running";
    private static final String NOT_STARTED = "open.not_running.not_started";
    private static final String RUNNING = "open.running";
    private static final String OPEN = "open";
    private static final String ROLLBACKED = "open.running.rollbacked";
    private static final String BLOCKED = "open.not_running.blocked";
    private static final String CLOSED = "closed";
    private static final String COMPLETED = "closed.completed";
    private static final String TERMINATED = "closed.terminated";
    private static final String ABORTED = "closed.aborted";
    private static final String SUSPENDED = "open.not_running.suspended";

    public static final String[] getIds(Map<String, Object> params, String idlist, String exceptionName) {
        List idList = (List)params.get(idlist);
        if (idList == null || idList.size() <= 0) {
            throw new IscBizException(exceptionName);
        }
        String[] Ids = new String[idList.size()];
        idList.toArray(Ids);
        return Ids;
    }

    public static final String handleEnum(String state) {
        if (state.isEmpty()) {
            return null;
        }
        String workflowState = null;
        if (NOT_RUNNING.equals(state) || NOT_STARTED.equals(state)) {
            workflowState = "Created";
        } else if (RUNNING.equals(state) || OPEN.equals(state) || ROLLBACKED.equals(state)) {
            workflowState = "Running";
        } else if (BLOCKED.equals(state)) {
            workflowState = "Suspended";
        } else if (CLOSED.equals(state) || COMPLETED.equals(state)) {
            workflowState = "Completed";
        } else if (TERMINATED.equals(state) || ABORTED.equals(state) || SUSPENDED.equals(state)) {
            workflowState = "Termimated";
        } else {
            throw new IscBizException("\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u72b6\u6001\u4e3a\uff1a" + state);
        }
        return workflowState;
    }

    public static final List<Map<String, Object>> getWorkFlowStateById(ConnectorContext ctx, String field, String[] ids) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT P.FPROCINSTID,P.FCREATEDTIME,P.FCOMLETETIME,P.FSTATE, ").append("P.FPROCINSTTOPIC_L1,P.FPROCDEFID,R.FREFID ").append("FROM T_WFR_PROCINST P  INNER JOIN T_WFR_ProcInstRef R ").append("ON P.FPROCINSTID = R.FPROCINSTID  ").append(WorkflowHandleUtil.generateWhereSql(field, ids.length)).append("ORDER BY P.FCREATEDTIME DESC");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        WorkflowHandleUtil.createValuesAndTypes(ids, values, types);
        ArrayList<Map<String, Object>> wfStateList = new ArrayList<Map<String, Object>>();
        ObjectReader reader = null;
        Connection cn = null;
        try {
            cn = ctx.getConnection();
            reader = DbUtil.executeQuery((Connection)cn, (String)sql.toString(), values, types);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("state", WorkflowHandleUtil.handleEnum(D.s((Object)row.get((Object)"fstate"))));
                map.put("startedTime", D.s((Object)row.get((Object)"fcreatedtime")));
                map.put("endTime", D.s((Object)row.get((Object)"fcomletetime")));
                map.put("procInstId", D.s((Object)row.get((Object)"fprocinstid")));
                map.put("procInstTitle", D.s((Object)row.get((Object)"fprocinsttopic_l1")));
                map.put("procDefId", D.s((Object)row.get((Object)"fprocdefid")));
                map.put("billObjId", D.s((Object)row.get((Object)"frefid")));
                wfStateList.add(map);
                row = (DataRow)reader.read();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(reader);
            ctx.dispose(cn);
            throw throwable;
        }
        DbUtil.close((ObjectReader)reader);
        ctx.dispose(cn);
        return wfStateList;
    }

    private static String generateWhereSql(String field, int num) {
        StringBuilder where = new StringBuilder("WHERE R.FTYPE = 1 and ");
        where.append("R.").append(field);
        where.append(" in(?");
        int i = 0;
        while (i < num - 1) {
            where.append(",?");
            ++i;
        }
        where.append(")");
        return where.toString();
    }

    private static final void createValuesAndTypes(String[] ids, List<Object> values, List<Integer> types) {
        int i = 0;
        while (i < ids.length) {
            values.add(ids[i]);
            types.add(12);
            ++i;
        }
    }
}

