/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import kd.isc.iscb.util.data.UniqueList;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Group;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.i.arithmetic.Graph;
import kd.isc.iscb.util.flow.core.i.c.composite.SubFlowIsDone;
import kd.isc.iscb.util.flow.core.i.model.AbstractExecutable;
import kd.isc.iscb.util.flow.core.i.model.AbstractVariableScope;
import kd.isc.iscb.util.flow.core.i.model.GroupImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.TransitionImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;
import kd.isc.iscb.util.flow.core.plugin.FlowExecutionSync;

public final class FlowImpl
extends AbstractVariableScope
implements Flow,
VariableScope {
    private Map<String, NodeImpl> nodes = new LinkedHashMap<String, NodeImpl>();
    private Map<String, TransitionImpl> transitions = new LinkedHashMap<String, TransitionImpl>();
    private UniqueList<VariableImpl> input = new UniqueList(4);
    private UniqueList<VariableImpl> output = new UniqueList(4);
    private Map<String, VariableImpl> variables = new HashMap<String, VariableImpl>();
    private List<VariableImpl> variable_addresses = new ArrayList<VariableImpl>();
    private Map<String, GroupImpl> groups = new HashMap<String, GroupImpl>();
    private Logger log;
    private boolean has_async_nodes = false;
    private NodeImpl root = new NodeImpl(this);
    private boolean is_sub_flow = false;
    private String crc;
    private int version;
    private String systemName;

    public FlowImpl(String id, String title, boolean isSubFlow, int version, String systemName) {
        super(id, title);
        this.is_sub_flow = isSubFlow;
        this.version = version;
        this.systemName = systemName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    public Logger getLogger() {
        return this.log;
    }

    @Override
    public boolean isSubFlow() {
        return this.is_sub_flow;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void setSynchronizer(FlowExecutionSync synchronizer) {
        if (this.is_sub_flow) {
            throw new IscBizException("'" + this + "' is subflow!");
        }
        this.root.setSynchronizer(synchronizer);
    }

    @Override
    public int variableCount() {
        return this.variable_addresses.size();
    }

    @Override
    public NodeImpl getNode(String id) {
        return this.nodes.get(id);
    }

    @Override
    public VariableImpl getVariable(int address) {
        return this.variable_addresses.get(address);
    }

    @Override
    public Map<String, ? extends Node> getNodes() {
        return this.nodes;
    }

    public GroupImpl getScope(String id) {
        return this.groups.get(id);
    }

    public Map<String, ? extends Group> getScopes() {
        return this.groups;
    }

    public List<VariableImpl> getOutputVariables() {
        return Collections.unmodifiableList(this.output);
    }

    public List<VariableImpl> getInputVariables() {
        return Collections.unmodifiableList(this.input);
    }

    void register(ProcessElement element) {
        String key = element.getId();
        ProcessElement original = null;
        if (element instanceof NodeImpl) {
            original = this.nodes.put(key, (NodeImpl)element);
        } else if (element instanceof GroupImpl) {
            original = this.groups.put(key, (GroupImpl)element);
        } else if (element instanceof VariableImpl) {
            VariableImpl v = (VariableImpl)element;
            original = this.variables.put(key, v);
            this.variable_addresses.add(v);
        } else if (element instanceof TransitionImpl) {
            original = this.transitions.put(key, (TransitionImpl)element);
        } else {
            throw new IllegalArgumentException();
        }
        if (original != null) {
            throw new IscBizException("Element '" + key + "' was registed!");
        }
    }

    public AbstractExecutable getExecutable(String id) {
        AbstractExecutable e = this.nodes.get(id);
        if (e == null) {
            e = this.variables.get(id);
        }
        if (e == null) {
            throw new IscBizException("Element '" + id + "' doesn't exist!");
        }
        return e;
    }

    public void addInput(String var) {
        VariableImpl variable = this.getVariable(var);
        if (variable == null) {
            throw new IscBizException("Variable '" + var + "' doesn't exist!");
        }
        if (!this.input.add(variable)) {
            throw new IscBizException("Variable '" + var + "' has been set as input parameter!");
        }
    }

    public void addOutput(String var) {
        VariableImpl variable = this.getVariable(var);
        if (variable == null) {
            throw new IscBizException("Variable '" + var + "' doesn't exist!");
        }
        if (!this.output.add(variable)) {
            throw new IscBizException("Variable '" + var + "' has been set as output parameter!");
        }
    }

    public void solidify() {
        this.compileMe();
        this.compileGroups();
        this.compileNodes();
        this.compileTransitions();
        this.compileVars();
        this.solidifyMyFields();
        this.generateCRC();
    }

    private void solidifyMyFields() {
        this.input.fix();
        this.output.fix();
        this.groups = Collections.unmodifiableMap(this.groups);
        this.nodes = Collections.unmodifiableMap(this.nodes);
    }

    private void compileVars() {
        for (VariableImpl var : this.variable_addresses) {
            var.compile();
        }
    }

    private void compileTransitions() {
        for (TransitionImpl tran : this.transitions.values()) {
            tran.compile();
        }
    }

    private void compileMe() {
        this.compile();
        this.root.insert(SubFlowIsDone.CMD);
        if (this.is_sub_flow && this.input.size() == 0) {
            throw new IscBizException("Subflow '" + this + "' has no input parameters!");
        }
    }

    private void compileNodes() {
        this.root.compile();
    }

    private void compileGroups() {
        for (GroupImpl group : this.groups.values()) {
            group.compile();
        }
    }

    @Override
    public NodeImpl getRoot() {
        return this.root;
    }

    @Override
    public TransitionImpl getTransition(String id) {
        return this.transitions.get(id);
    }

    @Override
    Map<String, VariableImpl> getOtherAvailableVariables() {
        return this.getVariables();
    }

    @Override
    public FlowRuntime newInstance() {
        return this.newInstance(null);
    }

    @Override
    public FlowRuntime newInstance(String id) {
        if (this.isSubFlow()) {
            throw new UnsupportedOperationException("'" + this + "' is subflow!");
        }
        return new RuntimeImpl(this, id);
    }

    @Override
    public String dumpMicroPrograms() {
        StringBuilder sb = new StringBuilder();
        sb.append("variables: ");
        for (VariableImpl v : this.variable_addresses) {
            v.dumpMicroProgram(sb);
        }
        sb.append("\r\n\r\n").append("nodes: ");
        this.root.dumpMicroProgram(sb, 0);
        sb.append("\r\n\r\n");
        this.root.dumpDiagram(sb);
        return sb.toString();
    }

    @Override
    public String dumpDiagram() {
        StringBuilder sb = new StringBuilder();
        this.root.dumpDiagram(sb);
        return sb.toString();
    }

    private void generateCRC() {
        CRC32 crc = new CRC32();
        for (VariableImpl v : this.variable_addresses) {
            v.updateCRC(crc);
            String s = v.getName();
            int j = 0;
            while (j < s.length()) {
                crc.update(s.charAt(j));
                ++j;
            }
        }
        for (NodeImpl n : this.nodes.values()) {
            n.updateCRC(crc);
        }
        this.crc = Integer.toHexString((int)crc.getValue()).toUpperCase(Locale.ENGLISH);
    }

    @Override
    public String getCrc() {
        return this.crc;
    }

    @Override
    public FlowRuntime fromJson(Map<String, Object> json) {
        return RuntimeImpl.fromJson(this, json);
    }

    @Override
    public GroupImpl getGroup(String id) {
        return this.groups.get(id);
    }

    @Override
    public Map<String, ? extends Group> getGroups() {
        return this.groups;
    }

    @Override
    public Graph getGraph() {
        return this.getRoot().getGraph();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowImpl other = (FlowImpl)obj;
        return this.getId().equals(other.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode() + 31;
    }

    public void setHasAsyncNodes() {
        this.has_async_nodes = true;
    }

    @Override
    public boolean hasAsyncNodes() {
        return this.has_async_nodes;
    }
}

