/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.string;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.tool.string.XmlObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Xml2JsonWithAttribute
implements NativeFunction {
    @Override
    public String name() {
        return "Xml2JsonWithAttribute";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        XmlObject xml = (XmlObject)args[0];
        if (xml == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
        Element element = xml.getElement();
        map.put(element.getTagName(), this.wrapValue(element));
        return map;
    }

    private Object wrapValue(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        NodeList childNodes = element.getChildNodes();
        if (attributes == null || attributes.getLength() == 0) {
            return this.handleNodeList(childNodes);
        }
        LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
        this.appendAttribute(children, attributes);
        this.appendChildNode(children, childNodes);
        return children;
    }

    private Object handleNodeList(NodeList childNodes) {
        int length = childNodes.getLength();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            Node e = childNodes.item(0);
            if (e instanceof Text) {
                return e.getTextContent();
            }
            return this.wrapNodeList(childNodes);
        }
        return this.wrapNodeList(childNodes);
    }

    private Object wrapNodeList(NodeList childNodes) {
        LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
        this.appendChildNode(children, childNodes);
        return children;
    }

    private void appendChildNode(Map<String, Object> children, NodeList childNodes) {
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                this.wrapElement(children, (Element)node);
            } else {
                String text = D.s(node.getTextContent());
                if (text != null) {
                    children.put("#text", text);
                }
            }
            ++i;
        }
    }

    private void appendAttribute(Map<String, Object> children, NamedNodeMap attributes) {
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attr = attributes.item(i);
                children.put("-" + attr.getNodeName(), attr.getNodeValue());
                ++i;
            }
        }
    }

    private void wrapElement(Map<String, Object> children, Element node) {
        String tagName = node.getTagName();
        Object value = this.wrapValue(node);
        Object old = children.get(tagName);
        if (old == null) {
            children.put(tagName, value);
        } else if (old instanceof List) {
            ((List)old).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(old);
            list.add(value);
            children.put(tagName, list);
        }
    }
}

