/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.text;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.util.Symbol;

public class SourceComparator {
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("^\\d\\d\\d\\d-\\d\\d?-\\d\\d?( |T)\\d\\d?:\\d\\d?:\\d\\d?([.]\\d+)?$");
    private static final int LARGE_STRING_SIZE = 2048;

    public static Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> compare(String a, String b) {
        return SourceComparator.compare(a, b, 350, 1, 3);
    }

    public static Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> compare(String a, String b, int maxLength, int minLength, int wcMinLength) {
        Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result = SourceComparator.prepareResult();
        if (a == null || b == null || a.equals(b)) {
            SourceComparator.output(a, b, result);
        } else if (SourceComparator.isDateTime(a, b)) {
            SourceComparator.outputDateTime(D.t(a), D.t(b), result);
        } else if (Hex.isNumber(a) && Hex.isNumber(b)) {
            SourceComparator.outputNumber(a, b, result);
        } else if (SourceComparator.isSourceString(b)) {
            StringFSM fsm = new StringFSM(30, b);
            String[] aa = SourceComparator.split(a);
            SourceComparator.compare(fsm, aa, 0, aa.length, 0, fsm.b.length, result, maxLength, minLength, wcMinLength);
        } else if (b.length() >= 2048) {
            int blockSize = Math.max(100, maxLength);
            SourceComparator.compare(new CharSharding(blockSize, a, b), a, b, maxLength, minLength, wcMinLength, result);
        } else {
            SourceComparator.compare(new CharFSM(b, maxLength, minLength, wcMinLength), a, 0, a.length(), 0, b.length(), result);
        }
        return SourceComparator.merge(result);
    }

    public static boolean isDateTime(String a, String b) {
        Pattern p = DATE_TIME_PATTERN;
        return p.matcher(a).matches() && p.matcher(b).matches();
    }

    private static boolean isSourceString(String b) {
        int count = 0;
        int i = 0;
        while (i < b.length()) {
            if (b.charAt(i) == '\n') {
                ++count;
            }
            ++i;
        }
        if (b.length() >= 1 && b.charAt(b.length() - 1) != '\n') {
            ++count;
        }
        return count * 50 >= b.length();
    }

    private static Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> merge(Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        int size = result.getA().size();
        if (size <= 1) {
            return result;
        }
        ArrayList<Pair<Flag, String>> a = new ArrayList<Pair<Flag, String>>(size);
        ArrayList<Pair<Flag, String>> b = new ArrayList<Pair<Flag, String>>(size);
        Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> merged = new Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>>(a, b);
        int j = size - 1;
        int i = 0;
        while (i < j) {
            Pair<Flag, String> p = result.getA().get(i);
            Pair<Flag, String> n = result.getA().get(i + 1);
            if (p.getA() == Flag.virgin && n.getA() == Flag.virgin) {
                Pair<Flag, String> x = new Pair<Flag, String>(Flag.virgin, String.valueOf(p.getB()) + n.getB());
                result.getA().set(i + 1, x);
                result.getB().set(i + 1, x);
            } else {
                a.add(result.getA().get(i));
                b.add(result.getB().get(i));
            }
            ++i;
        }
        a.add(result.getA().get(j));
        b.add(result.getB().get(j));
        return merged;
    }

    private static void compare(CharSharding sharding, String a, String b, int maxLength, int minLength, int wcMinLength, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        int startA = 0;
        int startB = 0;
        int beginA = 0;
        int j = a.length() - sharding.blockSize + 1;
        while (beginA < j) {
            int beginB = sharding.find(a, b, beginA, startB);
            if (beginB < 0) {
                ++beginA;
                continue;
            }
            int endA = beginA + sharding.blockSize;
            int endB = beginB + sharding.blockSize;
            int crlfA = endA;
            int crlfB = endB;
            boolean meetCrlf = false;
            while (endA < a.length() && endB < b.length()) {
                if (a.charAt(endA) != b.charAt(endB)) break;
                if (a.charAt(endA) == '\n') {
                    crlfA = endA + 1;
                    crlfB = endB + 1;
                    meetCrlf = true;
                }
                ++endA;
                ++endB;
            }
            if (meetCrlf) {
                endA = crlfA;
                endB = crlfB;
            }
            crlfA = --beginA;
            crlfB = --beginB;
            meetCrlf = false;
            while (beginA >= startA && beginB >= startB) {
                if (a.charAt(beginA) != b.charAt(beginB)) break;
                if (a.charAt(beginA) == '\n') {
                    crlfA = beginA - 1;
                    crlfB = beginB - 1;
                    meetCrlf = true;
                }
                --beginA;
                --beginB;
            }
            if (meetCrlf) {
                beginA = crlfA;
                beginB = crlfB;
            }
            String sa = a.substring(startA, ++beginA);
            String sb = b.substring(startB, ++beginB);
            SourceComparator.compare(new CharFSM(sb, maxLength, minLength, wcMinLength), sa, 0, sa.length(), 0, sb.length(), result);
            SourceComparator.output(a.substring(beginA, endA), b.substring(beginB, endB), result);
            startA = endA;
            startB = endB;
            beginA = endA;
        }
        String sa = a.substring(startA);
        String sb = b.substring(startB);
        SourceComparator.compare(new CharFSM(sb, maxLength, minLength, wcMinLength), sa, 0, sa.length(), 0, sb.length(), result);
    }

    private static void compare(StringFSM fsm, String[] a, int startA, int endA, int startB, int endB, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result, int maxLength, int minLength, int wcMinLength) {
        if (startA >= endA) {
            if (startB < endB) {
                SourceComparator.output(null, SourceComparator.join(fsm.b, startB, endB), result);
            }
        } else if (startB >= endB) {
            SourceComparator.output(SourceComparator.join(a, startA, endA), null, result);
        } else {
            Triple<Integer, Integer, Integer> t = fsm.find(a, startA, endA, startB, endB);
            int length = t.getC();
            if (length <= 0) {
                String sa = SourceComparator.join(a, startA, endA);
                String sb = SourceComparator.join(fsm.b, startB, endB);
                if (sb == null || sa == null) {
                    SourceComparator.output(sa, sb, result);
                } else {
                    CharFSM cm = new CharFSM(sb, maxLength, minLength, wcMinLength);
                    SourceComparator.compare(cm, sa, 0, sa.length(), 0, sb.length(), result);
                }
            } else {
                length = SourceComparator.extendsEnd(a, t.getA() + length, endA, fsm.b, t.getB() + length, endB, length);
                SourceComparator.compare(fsm, a, startA, t.getA(), startB, t.getB(), result, maxLength, minLength, wcMinLength);
                String common = SourceComparator.join(a, t.getA(), t.getA() + length);
                SourceComparator.output(common, common, result);
                SourceComparator.compare(fsm, a, t.getA() + length, endA, t.getB() + length, endB, result, maxLength, minLength, wcMinLength);
            }
        }
    }

    private static int extendsEnd(String[] a, int startA, int endA, String[] b, int startB, int endB, int length) {
        while (startA < endA && startB < endB && a[startA].equals(b[startB])) {
            ++startA;
            ++startB;
            ++length;
        }
        return length;
    }

    private static void compare(CharFSM fsm, String a, int startA, int endA, int startB, int endB, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        if (startA >= endA) {
            if (startB < endB) {
                SourceComparator.output(null, fsm.b.substring(startB, endB), result);
            }
        } else if (startB >= endB) {
            SourceComparator.output(a.substring(startA, endA), null, result);
        } else {
            Triple<Integer, Integer, Integer> t = fsm.find(a, startA, endA, startB, endB);
            int length = t.getC();
            if (length <= 0) {
                SourceComparator.output(a.substring(startA, endA), fsm.b.substring(startB, endB), result);
            } else {
                length = SourceComparator.extendsEnd(a, t.getA() + length, endA, fsm.b, t.getB() + length, endB, length);
                SourceComparator.compare(fsm, a, startA, (int)t.getA(), startB, (int)t.getB(), result);
                String common = a.substring(t.getA(), t.getA() + length);
                SourceComparator.output(common, common, result);
                SourceComparator.compare(fsm, a, t.getA() + length, endA, t.getB() + length, endB, result);
            }
        }
    }

    private static int extendsEnd(String a, int startA, int endA, String b, int startB, int endB, int length) {
        while (startA < endA && startB < endB && a.charAt(startA) == b.charAt(startB)) {
            ++startA;
            ++startB;
            ++length;
        }
        return length;
    }

    private static Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> prepareResult() {
        ArrayList la = new ArrayList();
        ArrayList lb = new ArrayList();
        Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result = new Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>>(la, lb);
        return result;
    }

    private static void output(String a, String b, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        if (a == null) {
            if (b != null) {
                result.getA().add(new Pair<Flag, String>(Flag.appended, ""));
                result.getB().add(new Pair<Flag, String>(Flag.appended, b));
            }
        } else if (b == null) {
            result.getA().add(new Pair<Flag, String>(Flag.deleted, a));
            result.getB().add(new Pair<Flag, String>(Flag.deleted, ""));
        } else if (a.equals(b)) {
            Pair<Flag, String> e = new Pair<Flag, String>(Flag.virgin, a);
            result.getA().add(e);
            result.getB().add(e);
        } else {
            result.getA().add(new Pair<Flag, String>(Flag.changed, a));
            result.getB().add(new Pair<Flag, String>(Flag.changed, b));
        }
    }

    private static void outputNumber(String a, String b, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        if (a.length() < 7 || b.length() < 7) {
            SourceComparator.output(a, b, result);
        } else {
            int maxLength = Math.max(a.length(), b.length());
            String sa = SourceComparator.paddingBlank(a, maxLength);
            String sb = SourceComparator.paddingBlank(b, maxLength);
            int from = 0;
            boolean flag = true;
            int i = 0;
            while (i < maxLength) {
                boolean x;
                boolean bl = x = sa.charAt(i) == sb.charAt(i);
                if (x != flag) {
                    SourceComparator.output(sa.substring(from, i).trim(), sb.substring(from, i).trim(), result);
                    flag = x;
                    from = i;
                }
                ++i;
            }
            SourceComparator.output(sa.substring(from).trim(), sb.substring(from).trim(), result);
        }
    }

    private static String paddingBlank(String s, int maxLength) {
        return SourceComparator.paddingLeft(s, ' ', maxLength);
    }

    private static String paddingZero(String s, int maxLength) {
        return SourceComparator.paddingLeft(s, '0', maxLength);
    }

    private static String paddingLeft(String s, char c, int maxLength) {
        if (s.length() == maxLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = maxLength - s.length();
        while (i < j) {
            sb.append(c);
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    private static void outputDateTime(Timestamp a, Timestamp b, Pair<List<Pair<Flag, String>>, List<Pair<Flag, String>>> result) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(a);
        Calendar cb = Calendar.getInstance();
        cb.setTime(b);
        SourceComparator.output(String.valueOf(ca.get(1)), String.valueOf(cb.get(1)), result);
        SourceComparator.output("-", "-", result);
        SourceComparator.output(String.valueOf(ca.get(2) + 1), String.valueOf(cb.get(2) + 1), result);
        SourceComparator.output("-", "-", result);
        SourceComparator.output(String.valueOf(ca.get(5)), String.valueOf(cb.get(5)), result);
        SourceComparator.output(" ", " ", result);
        SourceComparator.output(String.valueOf(ca.get(11)), String.valueOf(cb.get(11)), result);
        SourceComparator.output(":", ":", result);
        SourceComparator.output(String.valueOf(ca.get(12)), String.valueOf(cb.get(12)), result);
        SourceComparator.output(":", ":", result);
        SourceComparator.output(String.valueOf(ca.get(13)), String.valueOf(cb.get(13)), result);
        SourceComparator.output(".", ".", result);
        String msa = SourceComparator.paddingZero(String.valueOf(ca.get(14)), 3);
        String msb = SourceComparator.paddingZero(String.valueOf(cb.get(14)), 3);
        SourceComparator.output(msa, msb, result);
    }

    private static String join(String[] a, int start, int end) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < end) {
            sb.append(a[i]);
            ++i;
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static String[] split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = s.length();
        while (i < j) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\n') {
                list.add(sb.toString());
                sb = new StringBuilder();
            }
            ++i;
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private static <O> State<O> createNextState(State<O> current, O c, int i, int j) {
        State next = (State)((State)current).next.get(c);
        if (next == null) {
            next = new State(j - i + 1);
            ((State)current).put(c, next);
        }
        next.add(i);
        return next;
    }

    private static <O> int findBeginB(State<O> matched, int start, int end) {
        int r = -1;
        int i = 0;
        int j = ((State)matched).count;
        while (i < j) {
            int p = ((State)matched).start[i];
            if (p >= start && p + ((State)matched).length <= end) {
                if (((State)matched).length > 1) {
                    return p;
                }
                r = p;
            }
            ++i;
        }
        return r;
    }

    private static class CharFSM {
        private int maxLength = 30;
        private int minLength = 2;
        private int wcMinLength = 3;
        private State<Character> start = new State(0);
        private String b;

        private CharFSM(String s, int maxLength, int minLength, int wcMinLength) {
            this.b = s;
            this.maxLength = maxLength;
            this.minLength = minLength;
            this.wcMinLength = wcMinLength;
            int i = 0;
            int m = s.length();
            while (i < m) {
                int n = Math.min(i + maxLength, m);
                State current = this.start;
                int j = i;
                while (j < n) {
                    current = SourceComparator.createNextState(current, Character.valueOf(s.charAt(j)), i, j);
                    ++j;
                }
                ++i;
            }
        }

        public Triple<Integer, Integer, Integer> find(String a, int startA, int endA, int startB, int endB) {
            Pair<Integer, State<Character>> matched = null;
            State<Character> current = this.start;
            int i = startA;
            while (i < endA) {
                Character c = Character.valueOf(a.charAt(i));
                State<Character> next = (State<Character>)((State)current).next.get(c);
                if (next != null && SourceComparator.findBeginB(next, startB, endB) >= 0) {
                    ++i;
                    current = next;
                    if (((State)current).length != this.maxLength) continue;
                    break;
                }
                matched = this.recordTempResult(a, current, i, matched);
                i = ++startA;
                current = this.start;
            }
            matched = this.recordTempResult(a, current, i, matched);
            if (matched == null) {
                return new Triple<Integer, Integer, Integer>(startA, startB, 0);
            }
            int beginA = matched.getA();
            int beginB = SourceComparator.findBeginB(matched.getB(), startB, endB);
            int length = ((State)matched.getB()).length;
            return new Triple<Integer, Integer, Integer>(beginA, beginB, length);
        }

        private boolean isPartOfWord(String a, int beginA, int length) {
            if (length >= this.wcMinLength) {
                return false;
            }
            int endA = beginA + length;
            int x = beginA;
            int y = endA;
            while (x < y) {
                if (!Symbol.isAlphabet(a.charAt(x))) {
                    return false;
                }
                ++x;
            }
            return beginA == 0 || endA == a.length() || Symbol.isAlphabet(a.charAt(beginA - 1)) || Symbol.isAlphabet(a.charAt(endA));
        }

        private Pair<Integer, State<Character>> recordTempResult(String a, State<Character> current, int endA, Pair<Integer, State<Character>> matched) {
            int length = ((State)current).length;
            if (length <= 0) {
                return matched;
            }
            int beginA = endA - ((State)current).length;
            if (length < this.minLength) {
                if (Symbol.isSeperator(a.charAt(beginA))) {
                    return CharFSM.compareAndSelect(current, matched, length, beginA);
                }
                if (Symbol.isSeperator(a.charAt(endA - 1))) {
                    return CharFSM.compareAndSelect(current, matched, length, beginA);
                }
                return matched;
            }
            if (this.isPartOfWord(a, beginA, length)) {
                return matched;
            }
            return CharFSM.compareAndSelect(current, matched, length, beginA);
        }

        private static <O> Pair<Integer, State<O>> compareAndSelect(State<O> current, Pair<Integer, State<O>> matched, int length, int beginA) {
            if (matched == null) {
                matched = new Pair<Integer, State<O>>(beginA, current);
            } else if (length > ((State)matched.getB()).length) {
                matched = new Pair<Integer, State<O>>(beginA, current);
            }
            return matched;
        }
    }

    private static class CharSharding {
        private int blockSize;
        private Map<Integer, List<Integer>> hashB;

        private CharSharding(int blockSize, String a, String b) {
            this.blockSize = blockSize;
            this.initB(b);
        }

        private int find(String a, String b, int beginA, int startB) {
            int hash = CharSharding.calcHash(a, beginA, beginA + this.blockSize);
            List<Integer> position = this.hashB.get(hash);
            if (position == null) {
                return -1;
            }
            for (int j : position) {
                int beginB = j;
                if (beginB < startB || beginB >= b.length() || !this.equals(a, b, beginA, beginB)) continue;
                return beginB;
            }
            return -1;
        }

        private boolean equals(String a, String b, int beginA, int beginB) {
            int i = 0;
            while (i < this.blockSize) {
                if (a.charAt(beginA) != b.charAt(beginB)) {
                    return false;
                }
                ++i;
                ++beginA;
                ++beginB;
            }
            return true;
        }

        private void initB(String b) {
            this.hashB = new HashMap<Integer, List<Integer>>(b.length());
            int i = this.blockSize;
            while (i < b.length()) {
                int start = i - this.blockSize;
                int key = CharSharding.calcHash(b, start, i);
                List<Integer> position = this.hashB.get(key);
                if (position == null) {
                    position = new ArrayList<Integer>(2);
                    this.hashB.put(key, position);
                }
                position.add(start);
                ++i;
            }
        }

        private static int calcHash(String s, int start, int end) {
            int hash = 31;
            int i = start;
            while (i < end) {
                char c = s.charAt(i);
                hash = (hash << 5) - hash + c;
                ++i;
            }
            return hash;
        }
    }

    public static enum Flag {
        changed,
        appended,
        deleted,
        virgin;

    }

    private static class State<O> {
        private Map<O, State<O>> next = Collections.EMPTY_MAP;
        private int length;
        private int[] start = null;
        private int count = 0;

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.length).append(':');
            if (this.start != null) {
                int[] nArray = this.start;
                int n = this.start.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (i >= 0) {
                        s.append(i).append(' ');
                    }
                    ++n2;
                }
            }
            return s.toString();
        }

        public State(int length) {
            this.length = length;
        }

        private void add(int start) {
            if (this.start == null) {
                this.start = new int[2];
            } else if (this.count == this.start.length) {
                int[] tmp = new int[this.count + (this.count >> 1)];
                System.arraycopy(this.start, 0, tmp, 0, this.count);
                this.start = tmp;
            }
            this.start[this.count] = start;
            ++this.count;
        }

        private void put(O c, State<O> s) {
            if (this.next == Collections.EMPTY_MAP) {
                this.next = new HashMap<O, State<O>>(4);
            }
            this.next.put(c, s);
        }
    }

    private static class StringFSM {
        private int maxLength;
        private State<String> start = new State(0);
        private String[] b;

        private StringFSM(int maxLength, String b) {
            this.maxLength = maxLength;
            this.b = SourceComparator.split(b);
            this.init();
        }

        public Triple<Integer, Integer, Integer> find(String[] a, int startA, int endA, int startB, int endB) {
            Triple<Integer, State<String>, Integer> matched = null;
            State<String> current = this.start;
            int i = startA;
            int length = 0;
            while (i < endA) {
                String c = a[i];
                State<String> next = (State<String>)((State)current).next.get(c);
                if (next != null && SourceComparator.findBeginB(next, startB, endB) >= 0) {
                    ++i;
                    current = next;
                    length += c.length();
                    if (((State)current).length != this.maxLength) continue;
                    break;
                }
                matched = this.recordTempResult(current, i, matched, length);
                i = ++startA;
                current = this.start;
                length = 0;
            }
            matched = this.recordTempResult(current, i, matched, length);
            if (matched == null) {
                return new Triple<Integer, Integer, Integer>(startA, startB, 0);
            }
            int beginA = matched.getA();
            int beginB = SourceComparator.findBeginB(matched.getB(), startB, endB);
            int count = ((State)matched.getB()).length;
            return new Triple<Integer, Integer, Integer>(beginA, beginB, count);
        }

        private Triple<Integer, State<String>, Integer> recordTempResult(State<String> current, int endA, Triple<Integer, State<String>, Integer> matched, int length) {
            int beginA = endA - ((State)current).length;
            if (((State)current).length == 0) {
                return matched;
            }
            if (matched == null) {
                matched = new Triple<Integer, State<String>, Integer>(beginA, current, length);
            } else if (length > matched.getC()) {
                matched = new Triple<Integer, State<String>, Integer>(beginA, current, length);
            }
            return matched;
        }

        private void init() {
            int i = 0;
            while (i < this.b.length) {
                int n = Math.min(this.b.length, i + this.maxLength);
                State current = this.start;
                int j = i;
                while (j < n) {
                    current = SourceComparator.createNextState(current, this.b[j], i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

