/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.e.DbInfo;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;

public class GetTables
extends AbstractCommandExecutor {
    @Override
    public String getCommand() {
        return "get_tables";
    }

    @Override
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        return GetTables.get(ctx);
    }

    public static List<String> get(ConnectorContext ctx) {
        Connection cn = ctx.getConnection();
        try {
            List<String> list = GetTables.getTableList(ctx, cn);
            return list;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private static List<String> getTableList(ConnectorContext ctx, Connection cn) {
        List<String> list;
        DbInfo db = new DbInfo(cn);
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = null;
        try {
            rs = db.getMeta().getTables(db.getCatalog(), db.getSchema(), "%", types);
            list = GetTables.toList(rs, ctx);
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.META_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return list;
    }

    private static List<String> toList(ResultSet rs, ConnectorContext ctx) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        while (rs.next()) {
            String table_name = rs.getString("TABLE_NAME");
            if (!ctx.isValid(table_name, ConnectorContext.Operation.WRITE) && !ctx.isValid(table_name, ConnectorContext.Operation.READ)) continue;
            tables.add(table_name);
        }
        return tables;
    }
}

