/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.stream;

import java.util.Iterator;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.data.Schema;

public class Utils {
    public static Schema createSchema(Object[] expr) {
        String[] fields = new String[expr.length];
        int i = 0;
        while (i < expr.length) {
            Object e = expr[i];
            fields[i] = e instanceof Identifier ? ((Identifier)e).name() : String.valueOf(i);
            ++i;
        }
        return new Schema(fields);
    }

    public static boolean isIterable(Object e) {
        return e instanceof Iterable || e instanceof Iterator || e instanceof Object[] || e instanceof ObjectReader;
    }

    public static Iterator<?> createIterator(Object e) {
        if (e instanceof Iterable) {
            return ((Iterable)e).iterator();
        }
        if (e instanceof Iterator) {
            return (Iterator)e;
        }
        if (e instanceof Object[]) {
            return Utils.createArrayIterator(e);
        }
        if (e instanceof ObjectReader) {
            return Utils.createObjectReader((ObjectReader)e);
        }
        throw new IllegalArgumentException(e.getClass().getName());
    }

    private static Object readOrCloseOnError(ObjectReader<?> e) {
        try {
            return e.read();
        }
        catch (Exception err) {
            try {
                e.close();
            }
            catch (Exception e1) {
                throw D.e(e1);
            }
            throw D.e(err);
        }
    }

    private static Iterator<?> createObjectReader(final ObjectReader<?> e) {
        Object first = Utils.readOrCloseOnError(e);
        return new Iterator<Object>(first){
            private Object value;
            {
                this.value = object;
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public Object next() {
                Object value = this.value;
                this.value = Utils.readOrCloseOnError(e);
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator<Object> createArrayIterator(Object set) {
        return new Iterator<Object>(set){
            private Object[] array;
            private int index;
            {
                this.array = (Object[])object;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.array.length;
            }

            @Override
            public Object next() {
                return this.array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

