/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.script.ScriptContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.core.NativeFunction;

public class ClassInfo
implements NativeFunction {
    @Override
    public String name() {
        return "ClassInfo";
    }

    @Override
    public Map<String, Object> call(ScriptContext ctx, Object[] args) {
        String resourceName = this.getResourceName(args);
        String url = D.s(ClassInfo.class.getClassLoader().getResource(resourceName));
        if (url == null) {
            return this.defaultInfo(url);
        }
        return this.returnClassFileInfo(url);
    }

    private Map<String, Object> returnClassFileInfo(String url) {
        int j = url.indexOf(".jar!/");
        if (j < 0) {
            return this.defaultInfo(url);
        }
        return this.returnJarClassFileInfo(url, j);
    }

    private Map<String, Object> returnJarClassFileInfo(String url, int index) {
        try {
            return this.getZipClassFileInfoWithoutCatchError(url, index);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    private Map<String, Object> getZipClassFileInfoWithoutCatchError(String url, int index) throws IOException {
        ZipFile zipFile = ClassInfo.getZipFile(url, index);
        try {
            Map<String, Object> map = this.getZipClassFileInfo(zipFile, url, index);
            return map;
        }
        finally {
            zipFile.close();
        }
    }

    private Map<String, Object> getZipClassFileInfo(ZipFile zipFile, String url, int index) {
        String resourceName = url.substring(index + ".jar!/".length());
        ZipEntry entry = zipFile.getEntry(resourceName);
        if (entry == null) {
            return this.defaultInfo(url);
        }
        return this.getZipClassInfo(url, entry);
    }

    private Map<String, Object> getZipClassInfo(String url, ZipEntry entry) {
        Map<String, Object> info = this.defaultInfo(url);
        info.put("size", entry.getSize());
        info.put("crc", Long.toHexString(entry.getCrc()).toUpperCase());
        info.put("time", D.t(entry.getTime()));
        info.put("server", StringUtil.trim(NetUtil.getServerId(), 75));
        return info;
    }

    private static ZipFile getZipFile(String url, int index) throws IOException {
        int i = url.indexOf(":/") + ":/".length();
        String path = String.valueOf(url.substring(i, index)) + ".jar";
        if (path.charAt(1) != ':') {
            path = "/" + path;
        }
        ZipFile zipFile = new ZipFile(new File(path));
        return zipFile;
    }

    public static ZipFile getZipFile(String url) throws IOException {
        int index = url.indexOf(".jar!/");
        if (index < 0) {
            return null;
        }
        return ClassInfo.getZipFile(url, index);
    }

    private Map<String, Object> defaultInfo(String url) {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>(4);
        info.put("url", url);
        return info;
    }

    private String getResourceName(Object[] args) {
        String className = args.length > 0 ? D.s(args[0]) : ClassInfo.class.getName();
        String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
        return resourceName;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

