/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove;

import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailHisApprove;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MailHisApproveArea {
    private static final String approveUrlHtml = "<div id=\"{{approveHisArea}}\" class=\"subArea\" style=\"display: flex ; flex-wrap: wrap\">\n\n        <div id = \"{{approveHisAreaTitleId}}\" class=\"c_titleDiv\" style=\"flex-basis: 100%;padding-bottom: 15px;\">\n            <span style=\"color: #5582F3;\">|</span>\n            <span>{{approveHisAreaTitle}}</span>\n        </div>\n    </div>";
    private static final String approveUrlTableHtml = "   <tr id=\"{{approveHisArea}}\">\n    <td colspan=\"{{td_col_count_}}\"><span style=\"{{approveHis_titleStyle_1}}\">|</span><span style=\"{{approveHis_titleStyle_2}}\"> {{approveHisAreaTitle}}</span></td>\n   </tr>\n   {{allApproveRecord}}";
    private String title;
    private String titleStyle;
    private List<MailHisApprove> approveList;

    public String getTitle() {
        return this.title;
    }

    public MailHisApproveArea setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitleStyle() {
        return this.titleStyle;
    }

    public MailHisApproveArea setTitleStyle(String titleStyle) {
        this.titleStyle = titleStyle;
        return this;
    }

    public List<MailHisApprove> getApproveList() {
        return this.approveList;
    }

    public MailHisApproveArea setApproveList(List<MailHisApprove> approveList) {
        this.approveList = approveList;
        return this;
    }

    public static Map<String, String> buildHisApproveArea(MailApproveHtmlDTO mailApproveHtmlDTO) {
        if ("DIV".equals(mailApproveHtmlDTO.getModelStyle())) {
            return MailHisApproveArea.buildHisApproveAreaWithDiv(mailApproveHtmlDTO);
        }
        return MailHisApproveArea.buildHisApproveAreaWithTable(mailApproveHtmlDTO);
    }

    public static Map<String, String> buildHisApproveAreaWithTable(MailApproveHtmlDTO mailApproveHtmlDTO) {
        MailHisApproveArea approveArea = mailApproveHtmlDTO.getMailHisApproveArea();
        String html = approveUrlTableHtml;
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        if (approveArea == null || approveArea.getApproveList() == null || approveArea.getApproveList().isEmpty()) {
            return idHtmlMap;
        }
        if (StringUtils.isBlank((CharSequence)approveArea.getTitle())) {
            html = "{{allApproveRecord}}";
        }
        html = html.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(mailApproveHtmlDTO).toString());
        html = html.replace("{{approveHisArea}}", "approveHisArea");
        html = html.replace("{{approveHisAreaTitleId}}", "approveHisAreaTitleId");
        String defaultTitle = "\u5ba1\u6279\u8bb0\u5f55";
        if ("l1".equals(mailApproveHtmlDTO.getLanguage())) {
            defaultTitle = "Approval Records";
        } else if ("l3".equals(mailApproveHtmlDTO.getLanguage())) {
            defaultTitle = "\u5be9\u6279\u8a18\u9304";
        }
        html = html.replace("{{approveHisAreaTitle}}", StringUtils.isEmpty((CharSequence)approveArea.getTitle()) ? defaultTitle : approveArea.getTitle());
        if (approveArea.getTitleStyle() != null && !"".equals(approveArea.getTitleStyle())) {
            html = html.replace("{{approveHis_titleStyle_1}}", "color: #5582F3;" + approveArea.getTitleStyle().replace("\"", "'"));
            html = html.replace("{{approveHis_titleStyle_2}}", approveArea.getTitleStyle().replace("\"", "'"));
        } else {
            html = html.replace("{{approveHis_titleStyle_1}}", "color: #5582F3;font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
            html = html.replace("{{approveHis_titleStyle_2}}", "font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
        }
        if (approveArea.getApproveList() != null && approveArea.getApproveList().size() > 0) {
            StringBuilder allHisApproves = new StringBuilder();
            Integer colCount = MailApproveHtmlDTO.calColCount(mailApproveHtmlDTO);
            int i = 0;
            while (i < approveArea.getApproveList().size()) {
                Element hisApproveResultDiv;
                Element hisApproveTimeUserDiv;
                Element hisApproveDefNameDiv;
                MailHisApprove mailHisApprove = approveArea.getApproveList().get(i);
                String hisApproveHtml = "   <tr>\n     <td colspan=\"" + colCount + " \"><span style=\"color: #5582F3;font-weight: bold;font-family: Microsoft Yahei;font-size: 19px;\">\u25cb</span><span style=\"font-size: 14px;\">{{hisApproveDefName}}</span></td>" + "   </tr>\n" + "\n" + "   <tr style=\"font-size: 13px;color: #999999;mso-padding-left-alt: 20px;\">\n" + "    <td colspan=\"" + colCount + "\">\n" + "       <span style=\"padding-left: 20px;color: #212121;\">{{hisApproveUser}}</span>\n" + "       <span style=\"{{hisApproveResult_style_}}\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{hisApproveResult}}</span>\n" + "       <span style=\"font-size:12px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{hisApproveTime}}</span>\n" + "    </td>\n" + "   </tr>\n" + "   <tr  style=\"mso-padding-left-alt: 20px;\">\n" + "    <td colspan=\"" + colCount + "\"><span style=\"padding-left: 20px;color: #666666;font-size: 12px;\">{{hisApproveOpinion}}</span></td>\n" + "   </tr>";
                hisApproveHtml = String.valueOf(hisApproveHtml) + "</div>";
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveDefName}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveDefName()));
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveTime}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveTime()));
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveUser}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveUser()));
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveResult}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveResult()));
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveOpinion}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveOpinion()));
                Document hisApproveDoc = Jsoup.parse((String)hisApproveHtml);
                if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveDefNameStyle()) && (hisApproveDefNameDiv = hisApproveDoc.getElementById("{{hisApproveDefNameDivId}}")) != null) {
                    hisApproveDefNameDiv.removeAttr("style");
                    hisApproveDefNameDiv.attr("style", mailHisApprove.getApproveDefNameStyle());
                }
                if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveTimeUserStyle()) && (hisApproveTimeUserDiv = hisApproveDoc.getElementById("{{hisApproveTimeDivId}}")) != null) {
                    hisApproveTimeUserDiv.removeAttr("style");
                    hisApproveTimeUserDiv.attr("style", mailHisApprove.getApproveTimeUserStyle());
                }
                hisApproveHtml = mailHisApprove.getResultType() != null && mailHisApprove.getResultType() == 0 ? hisApproveHtml.replace("{{hisApproveResult_style_}}", "padding-left: 30px;color: #FB2323;") : hisApproveHtml.replace("{{hisApproveResult_style_}}", "padding-left: 30px;color: #1BA854;");
                if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveResultStyle())) {
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveResult_style_}}", mailHisApprove.getApproveResultStyle());
                }
                if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveResultStyle()) && (hisApproveResultDiv = hisApproveDoc.getElementById("{{hisApproveResultDivId}}")) != null) {
                    hisApproveResultDiv.removeAttr("style");
                    hisApproveResultDiv.attr("style", mailHisApprove.getApproveResultStyle());
                }
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveDefNameDivId}}", "hisApproveDefNameDivId_" + i);
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveTimeDivId}}", "hisApproveTimeDivId_" + i);
                hisApproveHtml = hisApproveHtml.replace("{{hisApproveResultDivId}}", "hisApproveResultDivId_" + i);
                allHisApproves.append(hisApproveHtml);
                ++i;
            }
            html = html.replace("{{allApproveRecord}}", allHisApproves);
        }
        idHtmlMap.put("approveHisArea", html);
        return idHtmlMap;
    }

    public static Map<String, String> buildHisApproveAreaWithDiv(MailApproveHtmlDTO mailApproveHtmlDTO) {
        MailHisApproveArea approveArea = mailApproveHtmlDTO.getMailHisApproveArea();
        String html = approveUrlHtml;
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        if (approveArea == null || approveArea.getApproveList() == null || approveArea.getApproveList().isEmpty()) {
            return idHtmlMap;
        }
        html = html.replace("{{approveHisArea}}", "approveHisArea");
        html = html.replace("{{approveHisAreaTitleId}}", "approveHisAreaTitleId");
        String defaultTitle = "\u5ba1\u6279\u8bb0\u5f55";
        if ("l1".equals(mailApproveHtmlDTO.getLanguage())) {
            defaultTitle = "Approval Records";
        } else if ("l3".equals(mailApproveHtmlDTO.getLanguage())) {
            defaultTitle = "\u5be9\u6279\u8a18\u9304";
        }
        html = html.replace("{{approveHisAreaTitle}}", StringUtils.isEmpty((CharSequence)approveArea.getTitle()) ? defaultTitle : approveArea.getTitle());
        Document hisApproveRoot = Jsoup.parse((String)html);
        Element titleDivEle = hisApproveRoot.getElementById("approveHisAreaTitleId");
        if (titleDivEle != null) {
            titleDivEle.removeAttr("style");
            titleDivEle.attr("style", approveArea.getTitleStyle());
            if (approveArea.getApproveList() != null && approveArea.getApproveList().size() > 0) {
                StringBuilder allHisApproves = new StringBuilder();
                int i = 0;
                while (i < approveArea.getApproveList().size()) {
                    Element hisApproveResultDiv;
                    Element hisApproveTimeUserDiv;
                    Element hisApproveDefNameDiv;
                    MailHisApprove mailHisApprove = approveArea.getApproveList().get(i);
                    String hisApproveHtml = "<div class=\"progess-bar\" style=\"flex-basis: 100%;\">\n            <div class=\"ball\">\n            </div>\n            <div class=\"detail\">\n                <div class=\"flow-detail\">\n                    <span class=\"flow-detail-node\">{{hisApproveDefName}}</span>\n                </div>\n                <div class=\"flow-detail-info\">\n                    <div style=\"padding:5px 2px;\">\n                        <span id = \"{{hisApproveDefNameDivId}}\" class=\"flow-detail-info-name\">{{hisApproveUser}}</span>\n                        <span id = \"{{hisApproveResultDivId}}\" class=\"flow-detail-info-result\">{{hisApproveResult}}</span>\n                        <span id = \"{{hisApproveTimeDivId}}\" class=\"flow-detail-info-date\">{{hisApproveTime}}</span>\n                    </div>\n\n                    <div class=\"c_approveOption\">\n                        {{hisApproveOpinion}}\n                    </div>\n\n                </div>\n            </div>\n";
                    if (i < approveArea.getApproveList().size() - 1) {
                        hisApproveHtml = String.valueOf(hisApproveHtml) + "<div class=\"progress negative\">\n            </div>";
                    }
                    hisApproveHtml = String.valueOf(hisApproveHtml) + "</div>";
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveDefName}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveDefName()));
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveTime}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveTime()));
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveUser}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveUser()));
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveResult}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveResult()));
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveOpinion}}", MailApproveHtmlDTO.replaceNullStr(mailHisApprove.getApproveOpinion()));
                    Document hisApproveDoc = Jsoup.parse((String)hisApproveHtml);
                    if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveDefNameStyle()) && (hisApproveDefNameDiv = hisApproveDoc.getElementById("{{hisApproveDefNameDivId}}")) != null) {
                        hisApproveDefNameDiv.removeAttr("style");
                        hisApproveDefNameDiv.attr("style", mailHisApprove.getApproveDefNameStyle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveTimeUserStyle()) && (hisApproveTimeUserDiv = hisApproveDoc.getElementById("{{hisApproveTimeDivId}}")) != null) {
                        hisApproveTimeUserDiv.removeAttr("style");
                        hisApproveTimeUserDiv.attr("style", mailHisApprove.getApproveTimeUserStyle());
                    }
                    if (mailHisApprove.getResultType() != null && mailHisApprove.getResultType() == 0 && (hisApproveResultDiv = hisApproveDoc.getElementById("{{hisApproveResultDivId}}")) != null) {
                        hisApproveResultDiv.removeAttr("style");
                        hisApproveResultDiv.attr("style", "color:#FB2323;");
                    }
                    if (StringUtils.isNotBlank((CharSequence)mailHisApprove.getApproveResultStyle()) && (hisApproveResultDiv = hisApproveDoc.getElementById("{{hisApproveResultDivId}}")) != null) {
                        hisApproveResultDiv.removeAttr("style");
                        hisApproveResultDiv.attr("style", mailHisApprove.getApproveResultStyle());
                    }
                    hisApproveHtml = hisApproveDoc.html();
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveDefNameDivId}}", "hisApproveDefNameDivId_" + i);
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveTimeDivId}}", "hisApproveTimeDivId_" + i);
                    hisApproveHtml = hisApproveHtml.replace("{{hisApproveResultDivId}}", "hisApproveResultDivId_" + i);
                    allHisApproves.append(hisApproveHtml);
                    ++i;
                }
                titleDivEle.after(allHisApproves.toString());
            }
        }
        idHtmlMap.put("approveHisArea", hisApproveRoot.html());
        return idHtmlMap;
    }
}

