/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.secrity;

import com.kingdee.bos.Context;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class SecrityTableAndFieldCheckUtil {
    private static Map<String, List<String>> excludeTablesAndFields = new HashMap<String, List<String>>();
    private static Map<String, Set<String>> forbidTableMap = new HashMap<String, Set<String>>();
    private static final String QUERY_FORBIN_TABLE_NAME = "shrQueryForbidTable.properties";
    private static Logger logger = Logger.getLogger(SecrityTableAndFieldCheckUtil.class);

    static {
        SecrityTableAndFieldCheckUtil.initForbidTableMap();
    }

    private SecrityTableAndFieldCheckUtil() {
    }

    public static void checkPrivateInSQL(Context ctx, String sql) throws EASBizException {
        if (StringUtils.isEmpty((String)sql)) {
            return;
        }
        String upperSQL = sql.toUpperCase();
        String dbType = (String)ctx.get((Object)"dbType");
        if (logger.isDebugEnabled()) {
            logger.error((Object)("checkPrivateInSQL, dbType : " + dbType));
        }
        Set<String> tables = forbidTableMap.get(dbType);
        for (String string : tables) {
            String string2;
            if (string == null || tables == null || !SecrityTableAndFieldCheckUtil.isForbidTable(upperSQL, string2 = string.toUpperCase(Locale.ENGLISH))) continue;
            throw new SyssettinException(SyssettinException.SECRITY_FIELD_EROR, new Object[]{string2});
        }
        for (Map.Entry entry : excludeTablesAndFields.entrySet()) {
            String table = (String)entry.getKey();
            if (!SecrityTableAndFieldCheckUtil.isForbidTable(upperSQL, table)) continue;
            List fields = (List)entry.getValue();
            if (fields == null || fields.isEmpty()) {
                throw new SyssettinException(SyssettinException.SECRITY_FIELD_EROR, new Object[]{String.valueOf(table) + ".*"});
            }
            if (SecrityTableAndFieldCheckUtil.isVaild(upperSQL, table)) {
                StringBuilder sb = new StringBuilder();
                for (String field : fields) {
                    sb.append(table).append(".").append(field).append(",");
                }
                throw new SyssettinException(SyssettinException.SECRITY_FIELD_EROR, new Object[]{sb.toString().subSequence(0, sb.toString().length() - 1)});
            }
            for (String field : fields) {
                if (upperSQL.indexOf(" " + field + " ") == -1 && upperSQL.indexOf(" " + field + ",") == -1 && upperSQL.indexOf("," + field + " ") == -1 && upperSQL.indexOf("," + field + ",") == -1 && upperSQL.indexOf("." + field + " ") == -1 && upperSQL.indexOf("." + field + ",") == -1) continue;
                throw new SyssettinException(SyssettinException.SECRITY_FIELD_EROR, new Object[]{String.valueOf(table) + "." + field});
            }
        }
    }

    private static boolean isForbidTable(String upperSQL, String table) {
        return upperSQL.indexOf(" " + table + " ") != -1 || upperSQL.indexOf(" " + table + ",") != -1 || upperSQL.indexOf(" " + table + ";") != -1 || upperSQL.indexOf("." + table + " ") != -1 || upperSQL.indexOf("." + table + ",") != -1 || upperSQL.indexOf("." + table + ";") != -1 || upperSQL.indexOf(table) != -1 && upperSQL.indexOf(table) + table.length() == upperSQL.length();
    }

    private static boolean isVaild(String sql, String table) {
        int pos = 0;
        while ((pos = sql.indexOf(table, pos)) != -1) {
            String alias;
            int lastSelect = sql.lastIndexOf("SELECT", pos += table.length());
            if (lastSelect == -1) continue;
            String seq = sql.substring(lastSelect, pos);
            if (!(pos + 1 > sql.length() ? seq.contains(" * ") || seq.contains(" *,") : (StringUtils.isEmpty((String)(alias = SecrityTableAndFieldCheckUtil.getAlias(pos, sql))) ? seq.contains(" * ") || seq.contains(" *,") : seq.contains(String.valueOf(alias) + ".* ") || seq.contains(String.valueOf(alias) + ".*,") || seq.contains(" * ") || seq.contains(" *,")))) continue;
            return true;
        }
        return false;
    }

    private static String getAlias(int start, String sql) {
        StringBuilder aliasBuilder = new StringBuilder();
        char[] sqlChars = sql.toCharArray();
        boolean isInsideAlias = false;
        int len = sql.length();
        int i = start;
        while (i < len) {
            char ch = sqlChars[i];
            if (ch == ' ' || ch == ',' || ch == '(' || ch == ';' || ch == '\n') {
                if (isInsideAlias) {
                    break;
                }
            } else if (ch == 'A' && sql.substring(i, i + 3).equals("AS ")) {
                i += 2;
            } else if (!Character.isWhitespace(ch)) {
                aliasBuilder.append(ch);
                isInsideAlias = true;
            }
            ++i;
        }
        return aliasBuilder.toString().trim();
    }

    private static String getConfigPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append(QUERY_FORBIN_TABLE_NAME);
        return sb.toString();
    }

    private static void initForbidTableMap() {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("FPASSWORD");
        fields.add("FPWDHISSTR");
        excludeTablesAndFields.put("T_PM_USER", fields);
        excludeTablesAndFields.put("T_WFD_SYS_USER", null);
        HashSet<String> oracleTable = new HashSet<String>();
        oracleTable.add("v$database".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)2), oracleTable);
        forbidTableMap.put(DbType.getName((int)7), oracleTable);
        forbidTableMap.put(DbType.getName((int)8), oracleTable);
        HashSet<String> sqlServerTable = new HashSet<String>();
        sqlServerTable.add("sys.databases".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)3), sqlServerTable);
        HashSet<String> dmTable = new HashSet<String>();
        dmTable.add("V$DATABASE".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)11), dmTable);
        HashSet<String> kingbaseTable = new HashSet<String>();
        kingbaseTable.add("sys_databases".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)12), kingbaseTable);
        HashSet<String> dB2Table = new HashSet<String>();
        dB2Table.add("SYSCAT.DBS".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)1), dB2Table);
        HashSet<String> pgTable = new HashSet<String>();
        pgTable.add("pg_database".toUpperCase(Locale.ENGLISH));
        forbidTableMap.put(DbType.getName((int)5), pgTable);
        File file = new File(SecrityTableAndFieldCheckUtil.getConfigPath());
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream input = new FileInputStream(file);){
                    Properties properties = new Properties();
                    properties.load(input);
                    for (String key : properties.stringPropertyNames()) {
                        if ("serviceTable".equals(key)) {
                            String forbidServiceTableAndFields = properties.getProperty(key).toUpperCase(Locale.ENGLISH);
                            if (StringUtils.isEmpty((String)forbidServiceTableAndFields)) continue;
                            String[] tablesAndFields = forbidServiceTableAndFields.split(";");
                            List<Object> list = excludeTablesAndFields.get(key) != null ? excludeTablesAndFields.get(key) : new ArrayList();
                            String[] stringArray = tablesAndFields;
                            int n = tablesAndFields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String tableAndField = stringArray[n2];
                                if (tableAndField.contains("(")) {
                                    int index = tableAndField.indexOf("(");
                                    String tableName = tableAndField.substring(0, index);
                                    String fieldsStr = tableAndField.substring(index + 1, tableAndField.length());
                                    Collections.addAll(list, fieldsStr.split(","));
                                    excludeTablesAndFields.put(tableName, list);
                                } else {
                                    excludeTablesAndFields.put(tableAndField, null);
                                }
                                ++n2;
                            }
                            continue;
                        }
                        String forbidTable = properties.getProperty(key);
                        if (StringUtils.isEmpty((String)forbidTable)) continue;
                        String[] tables = forbidTable.toUpperCase(Locale.ENGLISH).split(";");
                        Set<Object> set = forbidTableMap.get(key) != null ? forbidTableMap.get(key) : new HashSet();
                        Collections.addAll(set, tables);
                        forbidTableMap.put(key, set);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error((Object)"Init params error!");
            }
        }
    }
}

