/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.web.handler.integrate;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.field.UserFieldPermInfoHelper;
import com.kingdee.shr.base.permission.field.form.ShrFieldPermForm;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.shr.compensation.util.columnModel.CmpColumnModels;
import com.kingdee.shr.compensation.util.filter.CmpPermFilter;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateUtils;
import com.kingdee.shr.compensation.util.report.CommonSQLUtil;
import com.kingdee.shr.compensation.web.handler.CmpWorkFlowBaseHandler;
import com.kingdee.shr.compensation.web.handler.integrate.FileExportHelper;
import com.kingdee.shr.compensation.web.handler.integrate.entry.BaseSubmitBillEntryGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class BatchSubmitBillEntryGridHandler
extends CmpWorkFlowBaseHandler {
    protected static Logger logger = Logger.getLogger(BatchSubmitBillEntryGridHandler.class);
    private String entityName = "com.kingdee.eas.basedata.org.app.Position";

    public String getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return super.getGridDataAction(request, response, modelMap);
    }

    public Map<String, Object> getGridDataMap(HttpServletRequest request) throws SHRWebException {
        Map<String, Object> gridDataMap;
        String[] dateFieldMap = new String[]{"enterDate"};
        String submitSchemeId = request.getParameter("submitSchemeId");
        String billId = request.getParameter("billId");
        String querySql = "";
        Map resultMap = Maps.newHashMap();
        try {
            resultMap = CmpIntegrateUtils.getBillColumnListAndQuerySql((Context)this.ctx, (String)submitSchemeId, (String)billId);
        }
        catch (Exception var20) {
            logger.error((Object)"getBillColumnListAndQuerySql error: ", (Throwable)var20);
            this.handleException(var20);
        }
        try {
            querySql = ((Map)resultMap).get("querySql").toString();
            querySql = this.addPermSql(request, querySql);
        }
        catch (Exception var19) {
            logger.error((Object)"addPermSql error: ", (Throwable)var19);
            this.handleException(var19);
        }
        int totalCount = 0;
        IRowSet rowSet = null;
        try {
            gridDataMap = this.doExecuteQuery(request, querySql);
            String sql = String.valueOf(gridDataMap.get("afterPagingSql"));
            ParamData param = (ParamData)gridDataMap.get("afterPagingHelperParamData");
            rowSet = SqlUtil.executeQuery((Context)this.ctx, (String)sql, (ParamData)param);
            totalCount = Integer.parseInt(String.valueOf(gridDataMap.get("totalCount")));
        }
        catch (Exception var18) {
            logger.error((Object)"getGridDataMap doExecuteQuery error: ", (Throwable)var18);
            this.handleException(var18);
        }
        try {
            gridDataMap = this.assembleGridData(request, (List)((Map)resultMap).get("colNames"), rowSet, totalCount);
            List rowDataList = (List)gridDataMap.get("rows");
            if (rowDataList != null && rowDataList.size() > 0) {
                int i = 0;
                while (i < rowDataList.size()) {
                    Map rowDataMap = (Map)rowDataList.get(i);
                    String[] var13 = dateFieldMap;
                    int var14 = dateFieldMap.length;
                    int var15 = 0;
                    while (var15 < var14) {
                        String val;
                        String keyItem = var13[var15];
                        if (rowDataMap.containsKey(keyItem) && !StringUtils.isEmpty((CharSequence)(val = (String)rowDataMap.get(keyItem)))) {
                            rowDataMap.put(keyItem, val.substring(0, 10));
                        }
                        ++var15;
                    }
                    ++i;
                }
            }
            this.fieldPerm(this.ctx, rowDataList);
            return gridDataMap;
        }
        catch (Exception var21) {
            logger.error((Object)"getGridDataMap assembleGridData error: ", (Throwable)var21);
            this.handleException(var21);
            return null;
        }
    }

    protected void fieldPerm(Context ctx, List<Map<String, Object>> rowDataList) throws EASBizException, BOSException {
        Locale locale = ctx.getLocale();
        if (rowDataList != null && !rowDataList.isEmpty()) {
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            Set fieldPermSet = UserFieldPermInfoHelper.getUserEntityFields((Context)ctx, (String)userId, (String)this.entityName);
            ShrFieldPermForm shrFieldPermForm = new ShrFieldPermForm(ctx, null, this.entityName);
            if (fieldPermSet != null && fieldPermSet.size() >= 1) {
                int i = 0;
                while (i < rowDataList.size()) {
                    Map<String, Object> rowDataMap = rowDataList.get(i);
                    if (rowDataMap.containsKey("position")) {
                        HashMap<String, String> permMap = new HashMap<String, String>();
                        PositionInfo posInfo = (PositionInfo)rowDataMap.get("position");
                        for (String permField : fieldPermSet) {
                            if (!permField.contains("name")) continue;
                            permMap.put("name", posInfo.getName(locale));
                            if (shrFieldPermForm.isAllowView(this.entityName, permField, permMap)) continue;
                            posInfo.setName("***");
                            rowDataMap.put("position", posInfo);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void addEntryFastFilterItem(HttpServletRequest request, StringBuilder result) throws SHRWebException {
        String filterItems = request.getParameter("filterItems");
        if (!StringUtils.isEmpty((CharSequence)filterItems)) {
            filterItems = UrlParamEncryptHelper.decodeValue((String)filterItems);
            result.append(" and " + filterItems);
        }
    }

    public String addPermSql(HttpServletRequest request, String executeSql) throws SHRWebException {
        StringBuilder result = new StringBuilder(executeSql);
        this.addEntryFastFilterItem(request, result);
        if (this.checkIsShrWfButNoPermitemPermissionCtx(this.ctx, request)) {
            return result.toString();
        }
        String uipk = request.getParameter("uipk");
        if ("com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillMySubmission.form".equals(uipk)) {
            return result.toString();
        }
        String permItemId = this.getCurrentRequestPermItemId(request);
        String hrOrgSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)this.ctx, (String)permItemId);
        String adminOrgSql = this.getAdminOrgSql(this.ctx, permItemId);
        result.append(" and (exists (");
        result.append(" select 1 from T_HR_SCmpEmpORelation cmpOrel where t.FCmpEmpORelationID = cmpOrel.fid ");
        result.append(" and (");
        result.append(" (t.FAdminOrgUnitID in (").append(adminOrgSql).append(") ");
        if (CmpStrUtil.isNotEmpty((String)hrOrgSql)) {
            result.append(" and t.FHrOrgUnitID in (").append(hrOrgSql).append(") ");
        }
        result.append(" )");
        if (CmpStrUtil.isNotEmpty((String)hrOrgSql)) {
            result.append(" or (t.FHrOrgUnitID in (").append(hrOrgSql).append(") and cmpOrel.FUseDefault = 0 ").append(") ");
        } else {
            result.append(" or (cmpOrel.FUseDefault = 0 ").append(") ");
        }
        result.append(" )) ");
        result.append(" or not exists (");
        result.append(" select 1 from T_HR_SCmpEmpORelation cmpOrel where t.FCmpEmpORelationID = cmpOrel.fid ");
        result.append(" ))");
        String permSql = CmpPermFilter.getCmpPersonPermFilter((Context)this.ctx, (String)"t.FHrOrgUnitID", (String)"t.FPersonID", (String)permItemId, (boolean)true);
        if (CmpStrUtil.isNotEmpty((String)permSql)) {
            result.append(" and ").append(permSql);
        }
        return result.toString();
    }

    protected String getAdminOrgSql(Context ctx, String permItemId) {
        return CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
    }

    public String getSumRowDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            String submitSchemeId = request.getParameter("submitSchemeId");
            String billId = request.getParameter("billId");
            Map resultMap = CmpIntegrateUtils.getBillColumnListAndQuerySql((Context)SHRContext.getInstance().getContext(), (String)submitSchemeId, (String)billId);
            String querySql = resultMap.get("querySql").toString();
            querySql = this.addPermSql(request, querySql);
            IRowSet rowSet = CommonSQLUtil.executeQuery((Context)this.ctx, (String)querySql);
            HashMap columnMap = (HashMap)resultMap.get("columnMap");
            HashMap<String, String> sumItemMap = new HashMap<String, String>();
            Set columnList = columnMap.keySet();
            Object value = null;
            BigDecimal columnValue = null;
            if (columnList.size() > 0) {
                while (rowSet.next()) {
                    for (String columnName : columnList) {
                        Integer dot;
                        value = rowSet.getObject(columnName);
                        if (!(value instanceof BigDecimal) || (dot = (Integer)columnMap.get(columnName)) == null) continue;
                        BigDecimal bigValue = new BigDecimal(value.toString()).setScale((int)dot, RoundingMode.HALF_UP);
                        columnValue = sumItemMap.get(columnName) != null ? new BigDecimal((String)sumItemMap.get(columnName)) : BigDecimal.ZERO;
                        sumItemMap.put(columnName, columnValue.add(bigValue).toString());
                    }
                }
            }
            JSONUtils.SUCCESS(sumItemMap);
        }
        catch (Exception var18) {
            var18.printStackTrace();
            this.handleException(var18);
        }
        return null;
    }

    public Map<String, Object> doExecuteQuery(HttpServletRequest request, String executeSql) throws SHRWebException {
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        this.getSortData(request);
        String sord = request.getAttribute("sord").toString();
        String sidx = request.getAttribute("sidx").toString();
        return CommonSQLUtil.processGridDataPaging((Context)this.ctx, (String)executeSql, (int)rows, (int)page, (String)sidx, (String)sord);
    }

    public void getSortData(HttpServletRequest request) {
        String sidx = request.getParameter("sidx");
        String sord = request.getParameter("sord");
        if (StringUtils.isEmpty((CharSequence)sidx) || "orgUnit".equals(sidx) || "person".equals(sidx)) {
            sidx = "number,ADMORGNAME,POSITIONNAME";
        }
        if ("adminOrgUnit".equals(sidx)) {
            sidx = "ADMORGNAME";
        }
        if ("position".equals(sidx)) {
            sidx = "POSITIONNAME";
        }
        if (!"dealStatus".equals(sidx)) {
            sidx = "DEALSTATUS," + sidx;
        }
        request.setAttribute("sidx", (Object)sidx);
        request.setAttribute("sord", (Object)sord);
    }

    public String addSortSql(String sourceSql, HttpServletRequest request) {
        this.getSortData(request);
        String sidx = "";
        String sord = "";
        if (request.getAttribute("sidx") != null) {
            sidx = request.getAttribute("sidx").toString();
        }
        if (request.getAttribute("sord") != null) {
            sord = request.getAttribute("sord").toString();
        }
        String sorterItems = null;
        if (!StringUtils.isEmpty((CharSequence)sidx) && !"null".equals(sidx)) {
            String[] tempSidxs;
            StringBuilder buffer = new StringBuilder();
            String[] var8 = tempSidxs = sidx.split(",");
            int var9 = tempSidxs.length;
            int var10 = 0;
            while (var10 < var9) {
                String tempSidx = var8[var10];
                if ((tempSidx = tempSidx.trim()).contains(" ")) {
                    String[] strArr = tempSidx.split(" ");
                    buffer.append(",").append(strArr[0]).append(" ").append(strArr[1]);
                } else {
                    buffer.append(",").append(tempSidx).append(" ").append(sord);
                }
                ++var10;
            }
            sorterItems = buffer.toString().replaceFirst(",", "");
        }
        if (!StringUtils.isEmpty(sorterItems)) {
            sourceSql = String.valueOf(sourceSql) + " order by " + sorterItems;
        }
        return sourceSql;
    }

    public Map<String, Object> assembleGridData(HttpServletRequest request, List<String> columnList, IRowSet rowSet, int totalCount) throws SHRWebException {
        List<Map<String, Object>> rowDataList = this.assembleGridDataList(request, columnList, rowSet);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        if (totalCount % rows == 0) {
            resultMap.put("total", totalCount / rows);
        } else {
            resultMap.put("total", totalCount / rows + 1);
        }
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", rowDataList);
        return resultMap;
    }

    public List<Map<String, Object>> assembleGridDataList(HttpServletRequest request, List<String> columnList, IRowSet rowSet) throws SHRWebException {
        HashMap<String, Object> rowDataMap = null;
        ArrayList<Map<String, Object>> rowDataList = new ArrayList<Map<String, Object>>();
        if (rowSet.size() == 0) {
            return rowDataList;
        }
        try {
            String submitSchemeId = request.getParameter("submitSchemeId");
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT  ");
            sql.append(" item.fieldSn FIELDSN ");
            sql.append(" FROM T_HR_SCalSubmitScheme scheme ");
            sql.append(" inner join T_HR_SCalSubmitSchemeItem schemeItem on scheme.fid = schemeItem.FCalSubmitSchemeID ");
            sql.append(" inner join T_HR_SCalSubmitItem item on item.fid = schemeItem.FCalSubmitItemID ");
            sql.append(" where scheme.fid =  '").append(submitSchemeId).append("' and item.FDataType = '").append("3").append("'");
            sql.append(" order by  FSortSn");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            String fieldSn = "";
            String s = "S";
            HashSet<String> f7TypeFieldSet = new HashSet<String>();
            while (rs.next()) {
                fieldSn = String.valueOf(s) + rs.getString("FIELDSN");
                f7TypeFieldSet.add(fieldSn);
            }
            String column2 = "";
            while (rowSet.next()) {
                rowDataMap = new HashMap<String, Object>();
                for (String column2 : columnList) {
                    HashMap<String, String> f7TypeValue;
                    AdminOrgUnitInfo orgInfo;
                    String name;
                    String value;
                    if ("personId".equals(column2)) {
                        value = rowSet.getString(column2);
                        name = rowSet.getString("name");
                        PersonInfo info = new PersonInfo();
                        info.setName(name);
                        info.setId(BOSUuid.read((String)value));
                        rowDataMap.put("tempId", value);
                        rowDataMap.put("person", info);
                        continue;
                    }
                    if ("orgId".equals(column2)) {
                        orgInfo = new AdminOrgUnitInfo();
                        value = rowSet.getString(column2);
                        name = rowSet.getString("name");
                        rowDataMap.put("tempId", value);
                        orgInfo.setName(name);
                        orgInfo.setId(BOSUuid.read((String)value));
                        rowDataMap.put("orgUnit", orgInfo);
                        continue;
                    }
                    if ("admOrgId".equals(column2)) {
                        orgInfo = new AdminOrgUnitInfo();
                        value = rowSet.getString(column2);
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        name = rowSet.getString("admOrgName");
                        rowDataMap.put("tempId", value);
                        orgInfo.setName(name);
                        orgInfo.setId(BOSUuid.read((String)value));
                        rowDataMap.put("adminOrgUnit", orgInfo);
                        continue;
                    }
                    if ("positionId".equals(column2)) {
                        PositionInfo positionInfo = new PositionInfo();
                        value = rowSet.getString(column2);
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        name = rowSet.getString("positionName");
                        rowDataMap.put("tempId", value);
                        positionInfo.setName(name);
                        positionInfo.setId(BOSUuid.read((String)value));
                        rowDataMap.put("position", positionInfo);
                        continue;
                    }
                    if ("cmpEmpORelation".equals(column2)) {
                        CmpEmpORelationInfo cmpEmpORelation = new CmpEmpORelationInfo();
                        value = rowSet.getString(column2);
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        cmpEmpORelation.setId(BOSUuid.read((String)value));
                        cmpEmpORelation.put("name", (Object)value);
                        rowDataMap.put("cmpEmpORelation", cmpEmpORelation);
                        continue;
                    }
                    if ("submitElement".equals(column2)) {
                        SubmitElementInfo submitElementInfo = new SubmitElementInfo();
                        value = rowSet.getString(column2);
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        name = rowSet.getString("submitElementName");
                        submitElementInfo.setId(BOSUuid.read((String)value));
                        submitElementInfo.setName(name);
                        rowDataMap.put("submitElement", submitElementInfo);
                        continue;
                    }
                    if ("currency".equals(column2)) {
                        CurrencyInfo currencyInfo = new CurrencyInfo();
                        value = rowSet.getString(column2);
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        name = rowSet.getString("currencyName");
                        currencyInfo.setId(BOSUuid.read((String)value));
                        currencyInfo.setName(name);
                        rowDataMap.put("currency", currencyInfo);
                        continue;
                    }
                    if (f7TypeFieldSet.contains(column2)) {
                        value = rowSet.getString(String.valueOf(column2) + "id");
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            rowDataMap.put(column2, null);
                            continue;
                        }
                        f7TypeValue = new HashMap();
                        f7TypeValue.put("id", value);
                        f7TypeValue.put("name", rowSet.getString(column2));
                        f7TypeValue.put("number", rowSet.getString(String.valueOf(column2) + "number"));
                        rowDataMap.put(column2, f7TypeValue);
                        continue;
                    }
                    if ("description".equals(column2)) {
                        f7TypeValue = new HashMap<String, String>();
                        f7TypeValue.put("l1", rowSet.getString("description_l1"));
                        f7TypeValue.put("l2", rowSet.getString("description_l2"));
                        f7TypeValue.put("l3", rowSet.getString("description_l3"));
                        rowDataMap.put(column2, f7TypeValue);
                        continue;
                    }
                    value = rowSet.getString(column2);
                    rowDataMap.put(column2, value);
                }
                rowDataList.add(rowDataMap);
            }
            return rowDataList;
        }
        catch (Exception var18) {
            throw new SHRWebException((Throwable)var18);
        }
    }

    public String exportAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        try {
            logger.error((Object)"\u8fdb\u5165\u63d0\u62a5\u5bfc\u51fa\u65b9\u6cd5");
            request.setAttribute("title", (Object)this.getExportTitle(request));
            String submitSchemeId = request.getParameter("submitSchemeId");
            String billId = request.getParameter("billId");
            Context ctx = SHRContext.getInstance().getContext();
            Map resultMap = CmpIntegrateUtils.getBillColumnListAndQuerySql((Context)ctx, (String)submitSchemeId, (String)billId);
            HashMap params = Maps.newHashMap();
            params.put("datasource", Integer.valueOf(request.getParameter("datasource")));
            CmpColumnModels cmpColumnModels = null;
            cmpColumnModels = Integer.valueOf(request.getParameter("datasource")) == 1 ? new com.kingdee.shr.customer.gtiit.handler.BaseSubmitBillEntryGenerator().getEntryColumnModels(ctx, submitSchemeId, params) : new BaseSubmitBillEntryGenerator().getEntryColumnModels(ctx, submitSchemeId, (Map)params);
            FileExportHelper excel = new FileExportHelper();
            String querySql = resultMap.get("querySql").toString();
            querySql = this.addPermSql(request, querySql);
            String exportSql = this.addSortSql(querySql, request);
            String[] queryMode = this.assembleQueryMode(request, cmpColumnModels.getColModel());
            logger.error((Object)("\u63d0\u62a5\u5bfc\u51fa\u5b57\u6bb5\u4fe1\u606f\uff1a" + queryMode));
            IRowSet rowSet = CommonSQLUtil.executeQuery((String)exportSql);
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
            if (rowSet != null && rowSet.size() > 0) {
                String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
                Set fieldPermSet = UserFieldPermInfoHelper.getUserEntityFields((Context)ctx, (String)userId, (String)this.entityName);
                ShrFieldPermForm shrFieldPermForm = new ShrFieldPermForm(ctx, null, this.entityName);
                while (rowSet.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int i = 0;
                    while (i < queryMode.length) {
                        String[] column = queryMode[i].split(",");
                        if (StringUtils.isEmpty((CharSequence)column[1]) || !Boolean.valueOf(column[1]).booleanValue()) {
                            if ("positionName".equals(column[0]) && fieldPermSet != null && !fieldPermSet.isEmpty()) {
                                HashMap<String, Object> permMap = new HashMap<String, Object>();
                                for (String permField : fieldPermSet) {
                                    if (!permField.contains("name")) continue;
                                    permMap.put("name", rowSet.getObject(column[0]));
                                    if (shrFieldPermForm.isAllowView(this.entityName, permField, permMap)) continue;
                                    map.put(column[0], "****");
                                }
                            } else {
                                map.put(column[0], rowSet.getObject(column[0]));
                            }
                        }
                        ++i;
                    }
                    results.add(map);
                }
            }
            excel.exportToExcel(request, response, results, queryMode);
        }
        catch (Exception var25) {
            this.handleException(var25);
        }
        return null;
    }

    public BaseSubmitBillEntryGenerator getEntryGenerator() {
        return new BaseSubmitBillEntryGenerator();
    }

    protected String getExportTitle(HttpServletRequest request) throws SHRWebException {
        String billNumber = request.getParameter("billNumber");
        Context ctx = SHRContext.getInstance().getContext();
        String isMultiInspire = request.getParameter("isMultiInspire");
        return String.valueOf("1".equals(isMultiInspire) ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label30", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label31", (Locale)ctx.getLocale())) + billNumber.trim();
    }

    protected String[] assembleQueryMode(HttpServletRequest request, List<Map<String, Object>> colModel) {
        String[] queryMode = new String[colModel.size()];
        Map<String, Object> col = null;
        Context ctx = SHRContext.getInstance().getContext();
        String language = ctx.getLocale().getLanguage();
        HashMap<String, String> convert2NameMap = new HashMap<String, String>();
        convert2NameMap.put("orgUnit", "name");
        convert2NameMap.put("person", "name");
        convert2NameMap.put("adminOrgUnit", "admOrgName");
        convert2NameMap.put("position", "positionName");
        convert2NameMap.put("submitElement", "submitElementName");
        convert2NameMap.put("currency", "currencyName");
        convert2NameMap.put("description", "description_" + language);
        int i = 0;
        int size = colModel.size();
        while (i < size) {
            String type;
            Map inputJson;
            Map editoptions;
            col = colModel.get(i);
            StringBuilder buffer = new StringBuilder();
            String index = col.get("name").toString();
            if (convert2NameMap.containsKey(index)) {
                index = (String)convert2NameMap.get(index);
            }
            buffer.append(index).append(",");
            boolean hidden = false;
            if (col.get("hidden") != null) {
                hidden = Boolean.parseBoolean(col.get("hidden").toString());
            }
            String label = col.get("label") == null ? col.get("name").toString() : col.get("label").toString();
            buffer.append(hidden).append(",").append(label);
            String name = col.get("name").toString();
            boolean numItem = false;
            int precision = 0;
            if (name.matches("[sS]\\d+") && col.containsKey("editoptions") && "numberfield".equals(col.get("edittype")) && (editoptions = (Map)col.get("editoptions")) != null && editoptions.containsKey("inputJson") && (inputJson = (Map)editoptions.get("inputJson")) != null && inputJson.containsKey("decimalPrecision")) {
                precision = Integer.parseInt(inputJson.get("decimalPrecision").toString());
                numItem = true;
            }
            buffer.append(",").append(numItem);
            if (numItem) {
                buffer.append(",").append(precision);
            } else {
                buffer.append(",").append(0);
            }
            String string = type = col.containsKey("type") ? col.get("type").toString() : "String";
            if (!"IntEnum".equalsIgnoreCase(type) && !"StringEnum".equalsIgnoreCase(type)) {
                buffer.append(",").append(false);
            } else {
                buffer.append(",").append(true);
            }
            queryMode[i] = buffer.toString();
            ++i;
        }
        return queryMode;
    }

    public boolean checkIsShrWfButNoPermitemPermissionCtx(Context ctx, HttpServletRequest request) throws ShrWebBizException {
        System.out.println("checkIsShrWfButNoPermitemPermissionCtx: " + request.getMethod() + "_" + "POST".equals(request.getMethod()));
        logger.error((Object)("checkIsShrWfButNoPermitemPermissionCtx: " + request.getMethod() + "_" + "POST".equals(request.getMethod())));
        if ("POST".equals(request.getMethod())) {
            return true;
        }
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk((String)uipk);
        String billId = this.getBillId(request);
        String msgId = request.getParameter("msgId");
        Map shrWfInProcess = (Map)request.getSession().getAttribute("SHR_WF_IN_PROCESS");
        Map shrWfFinished = (Map)request.getSession().getAttribute("SHR_WF_FINISHED");
        Map shrWfCirculation = (Map)request.getSession().getAttribute("SHR_WF_CIRCULATION");
        Map myShrWfInOrFinished = (Map)request.getSession().getAttribute("MY_SHR_WF_INORFINISHED");
        if (ShrCheckDataPermissionUtil.sessionDataCheckHandler((Context)ctx, (Map)shrWfInProcess, (String)uipk, (String)billId, (String)"shrWfInProcess")) {
            return true;
        }
        if (ShrCheckDataPermissionUtil.sessionDataCheckHandler((Context)ctx, (Map)shrWfFinished, (String)uipk, (String)billId, (String)"shrWfFinished")) {
            return true;
        }
        return ShrCheckDataPermissionUtil.sessionDataCheckHandler((Context)ctx, (Map)shrWfCirculation, (String)uipk, (String)msgId, (String)"shrWfCirculation") ? true : ShrCheckDataPermissionUtil.sessionDataCheckHandler((Context)ctx, (Map)myShrWfInOrFinished, (String)uipk, (String)billId, (String)"myShrWfInOrFinished");
    }
}

